/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif.ui;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.filters.InlineCodeFinderPanel;
import net.sf.okapi.filters.mif.Parameters;
import net.sf.okapi.filters.mif.ui.Res;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

@EditorFor(value=Parameters.class)
public class Editor
implements IParametersEditor {
    private Shell shell;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private Button chkUseCodeFinder;
    private InlineCodeFinderPanel pnlCodeFinder;
    private IHelp help;
    private Button chkExtractBodyPages;
    private Button chkExtractHiddenPages;
    private Button chkExtractMasterPages;
    private Button chkExtractReferencePages;
    private Button chkExtractVariables;
    private Button chkExtractIndexMarkers;
    private Button chkExtractLinks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters params, boolean readOnly, IContext context) {
        this.help = (IHelp)context.getObject("help");
        boolean bRes = false;
        this.shell = null;
        this.params = (Parameters)params;
        try {
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception E) {
            Dialogs.showError(this.shell, E.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new Parameters();
    }

    private void create(Shell parent, boolean readOnly) {
        this.shell.setText(Res.getString("EditorCaption"));
        if (parent != null) {
            this.shell.setImage(parent.getImage());
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout(layTmp);
        TabFolder tfTmp = new TabFolder(this.shell, 0);
        GridData gdTmp = new GridData(1808);
        tfTmp.setLayoutData(gdTmp);
        Composite cmpTmp = new Composite(tfTmp, 0);
        layTmp = new GridLayout();
        cmpTmp.setLayout(layTmp);
        this.chkExtractVariables = new Button(cmpTmp, 32);
        this.chkExtractVariables.setText(Res.getString("extractVariables"));
        this.chkExtractIndexMarkers = new Button(cmpTmp, 32);
        this.chkExtractIndexMarkers.setText(Res.getString("extractIndexMarkers"));
        this.chkExtractLinks = new Button(cmpTmp, 32);
        this.chkExtractLinks.setText(Res.getString("extractLinks"));
        Group grpTmp = new Group(cmpTmp, 0);
        grpTmp.setText(Res.getString("pageTypesExtraction"));
        grpTmp.setLayout(new GridLayout());
        gdTmp = new GridData();
        gdTmp.verticalIndent = 8;
        grpTmp.setLayoutData(gdTmp);
        this.chkExtractBodyPages = new Button(grpTmp, 32);
        this.chkExtractBodyPages.setText(Res.getString("extractBodyPages"));
        this.chkExtractHiddenPages = new Button(grpTmp, 32);
        this.chkExtractHiddenPages.setText(Res.getString("extractHiddenPages"));
        this.chkExtractMasterPages = new Button(grpTmp, 32);
        this.chkExtractMasterPages.setText(Res.getString("extractMasterPages"));
        this.chkExtractReferencePages = new Button(grpTmp, 32);
        this.chkExtractReferencePages.setText(Res.getString("extractReferencePages"));
        TabItem tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText(Res.getString("tabOptions"));
        tiTmp.setControl(cmpTmp);
        cmpTmp = new Composite(tfTmp, 0);
        layTmp = new GridLayout();
        cmpTmp.setLayout(layTmp);
        this.chkUseCodeFinder = new Button(cmpTmp, 32);
        this.chkUseCodeFinder.setText(Res.getString("hasInlineCodes"));
        this.chkUseCodeFinder.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Editor.this.updateInlineCodes();
            }
        });
        this.pnlCodeFinder = new InlineCodeFinderPanel(cmpTmp, 0);
        this.pnlCodeFinder.setLayoutData(new GridData(1808));
        tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText(Res.getString("tabInlineCodes"));
        tiTmp.setControl(cmpTmp);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Editor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (Editor.this.help != null) {
                        Editor.this.help.showWiki("MIF Filter");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (!Editor.this.saveData()) {
                        return;
                    }
                    Editor.this.result = true;
                }
                Editor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel(this.shell, 0, OKCancelActions, true);
        gdTmp = new GridData(768);
        this.pnlActions.setLayoutData(gdTmp);
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.shell.pack();
        Rectangle Rect = this.shell.getBounds();
        this.shell.setMinimumSize(Rect.width, Rect.height);
        Dialogs.centerWindow(this.shell, parent);
        this.setData();
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void setData() {
        this.chkExtractBodyPages.setSelection(this.params.getExtractBodyPages());
        this.chkExtractHiddenPages.setSelection(this.params.getExtractHiddenPages());
        this.chkExtractMasterPages.setSelection(this.params.getExtractMasterPages());
        this.chkExtractReferencePages.setSelection(this.params.getExtractReferencePages());
        this.chkExtractVariables.setSelection(this.params.getExtractVariables());
        this.chkExtractIndexMarkers.setSelection(this.params.getExtractIndexMarkers());
        this.chkExtractLinks.setSelection(this.params.getExtractLinks());
        this.chkUseCodeFinder.setSelection(this.params.getUseCodeFinder());
        this.pnlCodeFinder.setRules(this.params.getCodeFinderData());
        this.updateInlineCodes();
        this.pnlCodeFinder.updateDisplay();
    }

    private boolean saveData() {
        if (this.chkUseCodeFinder.getSelection()) {
            if (this.pnlCodeFinder.getRules() == null) {
                return false;
            }
            this.params.setCodeFinderData(this.pnlCodeFinder.getRules());
        }
        this.params.setExtractBodyPages(this.chkExtractBodyPages.getSelection());
        this.params.setExtractHiddenPages(this.chkExtractHiddenPages.getSelection());
        this.params.setExtractMasterPages(this.chkExtractMasterPages.getSelection());
        this.params.setExtractReferencePages(this.chkExtractReferencePages.getSelection());
        this.params.setExtractVariables(this.chkExtractVariables.getSelection());
        this.params.setExtractIndexMarkers(this.chkExtractIndexMarkers.getSelection());
        this.params.setExtractLinks(this.chkExtractLinks.getSelection());
        this.params.setUseCodeFinder(this.chkUseCodeFinder.getSelection());
        return true;
    }

    private void updateInlineCodes() {
        this.pnlCodeFinder.setEnabled(this.chkUseCodeFinder.getSelection());
    }
}

