/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.segmentation;

import java.util.regex.Pattern;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.lib.segmentation.LanguageMap;
import net.sf.okapi.lib.ui.segmentation.Res;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LanguageMapDialog {
    private Shell shell;
    private Text edPattern;
    private Text edRuleName;
    private LanguageMap result = null;
    private OKCancelPanel pnlActions;
    private IHelp help;

    public LanguageMapDialog(Shell parent, LanguageMap langMap, IHelp helpParam) {
        this.help = helpParam;
        this.shell = new Shell(parent, 65648);
        this.shell.setText(Res.getString("langMap.caption"));
        UIUtil.inheritIcon(this.shell, parent);
        this.shell.setLayout(new GridLayout());
        Composite cmpTmp = new Composite(this.shell, 2048);
        cmpTmp.setLayoutData(new GridData(1808));
        GridLayout layTmp = new GridLayout();
        cmpTmp.setLayout(layTmp);
        Label label = new Label(cmpTmp, 0);
        label.setText(Res.getString("langMap.regexLabel"));
        this.edPattern = new Text(cmpTmp, 2052);
        GridData gdTmp = new GridData(768);
        this.edPattern.setLayoutData(gdTmp);
        this.edPattern.setText(langMap.getPattern());
        label = new Label(cmpTmp, 0);
        label.setText(Res.getString("langMap.groupName"));
        this.edRuleName = new Text(cmpTmp, 2052);
        gdTmp = new GridData(768);
        this.edRuleName.setLayoutData(gdTmp);
        this.edRuleName.setText(langMap.getRuleName());
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                LanguageMapDialog.this.result = null;
                if (e.widget.getData().equals("h")) {
                    if (LanguageMapDialog.this.help != null) {
                        LanguageMapDialog.this.help.showWiki("Ratel - Edit Language Map");
                    }
                    return;
                }
                if (e.widget.getData().equals("o") && !LanguageMapDialog.this.saveData()) {
                    return;
                }
                LanguageMapDialog.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel(this.shell, 0, OKCancelActions, true);
        this.pnlActions.setLayoutData(new GridData(768));
        this.shell.setDefaultButton(this.pnlActions.btOK);
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Dialogs.centerWindow(this.shell, parent);
    }

    public LanguageMap showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private boolean saveData() {
        try {
            if (this.edPattern.getText().length() == 0 && this.edRuleName.getText().length() == 0) {
                this.edPattern.selectAll();
                this.edPattern.setFocus();
                return false;
            }
            Pattern.compile(this.edPattern.getText());
            this.result = new LanguageMap(this.edPattern.getText(), this.edRuleName.getText());
            return true;
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
            return false;
        }
    }
}

