/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.security.InvalidParameterException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.okapi.lib.xliff2.core.BaseMarker;
import net.sf.okapi.lib.xliff2.core.CMarker;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.PMarker;
import net.sf.okapi.lib.xliff2.core.Store;
import net.sf.okapi.lib.xliff2.core.TagType;

public class Markers
implements Iterable<BaseMarker> {
    private final Store store;
    private LinkedHashMap<Integer, BaseMarker> markers;
    private LinkedHashMap<Integer, PMarker> pspans;
    private LinkedHashMap<Character, Integer> lastValues;

    public Markers(Store store) {
        if (store == null) {
            throw new InvalidParameterException("The store parameter cannot be null.");
        }
        this.store = store;
        this.lastValues = new LinkedHashMap();
        this.resetLastValues();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lastValues == null ? 0 : this.lastValues.hashCode());
        result = 31 * result + (this.markers == null ? 0 : this.markers.hashCode());
        result = 31 * result + (this.pspans == null ? 0 : this.pspans.hashCode());
        return result;
    }

    private void resetLastValues() {
        this.lastValues.put(Character.valueOf('\ue101'), -1);
        this.lastValues.put(Character.valueOf('\ue102'), -1);
        this.lastValues.put(Character.valueOf('\ue103'), -1);
        this.lastValues.put(Character.valueOf('\ue104'), -1);
        this.lastValues.put(Character.valueOf('\ue105'), -1);
        this.lastValues.put(Character.valueOf('\ue106'), -1);
    }

    protected void resetPMarkerLastValue() {
        this.lastValues.put(Character.valueOf('\ue106'), -1);
    }

    public boolean hasCodeWithOriginalData() {
        if (this.markers != null) {
            for (BaseMarker marker : this.markers.values()) {
                if (marker.isAnnotation() || !((CMarker)marker).hasOriginalData()) continue;
                return true;
            }
        }
        return false;
    }

    public BaseMarker getClosingMarker(BaseMarker openingMarker) {
        if (this.markers == null) {
            return null;
        }
        for (BaseMarker marker : this.markers.values()) {
            if (!marker.getId().equals(openingMarker.getId()) || marker.getTagType() != TagType.CLOSING) continue;
            return marker;
        }
        return null;
    }

    public BaseMarker getOpeningMarker(BaseMarker closingMarker) {
        return this.getOpeningMarker(closingMarker.getId());
    }

    public BaseMarker getOpeningMarker(String id) {
        if (this.markers == null) {
            return null;
        }
        for (BaseMarker marker : this.markers.values()) {
            if (!marker.getId().equals(id) || marker.getTagType() != TagType.OPENING) continue;
            return marker;
        }
        return null;
    }

    public int size() {
        if (this.markers == null) {
            return 0;
        }
        return this.markers.size();
    }

    public int getPMarkerCount() {
        if (this.pspans == null) {
            return 0;
        }
        return this.pspans.size();
    }

    public Store getStore() {
        return this.store;
    }

    public BaseMarker get(int key) {
        if (this.markers != null) {
            return this.markers.get(key);
        }
        return null;
    }

    public BaseMarker get(StringBuilder ctext, int pos) {
        return this.get(Fragment.toKey(ctext.charAt(pos), ctext.charAt(pos + 1)));
    }

    public BaseMarker get(String ctext, int pos) {
        return this.get(Fragment.toKey(ctext.charAt(pos), ctext.charAt(pos + 1)));
    }

    public BaseMarker get(String id, TagType type) {
        if (this.markers == null) {
            return null;
        }
        String tmp = BaseMarker.makeInternalId(id, type);
        for (BaseMarker marker : this.markers.values()) {
            if (!marker.getInternalId().equals(tmp)) continue;
            return marker;
        }
        return null;
    }

    public PMarker getPMarker(int key) {
        if (this.pspans != null) {
            return this.pspans.get(key);
        }
        return null;
    }

    public PMarker getPMarker(StringBuilder ctext, int pos) {
        return this.getPMarker(Fragment.toKey(ctext.charAt(pos), ctext.charAt(pos + 1)));
    }

    public PMarker getPMarker(String ctext, int pos) {
        return this.getPMarker(Fragment.toKey(ctext.charAt(pos), ctext.charAt(pos + 1)));
    }

    public int getKey(BaseMarker marker) {
        if (this.markers != null) {
            for (Map.Entry<Integer, BaseMarker> entry : this.markers.entrySet()) {
                if (entry.getValue() != marker) continue;
                return entry.getKey();
            }
        }
        return -1;
    }

    public int add(char mtype, BaseMarker marker) {
        if (this.markers == null) {
            this.markers = new LinkedHashMap(3);
        }
        int value = this.lastValues.get(Character.valueOf(mtype));
        this.lastValues.put(Character.valueOf(mtype), ++value);
        int key = Fragment.toKey(mtype, 57616 + value);
        if (this.markers.containsKey(key)) {
            throw new RuntimeException("The key auto-selected to add this marker exists already.");
        }
        this.markers.put(key, marker);
        return key;
    }

    public int add(BaseMarker marker) {
        boolean isCode = marker instanceof CMarker;
        switch (marker.getTagType()) {
            case OPENING: {
                return this.add(isCode ? (char)'\ue101' : '\ue104', marker);
            }
            case CLOSING: {
                return this.add(isCode ? (char)'\ue102' : '\ue105', marker);
            }
        }
        return this.add('\ue103', marker);
    }

    public int add(PMarker marker) {
        if (this.pspans == null) {
            this.pspans = new LinkedHashMap();
        }
        int value = this.lastValues.get(Character.valueOf('\ue106'));
        this.lastValues.put(Character.valueOf('\ue106'), ++value);
        int key = Fragment.toKey(57606, 57616 + value);
        if (this.pspans.containsKey(key)) {
            throw new RuntimeException("The key auto-selected to add this marker exists already.");
        }
        this.pspans.put(key, marker);
        return key;
    }

    @Override
    public Iterator<BaseMarker> iterator() {
        if (this.markers == null) {
            this.markers = new LinkedHashMap(3);
        }
        return this.markers.values().iterator();
    }

    public Iterator<PMarker> createPMarkerIterator() {
        if (this.pspans == null) {
            this.pspans = new LinkedHashMap();
        }
        return this.pspans.values().iterator();
    }

    public void remove(int key) {
        if (this.markers != null) {
            this.markers.remove(key);
            return;
        }
        throw new IndexOutOfBoundsException("There is no code or annotation marker in the list.");
    }

    public void removePMarker(int key) {
        if (this.pspans != null) {
            this.pspans.remove(key);
            return;
        }
        throw new IndexOutOfBoundsException("There is no protected content marker in the list.");
    }
}

