/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.security.InvalidParameterException;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Store;
import net.sf.okapi.lib.xliff2.core.TargetState;

public class Segment
extends Part {
    public static final TargetState STATE_DEFAULT = TargetState.INITIAL;
    private boolean canResegment = true;
    private TargetState state = STATE_DEFAULT;
    private String subState;

    public Segment(Segment original) {
        super(original);
        this.canResegment = original.canResegment;
        this.state = original.state;
        this.subState = original.subState;
    }

    public Segment(Store store) {
        super(store);
    }

    public boolean getCanResegment() {
        return this.canResegment;
    }

    public void setCanResegment(boolean canResegment) {
        this.canResegment = canResegment;
    }

    public TargetState getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state == null ? STATE_DEFAULT : TargetState.fromString(state);
    }

    public void setState(TargetState state) {
        this.state = state;
    }

    public String getSubState() {
        return this.subState;
    }

    public void setSubState(String subState) {
        int n;
        if (subState != null && ((n = subState.indexOf(58)) == -1 || n == 0 || n == subState.length() - 1)) {
            throw new InvalidParameterException(String.format("Invalid value '%s' for subState.", subState));
        }
        this.subState = subState;
    }

    @Override
    public boolean isSegment() {
        return true;
    }

    public Segment createAndCopyMetadata() {
        Segment seg = new Segment(this.getStore());
        seg.getSource().setDir(this.getSource().getDir(false));
        if (this.hasTarget()) {
            seg.getTarget(Part.GetTarget.CREATE_EMPTY).setDir(this.getTarget().getDir(false));
        }
        seg.setPreserveWS(this.getPreserveWS());
        seg.setCanResegment(this.getCanResegment());
        seg.setState(this.getState());
        seg.setSubState(this.getSubState());
        seg.setId(seg.getStore().suggestId(true));
        return seg;
    }
}

