/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.its;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.lib.xliff2.its.AnnotatorsRef;
import net.sf.okapi.lib.xliff2.its.DataCategoryGroup;
import net.sf.okapi.lib.xliff2.its.Domain;
import net.sf.okapi.lib.xliff2.its.IITSItem;
import net.sf.okapi.lib.xliff2.its.ITSItems;
import net.sf.okapi.lib.xliff2.its.IWithITSAttributes;
import net.sf.okapi.lib.xliff2.its.IWithITSGroups;
import net.sf.okapi.lib.xliff2.its.LocQualityIssue;
import net.sf.okapi.lib.xliff2.its.LocQualityIssues;
import net.sf.okapi.lib.xliff2.its.MTConfidence;
import net.sf.okapi.lib.xliff2.its.Provenance;
import net.sf.okapi.lib.xliff2.its.Provenances;
import net.sf.okapi.lib.xliff2.its.TermMarker;
import net.sf.okapi.lib.xliff2.its.TextAnalysis;
import net.sf.okapi.lib.xliff2.reader.XLIFFReaderException;

public class ITSReader {
    public static final String ANNOTATORSREF = "annotatorsRef";
    public static final String MTCONFIDENCE = "mtConfidence";
    public static final String DOMAINS = "domains";
    public static final String TACONFIDENCE = "taConfidence";
    public static final String TACLASSREF = "taClassRef";
    public static final String TASOURCE = "taSource";
    public static final String TAIDENT = "taIdent";
    public static final String TAIDENTREF = "taIdentRef";
    public static final String LOCQUALITYISSUES = "locQualityIssues";
    public static final String LOCQUALITYISSUE = "locQualityIssue";
    public static final String LOCQUALITYISSUETYPE = "locQualityIssueType";
    public static final String LOCQUALITYISSUECOMMENT = "locQualityIssueComment";
    public static final String LOCQUALITYISSUEENABLED = "locQualityIssueEnabled";
    public static final String LOCQUALITYISSUESEVERITY = "locQualityIssueSeverity";
    public static final String LOCQUALITYISSUEPROFILEREF = "locQualityIssueProfileRef";
    public static final String LOCQUALITYISSUESREF = "locQualityIssuesRef";
    public static final String PROVENANCERECORDS = "provenanceRecords";
    public static final String PROVENANCERECORD = "provenanceRecord";
    public static final String PROVTOOL = "tool";
    public static final String PROVTOOLREF = "toolRef";
    public static final String PROVREVTOOL = "revTool";
    public static final String PROVREVTOOLREF = "revToolRef";
    public static final String PROVPERSON = "person";
    public static final String PROVPERSONREF = "personRef";
    public static final String PROVREVPERSON = "revPerson";
    public static final String PROVREVPERSONREF = "revPersonRef";
    public static final String PROVORG = "org";
    public static final String PROVORGREF = "orgRef";
    public static final String PROVREVORG = "revOrg";
    public static final String PROVREVORGREF = "revOrgRef";
    public static final String PROVREF = "provRef";
    public static final String PROVENANCERECORDSREF = "provenanceRecordsRef";
    public static final String TERMCONFIDENCE = "termConfidence";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final XMLStreamReader reader;
    private IWithITSGroups groupHolder;

    public ITSReader(XMLStreamReader reader) {
        this.reader = reader;
    }

    public void readStandOffElements(String initialLocName, IWithITSGroups groupHolder, AnnotatorsRef ar) throws XMLStreamException {
        this.groupHolder = groupHolder;
        boolean isLQI = false;
        LocQualityIssues lqIssues = null;
        Provenances provRecs = null;
        String id = this.reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
        if (id == null) {
            throw new XLIFFReaderException("A stand-off element must have an xml:id attribute.");
        }
        switch (initialLocName) {
            case "locQualityIssues": {
                lqIssues = new LocQualityIssues(id);
                isLQI = true;
                break;
            }
            case "provenanceRecords": {
                provRecs = new Provenances(id);
                break;
            }
            default: {
                throw new XLIFFReaderException(String.format("Element '%s' is not ITS or is misplaced.", initialLocName));
            }
        }
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    IITSItem item;
                    String tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    if (!nsUri.equals("http://www.w3.org/2005/11/its")) {
                        this.logger.warning(String.format("Ignoring unexpected non-ITS element '%s'.", this.reader.getName().toString()));
                        break;
                    }
                    if (tmp.equals(LOCQUALITYISSUE) && isLQI) {
                        item = this.readLQI(true, ar);
                        if (item == null) {
                            throw new RuntimeException("Invalid <locQualityIssue> element in stand-off group.");
                        }
                        lqIssues.getList().add((LocQualityIssue)item);
                        break;
                    }
                    if (tmp.equals(PROVENANCERECORD) && !isLQI) {
                        item = this.readProvenance(true, ar);
                        if (item == null) {
                            throw new RuntimeException("Invalid <provenanceRecord> element in stand-off group.");
                        }
                        provRecs.getList().add((Provenance)item);
                        break;
                    }
                    this.logger.warning(String.format("Ignoring unexpected ITS element '%s'.", this.reader.getName().toString()));
                    break;
                }
                case 2: {
                    String tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    if (!nsUri.equals("http://www.w3.org/2005/11/its") || !tmp.equals(initialLocName)) break;
                    groupHolder.addITSGroup(lqIssues == null ? provRecs : lqIssues);
                    return;
                }
            }
        }
    }

    public boolean readAttributes(IWithITSGroups groupHolder, IWithITSAttributes object, AnnotatorsRef ar) {
        IITSItem item;
        boolean hasUnresolvedGroup = false;
        this.groupHolder = groupHolder;
        ITSItems list = new ITSItems();
        AnnotatorsRef objAr = this.readAnnotatorsRef(false, ar);
        if (objAr == null) {
            objAr = ar;
        }
        if ((item = this.readLQI(false, objAr)) != null) {
            list.add(item);
            if (item.hasUnresolvedGroup()) {
                hasUnresolvedGroup = true;
            }
        }
        if ((item = this.readProvenance(false, objAr)) != null) {
            list.add(item);
            if (item.hasUnresolvedGroup()) {
                hasUnresolvedGroup = true;
            }
        }
        if ((item = this.readMtConfidence(objAr)) != null) {
            list.add(item);
        }
        if ((item = this.readTextAnalysis(objAr)) != null) {
            list.add(item);
        }
        if ((item = this.readDomain(objAr)) != null) {
            list.add(item);
        }
        if (!list.isEmpty()) {
            object.setITSItems(list);
        }
        return hasUnresolvedGroup;
    }

    public void readTerminology(TermMarker marker, AnnotatorsRef ar) {
        AnnotatorsRef objAr = this.readAnnotatorsRef(false, ar);
        marker.setAnnotatorRef(objAr == null ? ar : objAr);
        String value = this.reader.getAttributeValue("http://www.w3.org/ns/its-xliff/", TERMCONFIDENCE);
        if (value != null) {
            marker.setTermConfidence(Double.parseDouble(value));
        }
    }

    public void fetchUnresolvedITSGroups(IWithITSAttributes parent) {
        DataCategoryGroup<?> group;
        String ref;
        if (!parent.hasITSItem()) {
            return;
        }
        ITSItems items = parent.getITSItems();
        IITSItem item = items.get(Provenance.class);
        if (item != null && item.hasUnresolvedGroup()) {
            Provenance prov = (Provenance)item;
            ref = prov.getUnresolvedGroupRef();
            group = this.findAndMoveReference(ref, Provenances.class.getName());
            if (group == null) {
                throw new XLIFFReaderException(String.format("No stand-off group for provenanceRecordsRef='%s' found at the expected location.", ref));
            }
            prov.setUnresolvedGroupRef(null);
            items.remove(prov);
            items.add(group);
        }
        if ((item = items.get(LocQualityIssue.class)) != null && item.hasUnresolvedGroup()) {
            LocQualityIssue lqi = (LocQualityIssue)item;
            ref = lqi.getUnresolvedGroupRef();
            group = this.findAndMoveReference(ref, LocQualityIssues.class.getName());
            if (group == null) {
                throw new XLIFFReaderException(String.format("No stand-off group for locQualityIssuesRef='%s' found at the expected location.", ref));
            }
            lqi.setUnresolvedGroupRef(null);
            items.remove(lqi);
            items.add(group);
        }
    }

    private IITSItem readLQI(boolean local, AnnotatorsRef ar) {
        LocQualityIssue lqi = new LocQualityIssue();
        lqi.setAnnotatorRef(ar);
        boolean hasData = false;
        String ns = local ? "" : "http://www.w3.org/2005/11/its";
        String value = this.reader.getAttributeValue(ns, LOCQUALITYISSUEENABLED);
        if (this.canBeYesOrNo(LOCQUALITYISSUEENABLED, value)) {
            lqi.setEnabled(value.equals("yes"));
            hasData = true;
        }
        if ((value = this.reader.getAttributeValue(ns, LOCQUALITYISSUETYPE)) != null) {
            lqi.setType(value);
            hasData = true;
        }
        if ((value = this.reader.getAttributeValue(ns, LOCQUALITYISSUECOMMENT)) != null) {
            lqi.setComment(value);
            hasData = true;
        }
        if ((value = this.reader.getAttributeValue(ns, LOCQUALITYISSUEPROFILEREF)) != null) {
            lqi.setProfileRef(value);
            hasData = true;
        }
        if ((value = this.reader.getAttributeValue(ns, LOCQUALITYISSUESEVERITY)) != null) {
            lqi.setSeverity(Double.parseDouble(value));
            hasData = true;
        }
        String ref = this.reader.getAttributeValue(ns, LOCQUALITYISSUESREF);
        AnnotatorsRef localAR = this.readAnnotatorsRef(local, ar);
        if (localAR != null) {
            lqi.setAnnotatorRef(localAR);
        }
        if (hasData) {
            if (ref != null) {
                throw new XLIFFReaderException("You cannot have locQualityIssuesRef with other LQI attributes.");
            }
            if (lqi.getComment() == null && lqi.getType() == null) {
                throw new XLIFFReaderException("The locQualityIssue element must have at least a comment or a type.");
            }
            return lqi;
        }
        if (ref != null) {
            if (!this.reader.getName().getLocalPart().equals("mrk")) {
                lqi.setUnresolvedGroupRef(ref);
                return lqi;
            }
            DataCategoryGroup<?> group = this.findAndMoveReference(ref, LocQualityIssues.class.getName());
            if (group == null) {
                throw new XLIFFReaderException(String.format("No stand-off group for locQualityIssuesRef='%s' found at the expected location.", ref));
            }
            return group;
        }
        return null;
    }

    public AnnotatorsRef readAnnotatorsRef(boolean local, AnnotatorsRef parentAR) {
        String ns = local ? "" : "http://www.w3.org/2005/11/its";
        String values = this.reader.getAttributeValue(ns, ANNOTATORSREF);
        if (values != null) {
            AnnotatorsRef ar = new AnnotatorsRef(parentAR);
            ar.read(values);
            return ar;
        }
        return null;
    }

    private IITSItem readProvenance(boolean local, AnnotatorsRef ar) {
        String value;
        Provenance prov = new Provenance();
        prov.setAnnotatorRef(ar);
        boolean hasData = false;
        String ns = local ? "" : "http://www.w3.org/2005/11/its";
        String[] res = this.getProvenanceFeature(PROVTOOL, ns);
        if (res != null) {
            if (res[0] != null) {
                prov.setTool(res[0]);
            } else {
                prov.setToolRef(res[1]);
            }
            hasData = true;
        }
        if ((res = this.getProvenanceFeature(PROVORG, ns)) != null) {
            if (res[0] != null) {
                prov.setOrg(res[0]);
            } else {
                prov.setOrgRef(res[1]);
            }
            hasData = true;
        }
        if ((res = this.getProvenanceFeature(PROVPERSON, ns)) != null) {
            if (res[0] != null) {
                prov.setPerson(res[0]);
            } else {
                prov.setPersonRef(res[1]);
            }
            hasData = true;
        }
        if ((res = this.getProvenanceFeature(PROVREVTOOL, ns)) != null) {
            if (res[0] != null) {
                prov.setRevTool(res[0]);
            } else {
                prov.setRevToolRef(res[1]);
            }
            hasData = true;
        }
        if ((res = this.getProvenanceFeature(PROVREVORG, ns)) != null) {
            if (res[0] != null) {
                prov.setRevOrg(res[0]);
            } else {
                prov.setRevOrgRef(res[1]);
            }
            hasData = true;
        }
        if ((res = this.getProvenanceFeature(PROVREVPERSON, ns)) != null) {
            if (res[0] != null) {
                prov.setRevPerson(res[0]);
            } else {
                prov.setRevPersonRef(res[1]);
            }
            hasData = true;
        }
        if ((value = this.reader.getAttributeValue(ns, PROVREF)) != null) {
            prov.setProvRef(value);
            hasData = true;
        }
        String ref = this.reader.getAttributeValue(ns, PROVENANCERECORDSREF);
        AnnotatorsRef localAR = this.readAnnotatorsRef(local, ar);
        if (localAR != null) {
            prov.setAnnotatorRef(localAR);
        }
        if (hasData) {
            if (ref != null) {
                throw new XLIFFReaderException("You cannot have provenanceRecordsRef with other Provenance attributes.");
            }
            return prov;
        }
        if (ref != null) {
            if (!this.reader.getName().getLocalPart().equals("mrk")) {
                prov.setUnresolvedGroupRef(ref);
                return prov;
            }
            DataCategoryGroup<?> group = this.findAndMoveReference(ref, Provenances.class.getName());
            if (group == null) {
                throw new XLIFFReaderException(String.format("No stand-off group for provenanceRecordsRef='%s' found at the expected location.", ref));
            }
            return group;
        }
        return null;
    }

    private String[] getProvenanceFeature(String baseName, String ns) {
        String[] res = new String[2];
        String value = this.reader.getAttributeValue(ns, baseName);
        String ref = this.reader.getAttributeValue(ns, baseName + "Ref");
        if (value != null) {
            if (ref != null) {
                throw new XLIFFReaderException(String.format("You cannot specific '%s' and '%s at the samw time.", baseName, baseName + "Ref"));
            }
            res[0] = value;
        } else if (ref != null) {
            res[1] = ref;
        } else {
            return null;
        }
        return res;
    }

    private MTConfidence readMtConfidence(AnnotatorsRef ar) {
        String value = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", MTCONFIDENCE);
        if (value != null) {
            MTConfidence item = new MTConfidence();
            item.setMtConfidence(Double.parseDouble(value));
            item.setAnnotatorRef(ar);
            item.validate();
            return item;
        }
        return null;
    }

    private Domain readDomain(AnnotatorsRef ar) {
        String value = this.reader.getAttributeValue("http://www.w3.org/ns/its-xliff/", DOMAINS);
        if (value != null) {
            Domain item = new Domain(value);
            item.setAnnotatorRef(ar);
            item.validate();
            return item;
        }
        return null;
    }

    private TextAnalysis readTextAnalysis(AnnotatorsRef ar) {
        TextAnalysis item = new TextAnalysis();
        item.setAnnotatorRef(ar);
        boolean hasData = false;
        String value = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", TACONFIDENCE);
        if (value != null) {
            item.setTaConfidence(Double.parseDouble(value));
            hasData = true;
        }
        if ((value = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", TACLASSREF)) != null) {
            item.setTaClassRef(value);
            hasData = true;
        }
        if ((value = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", TASOURCE)) != null) {
            item.setTaSource(value);
            hasData = true;
        }
        if ((value = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", TAIDENT)) != null) {
            item.setTaIdent(value);
            hasData = true;
        }
        if ((value = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", TAIDENTREF)) != null) {
            item.setTaIdentRef(value);
            hasData = true;
        }
        if (hasData) {
            item.validate();
            return item;
        }
        return null;
    }

    private boolean canBeYesOrNo(String name, String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty() || !value.equals("yes") && !value.equals("no")) {
            throw new XLIFFReaderException(String.format("Invalid attribute value for '%s' (must be '%s' or '%s')", name, "yes", "no"));
        }
        return true;
    }

    private DataCategoryGroup<?> findAndMoveReference(String ref, String className) {
        if (!this.groupHolder.hasITSGroup()) {
            return null;
        }
        if (ref.charAt(0) != '#') {
            throw new XLIFFReaderException(String.format("Missing '#' in the reference '%s'", ref));
        }
        int pos = ref.lastIndexOf("its=");
        if (pos == -1) {
            throw new XLIFFReaderException(String.format("Invalid fragment identifier syntax (missing ITS prefix) '%s'", ref));
        }
        String id = ref.substring(pos + 4);
        for (DataCategoryGroup<?> group : this.groupHolder.getITSGroups()) {
            if (!group.getGroupId().equals(id)) continue;
            if (className != null && !className.equals(group.getClass().getName())) {
                throw new XLIFFReaderException(String.format("The reference '%s' was found, but for '%s', not '%s'", ref, group.getClass().getName(), className));
            }
            this.groupHolder.getITSGroups().remove(group);
            return group;
        }
        return null;
    }
}

