/*
 * Decompiled with CFR 0.152.
 */
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;

public class UppercaseStep
extends BasePipelineStep {
    private LocaleId trgLoc;

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.trgLoc = targetLocale;
    }

    public String getName() {
        return "Uppercase";
    }

    public String getDescription() {
        return "Converts text units content to upper cases.";
    }

    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (tu.isTranslatable()) {
            TextContainer tc = tu.createTarget(this.trgLoc, false, 5);
            for (Segment seg : tc.getSegments()) {
                TextFragment tf = seg.getContent();
                tf.setCodedText(tf.getCodedText().toUpperCase());
            }
        }
        return event;
    }
}

