/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.tikal.logger;

import java.io.PrintStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.sf.okapi.applications.tikal.logger.ILogHandler;

class LogHandlerJDK
extends Handler
implements ILogHandler {
    private PrintStream ps;

    protected LogHandlerJDK() {
    }

    @Override
    public void initialize(PrintStream ps) {
        Handler[] handlers;
        if (ps == null) {
            return;
        }
        this.ps = ps;
        this.setLevel(Level.INFO);
        for (Handler handler : handlers = Logger.getLogger("").getHandlers()) {
            Logger.getLogger("").removeHandler(handler);
        }
        Logger.getLogger("").addHandler(this);
    }

    @Override
    public void setLogLevel(int level) {
        switch (level) {
            case 2: {
                this.setLevel(Level.FINE);
                Logger.getLogger("").setLevel(Level.FINE);
                break;
            }
            case 1: {
                this.setLevel(Level.FINEST);
                Logger.getLogger("").setLevel(Level.FINEST);
                break;
            }
            default: {
                this.setLevel(Level.INFO);
                Logger.getLogger("").setLevel(Level.INFO);
            }
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        if (this.ps == null) {
            return;
        }
        Level lev = record.getLevel();
        if (lev == Level.SEVERE) {
            this.ps.println("Error: " + record.getMessage());
            Throwable e = record.getThrown();
            if (e != null) {
                this.ps.println(e.getMessage());
                this.ps.println(" @ " + e.toString());
            }
        } else if (lev == Level.WARNING) {
            if ("org.apache.axis.utils.JavaUtils".equals(record.getLoggerName())) {
                return;
            }
            this.ps.println("Warning: " + record.getMessage());
        } else if (lev == Level.INFO) {
            this.ps.println(record.getMessage());
        } else {
            this.ps.println("Trace: " + record.getMessage());
        }
    }
}

