/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.common.resource.TextFragment;

public class InlineCodeFinder {
    public static final String TAGTYPE = "regxph";
    private ArrayList<String> rules;
    private String sample;
    private boolean useAllRulesWhenTesting;
    private Pattern pattern;

    public InlineCodeFinder() {
        this.reset();
    }

    public void reset() {
        this.rules = new ArrayList();
        this.sample = "";
        this.useAllRulesWhenTesting = false;
    }

    public InlineCodeFinder clone() {
        InlineCodeFinder tmp = new InlineCodeFinder();
        tmp.setSample(this.sample);
        tmp.setUseAllRulesWhenTesting(this.useAllRulesWhenTesting);
        tmp.getRules().addAll(this.getRules());
        return tmp;
    }

    public void addRule(String pattern) {
        this.rules.add(pattern);
    }

    public ArrayList<String> getRules() {
        return this.rules;
    }

    public String getSample() {
        return this.sample;
    }

    public void setSample(String value) {
        this.sample = value;
    }

    public boolean useAllRulesWhenTesting() {
        return this.useAllRulesWhenTesting;
    }

    public void setUseAllRulesWhenTesting(boolean value) {
        this.useAllRulesWhenTesting = value;
    }

    public void compile() {
        StringBuilder tmp = new StringBuilder();
        for (String rule : this.rules) {
            if (tmp.length() > 0) {
                tmp.append("|");
            }
            tmp.append("(" + rule + ")");
        }
        this.pattern = tmp.length() == 2 ? Pattern.compile("") : Pattern.compile(tmp.toString(), 8);
    }

    public void process(TextFragment fragment) {
        if (this.pattern.pattern().length() == 0) {
            return;
        }
        String tmp = fragment.getCodedText();
        Matcher m = this.pattern.matcher(tmp);
        int start = 0;
        int diff = 0;
        while (m.find(start)) {
            diff += fragment.changeToCode(m.start() + diff, m.end() + diff, TextFragment.TagType.PLACEHOLDER, TAGTYPE);
            start = m.end();
            if (start < tmp.length()) continue;
            break;
        }
    }

    public String toString() {
        ParametersString tmp = new ParametersString();
        tmp.setInteger("count", this.rules.size());
        int i = 0;
        for (String rule : this.rules) {
            tmp.setString(String.format("rule%d", i), rule);
            ++i;
        }
        tmp.setString("sample", this.sample);
        tmp.setBoolean("useAllRulesWhenTesting", this.useAllRulesWhenTesting);
        return tmp.toString();
    }

    public void fromString(String data) {
        this.reset();
        ParametersString tmp = new ParametersString(data);
        int count = tmp.getInteger("count", 0);
        for (int i = 0; i < count; ++i) {
            String rule = tmp.getString(String.format("rule%d", i), "");
            if (rule.length() <= 0) continue;
            this.rules.add(rule);
        }
        this.sample = tmp.getString("sample", this.sample);
        this.useAllRulesWhenTesting = tmp.getBoolean("useAllRulesWhenTesting", this.useAllRulesWhenTesting);
    }
}

