/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.sf.okapi.common.exceptions.OkapiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InputStreamFromOutputStream<T>
extends PipedInputStream {
    private static final int DEFAULT_PIPE_SIZE = 4096;
    private static final List<String> ACTIVE_THREAD_NAMES = Collections.synchronizedList(new ArrayList());
    private static int defaultPipeSize = 4096;
    private static final Logger LOG = LoggerFactory.getLogger(DataProducer.class);
    private boolean closeCalled = false;
    private final ExecutorService executorService;
    private Future<T> futureResult;
    private boolean started = false;
    private final PipedOutputStream pipedOs = new PipedOutputStream(){
        private boolean outputStreamCloseCalled = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            1 var1_1 = this;
            synchronized (var1_1) {
                if (this.outputStreamCloseCalled) {
                    return;
                }
                this.outputStreamCloseCalled = true;
            }
            super.close();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] getActiveThreadNames() {
        String[] result;
        List<String> list = ACTIVE_THREAD_NAMES;
        synchronized (list) {
            result = ACTIVE_THREAD_NAMES.toArray(new String[0]);
        }
        return result;
    }

    public static void setDefaultPipeSize(int defaultPipeSize) {
        InputStreamFromOutputStream.defaultPipeSize = defaultPipeSize;
    }

    public InputStreamFromOutputStream() {
        this(false);
    }

    private InputStreamFromOutputStream(boolean startImmediately) {
        super(defaultPipeSize);
        this.executorService = Executors.newSingleThreadExecutor();
        try {
            this.connect(this.pipedOs);
        }
        catch (IOException e) {
            throw new OkapiException("Error during pipe creaton", e);
        }
        if (startImmediately) {
            this.checkInitialized();
        }
    }

    protected void afterClose() throws IOException {
    }

    private void checkException() throws IOException {
        try {
            this.futureResult.get(1L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            IOException e1 = new IOException("Exception producing data");
            e1.initCause(t);
            throw e1;
        }
        catch (InterruptedException e) {
            IOException e1 = new IOException("Thread interrupted");
            e1.initCause(e);
            throw e1;
        }
        catch (TimeoutException e) {
            LOG.error("This timeout should never happen, the thread should terminate correctly. Please contact io-tools support.", e);
        }
    }

    private synchronized void checkInitialized() {
        if (!this.started) {
            this.started = true;
            DataProducer executingCallable = new DataProducer();
            this.futureResult = this.executorService.submit(executingCallable);
        }
    }

    @Override
    public final void close() throws IOException {
        this.checkInitialized();
        if (!this.closeCalled) {
            this.closeCalled = true;
            super.close();
            this.executorService.shutdownNow();
            this.afterClose();
        }
    }

    public T getResult() throws Exception {
        T result;
        if (!this.closeCalled) {
            throw new IllegalStateException("getResult() called before close().This method can be called only after the stream has been closed.");
        }
        try {
            result = this.futureResult.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
        return result;
    }

    protected abstract T produce(OutputStream var1) throws Exception;

    @Override
    public final int read() throws IOException {
        this.checkInitialized();
        int result = super.read();
        if (result < 0) {
            this.checkException();
        }
        return result;
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        this.checkInitialized();
        int result = super.read(b, off, len);
        if (result < 0) {
            this.checkException();
        }
        return result;
    }

    private final class DataProducer
    implements Callable<T> {
        private DataProducer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            Object result;
            String threadName = Thread.currentThread().getName();
            ACTIVE_THREAD_NAMES.add(threadName);
            LOG.debug("thread [" + threadName + "] started.");
            try {
                result = InputStreamFromOutputStream.this.produce(InputStreamFromOutputStream.this.pipedOs);
            }
            finally {
                this.closeStream();
                ACTIVE_THREAD_NAMES.remove(threadName);
                LOG.debug("thread [" + threadName + "] closed.");
            }
            return result;
        }

        private void closeStream() {
            try {
                InputStreamFromOutputStream.this.pipedOs.close();
            }
            catch (IOException e) {
                if (e.getMessage() != null && e.getMessage().indexOf("closed") > 0) {
                    LOG.debug("Stream already closed");
                } else {
                    LOG.error("IOException closing OutputStream Thread might be locked", e);
                }
            }
            catch (Throwable t) {
                LOG.error("Error closing InputStream Thread might be locked", t);
            }
        }
    }
}

