/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.its;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.TermsAnnotation;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.encoder.IEncoder;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiBadFilterParametersException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filters.SubFilter;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.filterwriter.ITSContent;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.its.ContextItem;
import net.sf.okapi.filters.its.Parameters;
import net.sf.okapi.filters.its.TargetPointerEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.its.ITSEngine;

public abstract class ITSFilter
implements IFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Parameters params;
    protected EncoderManager encoderManager;
    protected Document doc;
    protected RawDocument input;
    protected String encoding;
    protected String docName;
    protected LocaleId srcLang;
    protected String lineBreak;
    protected boolean hasUTF8BOM;
    protected GenericSkeleton skel;
    protected IFilterConfigurationMapper fcMapper;
    private final String mimeType;
    private final boolean isHTML5;
    private boolean hasStandoffLocation;
    private boolean hasTargetPointer;
    private String trgLangCode;
    private ITSEngine trav;
    private long dataCategoriesToApply;
    private LinkedList<Event> queue;
    private int tuId;
    private IdGenerator otherId;
    private TextFragment frag;
    private Stack<ContextItem> context;
    private boolean canceled;
    private IEncoder cfEncoder;
    private TermsAnnotation terms;
    private Map<String, String> variables;
    private LinkedHashMap<String, GenericAnnotations> inlineLQIs;
    private boolean inNoEscapeContent;

    public ITSFilter(boolean isHTML5, String mimeType, long dataCategoriesToApply) {
        this.isHTML5 = isHTML5;
        this.mimeType = mimeType;
        this.params = new Parameters();
        this.dataCategoriesToApply = dataCategoriesToApply;
    }

    public void setITSVariables(Map<String, String> map) {
        this.variables = map;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
        }
    }

    @Override
    public abstract ISkeletonWriter createSkeletonWriter();

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.queue != null;
    }

    @Override
    public Event next() {
        if (this.canceled) {
            this.queue = null;
            return new Event(EventType.CANCELED);
        }
        if (this.queue == null) {
            return null;
        }
        do {
            if (this.queue.size() > 0) {
                Event event = this.queue.poll();
                if (event.getEventType() == EventType.END_DOCUMENT) {
                    this.queue = null;
                }
                return event;
            }
            this.process();
        } while (this.queue.size() != 0);
        return null;
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    protected abstract void initializeDocument();

    protected void applyRules(ITSEngine itsEng) {
        itsEng.applyRules(this.dataCategoriesToApply);
    }

    protected abstract void createStartDocumentSkeleton(StartDocument var1);

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.input = input;
        this.canceled = false;
        this.tuId = 0;
        this.otherId = new IdGenerator(null, "o");
        this.hasStandoffLocation = false;
        this.inNoEscapeContent = false;
        this.initializeDocument();
        this.trgLangCode = null;
        if (!Util.isNullOrEmpty(input.getTargetLocale())) {
            this.trgLangCode = input.getTargetLocale().toString().toLowerCase();
        }
        if (this.params.useCodeFinder) {
            this.params.codeFinder.compile();
        }
        this.trav = new ITSEngine(this.doc, input.getInputURI(), input.getEncoding(), this.isHTML5, this.variables);
        if (this.params != null && this.params.getDocument() != null) {
            this.trav.addExternalRules(this.params.getDocument(), this.params.getURI());
        }
        this.applyRules(this.trav);
        this.prepareTargetPointers();
        this.trav.startTraversal();
        this.context = new Stack();
        this.queue = new LinkedList();
        StartDocument startDoc = new StartDocument(this.otherId.createId());
        startDoc.setName(this.docName);
        String realEnc = this.doc.getInputEncoding();
        if (realEnc != null) {
            this.encoding = realEnc;
        }
        startDoc.setEncoding(this.encoding, this.hasUTF8BOM);
        startDoc.setLineBreak(this.lineBreak);
        startDoc.setLocale(this.srcLang);
        this.params.quoteModeDefined = true;
        this.params.quoteMode = 3;
        if (!this.trav.getTranslatableAttributeRuleTriggered() && !this.params.escapeQuotes) {
            this.params.quoteModeDefined = true;
            this.params.quoteMode = 0;
        }
        startDoc.setFilterParameters(this.params);
        startDoc.setFilterWriter(this.createFilterWriter());
        startDoc.setType(this.mimeType);
        startDoc.setMimeType(this.mimeType);
        this.createStartDocumentSkeleton(startDoc);
        startDoc.setSkeleton(this.skel);
        this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
    }

    private void process() {
        this.nullFragment();
        this.skel = new GenericSkeleton();
        if (this.context.size() > 0 && this.context.peek().translate) {
            this.initFragment();
        }
        while (true) {
            Node node;
            if ((node = this.trav.nextNode()) == null) {
                Ending ending = new Ending(this.otherId.createId());
                if (this.skel != null && !this.skel.isEmpty()) {
                    ending.setSkeleton(this.skel);
                }
                this.queue.add(new Event(EventType.END_DOCUMENT, ending));
                return;
            }
            switch (node.getNodeType()) {
                case 4: {
                    if (this.frag == null) {
                        this.skel.append(this.buildCDATA(node));
                        break;
                    }
                    if (this.extract()) {
                        this.frag.append(node.getNodeValue());
                        break;
                    }
                    this.frag.append(TextFragment.TagType.PLACEHOLDER, null, this.buildCDATA(node));
                    break;
                }
                case 3: {
                    if (this.frag == null) {
                        if (this.inNoEscapeContent) {
                            this.skel.append(node.getNodeValue().replace("\n", this.lineBreak));
                            break;
                        }
                        this.skel.append(Util.escapeToXML(node.getNodeValue().replace("\n", this.lineBreak), 0, false, null));
                        break;
                    }
                    if (this.extract()) {
                        if (this.params.lineBreakAsCode) {
                            this.escapeAndAppend(this.frag, node.getNodeValue());
                            break;
                        }
                        this.frag.append(node.getNodeValue());
                        break;
                    }
                    String text = node.getNodeValue().replace("\n", this.params.escapeLineBreak ? "&#10;" : this.lineBreak);
                    Code code = this.frag.append(TextFragment.TagType.PLACEHOLDER, null, Util.escapeToXML(text, 0, false, null));
                    code.setCloneable(true);
                    code.setDeleteable(true);
                    break;
                }
                case 1: {
                    if (!this.processElementTag(node)) break;
                    return;
                }
                case 7: {
                    if (this.frag == null) {
                        this.skel.add(this.buildPI(node));
                        break;
                    }
                    this.frag.append(TextFragment.TagType.PLACEHOLDER, null, this.buildPI(node));
                    break;
                }
                case 8: {
                    if (this.frag == null) {
                        this.skel.add(this.buildComment(node));
                        break;
                    }
                    Code code = this.frag.append(TextFragment.TagType.PLACEHOLDER, null, this.buildComment(node));
                    code.setCloneable(true);
                    code.setDeleteable(true);
                    break;
                }
                case 5: {
                    Code code;
                    if (this.trav.backTracking()) break;
                    if (this.frag == null) {
                        this.skel.add("&" + node.getNodeName() + ";");
                    } else {
                        code = this.frag.append(TextFragment.TagType.PLACEHOLDER, "ref", "&" + node.getNodeName() + ";");
                        code.setCloneable(true);
                        code.setDeleteable(true);
                    }
                    if (!node.hasChildNodes()) break;
                    Node thisNode = node;
                    while ((node = this.trav.nextNode()) != thisNode) {
                    }
                    break;
                }
                case 10: {
                    break;
                }
                case 12: {
                    break;
                }
            }
        }
    }

    private void escapeAndAppend(TextFragment frag, String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\n') {
                Code code = frag.append(TextFragment.TagType.PLACEHOLDER, "lb", "&#10;");
                code.setCloneable(true);
                code.setDeleteable(true);
                continue;
            }
            frag.append(text.charAt(i));
        }
    }

    private void addStartTagToSkeleton(Node node) {
        boolean checkEncoding;
        StringBuilder tmp = new StringBuilder();
        tmp.append("<" + (node.getPrefix() == null ? "" : node.getPrefix() + ":") + node.getLocalName());
        boolean bl = checkEncoding = this.isHTML5 && node.getLocalName().equals("meta");
        if (node.hasAttributes()) {
            NamedNodeMap list = node.getAttributes();
            for (int i = 0; i < list.getLength(); ++i) {
                Attr attr = (Attr)list.item(i);
                if (!attr.getSpecified()) continue;
                tmp.append(" " + (attr.getPrefix() == null ? "" : attr.getPrefix() + ":") + attr.getLocalName() + "=\"");
                if (this.trav.getTranslate(attr) && attr.getValue().length() > 0) {
                    this.skel.append(tmp.toString());
                    tmp.setLength(0);
                    this.addAttributeTextUnit(attr, true);
                    tmp.append("\"");
                    continue;
                }
                if (attr.getName().equals("xml:lang")) {
                    tmp.append(Util.escapeToXML(attr.getNodeValue(), 3, false, null) + "\"");
                    continue;
                }
                if (this.isHTML5 && attr.getName().equals("lang")) {
                    tmp.append(Util.escapeToXML(attr.getNodeValue(), 3, false, null) + "\"");
                    continue;
                }
                if (checkEncoding && attr.getName().equals("charset")) {
                    DocumentPart dp = new DocumentPart(this.otherId.createId(), false);
                    dp.setProperty(new Property("encoding", this.encoding));
                    this.skel.append(tmp.toString());
                    this.skel.addValuePlaceholder(dp, "encoding", LocaleId.EMPTY);
                    this.skel.append("\"");
                    this.queue.add(new Event(EventType.DOCUMENT_PART, dp, this.skel));
                    this.skel = new GenericSkeleton();
                    tmp.setLength(0);
                    continue;
                }
                tmp.append(Util.escapeToXML(attr.getNodeValue(), 3, false, null) + "\"");
            }
        }
        if (!this.isHTML5 && !node.hasChildNodes()) {
            tmp.append("/");
        }
        tmp.append(">");
        this.skel.append(tmp.toString());
    }

    private void addStartTagToFragment(Node node) {
        StringBuilder tmp = new StringBuilder();
        String id = null;
        tmp.append("<" + (node.getPrefix() == null ? "" : node.getPrefix() + ":") + node.getLocalName());
        if (node.hasAttributes()) {
            NamedNodeMap list = node.getAttributes();
            for (int i = 0; i < list.getLength(); ++i) {
                Attr attr = (Attr)list.item(i);
                if (!attr.getSpecified()) continue;
                tmp.append(" " + (attr.getPrefix() == null ? "" : attr.getPrefix() + ":") + attr.getLocalName() + "=\"");
                if (this.trav.getTranslate(attr) && attr.getValue().length() > 0) {
                    id = this.addAttributeTextUnit(attr, false);
                    tmp.append(TextFragment.makeRefMarker(id));
                    tmp.append("\"");
                    continue;
                }
                if (attr.getName().equals("xml:lang")) {
                    tmp.append(Util.escapeToXML(attr.getNodeValue(), 3, false, null) + "\"");
                    continue;
                }
                tmp.append(Util.escapeToXML(attr.getNodeValue(), 3, false, null) + "\"");
            }
        }
        if (!this.isHTML5 && !node.hasChildNodes()) {
            tmp.append("/");
        }
        tmp.append(">");
        Code code = this.frag.append(node.hasChildNodes() ? TextFragment.TagType.OPENING : TextFragment.TagType.PLACEHOLDER, node.getLocalName(), tmp.toString());
        code.setReferenceFlag(id != null);
        this.attachAnnotations(code, this.frag, (Element)node);
        code.setCloneable(true);
        code.setDeleteable(true);
    }

    private void attachAnnotations(Code code, TextFragment frag, Element elem) {
        GenericAnnotations anns;
        if (!this.params.mapAnnotations) {
            return;
        }
        String value = this.trav.getAnnotatorsRef();
        Map<String, String> annotatorsRef = null;
        if (value != null) {
            GenericAnnotation.addAnnotation(code, new GenericAnnotation("its-annotators", "annotatorsValue", value));
            annotatorsRef = ITSContent.annotatorsRefToMap(value);
        }
        if ((value = this.trav.getLocNote(null)) != null) {
            String type = this.trav.getLocNoteType(null);
            GenericAnnotation.addAnnotation(code, new GenericAnnotation("its-ln", "lnValue", value, "lnType", type));
        }
        if ((anns = this.trav.getTextAnalysisAnnotation(null)) != null) {
            anns.getFirstAnnotation("its-ta").setString("annotatorRef", this.getAnnotatorRef(annotatorsRef, "text-analysis"));
            GenericAnnotations.addAnnotations(code, anns);
        }
        StringBuilder extResList = new StringBuilder();
        value = this.trav.getExternalResourceRef(null);
        if (value != null) {
            extResList.append(value);
        }
        NamedNodeMap map = elem.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Attr attr = (Attr)map.item(i);
            value = this.trav.getExternalResourceRef(attr);
            if (value == null) continue;
            if (extResList.length() > 0) {
                extResList.append(" ");
            }
            extResList.append(value);
        }
        if (extResList.length() > 0) {
            GenericAnnotation.addAnnotation(code, new GenericAnnotation("its-externalres", "its-externalresValue", extResList.toString()));
        }
        if ((anns = this.trav.getStorageSizeAnnotation(null)) != null) {
            GenericAnnotations.addAnnotations(code, anns);
        }
        if ((value = this.trav.getAllowedCharacters(null)) != null) {
            GenericAnnotation.addAnnotation(code, new GenericAnnotation("its-allowedchars", "allowedcharsValue", value));
        }
        if ((anns = this.trav.getTerminologyAnnotation(null)) != null) {
            anns.getFirstAnnotation("its-term").setString("annotatorRef", this.getAnnotatorRef(annotatorsRef, "terminology"));
            GenericAnnotations.addAnnotations(code, anns);
        }
        if ((anns = this.trav.getLocQualityRatingAnnotation()) != null) {
            GenericAnnotations.addAnnotations(code, anns);
        }
        if ((anns = this.trav.getLocQualityIssueAnnotations(null)) == null) {
            return;
        }
        if (code.getTagType() == TextFragment.TagType.CLOSING) {
            anns = this.inlineLQIs.get(anns.getData());
            for (GenericAnnotation ann : anns) {
                ann.setInteger("lqiXEnd", frag.length() - 2);
            }
        } else {
            if (this.inlineLQIs == null) {
                this.inlineLQIs = new LinkedHashMap(2);
            }
            for (GenericAnnotation ann : anns) {
                ann.setInteger("lqiXStart", frag.length());
            }
            this.inlineLQIs.put(anns.getData(), anns);
        }
    }

    private void applyCodeFinder(TextFragment tf) {
        this.params.codeFinder.process(tf);
        List<Code> codes = tf.getCodes();
        for (Code code : codes) {
            if (!code.getType().equals("regxph")) continue;
            if (this.cfEncoder == null) {
                this.encoderManager.setDefaultOptions(this.getParameters(), this.encoding, this.lineBreak);
                this.encoderManager.updateEncoder(this.getMimeType());
                this.cfEncoder = this.getEncoderManager().getEncoder();
                this.cfEncoder.setOptions(this.params, "utf-8", this.lineBreak);
            }
            code.setData(this.cfEncoder.encode(code.getData(), EncoderContext.TEXT));
        }
    }

    private String addAttributeTextUnit(Attr attr, boolean addToSkeleton) {
        String id = String.valueOf(++this.tuId);
        TextUnit tu = new TextUnit(id, attr.getValue(), true, this.mimeType);
        if (this.params.useCodeFinder) {
            this.applyCodeFinder(tu.getSource().getFirstContent());
        }
        ContextItem ci = new ContextItem(this.context.isEmpty() ? attr.getParentNode() : this.context.peek().node, this.trav, attr);
        this.processTextUnit(tu, ci, null, attr);
        this.queue.add(new Event(EventType.TEXT_UNIT, tu));
        if (addToSkeleton) {
            this.skel.addReference(tu);
        }
        return id;
    }

    private String buildEndTag(Node node) {
        if (node.hasChildNodes()) {
            return "</" + (node.getPrefix() == null ? "" : node.getPrefix() + ":") + node.getLocalName() + ">";
        }
        return "";
    }

    private String buildPI(Node node) {
        return "<?" + node.getNodeName() + " " + node.getNodeValue() + "?>";
    }

    private String buildCDATA(Node node) {
        return "<![CDATA[" + node.getNodeValue().replace("\n", this.lineBreak) + "]]>";
    }

    private String buildComment(Node node) {
        return "<!--" + node.getNodeValue().replace("\n", this.lineBreak) + "-->";
    }

    private boolean processElementTag(Node node) {
        if (this.trav.backTracking()) {
            if (this.trav.getTerm(null)) {
                if (this.terms == null) {
                    this.terms = new TermsAnnotation();
                }
                this.terms.add(node.getTextContent(), this.trav.getTermInfo(null));
            }
            if (this.isHTML5 && node.getNodeName().equals("body") && !this.hasStandoffLocation) {
                DocumentPart dp;
                this.hasStandoffLocation = true;
                if (this.frag != null) {
                    this.addTextUnit(node, false);
                }
                if (!this.skel.isEmpty()) {
                    dp = new DocumentPart(this.otherId.createId(), false, this.skel);
                    this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                    this.skel = new GenericSkeleton();
                }
                this.skel.add("$#@StandOff@#$");
                dp = new DocumentPart(this.otherId.createId(), false, this.skel);
                this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                this.skel = new GenericSkeleton();
            }
            if (this.frag == null) {
                this.skel.add(this.buildEndTag(node));
                if (node.isSameNode(this.context.peek().node)) {
                    this.context.pop();
                }
                if (this.isContextTranslatable()) {
                    this.initFragment();
                }
            } else {
                if (node.isSameNode(this.context.peek().node)) {
                    return this.addTextUnit(node, true);
                }
                Code code = this.frag.append(TextFragment.TagType.CLOSING, node.getLocalName(), this.buildEndTag(node));
                this.attachAnnotations(code, this.frag, (Element)node);
                code.setCloneable(true);
                code.setDeleteable(true);
            }
            if (this.isHTML5 && "script|style".indexOf(node.getLocalName()) != -1) {
                this.inNoEscapeContent = false;
            }
        } else {
            TargetPointerEntry tpe;
            if (this.hasTargetPointer && (tpe = this.getTargetPointerEntry(node)) != null) {
                if (tpe.getTargetNode() == node) {
                    tpe.toString();
                } else {
                    tpe.toString();
                }
            }
            if (this.trav.getSubFilter(null) != null) {
                this.processSubFilterContent(node, this.trav.getSubFilter(null));
                this.moveToEnd(node);
                return true;
            }
            switch (this.trav.getWithinText()) {
                case 1: 
                case 2: {
                    if (this.frag == null) {
                        this.addStartTagToSkeleton(node);
                        if (!node.hasChildNodes()) break;
                        this.context.push(new ContextItem(node, this.trav));
                        break;
                    }
                    this.addStartTagToFragment(node);
                    break;
                }
                default: {
                    if (this.frag == null) {
                        this.addStartTagToSkeleton(node);
                        if (this.extract()) {
                            this.initFragment();
                        }
                        if (node.hasChildNodes()) {
                            this.context.push(new ContextItem(node, this.trav));
                        }
                        if (!this.isHTML5 || "script|style".indexOf(node.getLocalName()) == -1) break;
                        this.inNoEscapeContent = true;
                        break;
                    }
                    this.addTextUnit(node, false);
                    this.addStartTagToSkeleton(node);
                    if (this.extract()) {
                        this.initFragment();
                    }
                    if (!node.hasChildNodes()) break;
                    this.context.push(new ContextItem(node, this.trav));
                }
            }
        }
        return false;
    }

    private void moveToEnd(Node start) {
        Node node = null;
        while ((node = this.trav.nextNode()) != null) {
            if (node != start) continue;
            return;
        }
    }

    private void processSubFilterContent(Node node, String configId) {
        this.addStartTagToSkeleton(node);
        IFilter sf = this.fcMapper.createFilter(configId, null);
        if (sf == null) {
            throw new OkapiBadFilterInputException(String.format("Could not instantiate subfilter '%s'.", configId));
        }
        this.encoderManager.setDefaultOptions(this.getParameters(), this.encoding, this.lineBreak);
        this.encoderManager.updateEncoder(this.getMimeType());
        SubFilter subfilter = new SubFilter(sf, this.getEncoderManager().getEncoder(), 1, "parentId", null);
        String content = node.getTextContent();
        subfilter.open(new RawDocument(content, this.srcLang));
        while (subfilter.hasNext()) {
            this.queue.add(subfilter.next());
        }
        subfilter.close();
        GenericSkeleton skelAfter = new GenericSkeleton();
        skelAfter.add(this.buildEndTag(node));
        this.queue.add(subfilter.createRefEvent(this.skel, skelAfter));
        this.skel = new GenericSkeleton();
    }

    private boolean extract() {
        if (!this.trav.getTranslate(null)) {
            return false;
        }
        String list = this.trav.getLocaleFilter();
        if (list == null || list.equals("*")) {
            return true;
        }
        if (list.isEmpty() || list.equals("!*")) {
            return false;
        }
        if (this.trgLangCode == null) {
            this.logger.warn("No target locale specified: Cannot use the provided ITS Locale Filter data category.");
            return true;
        }
        return ITSContent.isExtendedMatch(list, this.trgLangCode);
    }

    private boolean isContextTranslatable() {
        if (this.context.size() == 0) {
            return false;
        }
        return this.context.peek().translate;
    }

    private boolean addTextUnit(Node node, boolean popStack) {
        boolean extract;
        boolean bl = extract = this.frag.hasText(false) || this.params.extractIfOnlyCodes && this.frag.hasCode();
        if (extract) {
            if (this.params.useCodeFinder) {
                this.applyCodeFinder(this.frag);
            }
            boolean bl2 = extract = this.frag.hasText(false) || this.params.extractIfOnlyCodes && this.frag.hasCode();
        }
        if (!extract) {
            if (!this.frag.isEmpty()) {
                this.skel.add(this.frag.toText().replace("\n", this.params.escapeLineBreak ? "&#10;" : this.lineBreak));
            }
            this.nullFragment();
            if (popStack) {
                this.context.pop();
                this.skel.add(this.buildEndTag(node));
                if (this.isContextTranslatable()) {
                    this.initFragment();
                }
            }
            return false;
        }
        TextUnit tu = new TextUnit(String.valueOf(++this.tuId));
        tu.setMimeType(this.mimeType);
        tu.setSourceContent(this.frag);
        this.processTextUnit(tu, this.context.peek(), node.getNodeName(), null);
        this.skel.addContentPlaceholder(tu);
        if (popStack) {
            this.context.pop();
            this.skel.add(this.buildEndTag(node));
        }
        tu.setSkeleton(this.skel);
        this.queue.add(new Event(EventType.TEXT_UNIT, tu));
        this.nullFragment();
        if (popStack && this.isContextTranslatable()) {
            this.initFragment();
        }
        this.skel = new GenericSkeleton();
        return true;
    }

    private String getAnnotatorRef(Map<String, String> map, String dataCategory) {
        if (map == null) {
            return null;
        }
        return map.get(dataCategory);
    }

    private void processTextUnit(ITextUnit tu, ContextItem ci, String nodeName, Attr attribute) {
        String value = this.trav.getAnnotatorsRef();
        Map<String, String> annotatorsRef = null;
        if (value != null) {
            GenericAnnotation.addAnnotation(tu, new GenericAnnotation("its-annotators", "annotatorsValue", value));
            annotatorsRef = ITSContent.annotatorsRefToMap(value);
        }
        if (!Util.isEmpty(ci.locNote)) {
            tu.setProperty(new Property("note", ci.locNote));
            String type = this.trav.getLocNoteType(attribute);
            GenericAnnotation.addAnnotation(tu, new GenericAnnotation("its-ln", "lnValue", ci.locNote, "lnType", type));
        }
        if (!Util.isEmpty(ci.domains)) {
            GenericAnnotation.addAnnotation(tu, new GenericAnnotation("its-domain", "domainValue", ci.domains));
        }
        if (ci.ta != null) {
            ci.ta.getFirstAnnotation("its-ta").setString("annotatorRef", this.getAnnotatorRef(annotatorsRef, "text-analysis"));
            GenericAnnotations.addAnnotations(tu.getSource(), ci.ta);
        }
        if (!Util.isEmpty(ci.externalRes)) {
            GenericAnnotation.addAnnotation(tu, new GenericAnnotation("its-externalres", "its-externalresValue", ci.externalRes));
        }
        if (ci.mtConfidence != null) {
            GenericAnnotation.addAnnotation(tu, new GenericAnnotation("its-mtconfidence", "its-mtconfidenceValue", ci.mtConfidence, "annotatorRef", this.getAnnotatorRef(annotatorsRef, "mt-confidence")));
        }
        if (ci.storageSize != null) {
            GenericAnnotations.addAnnotations(tu.getSource(), ci.storageSize);
        }
        if (ci.allowedChars != null) {
            GenericAnnotation.addAnnotation(tu.getSource(), new GenericAnnotation("its-allowedchars", "allowedcharsValue", ci.allowedChars));
        }
        if (ci.prov != null) {
            GenericAnnotations.addAnnotations(tu, ci.prov);
        }
        if (ci.lqRating != null) {
            GenericAnnotations.addAnnotations(tu.getSource(), ci.lqRating);
        }
        if (ci.lqIssues != null) {
            GenericAnnotations.addAnnotations(tu.getSource(), ci.lqIssues);
        }
        if (this.inlineLQIs != null) {
            for (GenericAnnotations anns : this.inlineLQIs.values()) {
                GenericAnnotations.addAnnotations(tu.getSource(), anns);
            }
        }
        if (ci.terminology != null) {
            ci.terminology.getFirstAnnotation("its-term").setString("annotatorRef", this.getAnnotatorRef(annotatorsRef, "terminology"));
            GenericAnnotations.addAnnotations(tu.getSource(), ci.terminology);
        }
        if (this.terms != null) {
            tu.getSource().setAnnotation(this.terms);
            this.terms = null;
        }
        tu.setName(ci.idValue);
        if (this.isHTML5 && nodeName != null && (nodeName.equals("pre") || nodeName.equals("textarea"))) {
            ci.preserveWS = true;
        }
        if (ci.preserveWS) {
            tu.setPreserveWhitespaces(true);
        } else {
            tu.setPreserveWhitespaces(false);
            tu.getSource().unwrap(false, true);
        }
    }

    private void initFragment() {
        this.frag = new TextFragment();
        this.inlineLQIs = null;
    }

    private void nullFragment() {
        this.frag = null;
        this.inlineLQIs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareTargetPointers() {
        this.hasTargetPointer = false;
        try {
            Node srcNode;
            if (!this.trav.getTargetPointerRuleTriggered()) {
                return;
            }
            this.trav.startTraversal();
            while ((srcNode = this.trav.nextNode()) != null) {
                String pointer;
                if (srcNode.getNodeType() != 1 || this.trav.backTracking()) continue;
                if (this.trav.getTranslate(null) && (pointer = this.trav.getTargetPointer(null)) != null) {
                    if (this.trav.getWithinText() != 0) {
                        throw new OkapiBadFilterParametersException("An element within text or nested cannot use the Target Pointer data category.");
                    }
                    this.setTargetPointerPair(this.trav.getXPath(), false, srcNode, pointer);
                }
                NamedNodeMap map = ((Element)srcNode).getAttributes();
                for (int i = 0; i < map.getLength(); ++i) {
                    String pointer2;
                    Attr attr = (Attr)map.item(i);
                    if (!this.trav.getTranslate(attr) || (pointer2 = this.trav.getTargetPointer(attr)) == null) continue;
                    this.setTargetPointerPair(this.trav.getXPath(), true, attr, pointer2);
                }
            }
        }
        finally {
            this.trav.startTraversal();
        }
    }

    private void setTargetPointerPair(XPath xpath, boolean isAttributeNode, Node srcNode, String pointer) {
        try {
            XPathExpression expr = xpath.compile(pointer);
            Node trgNode = isAttributeNode ? (Node)expr.evaluate(((Attr)srcNode).getOwnerElement(), XPathConstants.NODE) : (Node)expr.evaluate(srcNode, XPathConstants.NODE);
            if (trgNode == null) {
                throw new OkapiIOException("the Target Pointer feature does not yet support pairs with non-existing target node.");
            }
            if (srcNode.getNodeType() != trgNode.getNodeType()) {
                this.logger.warn("Potential issue with target pointer '{}'.\nThe source and target node are of different types. Depending on the content of the source, this may or may not be an issue.", (Object)pointer);
            }
            TargetPointerEntry tpe = new TargetPointerEntry(srcNode, trgNode);
            srcNode.setUserData("\u10ff", tpe, null);
            trgNode.setUserData("\u20ff", tpe, null);
            this.hasTargetPointer = true;
            boolean translate = isAttributeNode ? this.trav.getTranslate((Attr)srcNode) : this.trav.getTranslate(null);
            tpe.setTranslate(translate);
            if (!translate) {
                return;
            }
            if (trgNode.getNodeType() == 1) {
                tpe.setHasExistingTargetContent(trgNode.hasChildNodes());
                if (!trgNode.hasChildNodes()) {
                    if (isAttributeNode) {
                        trgNode.setTextContent(srcNode.getTextContent());
                    } else {
                        for (Node tmp = srcNode.getFirstChild(); tmp != null; tmp = tmp.getNextSibling()) {
                            trgNode.appendChild(tmp.cloneNode(true));
                        }
                    }
                }
            } else {
                String text = trgNode.getTextContent();
                tpe.setHasExistingTargetContent(!text.isEmpty());
                if (text.isEmpty()) {
                    trgNode.setTextContent(srcNode.getTextContent());
                }
            }
        }
        catch (XPathExpressionException e) {
            throw new OkapiIOException(String.format("Bab XPath expression in target pointer '%s'.", pointer));
        }
    }

    public TargetPointerEntry getTargetPointerEntry(Node node) {
        TargetPointerEntry tpe = (TargetPointerEntry)node.getUserData("\u20ff");
        if (tpe != null || (tpe = (TargetPointerEntry)node.getUserData("\u10ff")) != null) {
            // empty if block
        }
        return tpe;
    }
}

