/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.ITSLQIAnnotations;
import net.sf.okapi.common.annotation.ITSProvenanceAnnotations;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.filters.xliff.its.IITSDataStore;
import net.sf.okapi.filters.xliff.its.ITSStandoffManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLIFFITSFilterExtension {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ITSStandoffManager itsStandoffManager;
    private XMLStreamReader reader;
    private XMLInputFactory xmlFactory;
    private URI docURI;
    private XLIFFFilter filter;

    public XLIFFITSFilterExtension(XMLInputFactory xmlFactory, IITSDataStore datastore, URI docURI, XLIFFFilter filter) {
        this.xmlFactory = xmlFactory;
        this.itsStandoffManager = new ITSStandoffManager(datastore);
        this.docURI = docURI;
        this.filter = filter;
    }

    public void parseInDocumentITSStandoff(XMLEventReader eventReader, String inStreamCharset) throws XMLStreamException {
        this.itsStandoffManager.parseXLIFF(eventReader, "", inStreamCharset);
    }

    public static int[] parseXLQIPos(String data, Logger logger) {
        int[] values = new int[]{0, -1, 0, -1};
        String[] items = data.split("\\s", 0);
        if (items.length != 4) {
            logger.warn("Invalid set of values for lqiPos: '{}'.", (Object)data);
        } else {
            try {
                values[0] = Integer.valueOf(items[0]);
                values[1] = Integer.valueOf(items[1]);
                values[2] = Integer.valueOf(items[2]);
                values[3] = Integer.valueOf(items[3]);
            }
            catch (NumberFormatException e) {
                logger.warn("At least one value is invalid in lqiPos: '{}'.", (Object)data);
            }
        }
        return values;
    }

    public void setXLIFFReader(XMLStreamReader reader) {
        this.reader = reader;
    }

    public ITSStandoffManager getITSStandoffManager() {
        return this.itsStandoffManager;
    }

    protected void readTextUnitITSAttributes(ITextUnit resource) throws IOException {
        GenericAnnotations anns = new GenericAnnotations();
        String val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssuesRef");
        if (val1 != null) {
            ITSLQIAnnotations lqiAnn = this.readITSLQI();
            ITSLQIAnnotations.addAnnotations(resource, lqiAnn);
            anns.addAll(lqiAnn);
        } else {
            val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssueComment");
            String val2 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssueType");
            if (val1 != null || val2 != null) {
                this.logger.warn("ITS Localization Quality Issue data category is to be used only on the main source and target and on mrk.");
            }
        }
        ITSProvenanceAnnotations provAnn = this.readITSProvenance();
        ITSProvenanceAnnotations.addAnnotations(resource, provAnn);
        anns.addAll(provAnn);
        anns.add(this.readITSExternalResource());
        anns.add(this.readITSLocaleFilter());
        anns.add(this.filter.getAnnotatorsRefContext().getAnnotation());
        val1 = this.reader.getAttributeValue("http://www.w3.org/ns/its-xliff/", "domains");
        if (val1 != null) {
            anns.add(new GenericAnnotation("its-domain", "domainValue", val1));
        }
        if (anns.size() > 0) {
            GenericAnnotations.addAnnotations(resource, anns);
        }
    }

    protected GenericAnnotations readTextContainerITSAttributes() throws IOException {
        GenericAnnotations anns = new GenericAnnotations();
        anns.addAll(this.readITSLQI());
        anns.addAll(this.readITSProvenance());
        anns.add(this.readITSAllowedCharacters());
        anns.add(this.readITSMtConfidence());
        anns.add(this.readITSStorageSize());
        anns.add(this.readITSLQR());
        return anns.size() > 0 ? anns : null;
    }

    protected GenericAnnotations readInlineCodeITSAttributes() throws IOException {
        String taClassRef;
        String mtype;
        GenericAnnotations anns = new GenericAnnotations();
        anns.addAll(this.readITSLQI());
        anns.add(this.readITSAllowedCharacters());
        anns.add(this.readITSMtConfidence());
        anns.add(this.readITSStorageSize());
        anns.add(this.readITSLQR());
        anns.add(this.readITSExternalResource());
        anns.add(this.readITSLocaleFilter());
        anns.add(this.filter.getAnnotatorsRefContext().getAnnotation());
        String val = this.reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
        if (val != null) {
            anns.add(new GenericAnnotation("its-lang", "langValue", val));
        }
        if ((val = this.reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "space")) != null) {
            if (val.equals("preserve") || val.equals("default")) {
                anns.add(new GenericAnnotation("its-preservews", "preservewsInfo", val));
            } else {
                this.logger.error("Invalid value for xml:space ('{}').", (Object)val);
            }
        }
        if ((val = this.reader.getAttributeValue(null, "comment")) != null) {
            anns.add(new GenericAnnotation("its-ln", "lnValue", val));
        }
        if ((mtype = this.reader.getAttributeValue(null, "mtype")) != null && mtype.equals("term")) {
            String info = this.reader.getAttributeValue("http://www.w3.org/ns/its-xliff/", "termInfo");
            String infoRef = this.reader.getAttributeValue("http://www.w3.org/ns/its-xliff/", "termInfoRef");
            if (info != null && infoRef != null) {
                this.logger.error("Cannot have both termInfo and termInfoRef on the same element. termInfo will be used.");
            } else if (infoRef != null) {
                info = "REF:" + infoRef;
            }
            val = this.reader.getAttributeValue("http://www.w3.org/ns/its-xliff/", "termConfidence");
            Double conf = null;
            if (val != null) {
                conf = Double.parseDouble(val);
            }
            anns.add(new GenericAnnotation("its-term", "termInfo", info, "termConfidence", conf, "annotatorRef", this.filter.getAnnotatorsRefContext().getAnnotatorRef("terminology")));
        }
        if ((taClassRef = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "taClassRef")) != null) {
            taClassRef = "REF:" + taClassRef;
        }
        String taSource = null;
        String taIdent = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "taIdentRef");
        if (taIdent != null) {
            taIdent = "REF:" + taIdent;
        } else {
            taIdent = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "taIdent");
            taSource = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "taSource");
        }
        if (taClassRef != null || taIdent != null) {
            val = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "taConfidence");
            Double conf = null;
            if (val != null) {
                conf = Double.parseDouble(val);
            }
            anns.add(new GenericAnnotation("its-ta", "taClass", taClassRef, "taSource", taSource, "taIdent", taIdent, "taConfidence", conf, "annotatorRef", this.filter.getAnnotatorsRefContext().getAnnotatorRef("text-analysis")));
        }
        return anns.size() > 0 ? anns : null;
    }

    protected ITSLQIAnnotations readITSLQI() throws IOException {
        ITSLQIAnnotations lqiAnns = new ITSLQIAnnotations();
        String val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssuesRef");
        if (val1 != null) {
            String r = XLIFFITSFilterExtension.getResourcePart(val1);
            if (!r.equals("")) {
                this.fetchStandoffData(r);
            }
            this.itsStandoffManager.addLQIAnnotation(lqiAnns, val1);
        } else {
            val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssueComment");
            String val2 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssueType");
            if (val1 != null || val2 != null) {
                GenericAnnotation ann = new GenericAnnotation("its-lqi", "lqiComment", val1, "lqiType", val2);
                val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssueSeverity");
                if (val1 != null) {
                    ann.setDouble("lqiSeverity", Double.parseDouble(val1));
                }
                if ((val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssueProfileRef")) != null) {
                    ann.setString("lqiProfileRef", val1);
                }
                if ((val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssueEnabled")) != null) {
                    ann.setBoolean("lqiEnabled", val1.equals("yes"));
                }
                if ((val1 = this.reader.getAttributeValue("okapi-framework:xliff-extensions", "lqiPos")) != null) {
                    int[] values = XLIFFITSFilterExtension.parseXLQIPos(val1, this.logger);
                    ann.setInteger("lqiXStart", values[0]);
                    ann.setInteger("lqiXEnd", values[1]);
                    ann.setInteger("lqiXTrgStart", values[2]);
                    ann.setInteger("lqiXTrgEnd", values[3]);
                }
                if ((val1 = this.reader.getAttributeValue("okapi-framework:xliff-extensions", "lqiCodes")) != null) {
                    ann.setString("lqiXCodes", val1);
                }
                if ((val1 = this.reader.getAttributeValue("okapi-framework:xliff-extensions", "lqiSegId")) != null) {
                    ann.setString("lqiXSegId", val1);
                }
                lqiAnns.add(ann);
            }
        }
        return lqiAnns.size() > 0 ? lqiAnns : null;
    }

    protected ITSProvenanceAnnotations readITSProvenance() throws IOException {
        ITSProvenanceAnnotations provAnns = new ITSProvenanceAnnotations();
        String val = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "provenanceRecordsRef");
        if (val != null) {
            String r = XLIFFITSFilterExtension.getResourcePart(val);
            if (r.isEmpty()) {
                this.fetchStandoffData(r);
            }
            this.itsStandoffManager.addProvAnnotation(provAnns, val);
        } else {
            GenericAnnotation ga = new GenericAnnotation("its-prov");
            this.readProvFields(ga, "provPerson", "provRevPerson", "person");
            this.readProvFields(ga, "provOrg", "provRevOrg", "org");
            this.readProvFields(ga, "provTool", "provRevTool", "tool");
            ga.setString("provRef", this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "provRef"));
            if (ga.getFieldCount() > 0) {
                provAnns.add(ga);
            }
        }
        return provAnns.size() > 0 ? provAnns : null;
    }

    private void readProvFields(GenericAnnotation ga, String fieldName, String revFieldName, String attributeBaseName) {
        String val = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", attributeBaseName);
        if (val != null) {
            ga.setString(fieldName, val);
        } else {
            val = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", attributeBaseName + "Ref");
            if (val != null) {
                ga.setString(fieldName, "REF:" + val);
            }
        }
        String baseRevName = "rev" + Character.toUpperCase(attributeBaseName.charAt(0)) + attributeBaseName.substring(1);
        val = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", baseRevName);
        if (val != null) {
            ga.setString(revFieldName, val);
        } else {
            val = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", baseRevName + "Ref");
            if (val != null) {
                ga.setString(revFieldName, "REF:" + val);
            }
        }
    }

    protected GenericAnnotation readITSAllowedCharacters() {
        String val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "allowedCharacters");
        return val1 == null ? null : new GenericAnnotation("its-allowedchars", "allowedcharsValue", val1);
    }

    protected GenericAnnotation readITSMtConfidence() {
        String val = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "mtConfidence");
        return val == null ? null : new GenericAnnotation("its-mtconfidence", "its-mtconfidenceValue", Double.parseDouble(val), "annotatorRef", this.filter.getAnnotatorsRefContext().getAnnotatorRef("mt-confidence"));
    }

    protected GenericAnnotation readITSLQR() {
        GenericAnnotation ann = null;
        String profile = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityRatingProfileRef");
        String val = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityRatingScore");
        if (val != null) {
            Double score = Double.parseDouble(val);
            Double threshold = null;
            val = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityRatingScoreThreshold");
            if (val != null) {
                threshold = Double.parseDouble(val);
            }
            ann = new GenericAnnotation("its-lqr", "lqrScore", score, "lqrScoreThreshold", threshold, "lqrProfileRef", profile);
        } else {
            val = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityRatingVote");
            if (val != null) {
                Integer vote = Integer.parseInt(val);
                Integer threshold = null;
                val = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityRatingVoteThreshold");
                if (val != null) {
                    threshold = Integer.parseInt(val);
                }
                ann = new GenericAnnotation("its-lqr", "lqrVote", vote, "lqrVoteThreshold", threshold, "lqrProfileRef", profile);
            }
        }
        return ann;
    }

    protected GenericAnnotation readITSStorageSize() {
        GenericAnnotation ann = null;
        String val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "storageSize");
        if (val1 != null) {
            String lb;
            String enc = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "storageEncoding");
            if (enc == null) {
                enc = "UTF-8";
            }
            if ((lb = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "lineBreakType")) == null) {
                lb = "lf";
            }
            ann = new GenericAnnotation("its-storagesize", "storagesizeSize", Integer.parseInt(val1), "storagesizeEncoding", enc, "storagesizeLinebreak", lb);
        }
        return ann;
    }

    protected GenericAnnotation readITSExternalResource() {
        String val1 = this.reader.getAttributeValue("http://www.w3.org/ns/its-xliff/", "externalResourceRef");
        return val1 == null ? null : new GenericAnnotation("its-externalres", "its-externalresValue", val1);
    }

    protected GenericAnnotation readITSLocaleFilter() {
        String val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "localeFilterList");
        if (val1 != null) {
            String val2 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "localeFilterType");
            if (val2 != null) {
                if (val2.equals("exclude")) {
                    val1 = "!" + val1;
                } else if (val2.equals("include")) {
                    this.logger.warn("Invalid value for ITS localeFilterType ({}).", (Object)val2);
                    return null;
                }
            }
            return new GenericAnnotation("its-locfilter", "its-locfilterValue", val1);
        }
        return null;
    }

    private void fetchStandoffData(String resource) throws IOException {
        if (!this.itsStandoffManager.alreadyParsed(resource)) {
            URL resourceURL;
            try {
                resourceURL = new URL(resource);
            }
            catch (MalformedURLException ex) {
                if (this.docURI != null) {
                    try {
                        resourceURL = this.docURI.resolve(resource).toURL();
                    }
                    catch (MalformedURLException ex1) {
                        this.logger.warn("Resource '" + resource + "' not a valid URL", ex);
                        throw new OkapiIOException("Bad uri for resource: " + resource, ex1);
                    }
                }
                throw new OkapiIOException("Resource '" + resource + "' not a valid URL", ex);
            }
            try (InputStreamReader externalResource = null;
                 InputStream is = resourceURL.openStream();){
                String charset = StandardCharsets.UTF_8.name();
                BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(is, StandardCharsets.UTF_8);
                detector.detectBom();
                if (detector.isAutodetected()) {
                    charset = detector.getEncoding();
                }
                externalResource = new InputStreamReader(is, charset);
                this.itsStandoffManager.parseXLIFF(this.xmlFactory.createXMLEventReader(externalResource), resource, charset);
            }
        }
    }

    protected static String getResourcePart(String uriRef) {
        int pn = uriRef.lastIndexOf(35);
        return pn > 0 ? uriRef.substring(0, pn) : "";
    }

    protected static String getFragmentIdPart(String uriRef) {
        int pn = uriRef.lastIndexOf(35);
        return uriRef.substring(pn + 1);
    }
}

