/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.persistence.json.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.lib.persistence.json.jackson.JSONBean;

public class JSONUtil {
    private static ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);

    public static <T> String toJSON(T obj) {
        return JSONUtil.toJSON(obj, false);
    }

    public static <T> String toJSON(T obj, boolean prettyPrint) {
        JSONBean<T> bean = new JSONBean<T>();
        bean.setClassName(ClassUtil.getQualifiedClassName(obj));
        try {
            if (prettyPrint) {
                mapper.enable(SerializationFeature.INDENT_OUTPUT);
            } else {
                mapper.disable(SerializationFeature.INDENT_OUTPUT);
            }
            bean.setContent(obj);
            return Util.normalizeNewlines(mapper.writeValueAsString(bean));
        }
        catch (JsonProcessingException e) {
            throw new OkapiIOException(e);
        }
    }

    public static <T> T fromJSON(String json) {
        try {
            JSONBean bean = (JSONBean)mapper.readValue(json, new TypeReference<JSONBean<T>>(){});
            Class<?> cls = Class.forName(bean.getClassName());
            String content = mapper.writeValueAsString(bean.getContent());
            return (T)mapper.readValue(content, cls);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new OkapiIOException(e);
        }
    }
}

