/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Util;
import net.sf.okapi.lib.verification.BlackTerm;
import net.sf.okapi.lib.verification.BlacklistReader;

class BlacklistTB {
    private List<BlackTerm> entries;

    public BlacklistTB() {
        this.reset();
    }

    private void reset() {
        this.entries = new ArrayList<BlackTerm>();
    }

    public void guessAndImport(File file) {
        String ext = Util.getExtension(file.getPath());
        if (!ext.equalsIgnoreCase(".xyz")) {
            this.importTSV(file);
        }
    }

    public void removeAll() {
        this.entries.clear();
    }

    public List<BlackTerm> getBlacklistStrings() {
        return this.entries;
    }

    private void importTSV(File file) {
        this.importBlacklist(new BlacklistReader(), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importBlacklist(BlacklistReader reader, File file) {
        try {
            reader.open(file);
            while (reader.hasNext()) {
                BlackTerm bterm = reader.next();
                this.entries.add(bterm);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

