/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.reader;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import net.sf.okapi.lib.xliff2.URIParser;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.CanReorder;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.ExtAttribute;
import net.sf.okapi.lib.xliff2.core.ExtAttributes;
import net.sf.okapi.lib.xliff2.core.ExtContent;
import net.sf.okapi.lib.xliff2.core.ExtElement;
import net.sf.okapi.lib.xliff2.core.ExtElements;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.IExtChild;
import net.sf.okapi.lib.xliff2.core.IWithExtAttributes;
import net.sf.okapi.lib.xliff2.core.IWithInheritedData;
import net.sf.okapi.lib.xliff2.core.IWithMetadata;
import net.sf.okapi.lib.xliff2.core.IWithNotes;
import net.sf.okapi.lib.xliff2.core.IWithValidation;
import net.sf.okapi.lib.xliff2.core.InheritedData;
import net.sf.okapi.lib.xliff2.core.InsingnificantPartData;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.MidFileData;
import net.sf.okapi.lib.xliff2.core.Note;
import net.sf.okapi.lib.xliff2.core.Notes;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.ProcessingInstruction;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Skeleton;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.Store;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Tags;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.glossary.GlossEntry;
import net.sf.okapi.lib.xliff2.glossary.Glossary;
import net.sf.okapi.lib.xliff2.glossary.Translation;
import net.sf.okapi.lib.xliff2.its.AnnotatorsRef;
import net.sf.okapi.lib.xliff2.its.ITSReader;
import net.sf.okapi.lib.xliff2.its.TermTag;
import net.sf.okapi.lib.xliff2.matches.Match;
import net.sf.okapi.lib.xliff2.matches.Matches;
import net.sf.okapi.lib.xliff2.metadata.IWithMetaGroup;
import net.sf.okapi.lib.xliff2.metadata.Meta;
import net.sf.okapi.lib.xliff2.metadata.MetaGroup;
import net.sf.okapi.lib.xliff2.metadata.Metadata;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.EventType;
import net.sf.okapi.lib.xliff2.reader.LocationValidator;
import net.sf.okapi.lib.xliff2.reader.SchemaValidator;
import net.sf.okapi.lib.xliff2.reader.URIContext;
import net.sf.okapi.lib.xliff2.reader.XLIFFReaderException;
import net.sf.okapi.lib.xliff2.validation.Rule;
import net.sf.okapi.lib.xliff2.validation.Validation;

public class XLIFFReader
implements Closeable {
    public static final int VALIDATION_MINIMAL = 0;
    public static final int VALIDATION_MAXIMAL = 255;
    public static final int VALIDATION_INCLUDE_SCHEMAS = 1;
    public static final int VALIDATION_INCLUDE_FRAGIDPREFIX = 2;
    private static final String NOTE_NS = "urn:oasis:names:tc:xliff:document:2.0_n";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final SchemaValidator schValidator;
    private final LocationValidator locValidator;
    private XMLStreamReader reader;
    private LinkedList<Event> queue;
    private StartXliffData docData;
    private StartFileData startFileData;
    private boolean isMidFile;
    private boolean isInFile;
    private Stack<InheritedData> inheritedData;
    private Stack<String> groups;
    private Stack<URIContext> uriContext;
    private Stack<Validation> valContext;
    private URIParser uriParser;
    private boolean checkTargetOrder;
    private Unit unit;
    private List<CTag> srcIsolated;
    private List<CTag> trgIsolated;
    private Segment segment;
    private Part ignorable;
    private Stack<String> xmlAttributes;
    private boolean reportUnsingnificantParts = false;
    private HashMap<String, Boolean> fileIds;
    private HashMap<String, Boolean> unitIds;
    private HashMap<String, Boolean> groupIds;
    private ArrayList<String> subFlowIds;
    private Stack<HashMap<String, ArrayList<String>>> specialIds;
    private int fileCount;
    private int fileLevelUnitOrGroupCount;
    private ITSReader itsReader;

    public XLIFFReader() {
        this(255, null);
    }

    public XLIFFReader(int validation) {
        this(validation, null);
    }

    public XLIFFReader(int validation, URIParser uriParserToUse) {
        if ((validation & 1) == 1) {
            this.schValidator = new SchemaValidator();
            this.locValidator = new LocationValidator();
            this.locValidator.load(this.getClass().getResourceAsStream("/net/sf/okapi/lib/xliff2/modules.xml"));
        } else {
            this.schValidator = null;
            this.locValidator = null;
        }
        this.uriParser = uriParserToUse == null ? new URIParser() : uriParserToUse;
        this.uriParser.setErrorOnUnknownPrefix((validation & 2) == 2);
    }

    public static void validate(File file) {
        XLIFFReader.validate(null, file, null, null, null);
    }

    public static void validate(File file, URIParser uriParser) {
        XLIFFReader.validate(uriParser, file, null, null, null);
    }

    public static void validate(URI inputURI, URIParser uriParser) {
        XLIFFReader.validate(uriParser, null, inputURI, null, null);
    }

    public static void validate(String input, URIParser uriParser) {
        XLIFFReader.validate(uriParser, null, null, input, null);
    }

    public static void validate(InputStream inputStream, URIParser uriParser) {
        XLIFFReader.validate(uriParser, null, null, null, inputStream);
    }

    private static void validate(URIParser uriParser, File file, URI uri, String string, InputStream stream) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (XLIFFReader reader = new XLIFFReader(255, uriParser);){
            reader.open(file, uri, string, stream);
            while (reader.hasNext()) {
                reader.next();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void open(File file) {
        this.open(file, null, null, null);
    }

    public void open(URI inputURI) {
        this.open(null, inputURI, null, null);
    }

    public void open(String input) {
        this.open(null, null, input, null);
    }

    public void open(InputStream inputStream) {
        this.open(null, null, null, inputStream);
    }

    private StreamSource validateAndGetInput(File file, URI uri, String string, InputStream stream) {
        StreamSource inputSource = null;
        try {
            inputSource = file != null ? new StreamSource(file) : (uri != null ? new StreamSource(new BufferedInputStream(uri.toURL().openStream())) : (string != null ? new StreamSource(new StringReader(string)) : (this.schValidator != null ? new StreamSource(this.createByteArrayInputStream(stream)) : new StreamSource(stream))));
        }
        catch (IOException e) {
            this.error("Cannot create input stream from input. " + e.getLocalizedMessage());
        }
        if (this.schValidator == null) {
            return inputSource;
        }
        this.schValidator.validate(inputSource);
        try {
            if (file != null) {
                inputSource = new StreamSource(file);
            } else if (uri != null) {
                inputSource = new StreamSource(new BufferedInputStream(uri.toURL().openStream()));
            } else if (string != null) {
                inputSource = new StreamSource(new StringReader(string));
            } else {
                inputSource.getInputStream().reset();
            }
        }
        catch (IOException e) {
            this.error("Cannot reset the input after schema validation. " + e.getLocalizedMessage());
        }
        return inputSource;
    }

    private ByteArrayInputStream createByteArrayInputStream(InputStream inputStream) {
        ByteArrayOutputStream baos = null;
        try {
            try {
                int nRead;
                baos = new ByteArrayOutputStream();
                byte[] data = new byte[10240];
                while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                    baos.write(data, 0, nRead);
                }
                baos.flush();
            }
            catch (IOException e) {
                throw new XLIFFReaderException("Cannot create temporary input stream for schema validation.", e);
            }
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        bais.mark(Integer.MAX_VALUE);
        return bais;
    }

    private void open(File file, URI uri, String string, InputStream stream) {
        try {
            this.close();
            StreamSource inputSource = this.validateAndGetInput(file, uri, string, stream);
            XMLInputFactory fact = XMLInputFactory.newInstance();
            fact.setProperty("javax.xml.stream.isCoalescing", true);
            fact.setProperty("javax.xml.stream.supportDTD", false);
            this.reader = fact.createXMLStreamReader(inputSource);
            this.groups = new Stack();
            this.inheritedData = new Stack();
            this.inheritedData.push(new InheritedData());
            this.uriContext = new Stack();
            this.uriContext.push(new URIContext());
            this.valContext = new Stack();
            this.valContext.push(new Validation());
            this.xmlAttributes = new Stack();
            this.xmlAttributes.push("d");
            this.queue = new LinkedList();
            this.queue.add(new Event(EventType.START_DOCUMENT, null));
        }
        catch (XMLStreamException e) {
            this.error("Cannot open the XLIFF stream. " + e.getMessage());
        }
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (XMLStreamException e) {
            this.error("Closing error. " + e.getMessage());
        }
    }

    public boolean hasNext() {
        try {
            return this.reader.hasNext();
        }
        catch (XMLStreamException e) {
            this.error("Reading error. " + e.getMessage());
            return false;
        }
    }

    public Event next() {
        if (this.queue.isEmpty()) {
            this.readNext();
        }
        if (this.queue.peek().getType() == EventType.END_DOCUMENT && this.xmlAttributes.size() != 1) {
            this.warning(String.format("Stack for xml:space is at %d instead of 1.", this.xmlAttributes.size()));
        }
        return this.queue.poll();
    }

    public void setReportUnsingnificantParts(boolean reportUnsingnificantParts) {
        this.reportUnsingnificantParts = reportUnsingnificantParts;
    }

    /*
     * Unable to fully structure code
     */
    private void readNext() {
        midFileData = null;
        startGroupData = null;
        try {
            while (this.reader.hasNext()) {
                type = this.reader.next();
                block1 : switch (type) {
                    case 7: {
                        break;
                    }
                    case 8: {
                        this.queue.add(new Event(EventType.END_DOCUMENT, null));
                        return;
                    }
                    case 1: {
                        tmp = this.reader.getLocalName();
                        nsUri = this.reader.getNamespaceURI();
                        this.pushXMLAttributes();
                        if (!nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) ** GOTO lbl91
                        var6_7 = tmp;
                        tmp = -1;
                        switch (var6_7.hashCode()) {
                            case 3143036: {
                                if (var6_7.equals("file")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case 3594628: {
                                if (var6_7.equals("unit")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case 98629247: {
                                if (var6_7.equals("group")) {
                                    tmp = 3;
                                }
                                break;
                            }
                            case 105008833: {
                                if (var6_7.equals("notes")) {
                                    tmp = 4;
                                }
                                break;
                            }
                            case 114144117: {
                                if (var6_7.equals("xliff")) {
                                    tmp = 5;
                                }
                                break;
                            }
                            case 2027747405: {
                                if (var6_7.equals("skeleton")) {
                                    tmp = 6;
                                }
                                break;
                            }
                        }
                        switch (tmp) {
                            case 2: {
                                if (this.isMidFile) {
                                    midFileData = this.ensureMidFileData(midFileData);
                                    this.isMidFile = false;
                                }
                                this.processUnit();
                                return;
                            }
                            case 3: {
                                if (this.isMidFile) {
                                    midFileData = this.ensureMidFileData(midFileData);
                                    this.isMidFile = false;
                                }
                                startGroupData = this.processStartGroup();
                                if (this.valContext.peek().isEmpty()) break block1;
                                startGroupData.setValidation(this.valContext.peek());
                                break block1;
                            }
                            case 1: {
                                this.processStartFile();
                                return;
                            }
                            case 5: {
                                this.processXliff();
                                return;
                            }
                            case 6: {
                                this.processSkeleton();
                                return;
                            }
                            case 4: {
                                if (this.groups.isEmpty()) {
                                    if (this.isMidFile) {
                                        midFileData = this.ensureMidFileData(midFileData);
                                        this.processNotes(midFileData);
                                        break block1;
                                    }
                                    this.error("Notes for a <file> must be before its first <unit> or <group>.");
                                    break block1;
                                }
                                if (startGroupData == null) {
                                    this.error("Notes for a <group> must be before its first <unit> or <group>.");
                                    break block1;
                                }
                                this.processNotes(startGroupData);
                                break block1;
                            }
                        }
                        this.error(String.format("Invalid element found: '%s'", new Object[]{tmp}));
                        break;
lbl91:
                        // 1 sources

                        if (nsUri.equals("urn:oasis:names:tc:xliff:metadata:2.0")) {
                            if (this.groups.isEmpty()) {
                                if (this.isMidFile) {
                                    midFileData = this.ensureMidFileData(midFileData);
                                    this.processMetadata(midFileData);
                                    break;
                                }
                            } else {
                                this.processMetadata(startGroupData);
                                break;
                            }
                            this.error("Invalid extension and module element " + this.reader.getName().toString());
                            break;
                        }
                        if (nsUri.equals("urn:oasis:names:tc:xliff:validation:2.0")) {
                            if (this.groups.isEmpty()) {
                                if (this.isMidFile) {
                                    midFileData = this.ensureMidFileData(midFileData);
                                    this.processValidation(midFileData);
                                    break;
                                }
                            } else {
                                this.processValidation(startGroupData);
                                break;
                            }
                            this.error("Invalid extension and module element " + this.reader.getName().toString());
                            break;
                        }
                        if (this.groups.isEmpty()) {
                            if (this.isMidFile) {
                                midFileData = this.ensureMidFileData(midFileData);
                                this.processExtElement("file", midFileData.getExtElements());
                                break;
                            }
                            if (this.isInFile) {
                                this.error("Extension and module elements of a <file> must be before its first <unit> or <group>.");
                                break;
                            }
                            this.error("No element allowed outside a <file> element.");
                            break;
                        }
                        this.processExtElement("group", startGroupData.getExtElements());
                        break;
                    }
                    case 2: {
                        tmp = this.reader.getLocalName();
                        nsUri = this.reader.getNamespaceURI();
                        this.popXMLAttributes();
                        if (!nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) break;
                        if (tmp.equals("group")) {
                            this.queue.add(new Event(EventType.END_GROUP, null));
                            this.groups.pop();
                            this.popInheritedData();
                            this.uriContext.pop();
                            this.valContext.pop();
                            this.popSpecialIds();
                            return;
                        }
                        if (tmp.equals("file")) {
                            if (this.fileLevelUnitOrGroupCount < 1) {
                                this.error("There must be at least one <unit> or <group> in a <file>.");
                            }
                            this.checkSubFlows();
                            this.queue.add(new Event(EventType.END_FILE, null));
                            this.isInFile = false;
                            this.popInheritedData();
                            this.uriContext.pop();
                            this.valContext.pop();
                            this.popSpecialIds();
                            return;
                        }
                        if (!tmp.equals("xliff")) break;
                        if (this.fileCount < 1) {
                            this.error("There must be at least one <file> per XLIFF document.");
                        }
                        this.queue.add(new Event(EventType.END_XLIFF, this.uriContext.peek()));
                        return;
                    }
                    case 4: 
                    case 6: {
                        if (!this.reportUnsingnificantParts) break;
                        this.queue.add(new Event(EventType.INSIGNIFICANT_PART, this.uriContext.peek(), new InsingnificantPartData(InsingnificantPartData.InsignificantPartType.TEXT, this.reader.getText())));
                        if (startGroupData != null) break;
                        return;
                    }
                    case 5: {
                        if (!this.reportUnsingnificantParts) break;
                        this.queue.add(new Event(EventType.INSIGNIFICANT_PART, this.uriContext.peek(), new InsingnificantPartData(InsingnificantPartData.InsignificantPartType.COMMENT, "<!--" + this.reader.getText() + "-->")));
                        if (startGroupData != null) break;
                        return;
                    }
                    case 3: {
                        if (!this.reportUnsingnificantParts) break;
                        this.queue.add(new Event(EventType.INSIGNIFICANT_PART, this.uriContext.peek(), new InsingnificantPartData(InsingnificantPartData.InsignificantPartType.PI, "<?" + this.reader.getText() + "?>")));
                        if (startGroupData != null) break;
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            this.error("Reading error. " + e.getMessage());
        }
    }

    private MidFileData ensureMidFileData(MidFileData current) {
        if (current == null) {
            current = new MidFileData();
            this.queue.add(new Event(EventType.MID_FILE, this.uriContext.peek(), current));
        }
        return current;
    }

    private void checkSubFlows() {
        for (String id : this.subFlowIds) {
            if (this.unitIds.containsKey(id)) continue;
            this.error(String.format("There is a reference to a subFlow id='%s' with no corresponding <unit>.", id));
        }
    }

    private void pushXMLAttributes() {
        String newStates = this.xmlAttributes.peek();
        String tmp = this.reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "space");
        if (!Util.isNoE(tmp)) {
            newStates = String.valueOf(tmp.equals("preserve") ? "p" : "d") + newStates.substring(1);
        }
        if (!Util.isNoE(tmp = this.reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang"))) {
            String msg = Util.validateLang(tmp);
            if (msg != null) {
                this.error(String.format("The xml:lang value '%s' is invalid.\n" + msg, tmp));
            }
            newStates = newStates.charAt(0) + tmp;
        }
        this.xmlAttributes.push(newStates);
    }

    private void popXMLAttributes() {
        this.xmlAttributes.pop();
    }

    private void processXliff() {
        String version = this.reader.getAttributeValue("", "version");
        this.cannotBeNullOrEmpty("version", version);
        if (!version.startsWith("2.")) {
            this.error(String.format("Not a XLIFF 2.x document (version='%s').", version));
        }
        this.docData = new StartXliffData(version);
        String value = this.reader.getAttributeValue("", "srcLang");
        this.cannotBeNullOrEmpty("srcLang", value);
        this.docData.setSourceLanguage(value);
        this.docData.setExtAttributes(this.gatherNamespaces(null));
        int i = 0;
        while (i < this.reader.getAttributeCount()) {
            String ns = this.reader.getAttributeNamespace(i);
            String locName = this.reader.getAttributeLocalName(i);
            value = this.reader.getAttributeValue(i);
            if (Util.isNoE(ns)) {
                if (!locName.equals("version") && !locName.equals("srcLang")) {
                    if (locName.equals("trgLang")) {
                        this.cannotBeEmpty("trgLang", value);
                        this.docData.setTargetLanguage(value);
                    } else {
                        this.error(String.format("Invalid attribute '%s'.", locName));
                    }
                }
            } else {
                this.addExtAttribute(this.docData, i, false);
            }
            ++i;
        }
        this.fileIds = new HashMap();
        this.fileCount = 0;
        this.isInFile = false;
        this.queue.add(new Event(EventType.START_XLIFF, this.uriContext.peek(), this.docData));
    }

    private void error(String message) {
        this.reportIssue(message, false);
    }

    private void warning(String message) {
        this.reportIssue(message, true);
    }

    private void reportIssue(String message, boolean warningOnly) {
        String fpart = "";
        if (this.fileCount > 0) {
            QName qn;
            fpart = "Error in <file> ";
            fpart = this.startFileData != null ? String.valueOf(fpart) + String.format("id='%s'", this.startFileData.getId()) : String.format("number %d", this.fileCount);
            if (this.unit != null) {
                fpart = String.valueOf(fpart) + String.format(", <unit> id='%s'", this.unit.getId());
            } else if (!this.groups.isEmpty()) {
                fpart = this.groups.peek() == null ? String.valueOf(fpart) + String.format(", <group> level %d", this.groups.size()) : String.valueOf(fpart) + String.format(", <group> id='%s'", this.groups.peek());
            }
            if (this.reader != null && this.reader.hasName() && (qn = this.reader.getName()) != null) {
                fpart = String.valueOf(fpart) + "\nLast element read: '" + qn.toString() + "'";
            }
            fpart = String.valueOf(fpart) + ":\n";
        }
        if (!warningOnly) {
            throw new XLIFFReaderException(String.valueOf(fpart) + message);
        }
        this.logger.warning(String.valueOf(fpart) + message);
    }

    private void processStartFile() {
        ++this.fileCount;
        this.fileLevelUnitOrGroupCount = 0;
        this.startFileData = new StartFileData(null);
        this.isMidFile = true;
        this.isInFile = true;
        this.unitIds = new HashMap();
        this.groupIds = new HashMap();
        this.subFlowIds = new ArrayList();
        this.specialIds = new Stack();
        this.itsReader = new ITSReader(this.reader);
        this.readAndPushInheritedAttributes(this.startFileData);
        this.uriContext.push(this.uriContext.peek().clone());
        this.valContext.push(new Validation(this.valContext.peek(), true));
        this.pushSpecialIds();
        if (this.locValidator != null) {
            this.locValidator.reset();
        }
        this.startFileData.setExtAttributes(this.gatherNamespaces(this.startFileData.getExtAttributes()));
        int i = 0;
        while (i < this.reader.getAttributeCount()) {
            String ns = this.reader.getAttributeNamespace(i);
            String locName = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            if (Util.isNoE(ns)) {
                if (!(locName.equals("canResegment") || locName.equals("translate") || locName.equals("srcDir") || locName.equals("trgDir"))) {
                    if (locName.equals("id")) {
                        this.cannotBeNullOrEmpty("id", value);
                        if (this.fileIds.containsKey(value)) {
                            this.error(String.format("The value '%s' is used as the id of two or more <file> elements.", value));
                        } else {
                            this.fileIds.put(value, false);
                        }
                        this.uriContext.peek().setFileId(value);
                        this.startFileData.setId(value);
                    } else if (locName.equals("original")) {
                        this.cannotBeEmpty("original", value);
                        this.startFileData.setOriginal(value);
                    } else {
                        this.error(String.format("Invalid attribute '%s'.", locName));
                    }
                }
            } else {
                this.addExtAttribute(this.startFileData, i, false);
            }
            ++i;
        }
        if (this.startFileData.getId() == null) {
            this.error("The <file> element must have an id.");
        }
        this.queue.add(new Event(EventType.START_FILE, this.uriContext.peek(), this.startFileData));
    }

    private void pushSpecialIds() {
        HashMap ids = new HashMap();
        this.specialIds.push(ids);
    }

    private void popSpecialIds() {
        this.specialIds.pop();
    }

    private void checkAndAddSpecialId(String idNs, String id) {
        if (idNs.equals("urn:oasis:names:tc:xliff:document:2.0")) {
            return;
        }
        HashMap<String, ArrayList<String>> ids = this.specialIds.peek();
        ArrayList<String> list = ids.get(idNs);
        if (list != null) {
            if (list.contains(id)) {
                if (idNs.equals(NOTE_NS)) {
                    this.error(String.format("Duplicate id '%s' for a <note> element.", id));
                } else {
                    this.error(String.format("Duplicate id '%s' for the module or extension '%s'.", id, idNs));
                }
            }
        } else {
            list = new ArrayList();
            ids.put(idNs, list);
        }
        list.add(id);
    }

    private void processSkeleton() throws XMLStreamException {
        boolean hasHref = false;
        Skeleton skelData = new Skeleton();
        QName qn = new QName("urn:oasis:names:tc:xliff:document:2.0", "skeleton");
        int i = 0;
        while (i < this.reader.getAttributeCount()) {
            String locName = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            if (Util.isNoE(this.reader.getAttributeNamespace(i))) {
                if (locName.equals("href")) {
                    if (this.cannotBeEmpty("href", value)) {
                        skelData.setHref(value);
                        hasHref = true;
                    }
                } else {
                    this.error(String.format("Invalid attribute '%s' in <skeleton>.", locName));
                }
            } else {
                this.error(String.format("Invalid attribute '%s' in <skeleton>.", locName));
            }
            ++i;
        }
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    if (hasHref) {
                        this.error("You cannot have both an href attribute and a content in <skeleton>.");
                    }
                    this.pushXMLAttributes();
                    skelData.addChild(this.readExtElement());
                    break;
                }
                case 2: {
                    if (!this.reader.getName().equals(qn)) break;
                    this.popXMLAttributes();
                    if (hasHref) {
                        if (skelData.getChildren() != null && skelData.getChildren().size() > 0) {
                            this.error("You must not have a content in <skeleton> if there is an href attribute.");
                        }
                    } else if (skelData.getChildren() == null || skelData.getChildren().size() == 0) {
                        this.error("You must have a content in <skeleton> if there is no href attribute.");
                    }
                    this.queue.add(new Event(EventType.SKELETON, this.uriContext.peek(), skelData));
                    return;
                }
                case 4: 
                case 6: {
                    skelData.addChild(new ExtContent(this.reader.getText()));
                    break;
                }
                case 12: {
                    skelData.addChild(new ExtContent(this.reader.getText(), true));
                    break;
                }
                case 3: {
                    skelData.addChild(new ProcessingInstruction("<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>"));
                    break;
                }
            }
        }
    }

    private void readAndPushInheritedAttributes(IWithInheritedData object) {
        AnnotatorsRef ar;
        InheritedData indat;
        block31: {
            String tmp;
            block29: {
                indat = new InheritedData(this.inheritedData.peek());
                tmp = this.reader.getAttributeValue("", "translate");
                if (this.canBeYesOrNo("translate", tmp)) {
                    indat.setTranslate(tmp.equals("yes"));
                }
                if (this.canBeYesOrNo("canResegment", tmp = this.reader.getAttributeValue("", "canResegment"))) {
                    indat.setCanResegment(tmp.equals("yes"));
                }
                if (!this.canBeAutoOrLtrOrRtl("srcDir", tmp = this.reader.getAttributeValue("", "srcDir"))) break block29;
                switch (tmp) {
                    case "auto": {
                        indat.setSourceDir(Directionality.AUTO);
                        break;
                    }
                    case "ltr": {
                        indat.setSourceDir(Directionality.LTR);
                        break;
                    }
                    case "rtl": {
                        indat.setSourceDir(Directionality.RTL);
                    }
                }
            }
            if (!this.canBeAutoOrLtrOrRtl("trgDir", tmp = this.reader.getAttributeValue("", "trgDir"))) break block31;
            switch (tmp) {
                case "auto": {
                    indat.setTargetDir(Directionality.AUTO);
                    break;
                }
                case "ltr": {
                    indat.setTargetDir(Directionality.LTR);
                    break;
                }
                case "rtl": {
                    indat.setTargetDir(Directionality.RTL);
                }
            }
        }
        if ((ar = this.itsReader.readAnnotatorsRef(false, indat.getAnnotatorsRef())) != null) {
            indat.setAnnotatorsRef(ar);
        }
        object.setInheritableData(indat);
        this.inheritedData.push(indat);
    }

    private void popInheritedData() {
        this.inheritedData.pop();
    }

    private StartGroupData processStartGroup() {
        String tmp = this.reader.getAttributeValue("", "id");
        if (this.groups.isEmpty()) {
            ++this.fileLevelUnitOrGroupCount;
        }
        this.groups.push(tmp);
        this.mustBeValidNmtoken("id", tmp, false);
        if (this.groupIds.containsKey(tmp)) {
            this.error(String.format("Duplicated group id value '%s' detected.", tmp));
        } else {
            this.groupIds.put(tmp, null);
        }
        this.uriContext.push(this.uriContext.peek().clone());
        this.uriContext.peek().setGroupId(tmp);
        this.pushSpecialIds();
        this.valContext.push(new Validation(this.valContext.peek(), true));
        if (this.locValidator != null) {
            this.locValidator.reset();
        }
        StartGroupData sgd = new StartGroupData(tmp);
        this.readAndPushInheritedAttributes(sgd);
        sgd.setExtAttributes(this.gatherNamespaces(sgd.getExtAttributes()));
        int i = 0;
        while (i < this.reader.getAttributeCount()) {
            String locName = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            String ns = this.reader.getAttributeNamespace(i);
            if (Util.isNoE(ns)) {
                if (!(locName.equals("id") || locName.equals("translate") || locName.equals("canResegment") || locName.equals("srcDir") || locName.equals("trgDir"))) {
                    if (locName.equals("name")) {
                        if (this.cannotBeEmpty("name", value)) {
                            sgd.setName(value);
                        }
                    } else if (locName.equals("type")) {
                        if (this.cannotBeEmpty("type", value)) {
                            sgd.setType(value);
                        }
                    } else {
                        this.error(String.format("Invalid attribute '%s'.", locName));
                    }
                }
            } else {
                this.addExtAttribute(sgd, i, false);
            }
            ++i;
        }
        this.queue.add(new Event(EventType.START_GROUP, this.uriContext.peek(), sgd));
        return sgd;
    }

    private int checkIntegerValue(String name, String value, int min, int max) {
        if (value == null) {
            return -1;
        }
        if (value.isEmpty()) {
            this.error(String.format("Empty attribute '%s'", name));
        }
        try {
            int tmp = Integer.parseInt(value);
            if (tmp < min || tmp > max) {
                this.error(String.format("Invalid value for attribute '%s'", name));
            }
            return tmp;
        }
        catch (NumberFormatException e) {
            this.error(String.format("Invalid syntax for attribute '%s'", name));
            return -1;
        }
    }

    private void checkInlineIds(Unit unit) {
        String id;
        HashMap<String, Integer> ids = new HashMap<String, Integer>();
        for (Part part : unit) {
            String id2 = part.getId();
            if (id2 == null) continue;
            if (ids.containsKey(id2)) {
                this.error(String.format("The id '%s' is used incorrectly more than once in the unit id='%s'", id2, unit.getId()));
                continue;
            }
            ids.put(id2, -1);
        }
        Tags markers = unit.getStore().getSourceTags();
        for (Tag bm : markers) {
            if (bm.getTagType() == TagType.CLOSING) continue;
            id = bm.getId();
            if (ids.containsKey(id)) {
                if ((Integer)ids.get(id) == -1) {
                    this.error(String.format("The id '%s' is already used for a segment or an ignorable element in the unit id='%s'", id, unit.getId()));
                    continue;
                }
                this.error(String.format("The id '%s' is already used in the source content of the unit id='%s'", id, unit.getId()));
                continue;
            }
            ids.put(id, 0);
        }
        markers = unit.getStore().getTargetTags();
        for (Tag bm : markers) {
            if (bm.getTagType() == TagType.CLOSING) continue;
            id = bm.getId();
            if (ids.containsKey(id)) {
                switch ((Integer)ids.get(id)) {
                    case 0: {
                        ids.put(id, 1);
                        break;
                    }
                    case -1: {
                        this.error(String.format("The id '%s' is already used for a segment or ignorable element in the unit id='%s'", id, unit.getId()));
                        break;
                    }
                    default: {
                        this.error(String.format("The id '%s' exists twice or more in the target content in the unit id='%s'", id, unit.getId()));
                        break;
                    }
                }
                continue;
            }
            ids.put(id, 1);
        }
    }

    private void cannotBeNullOrEmpty(String name, String value) {
        if (Util.isNoE(value)) {
            this.error(String.format("Missing or empty attribute '%s'", name));
        }
    }

    private boolean mustBeValidNmtoken(String name, String value, boolean allowNull) {
        if (value == null) {
            if (allowNull) {
                return false;
            }
            this.error(String.format("Missing attribute '%s'", name));
        }
        if (!Util.isValidNmtoken(value)) {
            this.error(String.format("Value '%s' is not a valid NMTOKEN for '%s'.", value, name));
        }
        return true;
    }

    private Directionality getDirectionality(String name, String value, Directionality defValue) {
        if (value == null) {
            return defValue;
        }
        switch (value) {
            case "auto": {
                return Directionality.AUTO;
            }
            case "ltr": {
                return Directionality.LTR;
            }
            case "rtl": {
                return Directionality.RTL;
            }
        }
        this.error(String.format("Invalid attribute value for '%s' (must be '%s', '%s' or '%s')", name, "auto", "ltr", "rtl"));
        return Directionality.AUTO;
    }

    private boolean getYesOrNo(String name, String value, boolean defValue) {
        if (value == null) {
            return defValue;
        }
        if (value.isEmpty() || !value.equals("yes") && !value.equals("no")) {
            this.error(String.format("Invalid attribute value for '%s' (must be '%s' or '%s')", name, "yes", "no"));
        }
        return value.equals("yes");
    }

    private boolean cannotBeEmpty(String name, String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty()) {
            this.error(String.format("Empty attribute '%s'", name));
        }
        return true;
    }

    private boolean canBeYesOrNo(String name, String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty() || !value.equals("yes") && !value.equals("no")) {
            this.error(String.format("Invalid attribute value for '%s' (must be '%s' or '%s')", name, "yes", "no"));
        }
        return true;
    }

    private boolean canBeYesOrNoOrFirstNo(String name, String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty() || !value.equals("yes") && !value.equals("no") && !value.equals("firstNo")) {
            this.error(String.format("Invalid attribute value for '%s' (must be '%s', '%s' or '%s')", name, "yes", "no", "firstNo"));
        }
        return true;
    }

    private boolean canBeAutoOrLtrOrRtl(String name, String value) {
        if (value == null) {
            return false;
        }
        switch (value) {
            case "ltr": 
            case "rtl": 
            case "auto": {
                return true;
            }
        }
        this.error(String.format("Invalid attribute value for '%s' (must be '%s', '%s' or '%s')", name, "auto", "ltr", "rtl"));
        return false;
    }

    private void processUnit() throws XMLStreamException {
        if (this.groups.isEmpty()) {
            ++this.fileLevelUnitOrGroupCount;
        }
        String tmp = this.reader.getAttributeValue("", "id");
        this.mustBeValidNmtoken("id", tmp, false);
        if (this.unitIds.containsKey(tmp)) {
            this.error(String.format("Duplicated unit id value '%s' detected.", tmp));
        } else {
            this.unitIds.put(tmp, null);
        }
        this.unit = new Unit(tmp);
        Map<String, DataElementContent> unitODM = null;
        this.srcIsolated = new ArrayList<CTag>();
        this.trgIsolated = new ArrayList<CTag>();
        this.uriContext.push(this.uriContext.peek().clone());
        this.uriContext.peek().setUnitId(tmp);
        this.valContext.push(new Validation(this.valContext.peek(), true));
        if (!this.valContext.peek().isEmpty()) {
            this.unit.setValidation(this.valContext.peek());
        }
        this.pushSpecialIds();
        this.readAndPushInheritedAttributes(this.unit);
        this.unit.setExtAttributes(this.gatherNamespaces(this.unit.getExtAttributes()));
        boolean needsITSFetch = this.itsReader.readAttributes(this.unit, this.unit, this.inheritedData.peek().getAnnotatorsRef());
        int i = 0;
        while (i < this.reader.getAttributeCount()) {
            String locName = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            String ns = this.reader.getAttributeNamespace(i);
            if (Util.isNoE(ns)) {
                if (!(locName.equals("id") || locName.equals("translate") || locName.equals("canResegment") || locName.equals("srcDir") || locName.equals("trgDir"))) {
                    if (locName.equals("name")) {
                        if (this.cannotBeEmpty("name", value)) {
                            this.unit.setName(value);
                        }
                    } else if (locName.equals("type")) {
                        if (this.cannotBeEmpty("type", value)) {
                            this.unit.setType(value);
                        }
                    } else {
                        this.error(String.format("Invalid attribute '%s'.", locName));
                    }
                }
            } else if (!ns.equals("http://www.w3.org/ns/its-xliff/") && !ns.equals("http://www.w3.org/2005/11/its")) {
                this.addExtAttribute(this.unit, i, false);
            }
            ++i;
        }
        ExtElements unitExtElems = null;
        this.checkTargetOrder = false;
        boolean hasOneSegment = false;
        HashMap<String, Boolean> partIds = new HashMap<String, Boolean>();
        boolean inExtensionPoint = true;
        boolean notesAllowed = true;
        block7: while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.pushXMLAttributes();
                    if (nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) {
                        inExtensionPoint = false;
                        if (tmp.equals("segment")) {
                            hasOneSegment = true;
                            notesAllowed = false;
                            this.processPart(true, partIds);
                            break;
                        }
                        if (tmp.equals("ignorable")) {
                            notesAllowed = false;
                            this.processPart(false, partIds);
                            break;
                        }
                        if (tmp.equals("originalData")) {
                            unitODM = this.processOriginalData();
                            break;
                        }
                        if (tmp.equals("notes")) {
                            if (notesAllowed) {
                                this.processNotes(this.unit);
                                break;
                            }
                            this.error("Notes for a <unit> must be before its first <segment> or <ignorable>.");
                            break;
                        }
                        this.error(String.format("Unexpected element '%s' in <unit>", tmp));
                        break;
                    }
                    if (inExtensionPoint) {
                        if (nsUri.equals("http://www.w3.org/2005/11/its")) {
                            this.itsReader.readStandOffElements(tmp, this.unit, this.inheritedData.peek().getAnnotatorsRef());
                            this.popXMLAttributes();
                            break;
                        }
                        if (nsUri.equals("urn:oasis:names:tc:xliff:matches:2.0")) {
                            this.processMatches();
                            break;
                        }
                        if (nsUri.equals("urn:oasis:names:tc:xliff:glossary:2.0")) {
                            this.processGlossary();
                            break;
                        }
                        if (nsUri.equals("urn:oasis:names:tc:xliff:metadata:2.0")) {
                            this.processMetadata(this.unit);
                            break;
                        }
                        if (nsUri.equals("urn:oasis:names:tc:xliff:validation:2.0")) {
                            this.processValidation(this.unit);
                            break;
                        }
                        if (this.locValidator != null) {
                            this.locValidator.reset();
                        }
                        unitExtElems = this.processExtElement("unit", unitExtElems);
                        break;
                    }
                    this.error(String.format("Invalid element '%s'. Extensions and modules must come before core elements.", tmp));
                    break;
                }
                case 2: {
                    tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.popXMLAttributes();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:document:2.0") || !tmp.equals("unit")) continue block7;
                    if (unitExtElems != null) {
                        this.unit.setExtElements(unitExtElems);
                    }
                    if (!hasOneSegment) {
                        this.error("No <segment> in <unit>.");
                    }
                    if (needsITSFetch) {
                        this.itsReader.fetchUnresolvedITSGroups(this.unit);
                    }
                    this.checkInlineIds(this.unit);
                    this.copyOriginalDataToCodes(this.unit.getStore(), unitODM);
                    this.checkPairsConsistency(this.unit.getStore().getSourceTags());
                    this.checkPairsConsistency(this.unit.getStore().getTargetTags());
                    this.checkTargetOrder(this.unit);
                    this.checkIsolatedAttributes(this.unit.getStore().getSourceTags(), this.srcIsolated);
                    this.checkIsolatedAttributes(this.unit.getStore().getTargetTags(), this.trgIsolated);
                    this.checkMatchReferences();
                    this.checkGlossaryReferences();
                    try {
                        Util.validateCopyOf(this.unit);
                        this.unit.verifyOpeningsBeforeClosings(false);
                        this.unit.verifyOpeningsBeforeClosings(true);
                        if (this.unit.doNonEmptySourcesHaveNonEmptyTargets()) {
                            Util.verifyReordering(this.unit.getOrderedCTags(false), this.unit.getOrderedCTags(true), true);
                        } else {
                            Util.createFixedSequences(this.unit.getOrderedCTags(false), true);
                            Util.createFixedSequences(this.unit.getOrderedCTags(true), true);
                        }
                        this.unit.verifyReadOnlyTags();
                    }
                    catch (Throwable e) {
                        this.error(e.getMessage());
                    }
                    this.queue.add(new Event(EventType.TEXT_UNIT, this.uriContext.peek(), this.unit));
                    this.popInheritedData();
                    this.uriContext.pop();
                    this.valContext.pop();
                    this.popSpecialIds();
                    this.unit = null;
                    return;
                }
            }
        }
    }

    private void checkMatchReferences() {
        if (!this.unit.hasMatch()) {
            return;
        }
        for (Match match : this.unit.getMatches()) {
            String ref = match.getRef();
            if (this.unit.getSourceOrTargetReference(ref) != null) continue;
            this.error(String.format("The ref value '%s' for <match> does not point to an existing span in it parent <unit>.", ref));
        }
    }

    private void checkGlossaryReferences() {
        if (!this.unit.hasGlossEntry()) {
            return;
        }
        for (GlossEntry entry : this.unit.getGlossary()) {
            String ref = entry.getRef();
            if (ref != null && this.unit.getSourceOrTargetReference(ref) == null) {
                this.error(String.format("The ref value '%s' for <glossEntry> does not point to an existing span in it parent <unit>.", ref));
            }
            for (Translation trans : entry) {
                ref = trans.getRef();
                if (ref == null || this.unit.getSourceOrTargetReference(ref) != null) continue;
                this.error(String.format("The ref value '%s' for <translation> does not point to an existing span in it parent <unit>.", ref));
            }
        }
    }

    private void checkPairsConsistency(Tags tags) {
        if (tags == null) {
            return;
        }
        for (Tag tag : tags) {
            CTag ctag;
            CTag closing;
            if (tag.isMarker() || tag.getTagType() != TagType.OPENING || (closing = (CTag)tags.getClosingTag(ctag = (CTag)tag)) == null) continue;
            if (closing.getCanOverlap() != ctag.getCanOverlap()) {
                this.error(String.format("The <ec> and <sc> for id='%s' must have the same canOverlap value.", ctag.getId()));
            }
            if (closing.getCanCopy() != ctag.getCanCopy()) {
                this.error(String.format("The <ec> and <sc> for id='%s' must have the same canCopy value.", ctag.getId()));
            }
            if (closing.getCanDelete() != ctag.getCanDelete()) {
                this.error(String.format("The <ec> and <sc> for id='%s' must have the same canDelete value.", ctag.getId()));
            }
            if (ctag.getCanReorder() == CanReorder.FIRSTNO) {
                if (closing.getCanReorder() == CanReorder.NO) continue;
                this.error(String.format("The <ec> for id='%s' must be set to canReorder='no'.", ctag.getId()));
                continue;
            }
            if (closing.getCanReorder() == ctag.getCanReorder()) continue;
            this.error(String.format("The <ec> for id='%s' must have the same canReorder value as its corresponding <sc>.", ctag.getId()));
        }
    }

    private void checkIsolatedAttributes(Tags markers, List<CTag> list) {
        for (Tag bm : markers) {
            if (bm.isMarker()) continue;
            switch (bm.getTagType()) {
                case OPENING: {
                    if (markers.getClosingTag(bm) == null) {
                        if (list.contains(bm)) break;
                        this.error(String.format("Missing isolated='yes' for opening code id='%s'.", bm.getId()));
                        break;
                    }
                    if (!list.contains(bm)) break;
                    this.error(String.format("Invalid isolated='yes' for opening code id='%s'.", bm.getId()));
                    break;
                }
                case CLOSING: {
                    if (markers.getOpeningTag(bm) == null) {
                        if (list.contains(bm)) break;
                        this.error(String.format("Missing isolated='yes' for closing code id='%s'.", bm.getId()));
                        break;
                    }
                    if (!list.contains(bm)) break;
                    this.error(String.format("Invalid isolated='yes' for closing code id='%s'.", bm.getId()));
                }
            }
        }
    }

    private void checkTargetOrder(Unit unit) {
        if (this.checkTargetOrder) {
            int max = unit.getPartCount();
            int i = 0;
            for (Part part : unit) {
                int order1 = part.getTargetOrder();
                if (order1 == 0) {
                    order1 = i + 1;
                }
                if (order1 < 1 || order1 > max) {
                    this.error(String.format("Invalid target order '%d'.", order1));
                }
                int j = 0;
                while (j < max) {
                    Part part2 = unit.getPart(j);
                    int order2 = part2.getTargetOrder();
                    if (order2 == 0) {
                        order2 = j + 1;
                    }
                    if (i != j && order1 == order2) {
                        this.error(String.format("The parts %d and %d have the same target order: '%d'.", i + 1, j + 1, order1));
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void copyOriginalDataToCodes(Store Store2, Map<String, DataElementContent> originalDataMap) {
        CTag code;
        String nid;
        if (Store2 == null) {
            return;
        }
        if (Store2.hasSourceTag()) {
            for (Tag marker : Store2.getSourceTags()) {
                if (marker.isMarker() || (nid = (code = (CTag)marker).getDataRef()) == null) continue;
                if (originalDataMap == null) {
                    this.error(String.format("The code id='%s' refers to the <data> id='%s', but no <originalData> is declared.", code.getId(), nid));
                }
                if (!originalDataMap.containsKey(nid)) {
                    this.error(String.format("No original data found for the id '%s'.", nid));
                }
                code.setData(originalDataMap.get((Object)nid).content);
                code.setDataDir(originalDataMap.get((Object)nid).dir);
            }
        }
        if (Store2.hasTargetTag()) {
            for (Tag marker : Store2.getTargetTags()) {
                if (marker.isMarker() || (nid = (code = (CTag)marker).getDataRef()) == null) continue;
                if (originalDataMap == null) {
                    this.error(String.format("The code id='%s' refers to the <data> id='%s', but no <originalData> is declared.", code.getId(), nid));
                }
                if (!originalDataMap.containsKey(nid)) {
                    this.error(String.format("No original data found for the id '%s'.", nid));
                }
                code.setData(originalDataMap.get((Object)nid).content);
                code.setDataDir(originalDataMap.get((Object)nid).dir);
            }
        }
    }

    private void processNote(IWithNotes parent) throws XMLStreamException {
        Note note = new Note();
        note.setExtAttributes(this.gatherNamespaces(null));
        int i = 0;
        while (i < this.reader.getAttributeCount()) {
            String ns = this.reader.getAttributeNamespace(i);
            String locName = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            if (Util.isNoE(ns)) {
                if (locName.equals("appliesTo")) {
                    this.cannotBeEmpty("appliesTo", value);
                    if (value.equals("source")) {
                        note.setAppliesTo(Note.AppliesTo.SOURCE);
                    } else if (value.equals("target")) {
                        note.setAppliesTo(Note.AppliesTo.TARGET);
                    } else {
                        this.error(String.format("Invalid appliesTo value ('%s').", value));
                    }
                } else if (locName.equals("id")) {
                    this.mustBeValidNmtoken("id", value, true);
                    this.checkAndAddSpecialId(NOTE_NS, value);
                    note.setId(value);
                } else if (locName.equals("priority")) {
                    this.cannotBeEmpty("priority", value);
                    int num = this.checkIntegerValue("priority", value, 1, 10);
                    if (num > -1) {
                        note.setPriority(num);
                    }
                } else if (locName.equals("category")) {
                    this.cannotBeEmpty("category", value);
                    note.setCategory(value);
                } else {
                    this.error(String.format("Invalid attribute '%s' in <note>.", locName));
                }
            } else {
                this.addExtAttribute(note, i, false);
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 4: {
                    sb.append(this.reader.getText());
                    break;
                }
                case 1: {
                    this.error("The <note> element has only text content.");
                }
                case 2: {
                    this.popXMLAttributes();
                    note.setText(sb.toString());
                    parent.addNote(note);
                    return;
                }
            }
        }
    }

    private void processNotes(IWithNotes parent) throws XMLStreamException {
        Notes notes = parent.getNotes();
        boolean hasNotes = false;
        notes.setExtAttributes(this.gatherNamespaces(null));
        if (this.reader.getAttributeCount() > 0) {
            this.error("No attributes are allowed on the <notes> element.");
        }
        block4: while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    this.pushXMLAttributes();
                    String tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    if (nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) {
                        if (tmp.equals("note")) {
                            this.processNote(parent);
                            hasNotes = true;
                            break;
                        }
                        this.error("Only <note> elements are allowed in <notes> elements.");
                        break;
                    }
                    this.error("Only <note> elements are allowed in <notes> elements.");
                    break;
                }
                case 2: {
                    this.popXMLAttributes();
                    String tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:document:2.0") || !tmp.equals("notes")) continue block4;
                    if (!hasNotes) {
                        this.error("A <notes> element must have at least one <note>.");
                    }
                    return;
                }
            }
        }
    }

    private Map<String, DataElementContent> processOriginalData() throws XMLStreamException {
        LinkedHashMap<String, DataElementContent> map = new LinkedHashMap<String, DataElementContent>();
        StringBuilder content = new StringBuilder();
        String id = null;
        Directionality dir = null;
        boolean inData = false;
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 4: {
                    if (id == null) break;
                    content.append(this.reader.getText());
                    break;
                }
                case 1: {
                    String tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.pushXMLAttributes();
                    if (nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) {
                        if (tmp.equals("data")) {
                            id = this.reader.getAttributeValue("", "id");
                            this.mustBeValidNmtoken("id", id, false);
                            if (map.containsKey(id)) {
                                this.error(String.format("Duplicated id '%s' in original data table.", id));
                            }
                            dir = this.getDirectionality("dir", this.reader.getAttributeValue("", "dir"), Directionality.AUTO);
                            inData = true;
                            break;
                        }
                        if (tmp.equals("cp")) {
                            tmp = this.reader.getAttributeValue("", "hex");
                            this.cannotBeNullOrEmpty("hex", tmp);
                            content.append(this.convertHexAttribute(tmp));
                            break;
                        }
                        if (inData) {
                            this.error("Only text is allowed in <data> elements.");
                            break;
                        }
                        this.error("Only <data> is allowed in <originalData> elements.");
                        break;
                    }
                    if (inData) {
                        this.error("Only text is allowed in <data> elements.");
                        break;
                    }
                    this.error("Only <data> is allowed in <originalData> elements.");
                    break;
                }
                case 2: {
                    String tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.popXMLAttributes();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) break;
                    if (tmp.equals("data")) {
                        map.put(id, new DataElementContent(content.toString(), dir));
                        id = null;
                        dir = null;
                        content.setLength(0);
                        inData = false;
                        break;
                    }
                    if (!tmp.equals("originalData")) break;
                    if (map.isEmpty()) {
                        this.error("There must be at least one <data> in a <originalData>.");
                    }
                    return map;
                }
            }
        }
        return null;
    }

    private void processPart(boolean isSegment, HashMap<String, Boolean> partIds) throws XMLStreamException {
        Part part;
        if (isSegment) {
            this.segment = this.unit.appendSegment();
            part = this.segment;
            this.segment.setCanResegment(this.inheritedData.peek().getCanResegment());
            int i = 0;
            while (i < this.reader.getAttributeCount()) {
                String ns = this.reader.getAttributeNamespace(i);
                String locName = this.reader.getAttributeLocalName(i);
                String value = this.reader.getAttributeValue(i);
                if (Util.isNoE(ns)) {
                    if (!locName.equals("id")) {
                        if (locName.equals("canResegment")) {
                            if (this.canBeYesOrNo("canResegment", value)) {
                                this.segment.setCanResegment(value.equals("yes"));
                            }
                        } else if (locName.equals("state")) {
                            this.segment.setState(value);
                        } else if (locName.equals("subState")) {
                            if (this.reader.getAttributeValue("", "state") == null) {
                                this.error("If <segment> has a subState, state must be set explicitly.");
                            }
                            this.segment.setSubState(value);
                        } else {
                            this.error(String.format("Invalid attribute '%s' in <segment>.", locName));
                        }
                    }
                } else {
                    this.error(String.format("Invalid attribute '%s' in <segment>.", locName));
                }
                ++i;
            }
        } else {
            part = this.ignorable = this.unit.appendIgnorable();
        }
        String tmp = this.reader.getAttributeValue("", "id");
        if (this.mustBeValidNmtoken("id", tmp, true)) {
            if (partIds.containsKey(tmp)) {
                this.error(String.format("The id value '%s' is used more than once for <segment> or <ignorable>.", tmp));
            } else {
                partIds.put(tmp, false);
            }
            part.setId(tmp);
        }
        Boolean srcPreserveWS = null;
        Boolean trgPreserveWS = null;
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.pushXMLAttributes();
                    if (nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) {
                        if (tmp.equals("source")) {
                            if (srcPreserveWS != null) {
                                this.error("Cannot have more than one <source> per <segment> or <ignorable>.");
                            }
                            srcPreserveWS = this.xmlAttributes.peek().startsWith("p");
                            if (isSegment) {
                                this.processContent(this.segment, false, false);
                                break;
                            }
                            this.processContent(this.ignorable, false, false);
                            break;
                        }
                        if (tmp.equals("target")) {
                            if (trgPreserveWS != null) {
                                this.error("Cannot have more than one <target> per <segment> or <ignorable>.");
                            }
                            trgPreserveWS = this.xmlAttributes.peek().startsWith("p");
                            if (isSegment) {
                                this.processContent(this.segment, true, false);
                            } else {
                                this.processContent(this.ignorable, true, false);
                            }
                            if (this.docData.getTargetLanguage() != null) break;
                            this.error("No target language defined in a file with a target entry.");
                            break;
                        }
                        this.error("Only <source> and <target> are allowed in <segment> or <ignorable> elements.");
                        break;
                    }
                    this.error("Only <source> and <target> are allowed in <segment> or <ignorable> elements.");
                    break;
                }
                case 2: {
                    tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.popXMLAttributes();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) break;
                    if (srcPreserveWS == null) {
                        this.error("Missing <source> element.");
                    }
                    if (srcPreserveWS != null && trgPreserveWS != null && srcPreserveWS != trgPreserveWS) {
                        this.error("Source and target must be set to the same whitespace handling option.");
                    }
                    return;
                }
            }
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processContent(Part partToFill, boolean isTarget, boolean allowAnyTargetLang) throws XMLStreamException {
        frag = new Fragment(partToFill.getStore(), isTarget);
        code = null;
        inTextContent = true;
        dataRef = null;
        pairs = new Stack<Tag>();
        dirCtx = new Stack<Directionality>();
        dirCtx.push(isTarget != false ? partToFill.getStore().getTargetDir() : partToFill.getStore().getSourceDir());
        lang = this.xmlAttributes.peek().substring(1);
        if (!lang.isEmpty()) {
            if (isTarget) {
                if (this.docData.getTargetLanguage() == null) {
                    this.error("You must define a target language (trgLang) in the <xliff> element.");
                }
                if (!allowAnyTargetLang && !lang.equals(this.docData.getTargetLanguage())) {
                    this.error(String.format("Invalid target language ('%s') set or inherited. It should be '%s'.", new Object[]{lang, this.docData.getTargetLanguage()}));
                }
            } else if (!lang.equals(this.docData.getSourceLanguage())) {
                this.error(String.format("Invalid source language ('%s') set or inherited. It should be '%s'.", new Object[]{lang, this.docData.getSourceLanguage()}));
            }
        }
        partToFill.setPreserveWS(this.xmlAttributes.peek().startsWith("p"));
        i = 0;
        while (i < this.reader.getAttributeCount()) {
            block49: {
                block50: {
                    locName = this.reader.getAttributeLocalName(i);
                    value = this.reader.getAttributeValue(i);
                    ns = this.reader.getAttributeNamespace(i);
                    if (!Util.isNoE(ns)) break block50;
                    if (isTarget && locName.equals("order")) {
                        try {
                            order = Integer.parseInt(value);
                            partToFill.setTargetOrder(order);
                            this.checkTargetOrder = true;
                        }
                        catch (NumberFormatException e) {
                            this.error(String.format("Invalid numeric value '%s' for order attribute.", new Object[]{value}));
                        }
                        break block49;
                    } else if (isTarget) {
                        this.error(String.format("Invalid attribute '%s' in <target>.", new Object[]{locName}));
                        break block49;
                    } else {
                        this.error(String.format("Invalid attribute '%s' <source>.", new Object[]{locName}));
                    }
                    break block49;
                }
                if (!ns.equals("http://www.w3.org/XML/1998/namespace")) ** GOTO lbl-1000
                var16_18 = locName;
                tmp = -1;
                switch (var16_18.hashCode()) {
                    case 3314158: {
                        if (!var16_18.equals("lang")) break;
                        tmp = 1;
                        break;
                    }
                    case 109637894: {
                        if (!var16_18.equals("space")) break;
                        tmp = 1;
                        break;
                    }
                }
                switch (tmp) {
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (isTarget) {
                            this.error(String.format("Invalid attribute '%s' in <target>.", new Object[]{locName}));
                            break;
                        }
                        this.error(String.format("Invalid attribute '%s' <source>.", new Object[]{locName}));
                        break;
                    }
                    case 1: 
                }
            }
            ++i;
        }
        currentElem = null;
        block16: while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 4: {
                    if (inTextContent) {
                        frag.append(this.reader.getText());
                        break;
                    }
                    this.error(String.format("The <%s> element must be empty.", new Object[]{currentElem}));
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 1: {
                    currentElem = tmp = this.reader.getLocalName();
                    id = this.reader.getAttributeValue("", "id");
                    if (this.reader.getNamespaceURI().equals("urn:oasis:names:tc:xliff:document:2.0")) {
                        if (tmp.equals("sc")) {
                            this.mustBeValidNmtoken("id", id, false);
                            code = frag.append(TagType.OPENING, id, null, true);
                            dataRef = this.setDataRef(code);
                            inTextContent = false;
                            this.setOtherInlineAttributes('\ue101', code, null, false, isTarget, false, null, dirCtx);
                            break;
                        }
                        if (tmp.equals("ec")) {
                            isolated = this.reader.getAttributeValue("", "isolated");
                            startRef = this.reader.getAttributeValue("", "startRef");
                            if (id != null && startRef != null) {
                                this.error("You cannot have both id and startRef attributes on a <ec/> element.");
                            }
                            if (isolated != null) {
                                this.canBeYesOrNo("isolated", isolated);
                                this.mustBeValidNmtoken("id", id, false);
                            } else {
                                this.mustBeValidNmtoken("startRef", startRef, false);
                                id = startRef;
                            }
                            code = frag.append(TagType.CLOSING, id, null, true);
                            dataRef = this.setDataRef(code);
                            inTextContent = false;
                            this.setOtherInlineAttributes('\ue102', code, null, false, isTarget, isolated != null, (CTag)frag.getOpeningTag(code), dirCtx);
                            break;
                        }
                        if (tmp.equals("ph")) {
                            this.mustBeValidNmtoken("id", id, false);
                            code = frag.appendCode(id, null);
                            dataRef = this.setDataRef(code);
                            inTextContent = false;
                            this.setOtherInlineAttributes('\ue103', code, null, false, isTarget, false, null, dirCtx);
                            break;
                        }
                        if (tmp.equals("pc")) {
                            this.mustBeValidNmtoken("id", id, false);
                            code = frag.append(TagType.OPENING, id, null, false);
                            this.setOtherInlineAttributes('\ue101', code, null, true, isTarget, false, null, dirCtx);
                            tmp = this.reader.getAttributeValue("", "dataRefStart");
                            if (this.cannotBeEmpty("dataRef", tmp)) {
                                dataRef = tmp;
                                code.setDataRef(dataRef);
                            }
                            code.setInitialWithData(dataRef != null);
                            code = null;
                            closing = new CTag(TagType.CLOSING, id, null);
                            this.setOtherInlineAttributes('\ue102', closing, null, true, isTarget, false, null, dirCtx);
                            tmp = this.reader.getAttributeValue("", "dataRefEnd");
                            if (tmp != null && dataRef == null || tmp == null && dataRef != null) {
                                this.warning(String.format("Both '%s' and '%s' should be present or absent.", new Object[]{"dataRefStart", "dataRefEnd"}));
                            }
                            if (this.cannotBeEmpty("dataRef", tmp)) {
                                closing.setDataRef(tmp);
                            }
                            closing.setInitialWithData(dataRef != null);
                            dataRef = null;
                            pairs.push(closing);
                            break;
                        }
                        if (tmp.equals("sm")) {
                            this.mustBeValidNmtoken("id", id, false);
                            ann = new MTag(id, null);
                            ann = (MTag)this.setOtherInlineAttributes('\ue104', null, ann, false, isTarget, false, null, dirCtx);
                            frag.append(ann);
                            break;
                        }
                        if (tmp.equals("em")) {
                            id = this.reader.getAttributeValue("", "startRef");
                            this.mustBeValidNmtoken("startRef", id, false);
                            ann = frag.closeMarkerSpan(id);
                            this.setOtherInlineAttributes('\ue105', null, ann, false, isTarget, false, null, dirCtx);
                            break;
                        }
                        if (tmp.equals("mrk")) {
                            this.mustBeValidNmtoken("id", id, false);
                            ann = new MTag(id, "generic");
                            ann = (MTag)this.setOtherInlineAttributes('\ue104', null, ann, true, isTarget, false, null, dirCtx);
                            frag.append(ann);
                            closing = new MTag(ann);
                            this.setOtherInlineAttributes('\ue105', null, closing, true, isTarget, false, null, dirCtx);
                            pairs.push(closing);
                            break;
                        }
                        if (tmp.equals("cp")) {
                            this.readCP(inTextContent, frag);
                            break;
                        }
                        this.error(String.format("Invalid element in inline content: '%s'", new Object[]{this.reader.getName().toString()}));
                        break;
                    }
                    this.error(String.format("Invalid element in inline content: '%s'", new Object[]{this.reader.getName().toString()}));
                    break;
                }
                case 2: {
                    tmp = this.reader.getLocalName();
                    if (!this.reader.getNamespaceURI().equals("urn:oasis:names:tc:xliff:document:2.0")) {
                        this.error("Only the core namespace is allowed in content.");
                    }
                    if (tmp.equals("sc") || tmp.equals("ec") || tmp.equals("ph")) {
                        code.setInitialWithData(dataRef != null);
                        inTextContent = true;
                        dataRef = null;
                        break;
                    }
                    if (tmp.equals("pc")) {
                        frag.append((CTag)pairs.pop());
                        break;
                    }
                    if (tmp.equals("mrk")) {
                        frag.append((MTag)pairs.pop());
                        break;
                    }
                    if (tmp.equals("source")) {
                        partToFill.setSource(frag);
                        this.popXMLAttributes();
                        return;
                    }
                    if (!tmp.equals("target")) continue block16;
                    partToFill.setTarget(frag);
                    this.popXMLAttributes();
                    return;
                }
            }
        }
    }

    private void checkAnnotation(MTag marker, boolean expliciteTranslate) {
        String ref = marker.getRef();
        URIContext ctx = null;
        if (ref != null) {
            ctx = this.uriContext.peek();
            this.uriParser.setURL(ref, ctx.getFileId(), ctx.getGroupId(), ctx.getUnitId());
        }
        switch (marker.getType()) {
            case "comment": {
                String val = marker.getValue();
                if (val == null && ref == null) {
                    this.error("A comment annotation must have value or ref specified.");
                }
                if (val != null && ref != null) {
                    this.error("A comment annotation must use either the value or the ref attribute, not both.");
                }
                if (ref == null) break;
                String nid = this.uriParser.getNoteId();
                if (nid == null) {
                    this.error(String.format("The ref value of a comment annotation must be a note, but '%s' is not.", ref));
                }
                this.uriParser.complementReference();
                if (!this.uriParser.getUnitId().equals(ctx.getUnitId()) || !this.uriParser.getFileId().equals(ctx.getFileId()) || this.uriParser.getRefContainer() != 'u') {
                    this.error(String.format("The ref value of a comment annotation must be a note in the same unit, but '%s' is not.", ref));
                }
                boolean found = false;
                if (this.unit.getNoteCount() > 0) {
                    for (Note note : this.unit.getNotes()) {
                        if (!note.getId().equals(nid)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) break;
                this.error(String.format("No note with id='%s' found in the unit for '%s'.", nid, ref));
                break;
            }
            case "generic": {
                if (expliciteTranslate) break;
                this.error("Annotation of type='generic' must have the translate attribute set explicitly.");
            }
        }
    }

    private void readCP(boolean inTextContent, Fragment frag) {
        char[] chars;
        if (!inTextContent) {
            this.error(String.format("The <%s> element must be empty.", "cp"));
        }
        String tmp = this.reader.getAttributeValue("", "hex");
        this.cannotBeNullOrEmpty("hex", tmp);
        char[] cArray = chars = this.convertHexAttribute(tmp);
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            frag.append(c);
            ++n2;
        }
    }

    private char[] convertHexAttribute(String value) {
        try {
            int cp = Integer.valueOf(value, 16);
            if (Util.isValidInXML(cp)) {
                this.error(String.format("Code-point U+%04X is valid in XML and must not be encoded with <cp/>.", cp));
            }
            return Character.toChars(cp);
        }
        catch (NumberFormatException e) {
            this.error(String.format("Invalid code-point value in '%s': '%s'", "hex", value));
            return null;
        }
    }

    private void checkECValueAgainstSC(String attName, String scValue, String ecValue) {
        if (scValue == null) {
            if (ecValue != null) {
                this.error(String.format("The value for '%s' is not defined in the <ec> element, but is defined in the <ec/> element.", attName));
            }
        } else if (!scValue.equals(ecValue)) {
            this.error(String.format("The value '%s' for '%s' in <ec/> is not matching the value '%s' in <sc/>.", ecValue, attName, scValue));
        }
    }

    private void checkECCanReorderAgainstSC(String attName, CanReorder scValue, String ecValue) {
        if (scValue == CanReorder.FIRSTNO) {
            if (ecValue.equals("yes")) {
                this.error(String.format("The value '%s' for '%s' in <ec/> is not matching the value '%s' in <sc/>.", new Object[]{ecValue, attName, scValue}));
            }
        } else if (!scValue.toString().equals(ecValue)) {
            this.error(String.format("The value '%s' for '%s' in <ec/> is not matching the value '%s' in <sc/>.", new Object[]{ecValue, attName, scValue}));
        }
    }

    private void checkECValueAgainstSC(String attName, boolean scValue, boolean ecValue) {
        if (scValue != ecValue) {
            this.error(String.format("The value '%s' for '%s' in <ec/> is not matching the value '%s' in <sc/>.", ecValue ? "yes" : "no", attName, scValue ? "yes" : "no"));
        }
    }

    /*
     * Unable to fully structure code
     */
    private Tag setOtherInlineAttributes(char inlineType, CTag ctag, MTag mtag, boolean paired, boolean isTarget, boolean closingIsolated, CTag opening, Stack<Directionality> dirCtx) {
        openingIsolated = false;
        expliciteTranslate = false;
        tag = null;
        tag = ctag != null ? ctag : mtag;
        closingNonIsolated = inlineType == '\ue102' && opening != null;
        tag.setExtAttributes(this.gatherNamespaces(tag.getExtAttributes()));
        canReorderChk = false;
        dirChk = false;
        copyOfChk = false;
        subTypeChk = false;
        canOverlapChk = false;
        canDeleteChk = false;
        canCopyChk = false;
        typeChk = false;
        value = this.reader.getAttributeValue("", "type");
        if (value != null) {
            switch (inlineType) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    if (closingNonIsolated) {
                        this.checkECValueAgainstSC("type", opening.getType(), value);
                        typeChk = true;
                        break;
                    }
                    ctag.setType(value);
                    break;
                }
                case '\ue104': {
                    if (value.equals("term") || value.equals("its:term-no")) {
                        mtag = new TermTag(mtag, value, this.inheritedData.peek().getAnnotatorsRef());
                        tag = mtag;
                        break;
                    }
                    mtag.setType(value);
                    break;
                }
            }
        }
        i = 0;
        while (i < this.reader.getAttributeCount()) {
            block135: {
                block134: {
                    block157: {
                        block158: {
                            block155: {
                                block156: {
                                    block153: {
                                        block154: {
                                            block152: {
                                                block151: {
                                                    block150: {
                                                        block149: {
                                                            block148: {
                                                                block147: {
                                                                    block146: {
                                                                        block145: {
                                                                            block144: {
                                                                                block143: {
                                                                                    block142: {
                                                                                        block141: {
                                                                                            block140: {
                                                                                                block139: {
                                                                                                    block138: {
                                                                                                        block137: {
                                                                                                            block136: {
                                                                                                                locName = this.reader.getAttributeLocalName(i);
                                                                                                                value = this.reader.getAttributeValue(i);
                                                                                                                if (!Util.isNoE(this.reader.getAttributeNamespace(i))) break block134;
                                                                                                                if (locName.equals("id") || locName.equals("startRef") || locName.equals("dataRef") || locName.equals("dataRefStart") || locName.equals("dataRefEnd")) break block135;
                                                                                                                if (!locName.equals("canCopy")) break block136;
                                                                                                                switch (inlineType) {
                                                                                                                    case '\ue101': 
                                                                                                                    case '\ue102': 
                                                                                                                    case '\ue103': {
                                                                                                                        if (this.canBeYesOrNo("canCopy", value)) {
                                                                                                                            if (closingNonIsolated) {
                                                                                                                                this.checkECValueAgainstSC("canCopy", opening.getCanCopy(), value.equals("yes"));
                                                                                                                                canCopyChk = true;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            ctag.setCanCopy(value.equals("yes"));
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        break block135;
                                                                                                                    }
                                                                                                                    default: {
                                                                                                                        this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                                                                                                        break;
                                                                                                                    }
                                                                                                                }
                                                                                                                break block135;
                                                                                                            }
                                                                                                            if (!locName.equals("canDelete")) break block137;
                                                                                                            switch (inlineType) {
                                                                                                                case '\ue101': 
                                                                                                                case '\ue102': 
                                                                                                                case '\ue103': {
                                                                                                                    if (this.canBeYesOrNo("canDelete", value)) {
                                                                                                                        if (closingNonIsolated) {
                                                                                                                            this.checkECValueAgainstSC("canDelete", opening.getCanDelete(), value.equals("yes"));
                                                                                                                            canDeleteChk = true;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        ctag.setCanDelete(value.equals("yes"));
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    break block135;
                                                                                                                }
                                                                                                                default: {
                                                                                                                    this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                                                                                                    break;
                                                                                                                }
                                                                                                            }
                                                                                                            break block135;
                                                                                                        }
                                                                                                        if (!locName.equals("canReorder")) break block138;
                                                                                                        switch (inlineType) {
                                                                                                            case '\ue101': 
                                                                                                            case '\ue102': 
                                                                                                            case '\ue103': {
                                                                                                                if (!this.canBeYesOrNoOrFirstNo("canReorder", value)) break block135;
                                                                                                                if (closingNonIsolated) {
                                                                                                                    this.checkECCanReorderAgainstSC("canReorder", opening.getCanReorder(), value);
                                                                                                                    canReorderChk = true;
                                                                                                                    break;
                                                                                                                }
                                                                                                                var24_25 = value;
                                                                                                                tmp = -1;
                                                                                                                switch (var24_25.hashCode()) {
                                                                                                                    case -849022831: {
                                                                                                                        if (var24_25.equals("firstNo")) {
                                                                                                                            tmp = 1;
                                                                                                                        }
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 3521: {
                                                                                                                        if (var24_25.equals("no")) {
                                                                                                                            tmp = 2;
                                                                                                                        }
                                                                                                                        break;
                                                                                                                    }
                                                                                                                }
                                                                                                                switch (tmp) {
                                                                                                                    case 1: {
                                                                                                                        ctag.setCanReorder(CanReorder.FIRSTNO);
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 2: {
                                                                                                                        ctag.setCanReorder(CanReorder.NO);
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    default: {
                                                                                                                        ctag.setCanReorder(CanReorder.YES);
                                                                                                                    }
                                                                                                                }
                                                                                                                if (ctag.getCanReorder() != CanReorder.YES && (this.reader.getAttributeValue("", "canCopy") == null || this.reader.getAttributeValue("", "canDelete") == null)) {
                                                                                                                    this.error("Both canCopy and canDelete must be set to 'no' if canReorder is not set to 'yes'.");
                                                                                                                    break;
                                                                                                                }
                                                                                                                break block135;
                                                                                                            }
                                                                                                            default: {
                                                                                                                this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                                                                                                break;
                                                                                                            }
                                                                                                        }
                                                                                                        break block135;
                                                                                                    }
                                                                                                    if (!locName.equals("copyOf")) break block139;
                                                                                                    switch (inlineType) {
                                                                                                        case '\ue101': 
                                                                                                        case '\ue102': 
                                                                                                        case '\ue103': {
                                                                                                            if (this.cannotBeEmpty("copyOf", value)) {
                                                                                                                if (closingNonIsolated) {
                                                                                                                    this.checkECValueAgainstSC("copyOf", opening.getCopyOf(), value);
                                                                                                                    copyOfChk = true;
                                                                                                                    break;
                                                                                                                }
                                                                                                                ctag.setCopyOf(value);
                                                                                                                break;
                                                                                                            }
                                                                                                            break block135;
                                                                                                        }
                                                                                                        default: {
                                                                                                            this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                                                                                            break;
                                                                                                        }
                                                                                                    }
                                                                                                    break block135;
                                                                                                }
                                                                                                if (locName.equals("type")) break block135;
                                                                                                if (!locName.equals("subType")) break block140;
                                                                                                switch (inlineType) {
                                                                                                    case '\ue101': 
                                                                                                    case '\ue102': 
                                                                                                    case '\ue103': {
                                                                                                        if (this.reader.getAttributeValue("", "type") == null) {
                                                                                                            this.error("An inline code with a subType attribute must also have a type attribute.");
                                                                                                        }
                                                                                                        if (closingNonIsolated) {
                                                                                                            this.checkECValueAgainstSC("subType", opening.getSubType(), value);
                                                                                                            subTypeChk = true;
                                                                                                            break;
                                                                                                        }
                                                                                                        ctag.setSubType(value);
                                                                                                        break;
                                                                                                    }
                                                                                                    default: {
                                                                                                        this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                                                                                        break;
                                                                                                    }
                                                                                                }
                                                                                                break block135;
                                                                                            }
                                                                                            if (!locName.equals("dir")) break block141;
                                                                                            switch (inlineType) {
                                                                                                case '\ue101': 
                                                                                                case '\ue102': {
                                                                                                    dir = this.getDirectionality("dir", value, dirCtx.peek());
                                                                                                    if (closingNonIsolated) {
                                                                                                        if (opening.getDir() != dir) {
                                                                                                            this.error(String.format("The value '%s' for 'dir' in <ec/> is not matching the value '%s' in <sc/>.", new Object[]{dir.toString(), dirCtx.peek().toString()}));
                                                                                                        }
                                                                                                        dirChk = true;
                                                                                                    } else {
                                                                                                        ctag.setDir(dir);
                                                                                                    }
                                                                                                    if (inlineType == '\ue101') {
                                                                                                        dirCtx.push(dir);
                                                                                                        break;
                                                                                                    }
                                                                                                    if (!dirCtx.isEmpty()) {
                                                                                                        dirCtx.pop();
                                                                                                        break;
                                                                                                    }
                                                                                                    break block135;
                                                                                                }
                                                                                                default: {
                                                                                                    this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                                                                                    break;
                                                                                                }
                                                                                            }
                                                                                            break block135;
                                                                                        }
                                                                                        if (!locName.equals("value")) break block142;
                                                                                        switch (inlineType) {
                                                                                            case '\ue104': 
                                                                                            case '\ue105': {
                                                                                                mtag.setValue(value);
                                                                                                break;
                                                                                            }
                                                                                            default: {
                                                                                                this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                                                                                break;
                                                                                            }
                                                                                        }
                                                                                        break block135;
                                                                                    }
                                                                                    if (!locName.equals("ref")) break block143;
                                                                                    switch (inlineType) {
                                                                                        case '\ue104': 
                                                                                        case '\ue105': {
                                                                                            mtag.setRef(value);
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                                                                            break;
                                                                                        }
                                                                                    }
                                                                                    break block135;
                                                                                }
                                                                                if (!locName.equals("translate")) break block144;
                                                                                switch (inlineType) {
                                                                                    case '\ue104': 
                                                                                    case '\ue105': {
                                                                                        this.canBeYesOrNo("translate", value);
                                                                                        mtag.setTranslate("yes".equals(value));
                                                                                        expliciteTranslate = true;
                                                                                        break;
                                                                                    }
                                                                                    default: {
                                                                                        this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                break block135;
                                                                            }
                                                                            if (!locName.equals("isolated")) break block145;
                                                                            switch (inlineType) {
                                                                                case '\ue101': {
                                                                                    this.canBeYesOrNo("isolated", value);
                                                                                    openingIsolated = true;
                                                                                    break;
                                                                                }
                                                                                case '\ue102': {
                                                                                    closingIsolated = true;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                                                                    break;
                                                                                }
                                                                            }
                                                                            break block135;
                                                                        }
                                                                        if (!locName.equals("canOverlap")) break block146;
                                                                        switch (inlineType) {
                                                                            case '\ue101': 
                                                                            case '\ue102': {
                                                                                yon = this.getYesOrNo("canOverlap", value, paired == false);
                                                                                if (closingNonIsolated) {
                                                                                    this.checkECValueAgainstSC("canOverlap", opening.getCanOverlap(), yon);
                                                                                    canOverlapChk = true;
                                                                                    break;
                                                                                }
                                                                                ctag.setCanOverlap(yon);
                                                                                break;
                                                                            }
                                                                            default: {
                                                                                this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                                                                break;
                                                                            }
                                                                        }
                                                                        break block135;
                                                                    }
                                                                    if (!locName.equals("equiv")) break block147;
                                                                    if (paired) ** GOTO lbl-1000
                                                                    switch (inlineType) {
                                                                        case '\ue101': 
                                                                        case '\ue102': 
                                                                        case '\ue103': {
                                                                            ctag.setEquiv(value);
                                                                            break;
                                                                        }
                                                                        default: lbl-1000:
                                                                        // 2 sources

                                                                        {
                                                                            this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                                                            break;
                                                                        }
                                                                    }
                                                                    break block135;
                                                                }
                                                                if (!locName.equals("equivStart")) break block148;
                                                                if (paired) {
                                                                    switch (inlineType) {
                                                                        case '\ue101': {
                                                                            ctag.setEquiv(value);
                                                                            break;
                                                                        }
                                                                    }
                                                                } else {
                                                                    this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                                                }
                                                                break block135;
                                                            }
                                                            if (!locName.equals("equivEnd")) break block149;
                                                            if (paired) {
                                                                switch (inlineType) {
                                                                    case '\ue102': {
                                                                        ctag.setEquiv(value);
                                                                        break;
                                                                    }
                                                                }
                                                            } else {
                                                                this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                                            }
                                                            break block135;
                                                        }
                                                        if (!locName.equals("disp")) break block150;
                                                        if (paired) ** GOTO lbl-1000
                                                        switch (inlineType) {
                                                            case '\ue101': 
                                                            case '\ue102': 
                                                            case '\ue103': {
                                                                ctag.setDisp(value);
                                                                break;
                                                            }
                                                            default: lbl-1000:
                                                            // 2 sources

                                                            {
                                                                this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                                                break;
                                                            }
                                                        }
                                                        break block135;
                                                    }
                                                    if (!locName.equals("dispStart")) break block151;
                                                    if (paired) {
                                                        switch (inlineType) {
                                                            case '\ue101': {
                                                                ctag.setDisp(value);
                                                                break;
                                                            }
                                                        }
                                                    } else {
                                                        this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                                    }
                                                    break block135;
                                                }
                                                if (!locName.equals("dispEnd")) break block152;
                                                if (paired) {
                                                    switch (inlineType) {
                                                        case '\ue102': {
                                                            ctag.setDisp(value);
                                                            break;
                                                        }
                                                    }
                                                } else {
                                                    this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                                }
                                                break block135;
                                            }
                                            if (!locName.equals("subFlows")) break block153;
                                            if (paired) break block154;
                                            switch (inlineType) {
                                                case '\ue101': 
                                                case '\ue102': 
                                                case '\ue103': {
                                                    ctag.setSubFlows(value);
                                                    var27_34 = ctag.getSubFlowsIds();
                                                    var26_33 = var27_34.length;
                                                    var25_32 = 0;
                                                    while (var25_32 < var26_33) {
                                                        id = var27_34[var25_32];
                                                        this.subFlowIds.add(id);
                                                        ++var25_32;
                                                    }
                                                    break block65;
                                                }
                                            }
                                            break block135;
                                        }
                                        this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                        break block135;
                                    }
                                    if (!locName.equals("subFlowsStart")) break block155;
                                    if (!paired) break block156;
                                    switch (inlineType) {
                                        case '\ue101': {
                                            ctag.setSubFlows(value);
                                            var27_34 = ctag.getSubFlowsIds();
                                            var26_33 = var27_34.length;
                                            var25_32 = 0;
                                            while (var25_32 < var26_33) {
                                                id = var27_34[var25_32];
                                                this.subFlowIds.add(id);
                                                ++var25_32;
                                            }
                                            break block68;
                                        }
                                    }
                                    break block135;
                                }
                                this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                break block135;
                            }
                            if (!locName.equals("subFlowsEnd")) break block157;
                            if (!paired) break block158;
                            switch (inlineType) {
                                case '\ue102': {
                                    ctag.setSubFlows(value);
                                    var27_34 = ctag.getSubFlowsIds();
                                    var26_33 = var27_34.length;
                                    var25_32 = 0;
                                    while (var25_32 < var26_33) {
                                        id = var27_34[var25_32];
                                        this.subFlowIds.add(id);
                                        ++var25_32;
                                    }
                                    break block71;
                                }
                            }
                            break block135;
                        }
                        this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                        break block135;
                    }
                    this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                    break block135;
                }
                qname = this.reader.getAttributeName(i);
                if (ctag != null) {
                    if (!qname.getNamespaceURI().startsWith("urn:oasis:names:tc:xliff:")) {
                        this.error(String.format("Invalid extension attribute (%s). Only attributes from core and modules can be used in inline codes.", new Object[]{qname.toString()}));
                    }
                    if (inlineType == '\ue102') {
                        if (!paired) {
                            if (!closingIsolated) {
                                this.error(String.format("Invalid module attribute %s. It is allowed in <ec> only when the element is isolated.", new Object[]{qname.toString()}));
                            }
                            this.addExtAttribute(ctag, i, false);
                        }
                    } else {
                        this.addExtAttribute(ctag, i, false);
                    }
                } else if (inlineType == '\ue105') {
                    if (!paired) {
                        this.error(String.format("Invalid attribute %s. No module or extension attribute is allowed in <em>.", new Object[]{qname.toString()}));
                    }
                } else {
                    if (tag instanceof TermTag) {
                        this.itsReader.readTerminology((TermTag)mtag, this.inheritedData.peek().getAnnotatorsRef());
                    } else {
                        this.itsReader.readAttributes(this.unit, mtag, this.inheritedData.peek().getAnnotatorsRef());
                    }
                    this.addExtAttribute(mtag, i, true);
                }
            }
            ++i;
        }
        if (ctag != null) {
            if (ctag.getCanReorder() != CanReorder.YES && (ctag.getCanCopy() || ctag.getCanDelete())) {
                this.error("If canReorder is not set to 'yes' then canCopy and canDelete must be set to 'no'.");
            }
            try {
                ctag.verifyTypeSubTypeValues();
            }
            catch (InvalidParameterException e) {
                this.error(e.getLocalizedMessage());
            }
            if (closingIsolated || openingIsolated) {
                if (isTarget) {
                    this.trgIsolated.add(ctag);
                } else {
                    this.srcIsolated.add(ctag);
                }
            }
            if (closingNonIsolated) {
                if (!canCopyChk && !ctag.getCanCopy()) {
                    this.error(String.format("In <ec> with startRef='%s', the default canCopy value does not match the one of the corresponding <sc> ('%s').", new Object[]{ctag.getId(), opening.getCanCopy() != false ? "yes" : "no"}));
                }
                if (!canDeleteChk && !ctag.getCanDelete()) {
                    this.error(String.format("In <ec> with startRef='%s', the default canDelete value does not match the one of the corresponding <sc> ('%s').", new Object[]{ctag.getId(), opening.getCanDelete() != false ? "yes" : "no"}));
                }
                if (!typeChk && ctag.getType() != null) {
                    this.error(String.format("In <ec> with startRef='%s', the default type value does not match the one of the corresponding <sc> ('%s').", new Object[]{ctag.getId(), opening.getType()}));
                }
                if (!subTypeChk && ctag.getSubType() != null) {
                    this.error(String.format("In <ec> with startRef='%s', the default subType value does not match the one of the corresponding <sc> ('%s').", new Object[]{ctag.getId(), opening.getSubType()}));
                }
                if (!copyOfChk && ctag.getCopyOf() != null) {
                    this.error(String.format("In <ec> with startRef='%s', the default copyOf value does not match the one of the corresponding <sc> ('%s').", new Object[]{ctag.getId(), opening.getCopyOf()}));
                }
                if (!canReorderChk && ctag.getCanReorder() != CanReorder.YES) {
                    this.error(String.format("In <ec> with startRef='%s', the default canReorder value is not valid for the corresponding <sc> value ('%s').", new Object[]{ctag.getId(), opening.getCanReorder()}));
                }
            }
        } else if (mtag.getTagType() == TagType.OPENING) {
            this.checkAnnotation(mtag, expliciteTranslate);
        }
        return tag;
    }

    private String setDataRef(CTag code) {
        String tmp = this.reader.getAttributeValue("", "dataRef");
        if (this.cannotBeEmpty("dataRef", tmp)) {
            code.setDataRef(tmp);
            return tmp;
        }
        return null;
    }

    private ExtAttributes gatherExtAttributes(boolean isExtElement) {
        ExtAttributes attrs = null;
        int i = 0;
        while (i < this.reader.getNamespaceCount()) {
            String namespaceURI = this.reader.getNamespaceURI(i);
            if (!namespaceURI.equals("urn:oasis:names:tc:xliff:document:2.0")) {
                if (attrs == null) {
                    attrs = new ExtAttributes();
                }
                attrs.setNamespace(this.reader.getNamespacePrefix(i), namespaceURI);
            }
            ++i;
        }
        i = 0;
        while (i < this.reader.getAttributeCount()) {
            QName qname = this.reader.getAttributeName(i);
            if (isExtElement || !qname.getNamespaceURI().isEmpty()) {
                if (attrs == null) {
                    attrs = new ExtAttributes();
                }
                attrs.setAttribute(new ExtAttribute(qname, this.reader.getAttributeValue(i)));
                if (qname.getLocalPart().equals("id") && (qname.getNamespaceURI().equals("http://www.w3.org/XML/1998/namespace") || qname.getNamespaceURI().isEmpty())) {
                    this.mustBeValidNmtoken(qname.toString(), this.reader.getAttributeValue(i), false);
                    this.checkAndAddSpecialId(this.reader.getNamespaceURI(), this.reader.getAttributeValue(i));
                }
            }
            ++i;
        }
        if (attrs == null || attrs.isEmpty()) {
            return null;
        }
        return attrs;
    }

    private ExtAttributes gatherNamespaces(ExtAttributes attrs) {
        int i = 0;
        while (i < this.reader.getNamespaceCount()) {
            String namespaceURI = this.reader.getNamespaceURI(i);
            if (!namespaceURI.equals("urn:oasis:names:tc:xliff:document:2.0")) {
                if (attrs == null) {
                    attrs = new ExtAttributes();
                }
                attrs.setNamespace(this.reader.getNamespacePrefix(i), namespaceURI);
            }
            ++i;
        }
        if (attrs == null || attrs.isEmpty()) {
            return null;
        }
        return attrs;
    }

    private void addExtAttribute(IWithExtAttributes object, int attributeIndex, boolean skipITS) {
        QName qname = this.reader.getAttributeName(attributeIndex);
        String ns = qname.getNamespaceURI();
        if (skipITS && ns != null && (ns.equals("http://www.w3.org/2005/11/its") || ns.equals("http://www.w3.org/ns/its-xliff/"))) {
            return;
        }
        if (this.locValidator != null) {
            String parentName = this.reader.getLocalName();
            switch (this.locValidator.verify(parentName, qname, true)) {
                case 1: {
                    this.error(String.format("No modules are allowed in '%s'.", parentName));
                }
                case 2: {
                    this.error(String.format("Attribute '%s' is not allowed in '%s'.", qname, parentName));
                }
            }
        }
        object.getExtAttributes().setAttribute(new ExtAttribute(qname, this.reader.getAttributeValue(attributeIndex)));
    }

    private ExtElements processExtElement(String parentName, ExtElements extElements) {
        if (extElements == null) {
            extElements = new ExtElements();
        }
        if (this.locValidator != null) {
            switch (this.locValidator.verify(parentName, this.reader.getName(), false)) {
                case 1: {
                    this.error(String.format("No modules are allowed in '%s'.", parentName));
                }
                case 3: {
                    this.error(String.format("Too many occurrences of '%s' in '%s'.", this.reader.getName(), parentName));
                }
                case 2: {
                    this.error(String.format("Element '%s' is not allowed in '%s'.", this.reader.getName(), parentName));
                }
            }
        }
        extElements.add(this.readExtElement());
        return extElements;
    }

    private ExtElement readExtElement() {
        try {
            ExtElement elem = new ExtElement(this.reader.getName());
            elem.setExtAttributes(this.gatherExtAttributes(true));
            List<IExtChild> children = elem.getChildren();
            while (this.reader.hasNext()) {
                switch (this.reader.next()) {
                    case 1: {
                        this.pushXMLAttributes();
                        children.add(this.readExtElement());
                        break;
                    }
                    case 2: {
                        if (!this.reader.getName().equals(elem.getQName())) break;
                        this.popXMLAttributes();
                        return elem;
                    }
                    case 4: 
                    case 6: {
                        children.add(new ExtContent(this.reader.getText()));
                        break;
                    }
                    case 12: {
                        children.add(new ExtContent(this.reader.getText(), true));
                        break;
                    }
                    case 3: {
                        children.add(new ProcessingInstruction("<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>"));
                    }
                }
            }
            throw new IOException("Unexpected end of file.");
        }
        catch (IOException | XMLStreamException e) {
            this.error("Error adding an extension element. " + e.getMessage());
            return null;
        }
    }

    protected void processMatches() throws XMLStreamException {
        if (!this.reader.getLocalName().equals("matches")) {
            this.error(String.format("Invalid element '%s'", this.reader.getName().toString()));
        }
        this.pushSpecialIds();
        Matches matches = new Matches();
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    this.processMatch(matches);
                    break;
                }
                case 2: {
                    this.popXMLAttributes();
                    if (matches.isEmpty()) {
                        this.error("You must have at least one <match> element in a <matches> element.");
                    }
                    this.unit.setMatches(matches);
                    this.popSpecialIds();
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processMatch(Matches matches) throws XMLStreamException {
        String tmp = this.reader.getLocalName();
        String nsUri = this.reader.getNamespaceURI();
        if (!tmp.equals("match") || !nsUri.equals("urn:oasis:names:tc:xliff:matches:2.0")) {
            this.error(String.format("Invalid element '%s' in <matches>.", this.reader.getName().toString()));
        }
        Match match = new Match();
        Map<String, DataElementContent> matchODM = null;
        ExtElements extElems = null;
        this.pushXMLAttributes();
        match.setExtAttributes(this.gatherNamespaces(match.getExtAttributes()));
        AnnotatorsRef ar = this.inheritedData.peek().getAnnotatorsRef();
        if (ar != null) {
            match.setAnnoatorRef(ar.get("mt-confidence"));
        }
        int i = 0;
        while (i < this.reader.getAttributeCount()) {
            block39: {
                block48: {
                    String ns;
                    String locName;
                    block47: {
                        block37: {
                            String value;
                            block46: {
                                block45: {
                                    block44: {
                                        block43: {
                                            block42: {
                                                block41: {
                                                    block40: {
                                                        block38: {
                                                            locName = this.reader.getAttributeLocalName(i);
                                                            value = this.reader.getAttributeValue(i);
                                                            ns = this.reader.getAttributeNamespace(i);
                                                            if (!Util.isNoE(ns)) break block37;
                                                            if (!locName.equals("ref")) break block38;
                                                            match.setRef(value);
                                                            break block39;
                                                        }
                                                        if (!locName.equals("type")) break block40;
                                                        match.setType(value);
                                                        break block39;
                                                    }
                                                    if (!locName.equals("subType")) break block41;
                                                    if (value != null) {
                                                        if (this.reader.getAttributeValue("", "type") == null) {
                                                            this.error("If <match> has a subType, type must be set explicitly.");
                                                        }
                                                        match.setSubType(value);
                                                    }
                                                    break block39;
                                                }
                                                if (!locName.equals("id")) break block42;
                                                this.mustBeValidNmtoken("id", value, true);
                                                this.checkAndAddSpecialId("urn:oasis:names:tc:xliff:matches:2.0", value);
                                                match.setId(value);
                                                break block39;
                                            }
                                            if (!locName.equals("similarity")) break block43;
                                            match.setSimilarity(Double.valueOf(value));
                                            break block39;
                                        }
                                        if (!locName.equals("matchQuality")) break block44;
                                        match.setMatchQuality(Double.valueOf(value));
                                        break block39;
                                    }
                                    if (!locName.equals("matchSuitability")) break block45;
                                    match.setMatchSuitability(Double.valueOf(value));
                                    break block39;
                                }
                                if (!locName.equals("origin")) break block46;
                                match.setOrigin(value);
                                break block39;
                            }
                            if (locName.equals("reference")) {
                                if (this.canBeYesOrNo("reference", value)) {
                                    match.setReference(value.equals("yes"));
                                }
                                break block39;
                            } else {
                                this.error(String.format("Invalid attribute '%s'.", locName));
                            }
                            break block39;
                        }
                        if (!ns.equals("http://www.w3.org/XML/1998/namespace")) break block47;
                        if (locName.equals("lang")) {
                            this.error("The attribute xml:lang is not allowed in <match>.");
                        }
                        break block39;
                    }
                    if (!ns.equals("http://www.w3.org/2005/11/its")) break block48;
                    if (locName.equals("annotatorsRef")) {
                        AnnotatorsRef tmpAR = this.itsReader.readAnnotatorsRef(false, ar);
                        if (tmpAR != null) {
                            match.setAnnoatorRef(tmpAR.get("mt-confidence"));
                        }
                        break block39;
                    } else {
                        this.warning("Unexpected ITS attribute: " + locName);
                    }
                    break block39;
                }
                this.addExtAttribute(match, i, false);
            }
            ++i;
        }
        Part part = new Part(match.getStore());
        int state = 0;
        block15: while (this.reader.hasNext()) {
            block0 : switch (this.reader.next()) {
                case 1: {
                    tmp = this.reader.getLocalName();
                    nsUri = this.reader.getNamespaceURI();
                    this.pushXMLAttributes();
                    if (nsUri.equals("urn:oasis:names:tc:xliff:metadata:2.0")) {
                        if (state > 0) {
                            this.error(String.format("Element '%s' misplaced.", this.reader.getName().toString()));
                        }
                        this.processMetadata(match);
                        state = 1;
                        break;
                    }
                    if (nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) {
                        switch (tmp) {
                            case "originalData": {
                                if (state > 1) {
                                    this.error(String.format("Element '%s' misplaced.", this.reader.getName().toString()));
                                }
                                matchODM = this.processOriginalData();
                                state = 2;
                                break block0;
                            }
                            case "source": {
                                if (state > 2) {
                                    this.error(String.format("Element '%s' misplaced.", this.reader.getName().toString()));
                                }
                                this.processContent(part, false, false);
                                match.setSource(part.getSource());
                                state = 3;
                                break block0;
                            }
                            case "target": {
                                if (state > 3) {
                                    this.error(String.format("Element '%s' misplaced.", this.reader.getName().toString()));
                                }
                                this.processContent(part, true, match.isReference());
                                match.setTarget(part.getTarget());
                                state = 4;
                                break block0;
                            }
                        }
                        this.error(String.format("Invalid element '%s'", this.reader.getName().toString()));
                        break;
                    }
                    if (state < 4) {
                        this.error(String.format("Element '%s' misplaced.", this.reader.getName().toString()));
                    }
                    if (this.locValidator != null) {
                        this.locValidator.reset();
                    }
                    extElems = this.processExtElement("mtc:match", extElems);
                    break;
                }
                case 2: {
                    tmp = this.reader.getLocalName();
                    nsUri = this.reader.getNamespaceURI();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:matches:2.0")) continue block15;
                    if (state < 4) {
                        this.error("Missing element(s) in <match>.");
                    }
                    this.copyOriginalDataToCodes(match.getStore(), matchODM);
                    matches.add(match);
                    if (extElems != null) {
                        match.setExtElements(extElems);
                    }
                    this.popXMLAttributes();
                    return;
                }
            }
        }
    }

    private void processGlossary() throws XMLStreamException {
        if (!this.reader.getLocalName().equals("glossary")) {
            this.error(String.format("Invalid element '%s'", this.reader.getName().toString()));
        }
        this.pushSpecialIds();
        Glossary glossary = new Glossary();
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    this.processGlossEntry(glossary);
                    break;
                }
                case 2: {
                    this.popXMLAttributes();
                    if (glossary.isEmpty()) {
                        this.error("You must have at least one <glossEntry> element in a <glossary> element.");
                    }
                    this.unit.setGlossary(glossary);
                    this.popSpecialIds();
                    return;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processGlossEntry(Glossary glossary) throws XMLStreamException {
        tmp = this.reader.getLocalName();
        nsUri = this.reader.getNamespaceURI();
        if (!tmp.equals("glossEntry") || !nsUri.equals("urn:oasis:names:tc:xliff:glossary:2.0")) {
            this.error(String.format("Invalid element '%s' in <glossary>.", new Object[]{this.reader.getName().toString()}));
        }
        entry = new GlossEntry();
        extElems = null;
        this.pushXMLAttributes();
        entry.setExtAttributes(this.gatherNamespaces(entry.getExtAttributes()));
        i = 0;
        while (i < this.reader.getAttributeCount()) {
            locName = this.reader.getAttributeLocalName(i);
            value = this.reader.getAttributeValue(i);
            ns = this.reader.getAttributeNamespace(i);
            if (Util.isNoE(ns)) {
                if (locName.equals("ref")) {
                    entry.setRef(value);
                } else if (locName.equals("id")) {
                    this.mustBeValidNmtoken("id", value, true);
                    this.checkAndAddSpecialId("urn:oasis:names:tc:xliff:glossary:2.0", value);
                    entry.setId(value);
                } else {
                    this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                }
            } else {
                this.addExtAttribute(entry, i, false);
            }
            ++i;
        }
        state = 0;
        while (this.reader.hasNext()) {
            block0 : switch (this.reader.next()) {
                case 1: {
                    tmp = this.reader.getLocalName();
                    nsUri = this.reader.getNamespaceURI();
                    this.pushXMLAttributes();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:glossary:2.0")) ** GOTO lbl130
                    var7_7 = tmp;
                    tmp = -1;
                    switch (var7_7.hashCode()) {
                        case -1840647503: {
                            if (var7_7.equals("translation")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case -1014418093: {
                            if (var7_7.equals("definition")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case 3556460: {
                            if (var7_7.equals("term")) {
                                tmp = 3;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 3: {
                            if (state != 0) {
                                this.error(String.format("Element '%s' misplaced.", new Object[]{this.reader.getName().toString()}));
                            }
                            i = 0;
                            while (i < this.reader.getAttributeCount()) {
                                locName = this.reader.getAttributeLocalName(i);
                                value = this.reader.getAttributeValue(i);
                                ns = this.reader.getAttributeNamespace(i);
                                if (Util.isNoE(ns)) {
                                    if (locName.equals("source")) {
                                        entry.getTerm().setSource(value);
                                    } else {
                                        this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                    }
                                } else {
                                    this.addExtAttribute(entry.getTerm(), i, false);
                                }
                                ++i;
                            }
                            entry.getTerm().setText(this.readTextContent(true));
                            state = 1;
                            break block0;
                        }
                        case 1: {
                            if (state != 1) {
                                this.error(String.format("Element '%s' misplaced.", new Object[]{this.reader.getName().toString()}));
                            }
                            trans = new Translation(null);
                            i = 0;
                            while (i < this.reader.getAttributeCount()) {
                                locName = this.reader.getAttributeLocalName(i);
                                value = this.reader.getAttributeValue(i);
                                ns = this.reader.getAttributeNamespace(i);
                                if (Util.isNoE(ns)) {
                                    if (locName.equals("ref")) {
                                        trans.setRef(value);
                                    } else if (locName.equals("source")) {
                                        trans.setSource(value);
                                    } else if (locName.equals("id")) {
                                        this.mustBeValidNmtoken("id", value, true);
                                        this.checkAndAddSpecialId("urn:oasis:names:tc:xliff:glossary:2.0", value);
                                        trans.setId(value);
                                    } else {
                                        this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                    }
                                } else {
                                    this.addExtAttribute(trans, i, false);
                                }
                                ++i;
                            }
                            trans.setText(this.readTextContent(true));
                            entry.getTranslations().add(trans);
                            break block0;
                        }
                        case 2: {
                            if (state < 1 && state > 2) {
                                this.error(String.format("Element '%s' misplaced.", new Object[]{this.reader.getName().toString()}));
                            }
                            i = 0;
                            while (i < this.reader.getAttributeCount()) {
                                locName = this.reader.getAttributeLocalName(i);
                                value = this.reader.getAttributeValue(i);
                                ns = this.reader.getAttributeNamespace(i);
                                if (Util.isNoE(ns)) {
                                    if (locName.equals("source")) {
                                        entry.getDefinition().setSource(value);
                                    } else {
                                        this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                    }
                                } else {
                                    this.addExtAttribute(entry.getDefinition(), i, false);
                                }
                                ++i;
                            }
                            entry.getDefinition().setText(this.readTextContent(true));
                            state = 3;
                            break block0;
                        }
                    }
                    this.error(String.format("Invalid element '%s'", new Object[]{this.reader.getName().toString()}));
                    break;
lbl130:
                    // 1 sources

                    if (state < 1) {
                        this.error(String.format("Element '%s' misplaced.", new Object[]{this.reader.getName().toString()}));
                    }
                    if (this.locValidator != null) {
                        this.locValidator.reset();
                    }
                    extElems = this.processExtElement("gls:glossEntry", extElems);
                    break;
                }
                case 2: {
                    tmp = this.reader.getLocalName();
                    nsUri = this.reader.getNamespaceURI();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:glossary:2.0")) break;
                    if (state < 1) {
                        this.error("Missing element(s) in <glossEntry>.");
                    }
                    if (entry.getDefinition().getText() == null && entry.getTranslations().isEmpty()) {
                        this.error("A <glossEntry> must have at least a <translation> or a <definition>.");
                    }
                    glossary.add(entry);
                    if (extElems != null) {
                        entry.setExtElements(extElems);
                    }
                    this.popXMLAttributes();
                    return;
                }
            }
        }
    }

    private void processMetadata(IWithMetadata parent) throws XMLStreamException {
        if (!this.reader.getLocalName().equals("metadata")) {
            this.error(String.format("Invalid element '%s'", this.reader.getName().toString()));
        }
        this.pushSpecialIds();
        Metadata metadata = new Metadata();
        int i = 0;
        while (i < this.reader.getAttributeCount()) {
            String locName = this.reader.getAttributeLocalName(i);
            if (Util.isNoE(this.reader.getAttributeNamespace(i))) {
                if (locName.equals("id")) {
                    String value = this.reader.getAttributeValue(i);
                    this.mustBeValidNmtoken("id", value, true);
                    this.checkAndAddSpecialId("urn:oasis:names:tc:xliff:metadata:2.0", value);
                    metadata.setId(value);
                } else {
                    this.error(String.format("Invalid attribute '%s'.", locName));
                }
            } else {
                this.error(String.format("Invalid attribute '%s'.", locName));
            }
            ++i;
        }
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    if (!"urn:oasis:names:tc:xliff:metadata:2.0".equals(this.reader.getNamespaceURI()) || !"metaGroup".equals(this.reader.getLocalName())) {
                        this.error(String.format("Invalid element '%s' in <metadata>.", this.reader.getName().toString()));
                    }
                    this.processMetaGroup(metadata);
                    break;
                }
                case 2: {
                    this.popXMLAttributes();
                    if (metadata.isEmpty()) {
                        this.error("You must have at least one entry a <metadata> element.");
                    }
                    parent.setMetadata(metadata);
                    this.popSpecialIds();
                    return;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processMetaGroup(IWithMetaGroup parent) throws XMLStreamException {
        group = new MetaGroup();
        i = 0;
        while (i < this.reader.getAttributeCount()) {
            locName = this.reader.getAttributeLocalName(i);
            value = this.reader.getAttributeValue(i);
            ns = this.reader.getAttributeNamespace(i);
            if (Util.isNoE(ns)) {
                if (locName.equals("category")) {
                    group.setCategory(value);
                } else if (locName.equals("appliesTo")) {
                    group.setAppliesTo(MetaGroup.AppliesTo.fromString(value));
                } else if (locName.equals("id")) {
                    this.mustBeValidNmtoken("id", value, true);
                    this.checkAndAddSpecialId("urn:oasis:names:tc:xliff:metadata:2.0", value);
                    group.setId(value);
                } else {
                    this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                }
            } else {
                this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
            }
            ++i;
        }
        while (this.reader.hasNext()) {
            block0 : switch (this.reader.next()) {
                case 1: {
                    if (!"urn:oasis:names:tc:xliff:metadata:2.0".equals(this.reader.getNamespaceURI())) ** GOTO lbl66
                    var3_4 = this.reader.getLocalName();
                    tmp = -1;
                    switch (var3_4.hashCode()) {
                        case -1091507334: {
                            if (var3_4.equals("metaGroup")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 3347973: {
                            if (var3_4.equals("meta")) {
                                tmp = 2;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            this.processMetaGroup(group);
                            break block0;
                        }
                        case 2: {
                            type = null;
                            i = 0;
                            while (i < this.reader.getAttributeCount()) {
                                locName = this.reader.getAttributeLocalName(i);
                                if (Util.isNoE(this.reader.getAttributeNamespace(i))) {
                                    if (locName.equals("type")) {
                                        type = this.reader.getAttributeValue(i);
                                    } else {
                                        this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                    }
                                } else {
                                    this.error(String.format("Invalid attribute '%s'.", new Object[]{locName}));
                                }
                                ++i;
                            }
                            if (type == null) {
                                this.error("The <meta> element must have a type attribute.");
                            }
                            group.add(new Meta(type, this.readTextContent(false)));
                            break block0;
                        }
                    }
lbl66:
                    // 2 sources

                    this.error(String.format("Invalid element '%s' in <metaGroup>.", new Object[]{this.reader.getName().toString()}));
                    break;
                }
                case 2: {
                    if (group.isEmpty()) {
                        this.error("You must have at least one entry a <metaGroup> element.");
                    }
                    parent.addGroup(group);
                    return;
                }
            }
        }
    }

    private void processValidation(IWithValidation parent) throws XMLStreamException {
        if (!this.reader.getLocalName().equals("validation")) {
            this.error(String.format("Invalid element '%s'", this.reader.getName().toString()));
        }
        Validation validation = parent.hasValidation() ? parent.getValidation() : this.valContext.peek();
        validation.setExtAttributes(this.gatherExtAttributes(false));
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    if (!"urn:oasis:names:tc:xliff:validation:2.0".equals(this.reader.getNamespaceURI()) || !"rule".equals(this.reader.getLocalName())) {
                        this.error(String.format("Invalid element '%s' in <validation>.", this.reader.getName().toString()));
                    }
                    this.processValidationRule(validation);
                    break;
                }
                case 2: {
                    this.popXMLAttributes();
                    if (validation.isEmpty()) {
                        this.error("You must have at least one entry a <validation> element.");
                    }
                    parent.setValidation(validation);
                    return;
                }
            }
        }
    }

    private void processValidationRule(Validation validation) throws XMLStreamException {
        Rule rule = new Rule("isPresent", null);
        String type = null;
        String occurs = null;
        String existsInSource = null;
        String caseSensitive = null;
        String disabled = null;
        String normalization = null;
        int i = 0;
        while (i < this.reader.getAttributeCount()) {
            block53: {
                block51: {
                    String locName = this.reader.getAttributeLocalName(i);
                    String value = this.reader.getAttributeValue(i);
                    String ns = this.reader.getAttributeNamespace(i);
                    if (!Util.isNoE(ns)) break block51;
                    switch (locName) {
                        case "startsWith": 
                        case "isPresent": 
                        case "isNotPresent": 
                        case "endsWith": {
                            if (type != null) {
                                this.error(String.format("Attribute %s cannot be used is %s is also used.", locName, type));
                            }
                            this.cannotBeEmpty(locName, value);
                            type = locName;
                            rule.setType(Rule.Type.fromString(type));
                            rule.setData(value);
                            break;
                        }
                        case "occurs": {
                            occurs = value;
                            break;
                        }
                        case "caseSensitive": {
                            caseSensitive = value;
                            break;
                        }
                        case "normalization": {
                            normalization = value;
                            break;
                        }
                        case "existsInSource": {
                            existsInSource = value;
                            break;
                        }
                        case "disabled": {
                            disabled = value;
                            break;
                        }
                        default: {
                            this.error(String.format("Invalid attribute '%s'.", locName));
                            break;
                        }
                    }
                    break block53;
                }
                this.addExtAttribute(rule, i, true);
            }
            ++i;
        }
        if (type == null) {
            if (!rule.hasExtAttribute()) {
                this.error("Missing the type of the rule (isPresent, etc.)");
            }
            rule.setType(Rule.Type.CUSTOM);
        }
        if (this.canBeYesOrNo("caseSensitive", caseSensitive)) {
            rule.setCaseSensitive(caseSensitive.equals("yes"));
        }
        if (normalization != null) {
            rule.setNormalization(Rule.Normalization.fromString(normalization));
        }
        if (this.canBeYesOrNo("disabled", disabled)) {
            rule.setEnable(disabled.equals("no"));
        }
        if (existsInSource != null) {
            switch (rule.getType()) {
                case ISPRESENT: 
                case STARTSWITH: 
                case ENDSWITH: {
                    this.canBeYesOrNo("existsInSource", existsInSource);
                    rule.setExistsInSource(existsInSource.equals("yes"));
                    break;
                }
                case ISNOTPRESENT: 
                case CUSTOM: {
                    this.error("The attribute existsInSource is not valid for this type of rule.");
                }
            }
        }
        if (occurs != null) {
            try {
                int number = Integer.parseInt(occurs);
                if (number < 1) {
                    this.error("The value of the attribute 'occurs' must be 1 or higer.");
                }
                rule.setOccurs(number);
            }
            catch (NumberFormatException e) {
                this.error(String.format("Invalid syntax for attribute 'occurs' (%s).", occurs));
            }
        }
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 2: {
                    boolean add = true;
                    int i2 = 0;
                    for (Rule existing : validation) {
                        if (!existing.isInherited() || existing.getType() == Rule.Type.CUSTOM) continue;
                        if (existing.getType() == rule.getType() && existing.getData().equals(rule.getData())) {
                            rule.prepare();
                            validation.set(i2, rule);
                            add = false;
                        }
                        ++i2;
                    }
                    if (add) {
                        rule.prepare();
                        validation.add(rule);
                    }
                    return;
                }
            }
        }
    }

    private String readTextContent(boolean popXMLAttributes) throws XMLStreamException {
        StringBuilder tmp = new StringBuilder();
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 4: 
                case 6: 
                case 12: {
                    tmp.append(this.reader.getText());
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 2: {
                    if (popXMLAttributes) {
                        this.popXMLAttributes();
                    }
                    return tmp.toString();
                }
                default: {
                    this.error(String.format("Invalid element '%s' in text content.", this.reader.getName().toString()));
                }
            }
        }
        return null;
    }

    private class DataElementContent {
        String content;
        Directionality dir;

        DataElementContent(String content, Directionality dir) {
            this.content = content;
            this.dir = dir;
        }
    }
}

