/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Stack;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;

public class XMLWriter {
    private static final String ERRMSG = "XMLWriter output error.";
    private static int defaultCharBufferSize = 16384;
    private BufferedWriter writer;
    private boolean inStartTag;
    private Stack<String> elements = new Stack();
    private String lineBreak = System.getProperty("line.separator");

    public XMLWriter(String path) {
        try {
            Util.createDirectories(path);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(path)), StandardCharsets.UTF_8);
            this.writer = new BufferedWriter(osw, defaultCharBufferSize);
        }
        catch (IOException e) {
            throw new OkapiIOException(ERRMSG, e);
        }
    }

    public XMLWriter(Writer writer) {
        this.writer = new BufferedWriter(writer, defaultCharBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public void setLineBreak(String lineBreak) {
        this.lineBreak = lineBreak;
    }

    public String getLineBreak() {
        return this.lineBreak;
    }

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
            catch (IOException e) {
                throw new OkapiIOException(ERRMSG, e);
            }
        }
        if (this.elements != null) {
            this.elements.clear();
            this.elements = null;
        }
    }

    public void writeStartDocument() {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + this.lineBreak);
    }

    public void writeStartHTMLDocument(String title) {
        this.write("<html>" + this.lineBreak);
        this.write("<head>" + this.lineBreak);
        this.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">" + this.lineBreak);
        if (title != null) {
            this.writeElementString("title", title);
            this.writeLineBreak();
        }
        this.write("</head>" + this.lineBreak);
    }

    public void writeEndDocument() {
        this.closeStartTag();
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new OkapiIOException(ERRMSG, e);
        }
    }

    public void writeStartElement(String name) {
        this.closeStartTag();
        this.elements.push(name);
        this.write("<" + name);
        this.inStartTag = true;
    }

    public void writeEndElement() {
        this.closeStartTag();
        this.write("</" + this.elements.pop() + ">");
    }

    public void writeEndElementLineBreak() {
        this.closeStartTag();
        this.write("</" + this.elements.pop() + ">" + this.lineBreak);
    }

    public void writeElementString(String name, String content) {
        this.closeStartTag();
        this.write("<" + name + ">");
        this.write(Util.escapeToXML(content, 0, false, null));
        this.write("</" + name + ">");
    }

    public void writeAttributeString(String name, String value) {
        this.write(" " + name + "=\"" + Util.escapeToXML(value, 3, false, null) + "\"");
    }

    public void writeString(String text) {
        this.closeStartTag();
        this.write(Util.escapeToXML(text, 0, false, null).replace("\n", this.lineBreak));
    }

    public void writeRawXML(String xmlData) {
        this.closeStartTag();
        this.write(xmlData.replace("\n", this.lineBreak));
    }

    public void appendRawXML(String xmlData) {
        this.write(xmlData.replace("\n", this.lineBreak));
    }

    public void writeComment(String text, boolean withLineBreak) {
        this.closeStartTag();
        this.write("<!--");
        this.write(text.replace("\n", this.lineBreak));
        this.write("-->");
        if (withLineBreak) {
            this.write(this.lineBreak);
        }
    }

    public void writeLineBreak() {
        this.closeStartTag();
        this.write(this.lineBreak);
    }

    private void closeStartTag() {
        if (this.inStartTag) {
            this.write(">");
            this.inStartTag = false;
        }
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new OkapiIOException(ERRMSG, e);
        }
    }

    private void write(String string) {
        try {
            this.writer.write(string);
        }
        catch (IOException e) {
            throw new OkapiIOException(ERRMSG, e);
        }
    }
}

