/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.icml;

import java.util.HashMap;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.filters.icml.NodeReference;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ICMLSkeleton
implements ISkeleton {
    public static final String NODEREMARKER = "SKLREF";
    private Document doc;
    private Node topNode;
    private Node scopeNode;
    private HashMap<String, NodeReference> refs;
    private String[] movedParts;
    private boolean forced = false;

    public ICMLSkeleton(Document doc) {
        this.doc = doc;
    }

    public ICMLSkeleton(Node topNode, Node scopeNode) {
        this.topNode = topNode;
        this.scopeNode = scopeNode;
    }

    public void addReferenceNode(String id, NodeReference ref) {
        if (this.refs == null) {
            this.refs = new HashMap();
        }
        this.refs.put(id, ref);
    }

    public void addMovedParts(String[] movedParts) {
        this.movedParts = movedParts;
    }

    public String[] getMovedParts() {
        return this.movedParts;
    }

    public boolean hasReferences() {
        return this.refs != null && this.refs.size() > 0;
    }

    public HashMap<String, NodeReference> getReferences() {
        return this.refs;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public Document getOriginal() {
        return this.doc;
    }

    public Node getScopeNode() {
        return this.scopeNode;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    public boolean getForced() {
        return this.forced;
    }

    @Override
    public ICMLSkeleton clone() {
        ICMLSkeleton newSkel = new ICMLSkeleton(this.doc);
        newSkel.doc = this.doc;
        newSkel.topNode = this.topNode;
        newSkel.scopeNode = this.scopeNode;
        newSkel.refs = this.refs;
        newSkel.movedParts = this.movedParts;
        return newSkel;
    }

    @Override
    public void setParent(IResource parent) {
    }

    @Override
    public IResource getParent() {
        return null;
    }
}

