/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.Tag;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.PropertyTextUnitPlaceholder;
import net.sf.okapi.common.io.InputStreamFromOutputStream;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.abstractmarkup.AbstractMarkupFilter;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ParagraphSimplifier;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.SharedStringPartHandler;
import net.sf.okapi.filters.openxml.TextRun;
import net.sf.okapi.filters.openxml.WordTextBox;
import net.sf.okapi.filters.openxml.XMLFactories;
import net.sf.okapi.filters.openxml.YamlParameters;
import net.sf.okapi.filters.yaml.TaggedFilterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenXMLContentFilter
extends AbstractMarkupFilter {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final char LINE_SEPARATOR = '\u2028';
    private static final char TAB = '\t';
    private ParseType configurationType;
    private ParseType filetype = ParseType.MSWORD;
    private String sConfigFileName;
    private URL urlConfig;
    private StringBuilder sInsideTextBox = new StringBuilder();
    private StringBuilder sSubML = new StringBuilder();
    private String sSubMLTriggerTagName = "";
    private StringBuilder sInBadChoice = new StringBuilder();
    private StringBuilder sInExclusion = new StringBuilder();
    private boolean bInTextBox = false;
    private boolean bInSubML = false;
    private boolean bInTextRun = false;
    private boolean bInSubTextRun = false;
    private boolean bInDeletion = false;
    private boolean bInInsertion = false;
    private boolean bInBadChoice = false;
    private boolean bBetweenTextMarkers = false;
    private boolean bAfterText = false;
    private TextRun trTextRun = null;
    private TextRun trNonTextRun = null;
    private boolean bIgnoredPreRun = false;
    private boolean bBeforeFirstTextRun = true;
    private boolean bInMainFile = false;
    private boolean bInSettingsFile = false;
    private boolean bExcludeTextInRun = false;
    private boolean bExcludeTextInUnit = false;
    private String sCurrentCharacterStyle = "";
    private String sCurrentParagraphStyle = "";
    private ConditionalParameters filterParams = null;
    private SharedStringPartHandler.SharedStringVisibilityStrategy visibleSharedStrings;
    private TreeSet<String> tsExcludeWordStyles = new TreeSet();
    private int nOriginalSharedStringCount = -1;
    private int nCurrentSharedString = -1;
    private YamlParameters params = null;
    private TaggedFilterConfiguration config = null;
    private EncoderManager internalEncManager;
    private StringBuilder endpara = new StringBuilder();
    private boolean bInPowerpointEndPara;
    private String sEndTxbxContent = "";
    private int nestedAGraphicCounter = 0;
    private String partName;
    private XMLFactories xmlFactories;
    private String pendingTagName;
    private String pendingTagText;
    private boolean bInPowerpointComment = false;

    public OpenXMLContentFilter(XMLFactories xmlFactories, ConditionalParameters filterParams) {
        this.xmlFactories = xmlFactories;
        this.filterParams = filterParams;
        this.setMimeType("text/xml");
        this.setFilterWriter(this.createFilterWriter());
        this.tsExcludeWordStyles = new TreeSet();
        this.internalEncManager = new EncoderManager();
        this.internalEncManager.setMapping("text/xml", "net.sf.okapi.common.encoder.XMLEncoder");
        this.internalEncManager.setMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "net.sf.okapi.common.encoder.OpenXMLEncoder");
        this.internalEncManager.setDefaultOptions(null, "utf-8", "\n");
        this.internalEncManager.updateEncoder("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), this.getMimeType(), this.getClass().getName(), "Microsoft OpenXML Document", "Microsoft OpenXML files (Used inside Office documents)."));
        return list;
    }

    public void displayOneEvent(Event event) {
        if (this.LOGGER.isTraceEnabled()) {
            String etyp = event.getEventType().toString();
            if (event.getEventType() == EventType.TEXT_UNIT || event.getEventType() == EventType.DOCUMENT_PART || event.getEventType() == EventType.START_GROUP || event.getEventType() == EventType.END_GROUP || event.getEventType() == EventType.START_SUBFILTER || event.getEventType() == EventType.END_SUBFILTER) {
                // empty if block
            }
            if (etyp.equals("START")) {
                this.LOGGER.trace("\n");
            }
            this.LOGGER.trace("{}: ", (Object)etyp);
            if (event.getResource() != null) {
                this.LOGGER.trace("({})", (Object)event.getResource().getId());
                if (event.getResource() instanceof DocumentPart) {
                    Set<String> setter = ((DocumentPart)event.getResource()).getSourcePropertyNames();
                    for (String seti : setter) {
                        this.LOGGER.trace(seti);
                    }
                } else {
                    this.LOGGER.trace(event.getResource().toString());
                }
                if (event.getResource().getSkeleton() != null) {
                    this.LOGGER.trace("*Skeleton: \n{}", (Object)event.getResource().getSkeleton().toString());
                }
            }
        }
    }

    public ParseType getParseType() {
        return this.filetype;
    }

    public void setUpConfig(ParseType filetype) {
        this.filetype = filetype;
        switch (filetype) {
            case MSWORDCHART: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/wordChartConfiguration.yml";
                this.configurationType = ParseType.MSWORDCHART;
                break;
            }
            case MSEXCEL: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/excelConfiguration.yml";
                this.configurationType = ParseType.MSEXCEL;
                break;
            }
            case MSPOWERPOINT: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/powerpointConfiguration.yml";
                this.configurationType = ParseType.MSPOWERPOINT;
                break;
            }
            case MSEXCELCOMMENT: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/excelCommentConfiguration.yml";
                this.configurationType = ParseType.MSEXCEL;
                break;
            }
            case MSWORDDOCPROPERTIES: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/wordDocPropertiesConfiguration.yml";
                this.configurationType = ParseType.MSWORDDOCPROPERTIES;
                break;
            }
            case MSPOWERPOINTCOMMENTS: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/powerpointCommentConfiguration.yml";
                this.configurationType = ParseType.MSPOWERPOINT;
                break;
            }
            default: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/wordConfiguration.yml";
                this.configurationType = ParseType.MSWORD;
            }
        }
        this.urlConfig = OpenXMLContentFilter.class.getResource(this.sConfigFileName);
        this.config = new TaggedFilterConfiguration(this.urlConfig);
        try {
            this.setParameters(new YamlParameters(this.urlConfig));
        }
        catch (Exception e) {
            throw new OkapiIOException("Can't read MS Office Filter Configuration File.");
        }
    }

    public InputStream combineRepeatedFormat(final InputStream input) {
        InputStreamFromOutputStream<Void> isos = new InputStreamFromOutputStream<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void produce(OutputStream dataSink) throws Exception {
                XMLEventWriter w = OpenXMLContentFilter.this.xmlFactories.getOutputFactory().createXMLEventWriter(new BufferedWriter(new OutputStreamWriter(dataSink, StandardCharsets.UTF_8)));
                XMLEventReader r = OpenXMLContentFilter.this.xmlFactories.getInputFactory().createXMLEventReader(new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)));
                try {
                    new ParagraphSimplifier(r, w, OpenXMLContentFilter.this.xmlFactories.getEventFactory(), OpenXMLContentFilter.this.filterParams).process();
                }
                finally {
                    r.close();
                    w.close();
                }
                return null;
            }
        };
        return isos;
    }

    @Override
    protected void handleCdataSection(Tag tag) {
        if (this.bInBadChoice) {
            this.sInBadChoice.append(tag.toString());
        } else if (this.bInDeletion) {
            this.addToNonTextRun(tag.toString());
        } else {
            this.addToDocumentPart(tag.toString());
        }
    }

    @Override
    protected void handleText(CharSequence text) {
        if (text == null) {
            return;
        }
        this.startDelayedTextUnit();
        String txt = text.toString();
        this.handleSomeText(txt, this.isWhiteSpace(text));
    }

    private void handleSomeText(String tixt, boolean bWhiteSpace) {
        String txt = tixt;
        if (this.bInBadChoice) {
            this.sInBadChoice.append(this.escapeEntity(tixt));
            return;
        }
        if (this.bInDeletion) {
            this.addToNonTextRun(this.internalEncManager.encode(txt, EncoderContext.TEXT));
            return;
        }
        if (this.getRuleState().isExludedState()) {
            this.sInExclusion.append(tixt);
            return;
        }
        if (this.bInTextBox) {
            if (txt.equals("<")) {
                this.sInsideTextBox.append("&lt;");
            } else {
                this.sInsideTextBox.append(txt);
            }
            return;
        }
        if (this.bInSubML) {
            this.sSubML.append(txt);
            return;
        }
        if (bWhiteSpace && !this.isInsideTextRun()) {
            this.addToDocumentPart(txt);
            return;
        }
        if (this.canStartNewTextUnit()) {
            this.addToDocumentPart(txt);
        } else if (this.bInTextRun) {
            if (this.bBetweenTextMarkers) {
                if (this.filetype == ParseType.MSEXCEL && txt != null && txt.length() > 0 && txt.charAt(0) == '=') {
                    this.addToTextRun(txt);
                } else if (this.bExcludeTextInRun || this.bExcludeTextInUnit) {
                    this.addToTextRun(this.internalEncManager.encode(txt, EncoderContext.TEXT));
                } else {
                    this.addTextRunToCurrentTextUnit(false);
                    this.bAfterText = true;
                    this.addToTextUnit(txt);
                    this.trTextRun = new TextRun();
                    this.bInTextRun = true;
                }
            } else {
                this.addToTextRun(this.internalEncManager.encode(txt, EncoderContext.TEXT));
            }
        } else {
            if (this.bInPowerpointEndPara) {
                this.endpara.append(txt);
                return;
            }
            if (this.bInPowerpointComment) {
                this.addToTextUnit(txt);
            } else {
                this.trTextRun = new TextRun();
                this.bInTextRun = true;
                this.addToTextRun(this.internalEncManager.encode(txt, EncoderContext.TEXT));
            }
        }
    }

    @Override
    protected void handleDocumentPart(Tag tag) {
        if (this.bInBadChoice) {
            this.sInBadChoice.append(tag.toString());
        } else if (this.canStartNewTextUnit()) {
            this.addToDocumentPart(tag.toString());
        } else if (this.bInDeletion) {
            this.addToNonTextRun(tag.toString());
        } else {
            this.addCodeToCurrentTextUnit(tag);
        }
    }

    @Override
    protected void handleStartTag(StartTag startTag) {
        if (startTag == null) {
            return;
        }
        this.startDelayedTextUnit();
        String sTagName = startTag.getName();
        String sTagString = startTag.toString();
        if (sTagName.equalsIgnoreCase("a:graphic")) {
            ++this.nestedAGraphicCounter;
        }
        if (this.bInBadChoice) {
            this.sInBadChoice.append(sTagString);
            return;
        }
        if (this.bInDeletion) {
            this.addToNonTextRun(startTag);
            return;
        }
        String sTagElementType = this.getConfig().getElementType(startTag);
        if (this.bInTextBox) {
            if (sTagName.equals("w:txbxcontent")) {
                this.appendToFirstSkeletonPart(sTagString);
            } else {
                this.sInsideTextBox.append(sTagString);
            }
            return;
        }
        if (this.bInPowerpointEndPara) {
            this.endpara.append(sTagString);
            return;
        }
        if (this.getRuleState().isExludedState()) {
            this.sInExclusion.append(sTagString);
            switch (this.getConfig().getElementRuleTypeCandidate(sTagName)) {
                case EXCLUDED_ELEMENT: {
                    this.getRuleState().pushExcludedRule(sTagName);
                    break;
                }
                case INCLUDED_ELEMENT: {
                    this.getRuleState().pushIncludedRule(sTagName);
                    break;
                }
                case PRESERVE_WHITESPACE: {
                    this.getRuleState().pushPreserverWhitespaceRule(sTagName, true);
                }
            }
            return;
        }
        if (sTagName.equals("mc:choice") && !sTagString.equals("<mc:Choice Requires=\"wps\">")) {
            this.bInBadChoice = true;
            this.sInBadChoice.append(sTagString);
            return;
        }
        if (this.bInSubML) {
            this.sSubML.append(sTagString);
            return;
        }
        if (sTagName.equals("p:text")) {
            this.bInPowerpointComment = true;
        }
        switch (this.getConfig().getElementRuleTypeCandidate(sTagName)) {
            case INLINE_ELEMENT: {
                if (this.canStartNewTextUnit()) {
                    if (sTagElementType.equals("style")) {
                        this.sCurrentCharacterStyle = startTag.getAttributeValue("w:styleId");
                    } else if (sTagElementType.equals("hidden")) {
                        if (!this.sCurrentCharacterStyle.equals("")) {
                            this.excludeStyle(this.sCurrentCharacterStyle);
                        }
                    } else if (sTagElementType.equals("sharedstring")) {
                        ++this.nCurrentSharedString;
                    } else if (sTagElementType.equals("count")) {
                        this.nOriginalSharedStringCount = Integer.valueOf(startTag.getAttributeValue("uniqueCount"));
                    }
                    this.addToDocumentPart(sTagString);
                    break;
                }
                if (sTagElementType.equals("rstyle")) {
                    this.sCurrentCharacterStyle = startTag.getAttributeValue("w:val");
                    if (this.tsExcludeWordStyles.contains(this.sCurrentCharacterStyle)) {
                        this.bExcludeTextInRun = true;
                    }
                } else if (sTagElementType.equals("pstyle")) {
                    this.sCurrentParagraphStyle = startTag.getAttributeValue("w:val");
                    if (this.tsExcludeWordStyles.contains(this.sCurrentParagraphStyle)) {
                        this.bExcludeTextInUnit = true;
                    }
                } else if (sTagElementType.equals("hidden") && !this.filterParams.getTranslateWordHidden()) {
                    if (this.bInTextRun) {
                        this.bExcludeTextInRun = true;
                    } else {
                        this.bExcludeTextInUnit = true;
                    }
                }
                if (this.bInTextRun) {
                    this.addToTextRun(startTag);
                    break;
                }
                if (sTagElementType.equals("delete") && !startTag.isSyntacticalEmptyElementTag()) {
                    this.bInDeletion = true;
                }
                this.addToNonTextRun(startTag);
                break;
            }
            case ATTRIBUTES_ONLY: {
                if (this.filterParams.getTranslateWordExcludeGraphicMetaData() && (sTagName.equals("wp:docpr") || sTagName.equals("pic:cnvpr"))) {
                    if (this.canStartNewTextUnit()) {
                        this.addToDocumentPart(sTagString);
                        break;
                    }
                    if (this.bInTextRun) {
                        this.addToTextRun(startTag);
                        break;
                    }
                    this.addToNonTextRun(startTag);
                    break;
                }
                if (this.canStartNewTextUnit()) {
                    List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders = this.createPropertyTextUnitPlaceholders(startTag);
                    if (propertyTextUnitPlaceholders != null && !propertyTextUnitPlaceholders.isEmpty()) {
                        this.startDocumentPart(sTagString, sTagName, propertyTextUnitPlaceholders);
                        this.endDocumentPart();
                        break;
                    }
                    this.addToDocumentPart(sTagString);
                    break;
                }
                List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders = this.createPropertyTextUnitPlaceholders(startTag);
                if (sTagElementType.equals("a:endpararpr")) {
                    this.endpara.append(sTagString);
                    if (startTag.isSyntacticalEmptyElementTag()) break;
                    this.bInPowerpointEndPara = true;
                    break;
                }
                if (this.bInTextRun) {
                    this.addToTextRun(startTag, propertyTextUnitPlaceholders);
                    break;
                }
                this.addToNonTextRun(startTag, propertyTextUnitPlaceholders);
                break;
            }
            case GROUP_ELEMENT: {
                if (!this.bInSettingsFile) {
                    if (!startTag.isSyntacticalEmptyElementTag()) {
                        String sSkeller;
                        boolean bToxicBox = sTagName.equals("v:textbox") || sTagName.equals("wps:txbx");
                        String string = sSkeller = bToxicBox ? "textbox" : sTagName;
                        if (!this.canStartNewTextUnit()) {
                            this.addTextRunToCurrentTextUnit(true);
                        }
                        if (bToxicBox) {
                            this.bInTextBox = true;
                            this.sInsideTextBox = new StringBuilder();
                        } else {
                            this.bInSubML = true;
                            this.sSubML = new StringBuilder();
                            this.sSubMLTriggerTagName = sTagName;
                        }
                        this.getRuleState().pushGroupRule(sTagName);
                        this.startGroup(new GenericSkeleton(sTagString), sSkeller);
                        break;
                    }
                    if (this.canStartNewTextUnit()) {
                        this.addToDocumentPart(sTagString);
                        break;
                    }
                    if (this.bInTextRun) {
                        this.addToTextRun(sTagString);
                        break;
                    }
                    this.addToNonTextRun(sTagString);
                    break;
                }
                this.addToDocumentPart(sTagString);
                break;
            }
            case EXCLUDED_ELEMENT: {
                this.getRuleState().pushExcludedRule(sTagName);
                this.sInExclusion.append(sTagString);
                break;
            }
            case INCLUDED_ELEMENT: {
                this.getRuleState().pushIncludedRule(sTagName);
                this.addToDocumentPart(sTagString);
                break;
            }
            case TEXT_UNIT_ELEMENT: {
                this.bExcludeTextInUnit = false;
                this.addNonTextRunToCurrentTextUnit();
                this.bBeforeFirstTextRun = true;
                if (startTag.isSyntacticalEmptyElementTag()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                if (sTagElementType.equals("t") && !this.visibleSharedStrings.isVisible(this.nCurrentSharedString)) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                this.pendingTagName = startTag.getName();
                this.pendingTagText = startTag.toString();
                break;
            }
            case TEXT_RUN_ELEMENT: {
                this.bExcludeTextInRun = false;
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                this.addNonTextRunToCurrentTextUnit();
                this.bBeforeFirstTextRun = false;
                if (this.getConfig().getElementType(startTag).equals("insert") && !startTag.isSyntacticalEmptyElementTag()) {
                    this.bInInsertion = true;
                } else if (this.bInTextRun) {
                    this.bInSubTextRun = true;
                } else {
                    this.bInTextRun = true;
                    this.bAfterText = false;
                    this.bIgnoredPreRun = false;
                    this.bBetweenTextMarkers = false;
                }
                this.addToTextRun(startTag);
                break;
            }
            case TEXT_MARKER_ELEMENT: {
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                this.addNonTextRunToCurrentTextUnit();
                if (this.bInTextRun) {
                    this.bBetweenTextMarkers = true;
                    this.addToTextRun(startTag);
                    break;
                }
                this.addToNonTextRun(sTagString);
                break;
            }
            case PRESERVE_WHITESPACE: {
                this.getRuleState().pushPreserverWhitespaceRule(sTagName, true);
                this.addToDocumentPart(sTagString);
                break;
            }
            default: {
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                if (this.bInTextRun) {
                    this.addToTextRun(startTag);
                    break;
                }
                this.addToNonTextRun(startTag);
            }
        }
    }

    private void startDelayedTextUnit() {
        if (this.pendingTagName != null) {
            this.getRuleState().pushTextUnitRule(this.pendingTagName);
            this.startTextUnit(new GenericSkeleton(this.pendingTagText));
            if (this.configurationType == ParseType.MSEXCEL || this.configurationType == ParseType.MSWORDCHART || this.configurationType == ParseType.MSWORDDOCPROPERTIES) {
                this.bInTextRun = true;
                this.bBetweenTextMarkers = true;
            } else {
                this.bInTextRun = false;
                this.bBetweenTextMarkers = false;
            }
            this.pendingTagName = null;
            this.pendingTagText = null;
        }
    }

    @Override
    protected void handleEndTag(EndTag endTag) {
        if (endTag == null) {
            return;
        }
        String sTagName = endTag.getName();
        String sTagElementType = this.getConfig().getElementType(endTag);
        String sTagString = endTag.toString();
        if (sTagName.equals("a:graphic")) {
            --this.nestedAGraphicCounter;
        }
        if (this.bInDeletion) {
            this.addToNonTextRun(endTag);
            if (sTagElementType.equals("delete")) {
                this.bInDeletion = false;
            }
            return;
        }
        if (sTagName.equals("p:text")) {
            this.bInPowerpointComment = false;
        }
        if (this.getRuleState().isExludedState()) {
            this.sInExclusion.append(sTagString);
            switch (this.getConfig().getElementRuleTypeCandidate(sTagName)) {
                case EXCLUDED_ELEMENT: {
                    this.getRuleState().popExcludedIncludedRule();
                    break;
                }
                case INCLUDED_ELEMENT: {
                    this.getRuleState().popExcludedIncludedRule();
                    break;
                }
                case PRESERVE_WHITESPACE: {
                    this.getRuleState().popPreserverWhitespaceRule();
                }
            }
            if (!this.getRuleState().isExludedState()) {
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(this.sInExclusion.toString());
                } else if (this.bInDeletion) {
                    this.addToNonTextRun(this.sInExclusion.toString());
                } else if (this.bInTextRun) {
                    this.addToTextRun(this.sInExclusion.toString());
                } else {
                    this.addToNonTextRun(this.sInExclusion.toString());
                }
                this.sInExclusion = new StringBuilder();
            }
            return;
        }
        if (this.bInTextBox && !sTagName.equals("v:textbox") && !sTagName.equals("wps:txbx")) {
            if (sTagName.equals("w:txbxcontent")) {
                this.sEndTxbxContent = sTagString;
            } else {
                this.sInsideTextBox.append(sTagString);
            }
            return;
        }
        if (this.bInPowerpointEndPara) {
            this.endpara.append(sTagString);
            if (sTagElementType.equals("a:endpararpr")) {
                this.bInPowerpointEndPara = false;
            }
            return;
        }
        if (sTagName.equals("mc:choice")) {
            if (!this.bInBadChoice) {
                this.sInBadChoice = new StringBuilder();
            }
            this.bInBadChoice = false;
            this.sInBadChoice.append(sTagString);
            if (this.canStartNewTextUnit()) {
                this.addToDocumentPart(this.sInBadChoice.toString());
            } else if (this.bInDeletion) {
                this.addToNonTextRun(this.sInBadChoice.toString());
            } else if (this.bInTextRun) {
                this.addToTextRun(this.sInBadChoice.toString());
            } else {
                this.addToNonTextRun(this.sInBadChoice.toString());
            }
            this.sInBadChoice = new StringBuilder();
            return;
        }
        if (this.bInBadChoice) {
            this.sInBadChoice.append(sTagString);
            return;
        }
        if (this.bInSubML && !sTagName.equals(this.sSubMLTriggerTagName)) {
            this.sSubML.append(sTagString);
            return;
        }
        switch (this.getConfig().getElementRuleTypeCandidate(sTagName)) {
            case INLINE_ELEMENT: {
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    if (!sTagElementType.equals("sharedstring") || this.nCurrentSharedString + 1 < this.nOriginalSharedStringCount) break;
                    this.bExcludeTextInUnit = false;
                    this.addNonTextRunToCurrentTextUnit();
                    this.bBeforeFirstTextRun = true;
                    this.bInTextRun = false;
                    this.bBetweenTextMarkers = false;
                    this.nCurrentSharedString = -1;
                    break;
                }
                if (this.bInTextRun) {
                    this.addToTextRun(endTag);
                    break;
                }
                if (sTagElementType.equals("delete")) {
                    if (this.trNonTextRun != null) {
                        this.addNonTextRunToCurrentTextUnit();
                    }
                    this.addToTextUnitCode(TextFragment.TagType.CLOSING, sTagString, "delete");
                    break;
                }
                if (sTagElementType.equals("excell")) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                this.addToNonTextRun(endTag);
                break;
            }
            case GROUP_ELEMENT: {
                if (!this.bInSettingsFile) {
                    if (this.bInSubML && sTagName.equals(this.sSubMLTriggerTagName)) {
                        if (sTagName.equals("a:graphic")) {
                            if (this.nestedAGraphicCounter == 0) {
                                this.endSubML(sTagString);
                                break;
                            }
                            this.sSubML.append(sTagString);
                            return;
                        }
                        this.endSubML(sTagString);
                        break;
                    }
                    if (this.bInTextBox && (sTagName.equals("v:textbox") || sTagName.equals("wps:txbx"))) {
                        this.processSubML(this.sInsideTextBox.toString());
                        this.bInTextBox = false;
                        this.sInsideTextBox = new StringBuilder();
                        this.getRuleState().popGroupRule();
                        this.endGroup(new GenericSkeleton(this.sEndTxbxContent + sTagString));
                        this.sEndTxbxContent = "";
                        break;
                    }
                    if (this.bInTextBox) {
                        this.sInsideTextBox.append(sTagString);
                        break;
                    }
                    if (this.bInSubML) {
                        this.sSubML.append(sTagString);
                        break;
                    }
                    this.addToDocumentPart(sTagString);
                    break;
                }
                this.addToDocumentPart(sTagString);
                break;
            }
            case EXCLUDED_ELEMENT: {
                this.getRuleState().popExcludedIncludedRule();
                this.addToDocumentPart(sTagString);
                break;
            }
            case INCLUDED_ELEMENT: {
                this.getRuleState().popExcludedIncludedRule();
                this.addToDocumentPart(sTagString);
                break;
            }
            case TEXT_UNIT_ELEMENT: {
                if (this.pendingTagName != null) {
                    this.addToDocumentPart(this.pendingTagText);
                    this.addToDocumentPart(sTagString);
                    this.pendingTagName = null;
                    this.pendingTagText = null;
                    break;
                }
                this.bExcludeTextInUnit = false;
                if (this.bInTextRun) {
                    this.addTextRunToCurrentTextUnit(true);
                    this.bInTextRun = false;
                }
                this.addNonTextRunToCurrentTextUnit();
                this.bBetweenTextMarkers = true;
                try {
                    this.getRuleState().popTextUnitRule();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.endTextUnit(new GenericSkeleton(this.endpara + sTagString));
                this.endpara = new StringBuilder();
                break;
            }
            case TEXT_RUN_ELEMENT: {
                this.bExcludeTextInRun = false;
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                this.addToTextRun(endTag);
                if (sTagElementType.equals("insert")) {
                    this.bInInsertion = false;
                    this.addTextRunToCurrentTextUnit(true);
                    this.bInTextRun = false;
                    this.addNonTextRunToCurrentTextUnit();
                    break;
                }
                if (this.bInSubTextRun) {
                    this.bInSubTextRun = false;
                    break;
                }
                if (!this.bInTextRun) break;
                if (!this.bInInsertion) {
                    this.addTextRunToCurrentTextUnit(true);
                    this.addNonTextRunToCurrentTextUnit();
                }
                this.bInTextRun = false;
                break;
            }
            case TEXT_MARKER_ELEMENT: {
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                if (this.bInTextRun) {
                    this.bBetweenTextMarkers = false;
                    this.addToTextRun(endTag);
                    break;
                }
                this.addToNonTextRun(sTagString);
                break;
            }
            case PRESERVE_WHITESPACE: {
                this.getRuleState().popPreserverWhitespaceRule();
                this.addToDocumentPart(sTagString);
                break;
            }
            default: {
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                if (this.bInTextRun) {
                    this.addToTextRun(endTag);
                    break;
                }
                this.addToNonTextRun(endTag);
            }
        }
    }

    private void endSubML(String sTagString) {
        this.processSubML(this.sSubML.toString());
        this.bInSubML = false;
        this.sSubML = new StringBuilder();
        this.sSubMLTriggerTagName = "";
        this.getRuleState().popGroupRule();
        this.endGroup(new GenericSkeleton(sTagString));
    }

    private void processSubML(String sInside) {
        WordTextBox wtb = null;
        ArrayList<Event> textBoxEventList = null;
        if (sInside.length() > 0) {
            wtb = new WordTextBox(this.xmlFactories, this.filterParams);
            OpenXMLContentFilter tboxcf = wtb.getTextBoxOpenXMLContentFilter();
            wtb.open(sInside, this.getSrcLoc());
            tboxcf.setUpConfig(ParseType.MSWORD);
            tboxcf.setTextUnitId(this.getTextUnitId());
            tboxcf.setDocumentPartId(this.getDocumentPartId());
            tboxcf.setGroupIdSequence(this.getGroupIdSequence());
            textBoxEventList = wtb.doEvents();
            for (Event event : textBoxEventList) {
                if (event.getEventType() == EventType.TEXT_UNIT) {
                    ITextUnit txu = event.getTextUnit();
                    Property prop = txu.getProperty("TextBoxLevel");
                    if (prop == null) {
                        txu.setProperty(new Property("TextBoxLevel", "1", false));
                    } else {
                        int nTextBoxLevel = 0;
                        try {
                            nTextBoxLevel = Integer.parseInt(prop.getValue());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        prop.setValue(new Integer(++nTextBoxLevel).toString());
                    }
                }
                this.addFilterEvent(event);
            }
            this.setTextUnitId(tboxcf.getTextUnitId());
            this.setDocumentPartId(tboxcf.getDocumentPartId());
            this.setGroupIdSequence(tboxcf.getGroupIdSequence());
        }
    }

    @Override
    protected void handleComment(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleDocTypeDeclaration(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleMarkupDeclaration(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleProcessingInstruction(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleServerCommon(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleServerCommonEscaped(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleXmlDeclaration(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    public String getName() {
        return "OpenXMLContentFilter";
    }

    @Override
    protected String normalizeAttributeName(String attrName, String attrValue, Tag tag) {
        StartTag st;
        String normalizedName = attrName;
        String tagName = tag.getName();
        if (tagName.equals("w:lang") || tagName.equals("w:themefontlang")) {
            StartTag st2 = (StartTag)tag;
            if (st2.getAttributeValue("w:val") != null) {
                normalizedName = "language";
                return normalizedName;
            }
        } else if (tagName.equals("c:lang")) {
            StartTag st3 = (StartTag)tag;
            if (st3.getAttributeValue("val") != null) {
                normalizedName = "language";
                return normalizedName;
            }
        } else if ((tagName.equals("a:endpararpr") || tagName.equals("a:rpr")) && (st = (StartTag)tag).getAttributeValue("lang") != null) {
            normalizedName = "language";
            return normalizedName;
        }
        return normalizedName;
    }

    private void addToNonTextRun(String s) {
        if (this.trNonTextRun == null) {
            this.trNonTextRun = new TextRun();
        }
        this.trNonTextRun.append(s);
    }

    private void addToNonTextRun(Tag tag) {
        if (this.trNonTextRun == null) {
            this.trNonTextRun = new TextRun();
        }
        this.trNonTextRun.append(tag.toString());
    }

    private void addToNonTextRun(Tag tag, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        if (this.trNonTextRun == null) {
            this.trNonTextRun = new TextRun();
        }
        String txt = this.trNonTextRun.getText();
        int offset = txt.length();
        this.trNonTextRun.appendWithPropertyTextUnitPlaceholders(tag.toString(), offset, propertyTextUnitPlaceholders);
    }

    private void addToTextRun(String s) {
        if (this.trTextRun == null) {
            this.trTextRun = new TextRun();
        }
        this.trTextRun.append(s);
    }

    private void addToTextRun(Tag tag) {
        if (this.trTextRun == null) {
            this.trTextRun = new TextRun();
        }
        this.trTextRun.append(tag.toString());
    }

    private void addToTextRun(Tag tag, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        if (this.trTextRun == null) {
            this.trTextRun = new TextRun();
        }
        String txt = this.trTextRun.getText();
        int offset = txt.length();
        this.trTextRun.appendWithPropertyTextUnitPlaceholders(tag.toString(), offset, propertyTextUnitPlaceholders);
    }

    private void addTextRunToCurrentTextUnit(boolean bEndRun) {
        String text;
        if (this.trTextRun != null && !(text = this.trTextRun.getText()).equals("")) {
            List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders;
            TextFragment.TagType codeType = this.bAfterText ? (text.indexOf("</w:t>") != -1 && (text.indexOf("<w:t>") != -1 || text.indexOf("<w:t ") != -1) || text.indexOf("</a:t>") != -1 && (text.indexOf("<a:t)") != -1 || text.indexOf("<a:t ") != -1) ? TextFragment.TagType.PLACEHOLDER : TextFragment.TagType.CLOSING) : (bEndRun ? TextFragment.TagType.PLACEHOLDER : TextFragment.TagType.OPENING);
            if (codeType == TextFragment.TagType.OPENING && !this.bBeforeFirstTextRun && this.bInMainFile && (text.equals("<w:r><w:t>") || text.equals("<w:r><w:t xml:space=\"preserve\">") || text.equals("<a:r><a:t>") || text.equals("<a:r><a:t xml:space=\"preserve\">"))) {
                this.bIgnoredPreRun = true;
                this.trTextRun = null;
                return;
            }
            if (codeType == TextFragment.TagType.CLOSING && this.bIgnoredPreRun) {
                this.bIgnoredPreRun = false;
                if (text.endsWith("</w:t></w:r>") || text.endsWith("</a:t></a:r>")) {
                    int len = text.length();
                    if (len > 12) {
                        text = text.substring(0, len - 12);
                        codeType = TextFragment.TagType.CLOSING;
                    } else {
                        this.trTextRun = null;
                        return;
                    }
                }
            }
            if ((propertyTextUnitPlaceholders = this.trTextRun.getPropertyTextUnitPlaceholders()) != null && !propertyTextUnitPlaceholders.isEmpty()) {
                this.addToTextUnitCode(codeType, text, "x", propertyTextUnitPlaceholders);
            } else {
                this.addToTextUnitCode(codeType, text, "x");
            }
            this.trTextRun = null;
            this.bBeforeFirstTextRun = false;
        }
    }

    private void addNonTextRunToCurrentTextUnit() {
        if (this.trNonTextRun != null) {
            String text = this.trNonTextRun.getText();
            if (this.canStartNewTextUnit()) {
                this.addToDocumentPart(text);
            }
            List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders = this.trNonTextRun.getPropertyTextUnitPlaceholders();
            if (this.bBeforeFirstTextRun && (propertyTextUnitPlaceholders == null || propertyTextUnitPlaceholders.size() == 0)) {
                this.appendToFirstSkeletonPart(text);
            } else {
                TextFragment.TagType codeType = TextFragment.TagType.PLACEHOLDER;
                if (propertyTextUnitPlaceholders != null && !propertyTextUnitPlaceholders.isEmpty()) {
                    this.addToTextUnitCode(codeType, text, "x", propertyTextUnitPlaceholders);
                } else {
                    this.addToTextUnitCode(codeType, text, "x");
                }
            }
            this.trNonTextRun = null;
        }
    }

    public void excludeStyle(String sTyle) {
        if (sTyle != null && !sTyle.equals("")) {
            this.tsExcludeWordStyles.add(sTyle);
        }
    }

    public ParseType getConfigurationType() {
        return this.configurationType;
    }

    protected void setBInMainFile(boolean bInMainFile) {
        this.bInMainFile = bInMainFile;
    }

    protected boolean getBInMainFile() {
        return this.bInMainFile;
    }

    protected void setBInSettingsFile(boolean bInSettingsFile) {
        this.bInSettingsFile = bInSettingsFile;
    }

    protected boolean getBInSettingsFile() {
        return this.bInSettingsFile;
    }

    public void setTsExcludeWordStyles(TreeSet<String> tsExcludeWordStyles) {
        this.tsExcludeWordStyles = tsExcludeWordStyles;
    }

    public TreeSet<String> getTsExcludeWordStyles() {
        return this.tsExcludeWordStyles;
    }

    public void setExcelVisibleSharedStrings(SharedStringPartHandler.SharedStringVisibilityStrategy visibleSharedStrings) {
        this.visibleSharedStrings = visibleSharedStrings;
    }

    @Override
    protected TaggedFilterConfiguration getConfig() {
        return this.config;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (YamlParameters)params;
    }

    public ConditionalParameters getFilterParameters() {
        return this.filterParams;
    }

    private void addToTextUnitCode(TextFragment.TagType codeType, String data, String type) {
        this.addToTextUnit(new Code(codeType, type, data));
    }

    private void addToTextUnitCode(TextFragment.TagType codeType, String data, String type, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        this.addToTextUnit(new Code(codeType, type, data), propertyTextUnitPlaceholders);
    }

    public void setPartName(String partName) {
        this.partName = partName;
    }

    public String toString() {
        return "OpenXMLContentFilter [" + this.partName + "]";
    }

    private String escapeEntity(String s) {
        switch (s) {
            case "&": {
                return "&amp;";
            }
            case "<": {
                return "&lt;";
            }
            case ">": {
                return "&gt;";
            }
        }
        return s;
    }
}

