/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.table.csv;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.RegexUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.table.base.BaseTableFilter;
import net.sf.okapi.filters.table.csv.CSVSkeletonWriter;
import net.sf.okapi.filters.table.csv.Parameters;
import net.sf.okapi.lib.extra.filters.TextProcessingResult;
import net.sf.okapi.lib.extra.filters.WrapMode;

public class CommaSeparatedValuesFilter
extends BaseTableFilter {
    public static final String FILTER_NAME = "okf_table_csv";
    public static final String FILTER_CONFIG = "okf_table_csv";
    public static final String PROP_QUALIFIED = "qualified";
    private static String MERGE_START_TAG = "\ue10a";
    private static String MERGE_END_TAG = "\ue10b";
    private static String LINE_BREAK_TAG = "\ue10c";
    private static String LINE_WRAP_TAG = "\ue10d";
    private static String ESCAPED_QUALIFIER = "\ue10e";
    private Parameters params;
    private List<String> buffer;
    private boolean merging = false;
    private int level = 0;
    private boolean lineFlushed = false;
    private int qualifierLen;
    private Pattern escapedQualifierPattern;

    public CommaSeparatedValuesFilter() {
        this.setName("okf_table_csv");
        this.addConfiguration(true, "okf_table_csv", "Table (Comma-Separated Values)", "Comma-separated values, optional header with field names.", "okf_table_csv.fprm", ".csv;");
        this.addConfiguration(false, "okf_table_catkeys", "Haiku CatKeys", "Haiku CatKeys resource files", "okf_table_catkeys.fprm");
        this.addConfiguration(false, "okf_table_src-tab-trg", "Table (Tab-Separated Values)", "2-column (source + target), tab separated files.", "okf_table_src-tab-trg.fprm");
        this.setParameters(new Parameters());
    }

    @Override
    protected void component_init() {
        this.merging = false;
        this.level = 0;
        this.lineFlushed = false;
        this.params = this.getParameters(Parameters.class);
        this.qualifierLen = Util.getLength(this.params.textQualifier);
        switch (this.params.escapingMode) {
            case 1: {
                this.escapedQualifierPattern = Pattern.compile(String.format("((%s%s)+)[^%s]|[^%s]((%s%s)+)", this.params.textQualifier, this.params.textQualifier, this.params.textQualifier, this.params.textQualifier, this.params.textQualifier, this.params.textQualifier));
                break;
            }
            case 2: {
                this.escapedQualifierPattern = Pattern.compile(String.format("(\\\\%s)", this.params.textQualifier));
            }
        }
        super.component_init();
        if (this.buffer == null) {
            this.buffer = new ArrayList<String>();
        } else {
            this.buffer.clear();
        }
    }

    @Override
    protected String getFieldDelimiter() {
        return this.params.fieldDelimiter;
    }

    @Override
    protected String getFieldQualifier() {
        return this.params.textQualifier;
    }

    @Override
    protected TextProcessingResult extractCells(List<ITextUnit> cells, TextContainer lineContainer, long lineNum) {
        if (cells == null) {
            return TextProcessingResult.REJECTED;
        }
        if (lineContainer == null) {
            return TextProcessingResult.REJECTED;
        }
        String line = lineContainer.getCodedText();
        String trimmedChunk = "";
        if (Util.isEmpty(this.params.fieldDelimiter)) {
            return super.extractCells(cells, lineContainer, lineNum);
        }
        String[] chunks = Util.isEmpty(line) ? new String[]{""} : ListUtil.stringAsArray(line, this.params.fieldDelimiter);
        for (String chunk : chunks) {
            int numTrailingQ;
            int numLeadingQ;
            trimmedChunk = chunk.trim();
            if (trimmedChunk.indexOf(this.params.textQualifier) < 0 && !this.merging) {
                this.buffer.add(chunk);
                continue;
            }
            if (trimmedChunk.equals(this.params.textQualifier)) {
                if (this.level > 0) {
                    numLeadingQ = 0;
                    numTrailingQ = 1;
                } else {
                    numLeadingQ = 1;
                    numTrailingQ = 0;
                }
            } else {
                trimmedChunk = RegexUtil.replaceAll(trimmedChunk, this.escapedQualifierPattern, 1, ESCAPED_QUALIFIER);
                numLeadingQ = (trimmedChunk = RegexUtil.replaceAll(trimmedChunk, this.escapedQualifierPattern, 3, ESCAPED_QUALIFIER)).startsWith(this.params.textQualifier) ? 1 : 0;
                int n = numTrailingQ = trimmedChunk.endsWith(this.params.textQualifier) ? 1 : 0;
            }
            if (this.level > 0) {
                int saveLevel = this.level;
                this.level += numLeadingQ - numTrailingQ;
                boolean endsQualified = trimmedChunk.endsWith(this.params.textQualifier);
                if (this.level == saveLevel && endsQualified && numTrailingQ == 0) {
                    --this.level;
                }
                this.buffer.add(chunk);
                if (numLeadingQ > numTrailingQ || this.level > 0) continue;
                this.endMerging();
                continue;
            }
            if (numLeadingQ > numTrailingQ) {
                this.startMerging();
            }
            this.level += numLeadingQ - numTrailingQ;
            this.buffer.add(chunk);
        }
        this.buffer.add(LINE_BREAK_TAG);
        this.buffer.add(String.valueOf(lineNum));
        this.processBuffer(false);
        return TextProcessingResult.DELAYED_DECISION;
    }

    @Override
    protected boolean processTU(ITextUnit textUnit) {
        TextFragment src;
        String cell;
        List<String> list;
        if (textUnit == null) {
            return false;
        }
        TextUnitUtil.trimTU(textUnit, true, true);
        if (this.params.removeQualifiers && TextUnitUtil.removeQualifiers(textUnit, this.params.textQualifier)) {
            textUnit.setProperty(new Property(PROP_QUALIFIED, "yes"));
        }
        if ((list = ListUtil.stringAsList(cell = (src = textUnit.getSource().getFirstContent()).getCodedText(), LINE_WRAP_TAG)).size() > 1) {
            src.setCodedText("");
            block4: for (int i = 0; i < list.size(); ++i) {
                String st = list.get(i);
                src.append(st);
                if (i == list.size() - 1) break;
                switch (this.params.wrapMode) {
                    case PLACEHOLDERS: {
                        src.append(new Code(TextFragment.TagType.PLACEHOLDER, "line break", this.getLineBreak()));
                        continue block4;
                    }
                    case SPACES: {
                        src.append(' ');
                        continue block4;
                    }
                    default: {
                        src.append('\n');
                    }
                }
            }
        }
        if (this.params.removeQualifiers) {
            int index;
            String st = src.getCodedText();
            String qq = this.params.escapingMode == 2 ? "\\" + this.params.textQualifier : this.params.textQualifier;
            int qqLen = qq.length();
            int start = 0;
            while ((index = st.indexOf(qq)) != -1) {
                src.changeToCode(start + index, start + index + qqLen, TextFragment.TagType.PLACEHOLDER, "CSV text qualifier");
                st = src.getCodedText().substring(start += index + 2);
            }
        }
        return super.processTU(textUnit);
    }

    @Override
    protected void component_idle(boolean lastChance) {
        super.component_idle(lastChance);
        this.processBuffer(lastChance);
    }

    @Override
    protected void component_done() {
        super.component_done();
    }

    private void startMerging() {
        if (this.merging) {
            return;
        }
        this.buffer.add(MERGE_START_TAG);
        this.merging = true;
        this.level = 0;
    }

    private void endMerging() {
        if (!this.merging) {
            return;
        }
        this.buffer.add(MERGE_END_TAG);
        this.merging = false;
        this.level = 0;
    }

    @Override
    protected boolean isMerging() {
        return this.merging;
    }

    private void processBuffer(boolean forceEnding) {
        if (this.buffer == null) {
            return;
        }
        if (this.buffer.isEmpty()) {
            return;
        }
        int start = -1;
        int end = -1;
        while (true) {
            int index;
            start = this.buffer.indexOf(MERGE_START_TAG);
            end = this.buffer.indexOf(MERGE_END_TAG);
            if (start == -1 || end == -1 || start >= end) break;
            List<String> buf = ListUtil.copyItems(this.buffer, start + 1, end - 1);
            while ((index = buf.indexOf(LINE_BREAK_TAG)) != -1) {
                buf.set(index, LINE_WRAP_TAG);
                if (!Util.checkIndex(index + 1, buf)) continue;
                buf.remove(index + 1);
            }
            while ((index = buf.indexOf(LINE_WRAP_TAG)) != -1 && Util.checkIndex(index - 1, buf) && Util.checkIndex(index + 1, buf)) {
                String mergedChunk = ListUtil.listAsString(buf.subList(index - 1, index + 2), "");
                mergedChunk = this.params.wrapMode == WrapMode.SPACES ? mergedChunk.replace(LINE_WRAP_TAG, " ") : mergedChunk.replace(LINE_WRAP_TAG, "\n");
                buf.subList(index, index + 2).clear();
                buf.set(index - 1, mergedChunk);
            }
            String mergedChunk = ListUtil.listAsString(buf, this.params.fieldDelimiter);
            this.buffer.subList(start + 1, end + 1).clear();
            this.buffer.set(start, mergedChunk);
        }
        int index = this.buffer.indexOf(LINE_BREAK_TAG);
        if (forceEnding) {
            if (start > -1 && index > -1 && index > start) {
                this.buffer.remove(start);
                --index;
            }
        } else if (index >= start && start > -1) {
            return;
        }
        if (!Util.checkIndex(index, this.buffer)) {
            return;
        }
        if (!Util.checkIndex(index + 1, this.buffer)) {
            return;
        }
        long lineNum = new Long(this.buffer.get(index + 1));
        this.buffer.remove(index);
        this.buffer.remove(index);
        if (index == 0) {
            return;
        }
        ArrayList<ITextUnit> buf = new ArrayList<ITextUnit>();
        for (int i = 0; i < index; ++i) {
            buf.add(TextUnitUtil.buildTU(this.buffer.get(i)));
        }
        this.buffer.subList(0, index).clear();
        if (this.lineFlushed && !forceEnding) {
            this.addLineBreak();
        }
        if (forceEnding) {
            this.getQueueSize();
        }
        this.processCells(buf, lineNum);
        this.lineFlushed = true;
        if (this.lineFlushed && forceEnding) {
            GenericSkeleton skel = null;
            if (this.isSendListedMode()) {
                DocumentPart dp = this.getFirstDocumentPart();
                if (dp == null) {
                    return;
                }
                skel = (GenericSkeleton)dp.getSkeleton();
            } else {
                ITextUnit tu = this.getFirstTextUnit();
                if (tu == null) {
                    return;
                }
                skel = (GenericSkeleton)tu.getSkeleton();
            }
            if (skel != null) {
                List<GenericSkeletonPart> parts = skel.getParts();
                parts.add(0, new GenericSkeletonPart(this.getLineBreak()));
            }
        }
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new CSVSkeletonWriter();
    }

    @Override
    protected boolean checkTU(ITextUnit textUnit) {
        return !this.isEmpty(textUnit);
    }

    @Override
    protected boolean isEmpty(ITextUnit textUnit) {
        boolean isQualified;
        if (textUnit == null) {
            return true;
        }
        TextContainer source = textUnit.getSource();
        Property prop = textUnit.getProperty(PROP_QUALIFIED);
        boolean bl = isQualified = prop != null && "yes".equals(prop.getValue());
        if (source.isEmpty() && !isQualified) {
            return true;
        }
        return super.isEmpty(textUnit);
    }
}

