/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffsplitter;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SpinInputPart;

@EditorFor(value=XliffWCSplitterParameters.class)
public class XliffWCSplitterParameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String THRESHOLD = "threshold";

    @Override
    public void reset() {
        super.reset();
        this.setThreshold(5000);
    }

    public int getThreshold() {
        return this.getInteger(THRESHOLD);
    }

    public void setThreshold(int threshold) {
        this.setInteger(THRESHOLD, threshold);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(THRESHOLD, "Maximum word-count per part:", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("XLIFF Word-Count Splitter", true, false);
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get(THRESHOLD));
        sip.setRange(2, 999);
        sip.setVertical(false);
        return desc;
    }
}

