/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.filters.openxml.ClarifiablePartHandler;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.DocumentType;
import net.sf.okapi.filters.openxml.ExcelFormulaPartHandler;
import net.sf.okapi.filters.openxml.ExcelStyles;
import net.sf.okapi.filters.openxml.ExcelWorkbook;
import net.sf.okapi.filters.openxml.ExcelWorksheetPartHandler;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.NonTranslatablePartHandler;
import net.sf.okapi.filters.openxml.OpenXMLContentFilter;
import net.sf.okapi.filters.openxml.OpenXMLPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.SharedStringMap;
import net.sf.okapi.filters.openxml.SharedStringsPartHandler;
import net.sf.okapi.filters.openxml.StandardPartHandler;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

class ExcelDocument
extends DocumentType {
    private final Map<String, String> sharedStrings;
    private SharedStringMap sharedStringMap = new SharedStringMap();
    private List<String> worksheetEntryNames = null;
    private ExcelStyles styles;
    private Relationships workbookRels;
    private Map<String, ExcelWorkbook.Sheet> worksheets = new HashMap<String, ExcelWorkbook.Sheet>();
    private Map<String, Boolean> tableVisibility = new HashMap<String, Boolean>();
    private static final String SHARED_STRING_TABLE_REL = Namespaces.DocumentRelationships.getDerivedURI("/sharedStrings");
    private static final String STYLES_REL = Namespaces.DocumentRelationships.getDerivedURI("/styles");

    ExcelDocument(OpenXMLZipFile zipFile, ConditionalParameters params, Map<String, String> sharedStrings) {
        super(zipFile, params);
        this.sharedStrings = sharedStrings;
    }

    @Override
    boolean isClarifiablePart(String contentType) {
        return "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml".equals(contentType) || "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml".equals(contentType);
    }

    @Override
    boolean isStyledTextPart(String entryName, String type) {
        return "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml".equals(type);
    }

    @Override
    void initialize() throws IOException, XMLStreamException {
        String mainDocumentPart = this.getZipFile().getMainDocumentTarget();
        this.workbookRels = this.getZipFile().getRelationshipsForTarget(mainDocumentPart);
        this.worksheetEntryNames = this.findWorksheets();
        this.styles = this.parseStyles();
    }

    @Override
    OpenXMLPartHandler getHandlerForFile(ZipEntry entry, String contentType) {
        if (!this.isTranslatablePart(entry.getName(), contentType)) {
            if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml")) {
                return new ExcelWorksheetPartHandler(this.getZipFile(), entry, this.sharedStringMap, this.styles, this.tableVisibility, this.findWorksheetNumber(entry.getName()), this.getParams(), this.isSheetHidden(entry.getName()));
            }
            if (this.isClarifiablePart(contentType)) {
                return new ClarifiablePartHandler(this.getZipFile(), entry);
            }
            return new NonTranslatablePartHandler(this.getZipFile(), entry);
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml")) {
            return new SharedStringsPartHandler(this.getParams(), this.getZipFile(), entry, StyleDefinitions.emptyStyleDefinitions(), this.sharedStringMap);
        }
        ParseType parseType = null;
        if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml")) {
            parseType = ParseType.MSEXCELCOMMENT;
        } else if ("application/vnd.openxmlformats-package.core-properties+xml".equals(contentType)) {
            parseType = ParseType.MSWORDDOCPROPERTIES;
        } else if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml".equals(contentType)) {
            parseType = ParseType.MSEXCEL;
        }
        if (ParseType.MSWORDDOCPROPERTIES.equals((Object)parseType) || ParseType.MSEXCELCOMMENT.equals((Object)parseType) || parseType == ParseType.MSEXCEL) {
            OpenXMLContentFilter openXMLContentFilter = new OpenXMLContentFilter(this.getParams());
            openXMLContentFilter.setUpConfig(parseType);
            openXMLContentFilter.setPartName(entry.getName());
            return new StandardPartHandler(openXMLContentFilter, this.getParams(), this.getZipFile(), entry);
        }
        return new ExcelFormulaPartHandler(this.getParams(), this.getZipFile(), entry, this.sharedStrings);
    }

    private boolean isSheetHidden(String entryName) {
        ExcelWorkbook.Sheet sheet = this.worksheets.get(entryName);
        return sheet != null && !sheet.visible;
    }

    private boolean isTranslatablePart(String entryName, String contentType) {
        if ("application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml".equals(contentType)) {
            Boolean b = this.tableVisibility.get(entryName);
            return b != null ? b : false;
        }
        return entryName.endsWith(".xml") && ("application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml".equals(contentType) || this.getParams().getTranslateExcelSheetNames() && "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml".equals(contentType) || this.getParams().getTranslateDocProperties() && "application/vnd.openxmlformats-package.core-properties+xml".equals(contentType) || this.getParams().getTranslateComments() && "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml".equals(contentType));
    }

    @Override
    Enumeration<? extends ZipEntry> getZipFileEntries() throws IOException, XMLStreamException {
        Enumeration<? extends ZipEntry> entries = this.getZipFile().entries();
        ArrayList<? extends ZipEntry> entryList = Collections.list(entries);
        ArrayList<String> worksheetsAndSharedStrings = new ArrayList<String>();
        worksheetsAndSharedStrings.addAll(this.worksheetEntryNames);
        worksheetsAndSharedStrings.add(this.findSharedStrings());
        Collections.sort(entryList, new ZipEntryComparator(worksheetsAndSharedStrings));
        return Collections.enumeration(entryList);
    }

    ExcelWorkbook parseWorkbook(String partName) throws IOException, XMLStreamException {
        XMLEventReader r = this.getZipFile().getInputFactory().createXMLEventReader(this.getZipFile().getPartReader(partName));
        return ExcelWorkbook.parseFrom(r, this.getParams());
    }

    ExcelStyles parseStyles() throws IOException, XMLStreamException {
        Relationships.Rel stylesRel = this.workbookRels.getRelByType(STYLES_REL).get(0);
        ExcelStyles styles = new ExcelStyles();
        styles.parse(this.getZipFile().getInputFactory().createXMLEventReader(this.getZipFile().getPartReader(stylesRel.target)));
        return styles;
    }

    List<String> findWorksheets() throws IOException, XMLStreamException {
        ArrayList<String> worksheetNames = new ArrayList<String>();
        ExcelWorkbook workbook = this.parseWorkbook(this.getZipFile().getMainDocumentTarget());
        List<ExcelWorkbook.Sheet> sheets = workbook.getSheets();
        for (ExcelWorkbook.Sheet sheet : sheets) {
            Relationships.Rel sheetRel = this.workbookRels.getRelById(sheet.relId);
            worksheetNames.add(sheetRel.target);
            this.worksheets.put(sheetRel.target, sheet);
        }
        return worksheetNames;
    }

    String findSharedStrings() throws IOException, XMLStreamException {
        String mainDocumentPart = this.getZipFile().getMainDocumentTarget();
        Relationships rels = this.getZipFile().getRelationshipsForTarget(mainDocumentPart);
        List<Relationships.Rel> r = rels.getRelByType(SHARED_STRING_TABLE_REL);
        if (r == null || r.size() != 1) {
            throw new OkapiBadFilterInputException("Unexpected number of relationships");
        }
        return r.get((int)0).target;
    }

    private int findWorksheetNumber(String worksheetEntryName) {
        for (int i = 0; i < this.worksheetEntryNames.size(); ++i) {
            if (!worksheetEntryName.equals(this.worksheetEntryNames.get(i))) continue;
            return i + 1;
        }
        throw new IllegalStateException("No worksheet entry with name " + worksheetEntryName + " in " + this.worksheetEntryNames);
    }
}

