/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.Tag;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.PropertyTextUnitPlaceholder;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.abstractmarkup.AbstractMarkupFilter;
import net.sf.okapi.filters.abstractmarkup.config.TaggedFilterConfiguration;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.TextRun;
import net.sf.okapi.filters.openxml.YamlParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenXMLContentFilter
extends AbstractMarkupFilter {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private ParseType configurationType;
    private ParseType filetype = ParseType.MSWORD;
    private String sConfigFileName;
    private URL urlConfig;
    private StringBuilder sInExclusion = new StringBuilder();
    private boolean bInTextRun = false;
    private boolean bInSubTextRun = false;
    private boolean bBetweenTextMarkers = false;
    private boolean bAfterText = false;
    private TextRun trTextRun = null;
    private TextRun trNonTextRun = null;
    private boolean bIgnoredPreRun = false;
    private boolean bBeforeFirstTextRun = true;
    private boolean bInMainFile = false;
    private boolean bInSettingsFile = false;
    private boolean bExcludeTextInRun = false;
    private boolean bExcludeTextInUnit = false;
    private String sCurrentCharacterStyle = "";
    private String sCurrentParagraphStyle = "";
    private ConditionalParameters filterParams = null;
    private TreeSet<String> tsExcludeWordStyles = new TreeSet();
    private int nOriginalSharedStringCount = -1;
    private int nCurrentSharedString = -1;
    private YamlParameters params = null;
    private TaggedFilterConfiguration config = null;
    private EncoderManager internalEncManager;
    private StringBuilder endpara = new StringBuilder();
    private String partName;
    private String pendingTagName;
    private String pendingTagText;
    private boolean bInPowerpointComment = false;
    private boolean bInHiddenSharedString = false;

    public OpenXMLContentFilter(ConditionalParameters filterParams) {
        this.filterParams = filterParams;
        this.setMimeType("text/xml");
        this.setFilterWriter(this.createFilterWriter());
        this.tsExcludeWordStyles = new TreeSet();
        this.internalEncManager = new EncoderManager();
        this.internalEncManager.setMapping("text/xml", "net.sf.okapi.common.encoder.XMLEncoder");
        this.internalEncManager.setMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "net.sf.okapi.common.encoder.OpenXMLEncoder");
        this.internalEncManager.setDefaultOptions(null, "utf-8", "\n");
        this.internalEncManager.updateEncoder("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), this.getMimeType(), this.getClass().getName(), "Microsoft OpenXML Document", "Microsoft OpenXML files (Used inside Office documents)."));
        return list;
    }

    public void displayOneEvent(Event event) {
        if (this.LOGGER.isTraceEnabled()) {
            String etyp = event.getEventType().toString();
            if (event.getEventType() == EventType.TEXT_UNIT || event.getEventType() == EventType.DOCUMENT_PART || event.getEventType() == EventType.START_GROUP || event.getEventType() == EventType.END_GROUP || event.getEventType() == EventType.START_SUBFILTER || event.getEventType() == EventType.END_SUBFILTER) {
                // empty if block
            }
            if (etyp.equals("START")) {
                this.LOGGER.trace("\n");
            }
            this.LOGGER.trace("{}: ", (Object)etyp);
            if (event.getResource() != null) {
                this.LOGGER.trace("({})", (Object)event.getResource().getId());
                if (event.getResource() instanceof DocumentPart) {
                    Set<String> setter = ((DocumentPart)event.getResource()).getSourcePropertyNames();
                    for (String seti : setter) {
                        this.LOGGER.trace(seti);
                    }
                } else {
                    this.LOGGER.trace(event.getResource().toString());
                }
                if (event.getResource().getSkeleton() != null) {
                    this.LOGGER.trace("*Skeleton: \n{}", (Object)event.getResource().getSkeleton().toString());
                }
            }
        }
    }

    public ParseType getParseType() {
        return this.filetype;
    }

    public void setUpConfig(ParseType filetype) {
        this.filetype = filetype;
        switch (filetype) {
            case MSWORDCHART: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/wordChartConfiguration.yml";
                this.configurationType = ParseType.MSWORDCHART;
                break;
            }
            case MSEXCEL: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/excelConfiguration.yml";
                this.configurationType = ParseType.MSEXCEL;
                break;
            }
            case MSPOWERPOINT: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/powerpointConfiguration.yml";
                this.configurationType = ParseType.MSPOWERPOINT;
                break;
            }
            case MSEXCELCOMMENT: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/excelCommentConfiguration.yml";
                this.configurationType = ParseType.MSEXCEL;
                break;
            }
            case MSWORDDOCPROPERTIES: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/wordDocPropertiesConfiguration.yml";
                this.configurationType = ParseType.MSWORDDOCPROPERTIES;
                break;
            }
            case MSPOWERPOINTCOMMENTS: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/powerpointCommentConfiguration.yml";
                this.configurationType = ParseType.MSPOWERPOINT;
                break;
            }
            default: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/wordConfiguration.yml";
                this.configurationType = ParseType.MSWORD;
            }
        }
        this.urlConfig = OpenXMLContentFilter.class.getResource(this.sConfigFileName);
        this.config = new TaggedFilterConfiguration(this.urlConfig);
        try {
            this.setParameters(new YamlParameters(this.urlConfig));
        }
        catch (Exception e) {
            throw new OkapiIOException("Can't read MS Office Filter Configuration File.");
        }
    }

    @Override
    protected void handleCdataSection(Tag tag) {
        this.addToDocumentPart(tag.toString());
    }

    @Override
    protected void handleText(CharSequence text) {
        if (text == null) {
            return;
        }
        this.startDelayedTextUnit();
        String txt = text.toString();
        this.handleSomeText(txt, this.isWhiteSpace(text));
    }

    private void handleSomeText(String tixt, boolean bWhiteSpace) {
        String txt = tixt;
        if (this.getRuleState().isExludedState()) {
            this.sInExclusion.append(tixt);
            return;
        }
        if (bWhiteSpace && !this.isInsideTextRun()) {
            this.addToDocumentPart(txt);
            return;
        }
        if (this.canStartNewTextUnit()) {
            if (this.bInHiddenSharedString) {
                txt = this.internalEncManager.encode(txt, EncoderContext.TEXT);
            }
            this.addToDocumentPart(txt);
        } else if (this.bInTextRun) {
            if (this.bBetweenTextMarkers) {
                if (this.filetype == ParseType.MSEXCEL && txt != null && txt.length() > 0 && txt.charAt(0) == '=') {
                    this.addToTextRun(txt);
                } else if (this.bExcludeTextInRun || this.bExcludeTextInUnit) {
                    this.addToTextRun(this.internalEncManager.encode(txt, EncoderContext.TEXT));
                } else {
                    this.addTextRunToCurrentTextUnit(false);
                    this.bAfterText = true;
                    this.addToTextUnit(txt);
                    this.trTextRun = new TextRun();
                    this.bInTextRun = true;
                }
            } else {
                this.addToTextRun(this.internalEncManager.encode(txt, EncoderContext.TEXT));
            }
        } else if (this.bInPowerpointComment) {
            this.addToTextUnit(txt);
        } else {
            this.trTextRun = new TextRun();
            this.bInTextRun = true;
            this.addToTextRun(this.internalEncManager.encode(txt, EncoderContext.TEXT));
        }
    }

    @Override
    protected void handleDocumentPart(Tag tag) {
        if (this.canStartNewTextUnit()) {
            this.addToDocumentPart(tag.toString());
        } else {
            this.addCodeToCurrentTextUnit(tag);
        }
    }

    @Override
    protected void handleStartTag(StartTag startTag) {
        if (startTag == null) {
            return;
        }
        this.startDelayedTextUnit();
        String sTagName = startTag.getName();
        String sTagString = startTag.toString();
        String sTagElementType = this.getConfig().getElementType(startTag);
        if (this.getRuleState().isExludedState()) {
            this.sInExclusion.append(sTagString);
            switch (this.getConfig().getElementRuleTypeCandidate(sTagName)) {
                case EXCLUDED_ELEMENT: {
                    this.getRuleState().pushExcludedRule(sTagName);
                    break;
                }
                case INCLUDED_ELEMENT: {
                    this.getRuleState().pushIncludedRule(sTagName);
                    break;
                }
                case PRESERVE_WHITESPACE: {
                    this.getRuleState().pushPreserverWhitespaceRule(sTagName, true);
                }
            }
            return;
        }
        if (sTagName.equals("p:text")) {
            this.bInPowerpointComment = true;
        }
        switch (this.getConfig().getElementRuleTypeCandidate(sTagName)) {
            case INLINE_ELEMENT: {
                if (this.getParseType().equals((Object)ParseType.MSEXCEL)) {
                    if (this.canStartNewTextUnit()) {
                        if (sTagElementType.equals("style")) {
                            this.sCurrentCharacterStyle = startTag.getAttributeValue("w:styleId");
                        } else if (sTagElementType.equals("hidden")) {
                            if (!this.sCurrentCharacterStyle.equals("")) {
                                this.excludeStyle(this.sCurrentCharacterStyle);
                            }
                        } else if (sTagElementType.equals("sharedstring")) {
                            ++this.nCurrentSharedString;
                        } else if (sTagElementType.equals("count")) {
                            this.nOriginalSharedStringCount = Integer.valueOf(startTag.getAttributeValue("uniqueCount"));
                        }
                        this.addToDocumentPart(sTagString);
                        break;
                    }
                    if (sTagElementType.equals("rstyle")) {
                        this.sCurrentCharacterStyle = startTag.getAttributeValue("w:val");
                        if (this.tsExcludeWordStyles.contains(this.sCurrentCharacterStyle)) {
                            this.bExcludeTextInRun = true;
                        }
                    } else if (sTagElementType.equals("pstyle")) {
                        this.sCurrentParagraphStyle = startTag.getAttributeValue("w:val");
                        if (this.tsExcludeWordStyles.contains(this.sCurrentParagraphStyle)) {
                            this.bExcludeTextInUnit = true;
                        }
                    } else if (sTagElementType.equals("hidden") && !this.filterParams.getTranslateWordHidden()) {
                        if (this.bInTextRun) {
                            this.bExcludeTextInRun = true;
                        } else {
                            this.bExcludeTextInUnit = true;
                        }
                    }
                    if (this.bInTextRun) {
                        this.addToTextRun(startTag);
                        break;
                    }
                    this.addToNonTextRun(startTag);
                    break;
                }
                if (!this.getParseType().equals((Object)ParseType.MSWORD)) break;
                if (this.canStartNewTextUnit()) {
                    if (sTagElementType.equals("sharedstring")) {
                        ++this.nCurrentSharedString;
                    } else if (sTagElementType.equals("count")) {
                        this.nOriginalSharedStringCount = Integer.valueOf(startTag.getAttributeValue("uniqueCount"));
                    }
                    this.addToDocumentPart(sTagString);
                    break;
                }
                if (this.bInTextRun) {
                    this.addToTextRun(startTag);
                    break;
                }
                this.addToNonTextRun(startTag);
                break;
            }
            case ATTRIBUTES_ONLY: {
                if (this.filterParams.getTranslateWordExcludeGraphicMetaData() && (sTagName.equals("wp:docpr") || sTagName.equals("pic:cnvpr"))) {
                    if (this.canStartNewTextUnit()) {
                        this.addToDocumentPart(sTagString);
                        break;
                    }
                    if (this.bInTextRun) {
                        this.addToTextRun(startTag);
                        break;
                    }
                    this.addToNonTextRun(startTag);
                    break;
                }
                if (this.canStartNewTextUnit()) {
                    List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders = this.createPropertyTextUnitPlaceholders(startTag);
                    if (propertyTextUnitPlaceholders != null && !propertyTextUnitPlaceholders.isEmpty()) {
                        this.startDocumentPart(sTagString, sTagName, propertyTextUnitPlaceholders);
                        this.endDocumentPart();
                        break;
                    }
                    this.addToDocumentPart(sTagString);
                    break;
                }
                List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders = this.createPropertyTextUnitPlaceholders(startTag);
                if (this.bInTextRun) {
                    this.addToTextRun(startTag, propertyTextUnitPlaceholders);
                    break;
                }
                this.addToNonTextRun(startTag, propertyTextUnitPlaceholders);
                break;
            }
            case GROUP_ELEMENT: {
                if (!this.bInSettingsFile) break;
                this.addToDocumentPart(sTagString);
                break;
            }
            case EXCLUDED_ELEMENT: {
                this.getRuleState().pushExcludedRule(sTagName);
                this.sInExclusion.append(sTagString);
                break;
            }
            case INCLUDED_ELEMENT: {
                this.getRuleState().pushIncludedRule(sTagName);
                this.addToDocumentPart(sTagString);
                break;
            }
            case TEXT_UNIT_ELEMENT: {
                this.bExcludeTextInUnit = false;
                this.addNonTextRunToCurrentTextUnit();
                this.bBeforeFirstTextRun = true;
                if (startTag.isSyntacticalEmptyElementTag()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                this.pendingTagName = startTag.getName();
                this.pendingTagText = startTag.toString();
                break;
            }
            case TEXT_RUN_ELEMENT: {
                this.bExcludeTextInRun = false;
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                this.addNonTextRunToCurrentTextUnit();
                this.bBeforeFirstTextRun = false;
                if (this.bInTextRun) {
                    this.bInSubTextRun = true;
                } else {
                    this.bInTextRun = true;
                    this.bAfterText = false;
                    this.bIgnoredPreRun = false;
                    this.bBetweenTextMarkers = false;
                }
                this.addToTextRun(startTag);
                break;
            }
            case TEXT_MARKER_ELEMENT: {
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                this.addNonTextRunToCurrentTextUnit();
                if (this.bInTextRun) {
                    this.bBetweenTextMarkers = true;
                    this.addToTextRun(startTag);
                    break;
                }
                this.addToNonTextRun(sTagString);
                break;
            }
            case PRESERVE_WHITESPACE: {
                this.getRuleState().pushPreserverWhitespaceRule(sTagName, true);
                this.addToDocumentPart(sTagString);
                break;
            }
            default: {
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                if (this.bInTextRun) {
                    this.addToTextRun(startTag);
                    break;
                }
                this.addToNonTextRun(startTag);
            }
        }
    }

    private void startDelayedTextUnit() {
        if (this.pendingTagName != null) {
            this.getRuleState().pushTextUnitRule(this.pendingTagName);
            this.startTextUnit(new GenericSkeleton(this.pendingTagText));
            if (this.configurationType == ParseType.MSEXCEL || this.configurationType == ParseType.MSWORDCHART || this.configurationType == ParseType.MSWORDDOCPROPERTIES) {
                this.bInTextRun = true;
                this.bBetweenTextMarkers = true;
            } else {
                this.bInTextRun = false;
                this.bBetweenTextMarkers = false;
            }
            this.pendingTagName = null;
            this.pendingTagText = null;
        }
    }

    @Override
    protected void handleEndTag(EndTag endTag) {
        if (endTag == null) {
            return;
        }
        String sTagName = endTag.getName();
        String sTagElementType = this.getConfig().getElementType(endTag);
        String sTagString = endTag.toString();
        if (this.getRuleState().isExludedState()) {
            this.sInExclusion.append(sTagString);
            switch (this.getConfig().getElementRuleTypeCandidate(sTagName)) {
                case EXCLUDED_ELEMENT: {
                    this.getRuleState().popExcludedIncludedRule();
                    break;
                }
                case INCLUDED_ELEMENT: {
                    this.getRuleState().popExcludedIncludedRule();
                    break;
                }
                case PRESERVE_WHITESPACE: {
                    this.getRuleState().popPreserverWhitespaceRule();
                }
            }
            if (sTagName.equals("p:text")) {
                this.bInPowerpointComment = false;
            }
            if (!this.getRuleState().isExludedState()) {
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(this.sInExclusion.toString());
                } else if (this.bInTextRun) {
                    this.addToTextRun(this.sInExclusion.toString());
                } else {
                    this.addToNonTextRun(this.sInExclusion.toString());
                }
                this.sInExclusion = new StringBuilder();
            }
            return;
        }
        switch (this.getConfig().getElementRuleTypeCandidate(sTagName)) {
            case INLINE_ELEMENT: {
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    if (!sTagElementType.equals("sharedstring") || this.nCurrentSharedString + 1 < this.nOriginalSharedStringCount) break;
                    this.bExcludeTextInUnit = false;
                    this.addNonTextRunToCurrentTextUnit();
                    this.bBeforeFirstTextRun = true;
                    this.bInTextRun = false;
                    this.bBetweenTextMarkers = false;
                    this.nCurrentSharedString = -1;
                    break;
                }
                if (this.bInTextRun) {
                    this.addToTextRun(endTag);
                    break;
                }
                if (sTagElementType.equals("delete")) {
                    if (this.trNonTextRun != null) {
                        this.addNonTextRunToCurrentTextUnit();
                    }
                    this.addToTextUnitCode(TextFragment.TagType.CLOSING, sTagString, "delete");
                    break;
                }
                if (sTagElementType.equals("excell")) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                this.addToNonTextRun(endTag);
                break;
            }
            case GROUP_ELEMENT: {
                if (!this.bInSettingsFile) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                this.addToDocumentPart(sTagString);
                break;
            }
            case EXCLUDED_ELEMENT: {
                this.getRuleState().popExcludedIncludedRule();
                this.addToDocumentPart(sTagString);
                break;
            }
            case INCLUDED_ELEMENT: {
                this.getRuleState().popExcludedIncludedRule();
                this.addToDocumentPart(sTagString);
                break;
            }
            case TEXT_UNIT_ELEMENT: {
                if (this.pendingTagName != null) {
                    this.addToDocumentPart(this.pendingTagText);
                    this.addToDocumentPart(sTagString);
                    this.pendingTagName = null;
                    this.pendingTagText = null;
                } else {
                    this.bExcludeTextInUnit = false;
                    if (this.bInTextRun) {
                        this.addTextRunToCurrentTextUnit(true);
                        this.bInTextRun = false;
                    }
                    this.addNonTextRunToCurrentTextUnit();
                    this.bBetweenTextMarkers = true;
                    try {
                        this.getRuleState().popTextUnitRule();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.endTextUnit(new GenericSkeleton(this.endpara + sTagString));
                    this.endpara = new StringBuilder();
                }
                this.bInHiddenSharedString = false;
                break;
            }
            case TEXT_RUN_ELEMENT: {
                this.bExcludeTextInRun = false;
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                this.addToTextRun(endTag);
                if (this.bInSubTextRun) {
                    this.bInSubTextRun = false;
                    break;
                }
                if (!this.bInTextRun) break;
                this.bInTextRun = false;
                break;
            }
            case TEXT_MARKER_ELEMENT: {
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                if (this.bInTextRun) {
                    this.bBetweenTextMarkers = false;
                    this.addToTextRun(endTag);
                    break;
                }
                this.addToNonTextRun(sTagString);
                break;
            }
            case PRESERVE_WHITESPACE: {
                this.getRuleState().popPreserverWhitespaceRule();
                this.addToDocumentPart(sTagString);
                break;
            }
            default: {
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                if (this.bInTextRun) {
                    this.addToTextRun(endTag);
                    break;
                }
                this.addToNonTextRun(endTag);
            }
        }
    }

    @Override
    protected void handleComment(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleDocTypeDeclaration(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleMarkupDeclaration(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleProcessingInstruction(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleServerCommon(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleServerCommonEscaped(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleXmlDeclaration(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    public String getName() {
        return "OpenXMLContentFilter";
    }

    @Override
    protected String normalizeAttributeName(String attrName, String attrValue, Tag tag) {
        StartTag st;
        String normalizedName = attrName;
        String tagName = tag.getName();
        if (tagName.equals("w:lang") || tagName.equals("w:themefontlang")) {
            StartTag st2 = (StartTag)tag;
            if (st2.getAttributeValue("w:val") != null) {
                normalizedName = "language";
                return normalizedName;
            }
        } else if (tagName.equals("c:lang")) {
            StartTag st3 = (StartTag)tag;
            if (st3.getAttributeValue("val") != null) {
                normalizedName = "language";
                return normalizedName;
            }
        } else if ((tagName.equals("a:endpararpr") || tagName.equals("a:rpr")) && (st = (StartTag)tag).getAttributeValue("lang") != null) {
            normalizedName = "language";
            return normalizedName;
        }
        return normalizedName;
    }

    private void addToNonTextRun(String s) {
        if (this.trNonTextRun == null) {
            this.trNonTextRun = new TextRun();
        }
        this.trNonTextRun.append(s);
    }

    private void addToNonTextRun(Tag tag) {
        if (this.trNonTextRun == null) {
            this.trNonTextRun = new TextRun();
        }
        this.trNonTextRun.append(tag.toString());
    }

    private void addToNonTextRun(Tag tag, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        if (this.trNonTextRun == null) {
            this.trNonTextRun = new TextRun();
        }
        String txt = this.trNonTextRun.getText();
        int offset = txt.length();
        this.trNonTextRun.appendWithPropertyTextUnitPlaceholders(tag.toString(), offset, propertyTextUnitPlaceholders);
    }

    private void addToTextRun(String s) {
        if (this.trTextRun == null) {
            this.trTextRun = new TextRun();
        }
        this.trTextRun.append(s);
    }

    private void addToTextRun(Tag tag) {
        if (this.trTextRun == null) {
            this.trTextRun = new TextRun();
        }
        this.trTextRun.append(tag.toString());
    }

    private void addToTextRun(Tag tag, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        if (this.trTextRun == null) {
            this.trTextRun = new TextRun();
        }
        String txt = this.trTextRun.getText();
        int offset = txt.length();
        this.trTextRun.appendWithPropertyTextUnitPlaceholders(tag.toString(), offset, propertyTextUnitPlaceholders);
    }

    private void addTextRunToCurrentTextUnit(boolean bEndRun) {
        String text;
        if (this.trTextRun != null && !(text = this.trTextRun.getText()).equals("")) {
            List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders;
            TextFragment.TagType codeType = this.bAfterText ? (text.indexOf("</w:t>") != -1 && (text.indexOf("<w:t>") != -1 || text.indexOf("<w:t ") != -1) || text.indexOf("</a:t>") != -1 && (text.indexOf("<a:t)") != -1 || text.indexOf("<a:t ") != -1) ? TextFragment.TagType.PLACEHOLDER : TextFragment.TagType.CLOSING) : (bEndRun ? TextFragment.TagType.PLACEHOLDER : TextFragment.TagType.OPENING);
            if (codeType == TextFragment.TagType.OPENING && !this.bBeforeFirstTextRun && this.bInMainFile && (text.equals("<w:r><w:t>") || text.equals("<w:r><w:t xml:space=\"preserve\">") || text.equals("<a:r><a:t>") || text.equals("<a:r><a:t xml:space=\"preserve\">"))) {
                this.bIgnoredPreRun = true;
                this.trTextRun = null;
                return;
            }
            if (codeType == TextFragment.TagType.CLOSING && this.bIgnoredPreRun) {
                this.bIgnoredPreRun = false;
                if (text.endsWith("</w:t></w:r>") || text.endsWith("</a:t></a:r>")) {
                    int len = text.length();
                    if (len > 12) {
                        text = text.substring(0, len - 12);
                        codeType = TextFragment.TagType.CLOSING;
                    } else {
                        this.trTextRun = null;
                        return;
                    }
                }
            }
            if ((propertyTextUnitPlaceholders = this.trTextRun.getPropertyTextUnitPlaceholders()) != null && !propertyTextUnitPlaceholders.isEmpty()) {
                this.addToTextUnitCode(codeType, text, "x", propertyTextUnitPlaceholders);
            } else {
                this.addToTextUnitCode(codeType, text, "x");
            }
            this.trTextRun = null;
            this.bBeforeFirstTextRun = false;
        }
    }

    private void addNonTextRunToCurrentTextUnit() {
        if (this.trNonTextRun != null) {
            String text = this.trNonTextRun.getText();
            if (this.canStartNewTextUnit()) {
                this.addToDocumentPart(text);
            }
            List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders = this.trNonTextRun.getPropertyTextUnitPlaceholders();
            if (this.bBeforeFirstTextRun && (propertyTextUnitPlaceholders == null || propertyTextUnitPlaceholders.size() == 0)) {
                this.appendToFirstSkeletonPart(text);
            } else {
                TextFragment.TagType codeType = TextFragment.TagType.PLACEHOLDER;
                if (propertyTextUnitPlaceholders != null && !propertyTextUnitPlaceholders.isEmpty()) {
                    this.addToTextUnitCode(codeType, text, "x", propertyTextUnitPlaceholders);
                } else {
                    this.addToTextUnitCode(codeType, text, "x");
                }
            }
            this.trNonTextRun = null;
        }
    }

    public void excludeStyle(String sTyle) {
        if (sTyle != null && !sTyle.equals("")) {
            this.tsExcludeWordStyles.add(sTyle);
        }
    }

    public ParseType getConfigurationType() {
        return this.configurationType;
    }

    protected void setBInMainFile(boolean bInMainFile) {
        this.bInMainFile = bInMainFile;
    }

    protected boolean getBInMainFile() {
        return this.bInMainFile;
    }

    protected void setBInSettingsFile(boolean bInSettingsFile) {
        this.bInSettingsFile = bInSettingsFile;
    }

    protected boolean getBInSettingsFile() {
        return this.bInSettingsFile;
    }

    public void setTsExcludeWordStyles(TreeSet<String> tsExcludeWordStyles) {
        this.tsExcludeWordStyles = tsExcludeWordStyles;
    }

    public TreeSet<String> getTsExcludeWordStyles() {
        return this.tsExcludeWordStyles;
    }

    @Override
    protected TaggedFilterConfiguration getConfig() {
        return this.config;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (YamlParameters)params;
    }

    public ConditionalParameters getFilterParameters() {
        return this.filterParams;
    }

    private void addToTextUnitCode(TextFragment.TagType codeType, String data, String type) {
        this.addToTextUnit(new Code(codeType, type, data));
    }

    private void addToTextUnitCode(TextFragment.TagType codeType, String data, String type, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        this.addToTextUnit(new Code(codeType, type, data), propertyTextUnitPlaceholders);
    }

    public void setPartName(String partName) {
        this.partName = partName;
    }

    public String toString() {
        return "OpenXMLContentFilter [" + this.partName + "]";
    }

    private String escapeEntity(String s) {
        switch (s) {
            case "&": {
                return "&amp;";
            }
            case "<": {
                return "&lt;";
            }
            case ">": {
                return "&gt;";
            }
        }
        return s;
    }
}

