/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.extra.filters;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.lib.extra.AbstractParameters;

public class CompoundFilterParameters
extends AbstractParameters {
    private String parametersClass = "";
    private LinkedList<IParameters> parameters = new LinkedList();
    private IParameters activeParameters = null;
    private String defParametersClass = "";

    public IParameters getActiveParameters() {
        return this.activeParameters;
    }

    protected void setActiveParameters(IParameters activeParameters) {
        this.activeParameters = activeParameters;
    }

    protected <T extends BaseParameters> boolean addParameters(Class<T> parametersClass) {
        if (this.parameters == null) {
            return false;
        }
        boolean res = false;
        IParameters params = null;
        BaseParameters bp = null;
        try {
            if (!BaseParameters.class.isAssignableFrom(parametersClass)) {
                return false;
            }
            try {
                Constructor<T> bpc = parametersClass.getConstructor(new Class[0]);
                if (bpc == null) {
                    return false;
                }
                bp = (BaseParameters)bpc.newInstance(new Object[0]);
            }
            catch (SecurityException e) {
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
            res = this.parameters.add(bp);
            if (!res) {
                return false;
            }
            params = this.parameters.getLast();
            if (params == null) {
                return false;
            }
        }
        catch (InstantiationException e2) {
            return false;
        }
        catch (IllegalAccessException e2) {
            return false;
        }
        if (this.activeParameters == null) {
            this.activeParameters = params;
            if (params == null) {
                return false;
            }
            if (params.getClass() == null) {
                return false;
            }
            this.defParametersClass = params.getClass().getName();
        }
        return res;
    }

    public boolean setActiveParameters(String parametersClass) {
        IParameters params = this.findParameters(parametersClass);
        if (params == null) {
            return false;
        }
        if (this.activeParameters != params) {
            this.activeParameters = params;
            this.parametersClass = parametersClass;
        }
        if (this.owner != null) {
            this.owner.exec(this, "parameters_changed", parametersClass);
        }
        return true;
    }

    private IParameters findParameters(String parametersClass) {
        if (this.parameters == null) {
            return null;
        }
        for (IParameters params : this.parameters) {
            if (params == null || params.getClass() == null || !params.getClass().getName().equalsIgnoreCase(parametersClass)) continue;
            return params;
        }
        return null;
    }

    protected void setParametersClassName(String parametersClass) {
        this.parametersClass = parametersClass;
        this.setActiveParameters(parametersClass);
    }

    public void setParametersClass(Class<?> parametersClass) {
        if (parametersClass == null) {
            return;
        }
        this.setParametersClassName(parametersClass.getName());
    }

    public String getParametersClassName() {
        return this.parametersClass;
    }

    public Class<?> getParametersClass() {
        try {
            return Class.forName(this.parametersClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public LinkedList<IParameters> getParameters() {
        return this.parameters;
    }

    @Override
    protected void parameters_init() {
    }

    @Override
    protected void parameters_load(ParametersString buffer) {
        this.setParametersClassName(buffer.getString("parametersClass", this.defParametersClass));
        this.setActiveParameters(this.getParametersClassName());
        for (IParameters params : this.parameters) {
            params.fromString(this.getData());
        }
        if (this.owner != null) {
            this.owner.exec(this, "parameters_changed", this.parametersClass);
        }
    }

    @Override
    protected void parameters_reset() {
        this.setParametersClassName(this.defParametersClass);
    }

    @Override
    protected void parameters_save(ParametersString buffer) {
        if (this.activeParameters != null) {
            buffer.fromString(this.activeParameters.toString());
        }
        this.parametersClass = this.activeParameters == null ? this.defParametersClass : this.activeParameters.getClass().getName();
        buffer.setString("parametersClass", this.parametersClass);
    }
}

