/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.sf.okapi.common.BOMAwareInputStream;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.lib.verification.BlackTerm;

public class BlacklistReader {
    private BlackTerm nextEntry;
    private BufferedReader reader;

    public BlacklistReader() {
        this.reset();
    }

    public void reset() {
        this.nextEntry = null;
        this.reader = null;
    }

    public void open(File file) {
        try {
            this.open(new FileInputStream(file));
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error opening the URI.\n" + e.getLocalizedMessage());
        }
    }

    public void open(InputStream input) {
        try {
            this.close();
            String encoding = "UTF-8";
            BOMAwareInputStream bis = new BOMAwareInputStream(input, encoding);
            encoding = bis.detectEncoding();
            this.reader = new BufferedReader(new InputStreamReader((InputStream)bis, encoding));
            this.readNext();
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error opening the URI.\n" + e.getLocalizedMessage());
        }
    }

    public void close() {
        this.nextEntry = null;
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    public boolean hasNext() {
        return this.nextEntry != null;
    }

    public BlackTerm next() {
        BlackTerm currentEntry = this.nextEntry;
        this.readNext();
        return currentEntry;
    }

    private void readNext() {
        try {
            String[] parts;
            String line;
            this.nextEntry = null;
            do {
                if ((line = this.reader.readLine()) != null) continue;
                return;
            } while ((line = line.trim()).isEmpty() || (parts = line.split("\\t"))[0].isEmpty());
            BlackTerm bterm = new BlackTerm();
            bterm.text = parts[0];
            bterm.suggestion = parts.length == 1 ? "" : parts[1];
            bterm.searchTerm = parts[0].toLowerCase();
            this.nextEntry = bterm;
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error opening the URI.\n" + e.getLocalizedMessage());
        }
    }
}

