/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.verification.AbstractChecker;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.Parameters;
import net.sf.okapi.lib.verification.PatternItem;

public class GeneralChecker
extends AbstractChecker {
    private Pattern patDoubledWords;
    private String doubledWordExceptions;

    @Override
    public void startProcess(LocaleId sourceLocale, LocaleId targetLocale, Parameters params, List<Issue> issues) {
        super.startProcess(sourceLocale, targetLocale, params, issues);
        this.patDoubledWords = null;
        if (params.getDoubledWord()) {
            this.patDoubledWords = Pattern.compile("\\b([\\p{Ll}\\p{Lu}\\p{Lt}\\p{Lo}\\p{Nd}]+)[\\t\\n\\f\\r\\p{Z}]+\\1\\b", 2);
            this.doubledWordExceptions = ";" + params.getDoubledWordExceptions().toLowerCase() + ";";
        }
    }

    @Override
    public void processStartDocument(StartDocument sd, List<String> sigList) {
        super.processStartDocument(sd, sigList);
    }

    @Override
    public void processStartSubDocument(StartSubDocument ssd) {
        super.processStartSubDocument(ssd);
    }

    @Override
    public void processTextUnit(ITextUnit tu) {
        if (!tu.isTranslatable()) {
            return;
        }
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = tu.getTarget(this.getTrgLoc());
        if (trgCont == null) {
            if (!this.isMonolingual()) {
                this.reportIssue(IssueType.MISSING_TARGETTU, tu, null, "Missing translation.", 0, -1, 0, -1, 100.0, srcCont.toString(), "", null);
                this.addAnnotation(tu.getSource(), null, IssueType.MISSING_TARGETTU, "Missing translation", 0, -1, 0, -1, 100.0, null);
            }
            return;
        }
        ISegments srcSegs = srcCont.getSegments();
        ISegments trgSegs = trgCont.getSegments();
        for (Segment srcSeg : srcSegs) {
            Segment trgSeg = trgSegs.get(srcSeg.getId());
            if (trgSeg == null) {
                this.reportIssue(IssueType.MISSING_TARGETSEG, tu, srcSeg.getId(), "The source segment has no corresponding target segment.", 0, -1, 0, -1, 100.0, srcSeg.toString(), "", null);
                this.addAnnotation(srcCont, srcSeg.getId(), IssueType.MISSING_TARGETSEG, "The source segment has no corresponding target segment.", 0, -1, 0, -1, 100.0, null);
                continue;
            }
            if (this.getParams().getEmptyTarget() && trgSeg.text.isEmpty() && !srcSeg.text.isEmpty()) {
                this.reportIssue(IssueType.EMPTY_TARGETSEG, tu, srcSeg.getId(), "The target segment is empty, but its source is not empty.", 0, -1, 0, -1, 100.0, srcSeg.toString(), "", null);
                this.addAnnotation(srcCont, srcSeg.getId(), IssueType.EMPTY_TARGETSEG, "The target segment is empty, but its source is not empty.", 0, -1, 0, -1, 100.0, null);
                continue;
            }
            if (this.getParams().getEmptySource() && srcSeg.text.isEmpty() && !trgSeg.text.isEmpty()) {
                this.reportIssue(IssueType.EMPTY_SOURCESEG, tu, srcSeg.getId(), "The target segment is not empty, but its source is empty.", 0, -1, 0, -1, 100.0, srcSeg.toString(), "", null);
                this.addAnnotation(srcCont, srcSeg.getId(), IssueType.EMPTY_SOURCESEG, "The target segment is not empty, but its source is empty.", 0, -1, 0, -1, 100.0, null);
                continue;
            }
            List<PatternItem> patterns = this.getParams().getPatterns();
            for (PatternItem item : patterns) {
                if (!item.enabled) continue;
                item.compile();
            }
            if (this.getParams().getTargetSameAsSource() && (this.getParams().getTargetSameAsSourceForSameLanguage() || !this.getSrcLoc().sameLanguageAs(this.getTrgLoc())) && this.hasMeaningfullText(srcSeg.text) && srcSeg.text.compareTo(trgSeg.text, this.getParams().getTargetSameAsSourceWithCodes()) == 0) {
                boolean warn = true;
                if (patterns != null) {
                    for (PatternItem item : patterns) {
                        Matcher m;
                        String ctext = srcSeg.text.getCodedText();
                        if (!item.enabled || !item.target.equals("<same>") || !(m = item.getSourcePattern().matcher(ctext)).find()) continue;
                        warn = !ctext.equals(m.group());
                        break;
                    }
                }
                if (warn) {
                    this.reportIssue(IssueType.TARGET_SAME_AS_SOURCE, tu, srcSeg.getId(), "Translation is the same as the source.", 0, -1, 0, -1, 50.0, srcSeg.toString(), trgSeg.toString(), null);
                    this.addAnnotation(srcCont, srcSeg.getId(), IssueType.TARGET_SAME_AS_SOURCE, "Translation is the same as the source.", 0, -1, 0, -1, 50.0, null);
                }
            }
            this.checkSuspectPatterns(srcSeg, trgSeg, tu);
        }
        for (Segment trgSeg : trgSegs) {
            Segment srcSeg = srcSegs.get(trgSeg.getId());
            if (srcSeg != null) continue;
            this.reportIssue(IssueType.EXTRA_TARGETSEG, tu, trgSeg.getId(), String.format("Extra target segment (id=%s).", trgSeg.getId()), 0, -1, 0, -1, 100.0, "", trgSeg.toString(), null);
            this.addAnnotation(trgCont, trgSeg.getId(), IssueType.EXTRA_TARGETSEG, String.format("Extra target segment (id=%s).", trgSeg.getId()), 0, -1, 0, -1, 100.0, null);
        }
        String srcOri = null;
        srcOri = srcCont.contentIsOneSegment() ? srcCont.toString() : srcCont.getUnSegmentedContentCopy().toText();
        String trgOri = null;
        trgOri = trgCont.contentIsOneSegment() ? trgCont.toString() : trgCont.getUnSegmentedContentCopy().toText();
        this.checkWhiteSpaces(srcOri, trgOri, tu);
        this.setAnnotationIds(srcCont, trgCont);
    }

    private boolean hasMeaningfullText(TextFragment frag) {
        return WORDCHARS.matcher(frag.getCodedText()).find();
    }

    private boolean isSpaceWeCareAbout(char c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c);
    }

    private void checkWhiteSpaces(String srcOri, String trgOri, ITextUnit tu) {
        if (this.getParams().getLeadingWS()) {
            int i;
            for (i = 0; i < srcOri.length() && this.isSpaceWeCareAbout(srcOri.charAt(i)); ++i) {
                if (srcOri.length() > i) {
                    if (trgOri.length() - 1 >= i && trgOri.charAt(i) == srcOri.charAt(i)) continue;
                    this.reportIssue(IssueType.MISSINGORDIFF_LEADINGWS, tu, null, String.format("Missing or different leading white space at position %d.", i), i, i + 1, 0, -1, 1.0, srcOri, trgOri, null);
                    this.addAnnotation(tu.getSource(), null, IssueType.MISSINGORDIFF_LEADINGWS, String.format("Missing or different leading white space at position %d.", i), i, i + 1, 0, -1, 1.0, null);
                    break;
                }
                this.reportIssue(IssueType.MISSING_LEADINGWS, tu, null, String.format("Missing leading white space at position %d.", i), i, i + 1, 0, -1, 1.0, srcOri, trgOri, null);
                this.addAnnotation(tu.getSource(), null, IssueType.MISSINGORDIFF_LEADINGWS, String.format("Missing leading white space at position %d.", i), i, i + 1, 0, -1, 1.0, null);
            }
            for (i = 0; i < trgOri.length() && this.isSpaceWeCareAbout(trgOri.charAt(i)); ++i) {
                if (srcOri.length() > i) {
                    if (srcOri.length() - 1 >= i && srcOri.charAt(i) == trgOri.charAt(i)) continue;
                    this.reportIssue(IssueType.EXTRAORDIFF_LEADINGWS, tu, null, String.format("Extra or different leading white space at position %d.", i), 0, -1, i, i + 1, 1.0, srcOri, trgOri, null);
                    this.addAnnotation(tu.getTarget(this.getTrgLoc()), null, IssueType.EXTRAORDIFF_LEADINGWS, String.format("Extra or different leading white space at position %d.", i), 0, -1, i, i + 1, 1.0, null);
                    break;
                }
                this.reportIssue(IssueType.EXTRA_LEADINGWS, tu, null, String.format("Extra leading white space at position %d.", i), 0, -1, i, i + 1, 1.0, srcOri, trgOri, null);
                this.addAnnotation(tu.getTarget(this.getTrgLoc()), null, IssueType.EXTRA_LEADINGWS, String.format("Extra leading white space at position %d.", i), 0, -1, i, i + 1, 1.0, null);
            }
        }
        if (this.getParams().getTrailingWS()) {
            int i;
            int j = trgOri.length() - 1;
            for (i = srcOri.length() - 1; i >= 0 && this.isSpaceWeCareAbout(srcOri.charAt(i)); --i) {
                if (j >= 0) {
                    if (trgOri.length() - 1 < j || trgOri.charAt(j) != srcOri.charAt(i)) {
                        this.reportIssue(IssueType.MISSINGORDIFF_TRAILINGWS, tu, null, String.format("Missing or different trailing white space at position %d", i), i, i + 1, 0, -1, 1.0, srcOri, trgOri, null);
                        this.addAnnotation(tu.getSource(), null, IssueType.MISSINGORDIFF_TRAILINGWS, String.format("Missing or different trailing white space at position %d", i), i, i + 1, 0, -1, 1.0, null);
                        break;
                    }
                } else {
                    this.reportIssue(IssueType.MISSING_TRAILINGWS, tu, null, String.format("Missing trailing white space at position %d.", i), i, i + 1, 0, -1, 1.0, srcOri, trgOri, null);
                    this.addAnnotation(tu.getSource(), null, IssueType.MISSING_TRAILINGWS, String.format("Missing trailing white space at position %d.", i), i, i + 1, 0, -1, 1.0, null);
                }
                --j;
            }
            j = srcOri.length() - 1;
            for (i = trgOri.length() - 1; i >= 0 && this.isSpaceWeCareAbout(trgOri.charAt(i)); --i) {
                if (j >= 0) {
                    if (srcOri.length() - 1 < j || srcOri.charAt(j) != trgOri.charAt(i)) {
                        this.reportIssue(IssueType.EXTRAORDIFF_TRAILINGWS, tu, null, String.format("Extra or different trailing white space at position %d.", i), 0, -1, i, i + 1, 1.0, srcOri, trgOri, null);
                        this.addAnnotation(tu.getTarget(this.getTrgLoc()), null, IssueType.EXTRAORDIFF_TRAILINGWS, String.format("Extra or different trailing white space at position %d.", i), 0, -1, i, i + 1, 1.0, null);
                        break;
                    }
                } else {
                    this.reportIssue(IssueType.EXTRA_TRAILINGWS, tu, null, String.format("Extra white trailing space at position %d.", i), 0, -1, i, i + 1, 1.0, srcOri, trgOri, null);
                    this.addAnnotation(tu.getTarget(this.getTrgLoc()), null, IssueType.EXTRA_TRAILINGWS, String.format("Extra white trailing space at position %d.", i), 0, -1, i, i + 1, 1.0, null);
                }
                --j;
            }
        }
    }

    private void checkSuspectPatterns(Segment srcSeg, Segment trgSeg, ITextUnit tu) {
        String trgCText = trgSeg.text.getCodedText();
        if (this.getParams().getDoubledWord()) {
            Matcher m = this.patDoubledWords.matcher(trgCText);
            while (m.find()) {
                if (this.doubledWordExceptions.indexOf(";" + m.group(1).toLowerCase() + ";") != -1) continue;
                this.reportIssue(IssueType.SUSPECT_PATTERN, tu, srcSeg.getId(), String.format("Double word: \"%s\" found in the target.", m.group()), 0, -1, TextFragment.fromFragmentToString(trgSeg.text, m.start()), TextFragment.fromFragmentToString(trgSeg.text, m.end()), 100.0, srcSeg.toString(), trgSeg.toString(), null);
                this.addAnnotation(tu.getTarget(this.getTrgLoc()), null, IssueType.SUSPECT_PATTERN, String.format("Double word: \"%s\" found in the target.", m.group()), 0, -1, TextFragment.fromFragmentToString(trgSeg.text, m.start()), TextFragment.fromFragmentToString(trgSeg.text, m.end()), 1.0, null);
            }
        }
    }
}

