/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.segmentation.ui;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.ISWTEmbeddableParametersEditor;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.lib.ui.segmentation.SRXEditor;
import net.sf.okapi.steps.segmentation.Parameters;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

@EditorFor(value=Parameters.class)
public class ParametersEditor
implements IParametersEditor,
ISWTEmbeddableParametersEditor {
    private Shell shell;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private Button chkSegmentSource;
    private Button btGetSourceSRX;
    private Button btEditSourceSRX;
    private Button chkSegmentTarget;
    private Button btGetTargetSRX;
    private Button btEditTargetSRX;
    private Button chkCopySource;
    private Button chkCheckSegments;
    private Button chkForceSegmentedOutput;
    private Button chkRenumberCodes;
    private Text edSourceSRX;
    private Text edTargetSRX;
    private IHelp help;
    private String projectDir;
    private Composite mainComposite;
    private Group grpOptions;
    private Label lblBehaviorForSegmented;
    private List listBehaviorForSegmented;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters params, boolean readOnly, IContext context) {
        boolean bRes = false;
        try {
            this.projectDir = context.getString("projDir");
            this.help = (IHelp)context.getObject("help");
            this.params = (Parameters)params;
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new Parameters();
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    @Override
    public void initializeEmbeddableEditor(Composite parent, IParameters paramsObject, IContext context) {
        this.params = (Parameters)paramsObject;
        this.shell = (Shell)context.getObject("shell");
        this.createComposite(parent);
        this.setData();
    }

    public String validateAndSaveParameters() {
        if (!this.saveData()) {
            return null;
        }
        return this.params.toString();
    }

    private void create(Shell parent, boolean readOnly) {
        this.shell.setText("Segmentation");
        if (parent != null) {
            UIUtil.inheritIcon(this.shell, parent);
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout(layTmp);
        this.createComposite(this.shell);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (ParametersEditor.this.help != null) {
                        ParametersEditor.this.help.showWiki("Segmentation Step");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    ParametersEditor.this.saveData();
                }
                ParametersEditor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel(this.shell, 0, OKCancelActions, true);
        this.pnlActions.setLayoutData(new GridData(768));
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 600) {
            startSize.x = 600;
        }
        this.shell.setSize(startSize);
        this.setData();
        Dialogs.centerWindow(this.shell, parent);
    }

    private void createComposite(Composite parent) {
        this.mainComposite = new Composite(parent, 2048);
        this.mainComposite.setLayoutData(new GridData(1808));
        this.mainComposite.setLayout(new GridLayout(3, false));
        this.chkSegmentSource = new Button(this.mainComposite, 32);
        this.chkSegmentSource.setText("Segment the source text using the following SRX rules:");
        GridData gdTmp = new GridData();
        gdTmp.horizontalSpan = 3;
        this.chkSegmentSource.setLayoutData(gdTmp);
        this.chkSegmentSource.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updateSourceDisplay();
                ParametersEditor.this.updateOptionsDisplay();
            }
        });
        this.edSourceSRX = new Text(this.mainComposite, 2048);
        this.edSourceSRX.setLayoutData(new GridData(768));
        this.btGetSourceSRX = new Button(this.mainComposite, 8);
        this.btGetSourceSRX.setText("...");
        this.btGetSourceSRX.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.getSRXFile(ParametersEditor.this.edSourceSRX);
            }
        });
        this.btEditSourceSRX = new Button(this.mainComposite, 8);
        this.btEditSourceSRX.setText("Edit...");
        this.btEditSourceSRX.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.editSRXFile(ParametersEditor.this.edSourceSRX);
            }
        });
        this.chkSegmentTarget = new Button(this.mainComposite, 32);
        this.chkSegmentTarget.setText("Segment existing target text using the following SRX rules:");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 3;
        this.chkSegmentTarget.setLayoutData(gdTmp);
        this.chkSegmentTarget.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updateTargetDisplay();
                ParametersEditor.this.updateOptionsDisplay();
            }
        });
        this.edTargetSRX = new Text(this.mainComposite, 2048);
        this.edTargetSRX.setLayoutData(new GridData(768));
        this.btGetTargetSRX = new Button(this.mainComposite, 8);
        this.btGetTargetSRX.setText("...");
        this.btGetTargetSRX.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.getSRXFile(ParametersEditor.this.edTargetSRX);
            }
        });
        this.btEditTargetSRX = new Button(this.mainComposite, 8);
        this.btEditTargetSRX.setText("Edit...");
        this.btEditTargetSRX.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.editSRXFile(ParametersEditor.this.edTargetSRX);
            }
        });
        this.grpOptions = new Group(this.mainComposite, 0);
        this.grpOptions.setText("Options");
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 3;
        this.grpOptions.setLayoutData(gdTmp);
        this.grpOptions.setLayout(new GridLayout(1, false));
        this.lblBehaviorForSegmented = new Label(this.grpOptions, 0);
        this.lblBehaviorForSegmented.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblBehaviorForSegmented.setText("Behavior if input text is already segmented:");
        this.listBehaviorForSegmented = new List(this.grpOptions, 2048);
        this.listBehaviorForSegmented.setItems(new String[]{"Keep existing segmentation", "Overwrite existing segmentation (resegment)", "Keep existing segmentation, segment further against the SRX rules"});
        this.listBehaviorForSegmented.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.chkCopySource = new Button(this.grpOptions, 32);
        this.chkCopySource.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.chkCopySource.setText("Copy source into target if no target exists");
        this.chkCheckSegments = new Button(this.grpOptions, 32);
        this.chkCheckSegments.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.chkCheckSegments.setText("Verify that a target segment matches each source segment when a target content exists");
        this.chkForceSegmentedOutput = new Button(this.grpOptions, 32);
        this.chkForceSegmentedOutput.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.chkForceSegmentedOutput.setText("When possible force the output to show the segmentation");
        this.chkRenumberCodes = new Button(this.grpOptions, 32);
        this.chkRenumberCodes.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.chkRenumberCodes.setText("Renumber code IDs");
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void getSRXFile(Text edTextField) {
        String caption = edTextField == this.edSourceSRX ? "Select SRX for Source" : "Select SRX for Target";
        String[] paths = Dialogs.browseFilenames(this.shell, caption, false, null, "SRX Documents (*.srx)\tAll Files (*.*)", "*.srx\t*.*");
        if (paths == null) {
            return;
        }
        UIUtil.checkProjectFolderAfterPick(paths[0], edTextField, this.projectDir);
    }

    private void editSRXFile(Text edTextField) {
        try {
            SRXEditor editor = new SRXEditor(this.shell, true, this.help);
            String oriPath = edTextField.getText();
            if (this.projectDir != null) {
                oriPath = oriPath.replace("${ProjDir}", this.projectDir);
            }
            if (oriPath.length() == 0) {
                oriPath = null;
            }
            editor.showDialog(oriPath);
            String newPath = editor.getPath();
            UIUtil.checkProjectFolderAfterPick(newPath, edTextField, this.projectDir);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void updateSourceDisplay() {
        this.edSourceSRX.setEnabled(this.chkSegmentSource.getSelection());
        this.btEditSourceSRX.setEnabled(this.chkSegmentSource.getSelection());
        this.btGetSourceSRX.setEnabled(this.chkSegmentSource.getSelection());
    }

    private void updateTargetDisplay() {
        this.edTargetSRX.setEnabled(this.chkSegmentTarget.getSelection());
        this.btEditTargetSRX.setEnabled(this.chkSegmentTarget.getSelection());
        this.btGetTargetSRX.setEnabled(this.chkSegmentTarget.getSelection());
    }

    private void updateOptionsDisplay() {
        boolean enabled = this.chkSegmentTarget.getSelection() || this.chkSegmentSource.getSelection();
        this.grpOptions.setEnabled(enabled);
        for (Control ctrl : this.grpOptions.getChildren()) {
            ctrl.setEnabled(enabled);
        }
    }

    private void setData() {
        this.chkSegmentSource.setSelection(this.params.getSegmentSource());
        this.edSourceSRX.setText(this.params.getSourceSrxPath());
        this.chkSegmentTarget.setSelection(this.params.getSegmentTarget());
        this.edTargetSRX.setText(this.params.getTargetSrxPath());
        this.chkCopySource.setSelection(this.params.getCopySource());
        this.chkCheckSegments.setSelection(this.params.getCheckSegments());
        this.chkForceSegmentedOutput.setSelection(this.params.getForcesegmentedOutput());
        this.chkRenumberCodes.setSelection(this.params.getRenumberCodes());
        this.listBehaviorForSegmented.setSelection(this.params.getSegmentationStrategy().ordinal());
        this.updateSourceDisplay();
        this.updateTargetDisplay();
        this.updateOptionsDisplay();
    }

    private boolean saveData() {
        this.params.setSegmentSource(this.chkSegmentSource.getSelection());
        if (this.params.getSegmentSource()) {
            this.params.setSourceSrxPath(this.edSourceSRX.getText());
        }
        this.params.setSegmentTarget(this.chkSegmentTarget.getSelection());
        if (this.params.getSegmentTarget()) {
            this.params.setTargetSrxPath(this.edTargetSRX.getText());
        }
        this.params.setCopySource(this.chkCopySource.getSelection());
        this.params.setCheckSegments(this.chkCheckSegments.getSelection());
        this.params.setForcesegmentedOutput(this.chkForceSegmentedOutput.getSelection());
        this.params.setRenumberCodes(this.chkRenumberCodes.getSelection());
        this.params.setSegmentationStrategy(Parameters.SegmStrategy.values()[this.listBehaviorForSegmented.getSelectionIndex()]);
        this.result = true;
        return true;
    }
}

