/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.walker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.document.BeforeAndAfter;
import net.sf.okapi.lib.xliff2.document.FileNode;
import net.sf.okapi.lib.xliff2.document.UnitNode;
import net.sf.okapi.lib.xliff2.document.XLIFFDocument;
import net.sf.okapi.lib.xliff2.walker.AbstractXliffWalkerStrategy;
import net.sf.okapi.lib.xliff2.walker.DefaultXliffWalkerStrategy;
import net.sf.okapi.lib.xliff2.walker.IXliffVisitor;

public class XliffWalker {
    private XLIFFDocument xlf;
    private final AbstractXliffWalkerStrategy strategy;
    private Map<Integer, IXliffVisitor<FileNode>> fileVisitors = new TreeMap<Integer, IXliffVisitor<FileNode>>();
    private Map<Integer, IXliffVisitor<UnitNode>> unitVisitors = new TreeMap<Integer, IXliffVisitor<UnitNode>>();
    private Map<Integer, IXliffVisitor<Segment>> segmentVisitors = new TreeMap<Integer, IXliffVisitor<Segment>>();
    private int fileVisitorID = -1;
    private int unitVisitorID = -1;
    private int segmentVisitorID = -1;

    public XliffWalker(XLIFFDocument doc) {
        if (doc == null) {
            throw new IllegalArgumentException("A valid XLIFF document must be provided.");
        }
        this.xlf = doc;
        this.strategy = new DefaultXliffWalkerStrategy(this);
    }

    public XliffWalker(XLIFFDocument doc, AbstractXliffWalkerStrategy strategy) {
        if (doc == null) {
            throw new IllegalArgumentException("A valid XLIFF document must be provided.");
        }
        if (strategy == null) {
            throw new IllegalArgumentException("A valid strategy object must be provided.");
        }
        this.xlf = doc;
        this.strategy = strategy;
    }

    public void doWalk() {
        if (this.fileVisitors.isEmpty() && this.unitVisitors.isEmpty() && this.segmentVisitors.isEmpty()) {
            throw new IllegalStateException("At least one visitor must be added before running the xliff doc traversal");
        }
        this.strategy.doWalk();
    }

    public void setVisitors(List<IXliffVisitor<FileNode>> fileVisitors, List<IXliffVisitor<UnitNode>> unitVisitors, List<IXliffVisitor<Segment>> segmentVisitors) {
        if (fileVisitors != null) {
            for (IXliffVisitor<BeforeAndAfter> iXliffVisitor : fileVisitors) {
                this.addFileVisitor(iXliffVisitor);
            }
        }
        if (unitVisitors != null) {
            for (IXliffVisitor<Object> iXliffVisitor : unitVisitors) {
                this.addUnitVisitor(iXliffVisitor);
            }
        }
        if (segmentVisitors != null) {
            for (IXliffVisitor<Object> iXliffVisitor : segmentVisitors) {
                this.addSegmentVisitor(iXliffVisitor);
            }
        }
    }

    public Integer addFileVisitor(IXliffVisitor<FileNode> fileVisitor) {
        if (fileVisitor == null) {
            throw new IllegalArgumentException("A valid file visitor must be provided.");
        }
        Integer key = this.nextFileVisitorID();
        this.fileVisitors.put(key, fileVisitor);
        return key;
    }

    public Integer addUnitVisitor(IXliffVisitor<UnitNode> unitVisitor) {
        if (unitVisitor == null) {
            throw new IllegalArgumentException("A valid unit visitor must be provided.");
        }
        Integer key = this.nextUnitVisitorID();
        this.unitVisitors.put(key, unitVisitor);
        return key;
    }

    public Integer addSegmentVisitor(IXliffVisitor<Segment> segmentVisitor) {
        if (segmentVisitor == null) {
            throw new IllegalArgumentException("A valid segment visitor must be provided.");
        }
        Integer key = this.nextSegmentVisitorID();
        this.segmentVisitors.put(key, segmentVisitor);
        return key;
    }

    public List<IXliffVisitor<FileNode>> getFileNodeVisitors() {
        return new ArrayList<IXliffVisitor<FileNode>>(this.fileVisitors.values());
    }

    public List<IXliffVisitor<UnitNode>> getUnitNodeVisitors() {
        return new ArrayList<IXliffVisitor<UnitNode>>(this.unitVisitors.values());
    }

    public List<IXliffVisitor<Segment>> getSegmentVisitors() {
        return new ArrayList<IXliffVisitor<Segment>>(this.segmentVisitors.values());
    }

    public void removeFileVisitor(Integer ID) {
        if (ID == null || ID < 0) {
            throw new IllegalArgumentException("A valid ID must be provided.");
        }
        this.fileVisitors.remove(ID);
    }

    public void removeUnitVisitor(Integer ID) {
        if (ID == null || ID < 0) {
            throw new IllegalArgumentException("A valid ID must be provided.");
        }
        this.unitVisitors.remove(ID);
    }

    public void removeSegmentVisitor(Integer ID) {
        if (ID == null || ID < 0) {
            throw new IllegalArgumentException("A valid ID must be provided.");
        }
        this.segmentVisitors.remove(ID);
    }

    public void removeAllVisitors() {
        this.fileVisitors.clear();
        this.unitVisitors.clear();
        this.segmentVisitors.clear();
    }

    public XLIFFDocument getXlfDoc() {
        return this.xlf;
    }

    public List<String> getFileNodeIds() {
        return this.xlf.getFileNodeIds();
    }

    public FileNode getFileNode(String fileNodeID) {
        if (fileNodeID == null || fileNodeID.isEmpty()) {
            throw new IllegalArgumentException("A valid file node ID must be provided.");
        }
        return this.xlf.getFileNode(fileNodeID);
    }

    private Integer nextFileVisitorID() {
        return ++this.fileVisitorID;
    }

    private Integer nextUnitVisitorID() {
        return ++this.unitVisitorID;
    }

    private Integer nextSegmentVisitorID() {
        return ++this.segmentVisitorID;
    }
}

