/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.CodecUtil;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.Outputs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FST<T> {
    public final INPUT_TYPE inputType;
    private static final int BIT_FINAL_ARC = 1;
    private static final int BIT_LAST_ARC = 2;
    private static final int BIT_TARGET_NEXT = 4;
    private static final int BIT_STOP_NODE = 8;
    private static final int BIT_ARC_HAS_OUTPUT = 16;
    private static final int BIT_ARC_HAS_FINAL_OUTPUT = 32;
    private static final int BIT_ARCS_AS_FIXED_ARRAY = 64;
    static final int FIXED_ARRAY_SHALLOW_DISTANCE = 3;
    static final int FIXED_ARRAY_NUM_ARCS_SHALLOW = 5;
    static final int FIXED_ARRAY_NUM_ARCS_DEEP = 10;
    private int[] bytesPerArc = new int[0];
    private static final String FILE_FORMAT_NAME = "FST";
    private static final int VERSION_START = 0;
    private static final int VERSION_CURRENT = 0;
    private static final int FINAL_END_NODE = -1;
    private static final int NON_FINAL_END_NODE = 0;
    T emptyOutput;
    private byte[] emptyOutputBytes;
    private byte[] bytes;
    int byteUpto = 0;
    private int startNode = -1;
    public final Outputs<T> outputs;
    private int lastFrozenNode;
    private final T NO_OUTPUT;
    public int nodeCount;
    public int arcCount;
    public int arcWithOutputCount;
    public static final int END_LABEL = -1;
    private final BytesWriter writer;

    static boolean flag(int flags, int bit) {
        return (flags & bit) != 0;
    }

    public FST(INPUT_TYPE inputType, Outputs<T> outputs) {
        this.inputType = inputType;
        this.outputs = outputs;
        this.bytes = new byte[128];
        this.NO_OUTPUT = outputs.getNoOutput();
        this.writer = new BytesWriter();
        this.emptyOutput = null;
    }

    public FST(DataInput in, Outputs<T> outputs) throws IOException {
        this.outputs = outputs;
        this.writer = null;
        CodecUtil.checkHeader(in, FILE_FORMAT_NAME, 0, 0);
        if (in.readByte() == 1) {
            int numBytes = in.readVInt();
            this.bytes = new byte[numBytes];
            in.readBytes(this.bytes, 0, numBytes);
            this.emptyOutput = outputs.read(this.getBytesReader(numBytes - 1));
        } else {
            this.emptyOutput = null;
        }
        byte t = in.readByte();
        switch (t) {
            case 0: {
                this.inputType = INPUT_TYPE.BYTE1;
                break;
            }
            case 1: {
                this.inputType = INPUT_TYPE.BYTE2;
                break;
            }
            case 2: {
                this.inputType = INPUT_TYPE.BYTE4;
                break;
            }
            default: {
                throw new IllegalStateException("invalid input type " + t);
            }
        }
        this.startNode = in.readVInt();
        this.nodeCount = in.readVInt();
        this.arcCount = in.readVInt();
        this.arcWithOutputCount = in.readVInt();
        this.bytes = new byte[in.readVInt()];
        in.readBytes(this.bytes, 0, this.bytes.length);
        this.NO_OUTPUT = outputs.getNoOutput();
    }

    public INPUT_TYPE getInputType() {
        return this.inputType;
    }

    public int sizeInBytes() {
        return this.bytes.length;
    }

    void finish(int startNode) {
        if (startNode == -1 && this.emptyOutput != null) {
            startNode = 0;
        }
        if (this.startNode != -1) {
            throw new IllegalStateException("already finished");
        }
        byte[] finalBytes = new byte[this.writer.posWrite];
        System.arraycopy(this.bytes, 0, finalBytes, 0, this.writer.posWrite);
        this.bytes = finalBytes;
        this.startNode = startNode;
    }

    void setEmptyOutput(T v) throws IOException {
        this.emptyOutput = this.emptyOutput != null ? this.outputs.merge(this.emptyOutput, v) : v;
        int posSave = this.writer.posWrite;
        this.outputs.write(this.emptyOutput, this.writer);
        this.emptyOutputBytes = new byte[this.writer.posWrite - posSave];
        int stopAt = (this.writer.posWrite - posSave) / 2;
        for (int upto = 0; upto < stopAt; ++upto) {
            byte b = this.bytes[posSave + upto];
            this.bytes[posSave + upto] = this.bytes[this.writer.posWrite - upto - 1];
            this.bytes[this.writer.posWrite - upto - 1] = b;
        }
        System.arraycopy(this.bytes, posSave, this.emptyOutputBytes, 0, this.writer.posWrite - posSave);
        this.writer.posWrite = posSave;
    }

    public void save(DataOutput out) throws IOException {
        if (this.startNode == -1) {
            throw new IllegalStateException("call finish first");
        }
        CodecUtil.writeHeader(out, FILE_FORMAT_NAME, 0);
        if (this.emptyOutput != null) {
            out.writeByte((byte)1);
            out.writeVInt(this.emptyOutputBytes.length);
            out.writeBytes(this.emptyOutputBytes, 0, this.emptyOutputBytes.length);
        } else {
            out.writeByte((byte)0);
        }
        int t = this.inputType == INPUT_TYPE.BYTE1 ? 0 : (this.inputType == INPUT_TYPE.BYTE2 ? 1 : 2);
        out.writeByte((byte)t);
        out.writeVInt(this.startNode);
        out.writeVInt(this.nodeCount);
        out.writeVInt(this.arcCount);
        out.writeVInt(this.arcWithOutputCount);
        out.writeVInt(this.bytes.length);
        out.writeBytes(this.bytes, 0, this.bytes.length);
    }

    private void writeLabel(int v) throws IOException {
        assert (v >= 0) : "v=" + v;
        if (this.inputType == INPUT_TYPE.BYTE1) {
            assert (v <= 255) : "v=" + v;
            this.writer.writeByte((byte)v);
        } else if (this.inputType == INPUT_TYPE.BYTE2) {
            assert (v <= 65535) : "v=" + v;
            this.writer.writeVInt(v);
        } else {
            this.writer.writeVInt(v);
        }
    }

    int readLabel(DataInput in) throws IOException {
        int v = this.inputType == INPUT_TYPE.BYTE1 ? in.readByte() & 0xFF : in.readVInt();
        return v;
    }

    public boolean targetHasArcs(Arc<T> arc) {
        return arc.target > 0;
    }

    int addNode(Builder.UnCompiledNode<T> node) throws IOException {
        int fixedArrayStart;
        if (node.numArcs == 0) {
            if (node.isFinal) {
                return -1;
            }
            return 0;
        }
        int startAddress = this.writer.posWrite;
        boolean doFixedArray = this.shouldExpand(node);
        if (doFixedArray) {
            if (this.bytesPerArc.length < node.numArcs) {
                this.bytesPerArc = new int[ArrayUtil.oversize(node.numArcs, 1)];
            }
            this.writer.writeByte((byte)64);
            this.writer.writeVInt(node.numArcs);
            this.writer.writeByte((byte)0);
            fixedArrayStart = this.writer.posWrite;
        } else {
            fixedArrayStart = 0;
        }
        ++this.nodeCount;
        this.arcCount += node.numArcs;
        int lastArc = node.numArcs - 1;
        int lastArcStart = this.writer.posWrite;
        int maxBytesPerArc = 0;
        for (int arcIdx = 0; arcIdx < node.numArcs; ++arcIdx) {
            boolean targetHasArcs;
            Builder.Arc arc = node.arcs[arcIdx];
            Builder.CompiledNode target = (Builder.CompiledNode)arc.target;
            int flags = 0;
            if (arcIdx == lastArc) {
                flags += 2;
            }
            if (this.lastFrozenNode == target.address && !doFixedArray) {
                flags += 4;
            }
            if (arc.isFinal) {
                ++flags;
                if (arc.nextFinalOutput != this.NO_OUTPUT) {
                    flags += 32;
                }
            } else assert (arc.nextFinalOutput == this.NO_OUTPUT);
            boolean bl = targetHasArcs = target.address > 0;
            if (!targetHasArcs) {
                flags += 8;
            }
            if (arc.output != this.NO_OUTPUT) {
                flags += 16;
            }
            this.writer.writeByte((byte)flags);
            this.writeLabel(arc.label);
            if (arc.output != this.NO_OUTPUT) {
                this.outputs.write(arc.output, this.writer);
                ++this.arcWithOutputCount;
            }
            if (arc.nextFinalOutput != this.NO_OUTPUT) {
                this.outputs.write(arc.nextFinalOutput, this.writer);
            }
            if (targetHasArcs && (doFixedArray || this.lastFrozenNode != target.address)) {
                assert (target.address > 0);
                this.writer.writeInt(target.address);
            }
            if (!doFixedArray) continue;
            this.bytesPerArc[arcIdx] = this.writer.posWrite - lastArcStart;
            lastArcStart = this.writer.posWrite;
            maxBytesPerArc = Math.max(maxBytesPerArc, this.bytesPerArc[arcIdx]);
        }
        if (doFixedArray) {
            int destPos;
            assert (maxBytesPerArc > 0);
            int sizeNeeded = fixedArrayStart + node.numArcs * maxBytesPerArc;
            this.bytes = ArrayUtil.grow(this.bytes, sizeNeeded);
            if (maxBytesPerArc > 255) {
                throw new IllegalStateException("max arc size is too large (" + maxBytesPerArc + ")");
            }
            this.bytes[fixedArrayStart - 1] = (byte)maxBytesPerArc;
            int srcPos = this.writer.posWrite;
            this.writer.posWrite = destPos = fixedArrayStart + node.numArcs * maxBytesPerArc;
            for (int arcIdx = node.numArcs - 1; arcIdx >= 0; --arcIdx) {
                if ((srcPos -= this.bytesPerArc[arcIdx]) == (destPos -= maxBytesPerArc)) continue;
                assert (destPos > srcPos);
                System.arraycopy(this.bytes, srcPos, this.bytes, destPos, this.bytesPerArc[arcIdx]);
            }
        }
        int endAddress = this.lastFrozenNode = this.writer.posWrite - 1;
        int left = startAddress;
        int right = endAddress;
        while (left < right) {
            byte b = this.bytes[left];
            this.bytes[left++] = this.bytes[right];
            this.bytes[right--] = b;
        }
        return endAddress;
    }

    public Arc<T> getFirstArc(Arc<T> arc) {
        if (this.emptyOutput != null) {
            arc.flags = (byte)3;
            arc.nextFinalOutput = this.emptyOutput;
        } else {
            arc.flags = (byte)2;
            arc.nextFinalOutput = this.NO_OUTPUT;
        }
        arc.output = this.NO_OUTPUT;
        arc.target = this.startNode;
        return arc;
    }

    public Arc<T> readLastTargetArc(Arc<T> follow, Arc<T> arc) throws IOException {
        if (!this.targetHasArcs(follow)) {
            assert (follow.isFinal());
            arc.label = -1;
            arc.output = follow.nextFinalOutput;
            arc.flags = (byte)2;
            return arc;
        }
        BytesReader in = this.getBytesReader(follow.target);
        arc.flags = in.readByte();
        if (arc.flag(64)) {
            arc.numArcs = in.readVInt();
            arc.bytesPerArc = in.readByte() & 0xFF;
            arc.posArcsStart = in.pos;
            arc.arcIdx = arc.numArcs - 2;
        } else {
            arc.bytesPerArc = 0;
            while (!arc.isLast()) {
                this.readLabel(in);
                if (arc.flag(16)) {
                    this.outputs.read(in);
                }
                if (arc.flag(32)) {
                    this.outputs.read(in);
                }
                if (!arc.flag(8) && !arc.flag(4)) {
                    in.pos -= 4;
                }
                arc.flags = in.readByte();
            }
            arc.nextArc = in.pos + 1;
        }
        this.readNextRealArc(arc);
        assert (arc.isLast());
        return arc;
    }

    public Arc<T> readFirstTargetArc(Arc<T> follow, Arc<T> arc) throws IOException {
        if (follow.isFinal()) {
            arc.label = -1;
            arc.output = follow.nextFinalOutput;
            if (follow.target <= 0) {
                arc.flags = (byte)2;
            } else {
                arc.flags = 0;
                arc.nextArc = follow.target;
            }
            return arc;
        }
        return this.readFirstRealArc(follow.target, arc);
    }

    Arc<T> readFirstRealArc(int address, Arc<T> arc) throws IOException {
        BytesReader in = this.getBytesReader(address);
        arc.flags = in.readByte();
        if (arc.flag(64)) {
            arc.numArcs = in.readVInt();
            arc.bytesPerArc = in.readByte() & 0xFF;
            arc.arcIdx = -1;
            arc.nextArc = arc.posArcsStart = in.pos;
        } else {
            arc.nextArc = address;
            arc.bytesPerArc = 0;
        }
        return this.readNextRealArc(arc);
    }

    boolean isExpandedTarget(Arc<T> follow) throws IOException {
        if (!this.targetHasArcs(follow)) {
            return false;
        }
        BytesReader in = this.getBytesReader(follow.target);
        byte b = in.readByte();
        return (b & 0x40) != 0;
    }

    public Arc<T> readNextArc(Arc<T> arc) throws IOException {
        if (arc.label == -1) {
            if (arc.nextArc <= 0) {
                return null;
            }
            return this.readFirstRealArc(arc.nextArc, arc);
        }
        return this.readNextRealArc(arc);
    }

    public int readNextArcLabel(Arc<T> arc) throws IOException {
        BytesReader in;
        assert (!arc.isLast());
        if (arc.label == -1) {
            in = this.getBytesReader(arc.nextArc);
            byte flags = this.bytes[in.pos];
            if (FST.flag(flags, 64)) {
                --in.pos;
                in.readVInt();
                in.readByte();
            }
        } else {
            in = arc.bytesPerArc != 0 ? this.getBytesReader(arc.posArcsStart - (1 + arc.arcIdx) * arc.bytesPerArc) : this.getBytesReader(arc.nextArc);
        }
        in.readByte();
        return this.readLabel(in);
    }

    Arc<T> readNextRealArc(Arc<T> arc) throws IOException {
        BytesReader in;
        if (arc.bytesPerArc != 0) {
            ++arc.arcIdx;
            assert (arc.arcIdx < arc.numArcs);
            in = this.getBytesReader(arc.posArcsStart - arc.arcIdx * arc.bytesPerArc);
        } else {
            in = this.getBytesReader(arc.nextArc);
        }
        arc.flags = in.readByte();
        arc.label = this.readLabel(in);
        arc.output = arc.flag(16) ? this.outputs.read(in) : this.outputs.getNoOutput();
        arc.nextFinalOutput = arc.flag(32) ? this.outputs.read(in) : this.outputs.getNoOutput();
        if (arc.flag(8)) {
            arc.target = arc.flag(1) ? -1 : 0;
            arc.nextArc = in.pos;
        } else if (arc.flag(4)) {
            arc.nextArc = in.pos;
            if (!arc.flag(2)) {
                if (arc.bytesPerArc == 0) {
                    this.seekToNextNode(in);
                } else {
                    in.pos = arc.posArcsStart - arc.bytesPerArc * arc.numArcs;
                }
            }
            arc.target = in.pos;
        } else {
            arc.target = in.readInt();
            arc.nextArc = in.pos;
        }
        return arc;
    }

    public Arc<T> findTargetArc(int labelToMatch, Arc<T> follow, Arc<T> arc) throws IOException {
        if (labelToMatch == -1) {
            if (follow.isFinal()) {
                arc.output = follow.nextFinalOutput;
                arc.label = -1;
                return arc;
            }
            return null;
        }
        if (!this.targetHasArcs(follow)) {
            return null;
        }
        BytesReader in = this.getBytesReader(follow.target);
        if ((in.readByte() & 0x40) != 0) {
            arc.numArcs = in.readVInt();
            arc.bytesPerArc = in.readByte() & 0xFF;
            arc.posArcsStart = in.pos;
            int low = 0;
            int high = arc.numArcs - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                in.pos = arc.posArcsStart - arc.bytesPerArc * mid - 1;
                int midLabel = this.readLabel(in);
                int cmp = midLabel - labelToMatch;
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                arc.arcIdx = mid - 1;
                return this.readNextRealArc(arc);
            }
            return null;
        }
        this.readFirstTargetArc(follow, arc);
        while (arc.label != labelToMatch) {
            if (arc.label > labelToMatch) {
                return null;
            }
            if (arc.isLast()) {
                return null;
            }
            this.readNextArc(arc);
        }
        return arc;
    }

    private void seekToNextNode(BytesReader in) throws IOException {
        byte flags;
        do {
            flags = in.readByte();
            this.readLabel(in);
            if (FST.flag(flags, 16)) {
                this.outputs.read(in);
            }
            if (FST.flag(flags, 32)) {
                this.outputs.read(in);
            }
            if (FST.flag(flags, 8) || FST.flag(flags, 4)) continue;
            in.readInt();
        } while (!FST.flag(flags, 2));
    }

    public int getNodeCount() {
        return 1 + this.nodeCount;
    }

    public int getArcCount() {
        return this.arcCount;
    }

    public int getArcWithOutputCount() {
        return this.arcWithOutputCount;
    }

    private boolean shouldExpand(Builder.UnCompiledNode<T> node) {
        return node.depth <= 3 && node.numArcs >= 5 || node.numArcs >= 10;
    }

    final BytesReader getBytesReader(int pos) {
        return new BytesReader(pos);
    }

    static /* synthetic */ byte[] access$002(FST x0, byte[] x1) {
        x0.bytes = x1;
        return x1;
    }

    class BytesReader
    extends DataInput {
        int pos;

        public BytesReader(int pos) {
            this.pos = pos;
        }

        public byte readByte() {
            return FST.this.bytes[this.pos--];
        }

        public void readBytes(byte[] b, int offset, int len) {
            for (int i = 0; i < len; ++i) {
                b[offset + i] = FST.this.bytes[this.pos--];
            }
        }
    }

    class BytesWriter
    extends DataOutput {
        int posWrite = 1;

        public void writeByte(byte b) {
            if (FST.this.bytes.length == this.posWrite) {
                FST.access$002(FST.this, ArrayUtil.grow(FST.this.bytes));
            }
            assert (this.posWrite < FST.this.bytes.length) : "posWrite=" + this.posWrite + " bytes.length=" + FST.access$000(FST.this).length;
            ((FST)FST.this).bytes[this.posWrite++] = b;
        }

        public void writeBytes(byte[] b, int offset, int length) {
            int size = this.posWrite + length;
            FST.access$002(FST.this, ArrayUtil.grow(FST.this.bytes, size));
            System.arraycopy(b, offset, FST.this.bytes, this.posWrite, length);
            this.posWrite += length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Arc<T> {
        public int label;
        public T output;
        int target;
        byte flags;
        T nextFinalOutput;
        int nextArc;
        int posArcsStart;
        int bytesPerArc;
        int arcIdx;
        int numArcs;

        public Arc<T> copyFrom(Arc<T> other) {
            this.label = other.label;
            this.target = other.target;
            this.flags = other.flags;
            this.output = other.output;
            this.nextFinalOutput = other.nextFinalOutput;
            this.nextArc = other.nextArc;
            if (other.bytesPerArc != 0) {
                this.bytesPerArc = other.bytesPerArc;
                this.posArcsStart = other.posArcsStart;
                this.arcIdx = other.arcIdx;
                this.numArcs = other.numArcs;
            } else {
                this.bytesPerArc = 0;
            }
            return this;
        }

        boolean flag(int flag) {
            return FST.flag(this.flags, flag);
        }

        public boolean isLast() {
            return this.flag(2);
        }

        public boolean isFinal() {
            return this.flag(1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum INPUT_TYPE {
        BYTE1,
        BYTE2,
        BYTE4;

    }
}

