/*
 * Decompiled with CFR 0.152.
 */
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;

public class PseudoTranslateStep
extends BasePipelineStep {
    private static final String OLDCHARS = "AaEeIiOoUuYyCcDdNn";
    private static final String NEWCHARS = "\u00c2\u00e5\u00c9\u00e8\u00cf\u00ec\u00d8\u00f5\u00db\u00fc\u00dd\u00ff\u00c7\u00e7\u00d0\u00f0\u00d1\u00f1";
    private LocaleId trgLoc;

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.trgLoc = targetLocale;
    }

    public String getName() {
        return "Pseudo-Translation";
    }

    public String getDescription() {
        return "Pseudo-translates text units content.";
    }

    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return event;
        }
        TextContainer tc = tu.createTarget(this.trgLoc, false, 5);
        for (Segment seg : tc.getSegments()) {
            TextFragment tf = seg.getContent();
            StringBuilder text = new StringBuilder(tf.getCodedText());
            for (int i = 0; i < text.length(); ++i) {
                if (TextFragment.isMarker((char)text.charAt(i))) {
                    ++i;
                    continue;
                }
                int n = OLDCHARS.indexOf(text.charAt(i));
                if (n <= -1) continue;
                text.setCharAt(i, NEWCHARS.charAt(n));
            }
            tf.setCodedText(text.toString());
        }
        return event;
    }
}

