/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui;

import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.ui.ClosePanel;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.Res;
import net.sf.okapi.common.ui.UIUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CharacterInfoDialog {
    private Shell shell;
    private int codePoint;
    private CLabel stRendering;
    private Text edCharacter;
    private Text edCodePoint;
    private Text edType;
    private Text edNumValue;
    private Text edIsJavaSpace;
    private Text edIsUnicodeSpace;
    private boolean settingCodePoint = false;
    private Font sampleFont;
    private IHelp help;

    protected void finalize() {
        this.dispose();
    }

    public CharacterInfoDialog(Shell parent, String captionText, IHelp helpParam) {
        this.help = helpParam;
        this.shell = new Shell(parent, 65648);
        if (captionText != null) {
            this.shell.setText(captionText);
        }
        UIUtil.inheritIcon(this.shell, parent);
        this.shell.setLayout(new GridLayout());
        Composite cmpTmp = new Composite(this.shell, 2048);
        cmpTmp.setLayoutData(new GridData(1808));
        GridLayout layTmp = new GridLayout(3, false);
        cmpTmp.setLayout(layTmp);
        this.stRendering = new CLabel(cmpTmp, 0x1000800);
        GridData gdTmp = new GridData();
        gdTmp.widthHint = 60;
        gdTmp.heightHint = 60;
        gdTmp.verticalSpan = 2;
        this.stRendering.setLayoutData(gdTmp);
        Font font = this.stRendering.getFont();
        FontData[] fontData = font.getFontData();
        fontData[0].setHeight(20);
        this.sampleFont = new Font(font.getDevice(), fontData[0]);
        this.stRendering.setFont(this.sampleFont);
        Label label = new Label(cmpTmp, 0);
        label.setText(Res.getString("charInfoDlg.codePoint"));
        this.edCodePoint = new Text(cmpTmp, 2048);
        gdTmp = new GridData();
        gdTmp.widthHint = 60;
        this.edCodePoint.setLayoutData(gdTmp);
        this.edCodePoint.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent e) {
                CharacterInfoDialog.this.updateCodePoint();
            }
        });
        label = new Label(cmpTmp, 0);
        label.setText(Res.getString("charInfoDlg.char"));
        this.edCharacter = new Text(cmpTmp, 2048);
        gdTmp = new GridData();
        gdTmp.widthHint = 30;
        this.edCharacter.setLayoutData(gdTmp);
        this.edCharacter.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent e) {
                CharacterInfoDialog.this.updateCharacter();
            }
        });
        label = new Label(cmpTmp, 0);
        label.setText(Res.getString("charInfoDlg.charType"));
        this.edType = new Text(cmpTmp, 2048);
        this.edType.setEditable(false);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.edType.setLayoutData(gdTmp);
        label = new Label(cmpTmp, 0);
        label.setText(Res.getString("charInfoDlg.numValue"));
        this.edNumValue = new Text(cmpTmp, 2048);
        this.edNumValue.setEditable(false);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.edNumValue.setLayoutData(gdTmp);
        label = new Label(cmpTmp, 0);
        label.setText(Res.getString("charInfoDlg.isWhitespace"));
        this.edIsJavaSpace = new Text(cmpTmp, 2048);
        this.edIsJavaSpace.setEditable(false);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.edIsJavaSpace.setLayoutData(gdTmp);
        label = new Label(cmpTmp, 0);
        label.setText(Res.getString("charInfoDlg.isUniWhitespace"));
        this.edIsUnicodeSpace = new Text(cmpTmp, 2048);
        this.edIsUnicodeSpace.setEditable(false);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.edIsUnicodeSpace.setLayoutData(gdTmp);
        SelectionAdapter CloseActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (e.widget.getData().equals("h")) {
                    if (CharacterInfoDialog.this.help != null) {
                        CharacterInfoDialog.this.help.showWiki("Character Information");
                    }
                    return;
                }
                CharacterInfoDialog.this.shell.close();
            }
        };
        ClosePanel pnlActions = new ClosePanel(this.shell, 0, CloseActions, this.help != null);
        pnlActions.setLayoutData(new GridData(768));
        this.shell.setDefaultButton(pnlActions.btClose);
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 450) {
            startSize.x = 450;
        }
        this.shell.setSize(startSize);
        Dialogs.centerWindow(this.shell, parent);
    }

    public void dispose() {
        if (this.sampleFont != null) {
            this.sampleFont.dispose();
            this.sampleFont = null;
        }
    }

    private void updateCodePoint() {
        try {
            if (this.settingCodePoint) {
                return;
            }
            String tmp = this.edCodePoint.getText();
            if (tmp.length() != 4) {
                return;
            }
            int cp = Integer.valueOf(tmp, 16);
            this.setCodePoint(cp);
            this.edCodePoint.setSelection(4, 4);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, Res.getString("charInfoDlg.invalidValue") + e.getMessage(), null);
        }
    }

    private void updateCharacter() {
        try {
            if (this.settingCodePoint) {
                return;
            }
            String tmp = this.edCharacter.getText();
            if (tmp.length() < 1) {
                return;
            }
            this.setCodePoint(tmp.codePointAt(0));
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, Res.getString("charInfoDlg.invalidValue") + e.getMessage(), null);
        }
    }

    private void setCodePoint(int value) {
        this.settingCodePoint = true;
        this.codePoint = value;
        this.stRendering.setText(String.format("%c", this.codePoint));
        this.edCharacter.setText(this.stRendering.getText());
        this.edCodePoint.setText(String.format("%04X", this.codePoint));
        int type = Character.getType(this.codePoint);
        switch (type) {
            case 8: {
                this.edType.setText("Mc : COMBINING_SPACING_MARK");
                break;
            }
            case 23: {
                this.edType.setText("Pc : CONNECTOR_PUNCTUATION");
                break;
            }
            case 15: {
                this.edType.setText("Cc : CONTROL");
                break;
            }
            case 26: {
                this.edType.setText("Sc : CURRENCY_SYMBOL");
                break;
            }
            case 20: {
                this.edType.setText("Pd : DASH_PUNCTUATION");
                break;
            }
            case 9: {
                this.edType.setText("Nd : DECIMAL_DIGIT_NUMBER");
                break;
            }
            case 7: {
                this.edType.setText("Me : ENCLOSING_MARK");
                break;
            }
            case 22: {
                this.edType.setText("Pe : END_PUNCTUATION");
                break;
            }
            case 30: {
                this.edType.setText("Pf : FINAL_QUOTE_PUNCTUATION");
                break;
            }
            case 16: {
                this.edType.setText("Cf : FORMAT");
                break;
            }
            case 29: {
                this.edType.setText("Pi : INITIAL_QUOTE_PUNCTUATION");
                break;
            }
            case 10: {
                this.edType.setText("Nl : LETTER_NUMBER");
                break;
            }
            case 1: {
                this.edType.setText("Lu : UPPERCASE_LETTER");
                break;
            }
            case 13: {
                this.edType.setText("Zl : LINE_SEPARATOR");
                break;
            }
            case 2: {
                this.edType.setText("Ll : LOWERCASE_LETTER");
                break;
            }
            case 25: {
                this.edType.setText("Sm : MATH_SYMBOL");
                break;
            }
            case 4: {
                this.edType.setText("Lm : MODIFIER_LETTER");
                break;
            }
            case 27: {
                this.edType.setText("Sk : MODIFIER_SYMBOL");
                break;
            }
            case 6: {
                this.edType.setText("Mn : NON_SPACING_MARK");
                break;
            }
            case 5: {
                this.edType.setText("Lo : OTHER_LETTER");
                break;
            }
            case 11: {
                this.edType.setText("No : OTHER_NUMBER");
                break;
            }
            case 24: {
                this.edType.setText("Po : OTHER_PUNCTUATION");
                break;
            }
            case 28: {
                this.edType.setText("So : OTHER_SYMBOL");
                break;
            }
            case 14: {
                this.edType.setText("Zp : PARAGRAPH_SEPARATOR");
                break;
            }
            case 18: {
                this.edType.setText("Co : PRIVATE_USE");
                break;
            }
            case 12: {
                this.edType.setText("Zs : SPACE_SEPARATOR");
                break;
            }
            case 21: {
                this.edType.setText("Ps : START_PUNCTUATION");
                break;
            }
            case 19: {
                this.edType.setText("Cs : SURROGATE");
                break;
            }
            case 3: {
                this.edType.setText("Lt : TITLECASE_LETTER");
                break;
            }
            case 0: {
                this.edType.setText("Cn : UNASSIGNED");
            }
        }
        this.edIsJavaSpace.setText(Character.isWhitespace(this.codePoint) ? Res.getString("charInfoDlg.yes") : Res.getString("charInfoDlg.no"));
        this.edIsUnicodeSpace.setText(Character.isSpaceChar(this.codePoint) ? Res.getString("charInfoDlg.yes") : Res.getString("charInfoDlg.no"));
        this.edNumValue.setText(String.valueOf(Character.getNumericValue(this.codePoint)));
        this.settingCodePoint = false;
    }

    public void showDialog(int codePoint) {
        this.setCodePoint(codePoint);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }
}

