/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.segmentation;

import java.io.File;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.lib.ui.segmentation.Res;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileProcessingDialog {
    private Shell shell;
    private Text edInput;
    private Text edOutput;
    private Button chkHtmlOutput;
    private String[] result = null;
    private IHelp help;

    public FileProcessingDialog(Shell parent, IHelp helpParam) {
        this.help = helpParam;
        this.shell = new Shell(parent, 65648);
        this.shell.setText(Res.getString("testFileDlg.caption"));
        UIUtil.inheritIcon(this.shell, parent);
        this.shell.setLayout(new GridLayout());
        Composite cmpTmp = new Composite(this.shell, 2048);
        cmpTmp.setLayout(new GridLayout(2, false));
        GridData gdTmp = new GridData(768);
        cmpTmp.setLayoutData(gdTmp);
        Label label = new Label(cmpTmp, 0);
        label.setText(Res.getString("testFileDlg.inputPath"));
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        label.setLayoutData(gdTmp);
        this.edInput = new Text(cmpTmp, 2052);
        gdTmp = new GridData(768);
        this.edInput.setLayoutData(gdTmp);
        Button btGetInput = new Button(cmpTmp, 8);
        btGetInput.setText("...");
        btGetInput.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String[] paths = Dialogs.browseFilenames(FileProcessingDialog.this.shell, Res.getString("testFileDlg.getInputCaption"), false, Util.getDirectoryName((String)FileProcessingDialog.this.edInput.getText()), Res.getString("testFileDlg.getInputFileTypes"), Res.getString("testFileDlg.getInputFilter"));
                if (paths == null) {
                    return;
                }
                FileProcessingDialog.this.edInput.setText(paths[0]);
                FileProcessingDialog.this.edInput.selectAll();
                FileProcessingDialog.this.edInput.setFocus();
                FileProcessingDialog.this.updateOutputPath();
            }
        });
        label = new Label(cmpTmp, 0);
        label.setText(Res.getString("testFileDlg.outputPath"));
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        label.setLayoutData(gdTmp);
        this.edOutput = new Text(cmpTmp, 2052);
        gdTmp = new GridData(768);
        this.edOutput.setLayoutData(gdTmp);
        Button btGetOutput = new Button(cmpTmp, 8);
        btGetOutput.setText("...");
        btGetOutput.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String path = Dialogs.browseFilenamesForSave(FileProcessingDialog.this.shell, Res.getString("testFileDlg.getOutputCaption"), FileProcessingDialog.this.edInput.getText(), null, Res.getString("testFileDlg.getOutputFileTypes"), Res.getString("testFileDlg.getOutputFilter"));
                if (path == null) {
                    return;
                }
                FileProcessingDialog.this.edOutput.setText(path);
                FileProcessingDialog.this.edOutput.selectAll();
                FileProcessingDialog.this.edOutput.setFocus();
            }
        });
        this.chkHtmlOutput = new Button(cmpTmp, 32);
        this.chkHtmlOutput.setText(Res.getString("testFileDlg.createHTML"));
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkHtmlOutput.setLayoutData(gdTmp);
        this.chkHtmlOutput.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                FileProcessingDialog.this.updateOutputPath();
            }
        });
        SelectionAdapter okCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                FileProcessingDialog.access$402(FileProcessingDialog.this, null);
                if (e.widget.getData().equals("h")) {
                    if (FileProcessingDialog.this.help != null) {
                        FileProcessingDialog.this.help.showWiki("Ratel - Test Segmentation on a File");
                    }
                    return;
                }
                if (e.widget.getData().equals("o") && !FileProcessingDialog.this.saveData()) {
                    return;
                }
                FileProcessingDialog.this.shell.close();
            }
        };
        OKCancelPanel pnlActions = new OKCancelPanel(this.shell, 0, okCancelActions, true);
        pnlActions.setLayoutData(new GridData(768));
        this.shell.setDefaultButton(pnlActions.btOK);
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 600) {
            startSize.x = 600;
        }
        this.shell.setSize(startSize);
        Dialogs.centerWindow(this.shell, parent);
    }

    public String[] showDialog(String inputPath, String outputPath, boolean htmlOutput) {
        this.shell.open();
        if (inputPath != null) {
            this.edInput.setText(inputPath);
        }
        if (outputPath != null) {
            this.edOutput.setText(outputPath);
        }
        this.chkHtmlOutput.setSelection(htmlOutput);
        this.updateOutputPath();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private boolean saveData() {
        try {
            this.result = null;
            if (this.edInput.getText().length() == 0) {
                this.edInput.selectAll();
                this.edInput.setFocus();
                return false;
            }
            if (this.edOutput.getText().length() == 0) {
                this.edOutput.selectAll();
                this.edOutput.setFocus();
                return false;
            }
            this.result = new String[3];
            this.result[0] = this.edInput.getText();
            this.result[1] = this.edOutput.getText();
            this.result[2] = this.chkHtmlOutput.getSelection() ? "html" : null;
            return true;
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
            return false;
        }
    }

    private String makeHtmlOutputPath(String inputPath) {
        if (inputPath.length() == 0) {
            return "";
        }
        return inputPath + ".html";
    }

    private String makeNonHtmlOutputPath(String inputPath) {
        if (inputPath.length() == 0) {
            return "";
        }
        String ext = Util.getExtension((String)inputPath);
        String filename = Util.getFilename((String)inputPath, (boolean)false);
        return Util.getDirectoryName((String)inputPath) + File.separator + filename + Res.getString("testFileDlg.outputExtension") + ext;
    }

    private void updateOutputPath() {
        if (this.chkHtmlOutput.getSelection()) {
            this.edOutput.setText(this.makeHtmlOutputPath(this.edInput.getText()));
        } else {
            this.edOutput.setText(this.makeNonHtmlOutputPath(this.edInput.getText()));
        }
    }

    static /* synthetic */ String[] access$402(FileProcessingDialog x0, String[] x1) {
        x0.result = x1;
        return x1;
    }
}

