/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.html;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.LinkedHashMap;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.StreamedSource;
import net.htmlparser.jericho.Tag;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UnicodeBOMWriter;
import net.sf.okapi.common.resource.RawDocument;

class StreamedSourceCopy {
    StreamedSourceCopy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RawDocument htmlTidiedRewrite(RawDocument input, boolean documentEncoding, String encoding, boolean hasBOM) throws IOException {
        LocaleId locale = input.getSourceLocale();
        File t = File.createTempFile("~okapi-html-filter-preprocess", ".sourceTemp");
        URI tempUri = t.toURI();
        boolean needEncodingDeclaration = !documentEncoding;
        boolean isXHTML = false;
        Writer writer = null;
        StreamedSource streamedSource = null;
        try {
            if (input.getEncoding() == "null") {
                input.setEncoding(encoding);
            }
            streamedSource = new StreamedSource(input.getReader());
            writer = hasBOM ? new UnicodeBOMWriter(new FileOutputStream(new File(tempUri.getPath())), encoding) : new OutputStreamWriter((OutputStream)new FileOutputStream(new File(tempUri.getPath())), encoding);
            int lastSegmentEnd = 0;
            for (Segment segment : streamedSource) {
                Tag tag;
                if (segment.getEnd() <= lastSegmentEnd) continue;
                lastSegmentEnd = segment.getEnd();
                if (segment instanceof Tag && (tag = (Tag)segment) instanceof StartTag) {
                    StartTag st = (StartTag)tag;
                    if (StreamedSourceCopy.tagHasUnquotedAttribute(st)) {
                        LinkedHashMap<String, String> attributesMap = new LinkedHashMap<String, String>();
                        writer.write(StartTag.generateHTML(st.getNameSegment().toString(), st.getAttributes().populateMap(attributesMap, false), st.isSyntacticalEmptyElementTag()));
                    } else {
                        writer.write(st.toString());
                    }
                    if (!needEncodingDeclaration) continue;
                    if (st.getName() == "html") {
                        Attributes attrs = st.getAttributes();
                        for (int i = 0; i < attrs.getCount(); ++i) {
                            String xmlns;
                            String name = attrs.get(i).getName();
                            if (!name.equals("xmlns") && !name.startsWith("xmlns:") || (xmlns = st.getAttributeValue(name)) == null) continue;
                            if (xmlns.equals("http://www.w3.org/1999/xhtml")) {
                                isXHTML = true;
                                continue;
                            }
                            needEncodingDeclaration = false;
                        }
                        continue;
                    }
                    if (st.getName() != "head") continue;
                    writer.write(String.format("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\"%s>", input.getEncoding() == "null" ? encoding : input.getEncoding(), isXHTML ? " /" : ""));
                    needEncodingDeclaration = false;
                    continue;
                }
                writer.write(segment.toString());
            }
            RawDocument rawDocument = new RawDocument(tempUri, encoding, locale);
            return rawDocument;
        }
        finally {
            input.close();
            if (streamedSource != null) {
                streamedSource.close();
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private static boolean tagHasUnquotedAttribute(StartTag tag) {
        if (tag.getAttributes() != null && !tag.getAttributes().isEmpty() && tag.getTagType() != StartTagType.XML_DECLARATION && tag.getTagType() != StartTagType.DOCTYPE_DECLARATION && tag.getTagType() != StartTagType.XML_PROCESSING_INSTRUCTION) {
            for (Attribute att : tag.getAttributes()) {
                if (att.getQuoteChar() != ' ') continue;
                return true;
            }
        }
        return false;
    }
}

