/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.DesignMap;
import net.sf.okapi.filters.idml.Layer;
import net.sf.okapi.filters.idml.Namespaces;
import net.sf.okapi.filters.idml.ParsingIdioms;

class DesignMapParser {
    private static final QName DOCUMENT = Namespaces.getDefaultNamespace().getQName("Document");
    private static final QName STORY_LIST = Namespaces.getDefaultNamespace().getQName("StoryList");
    private static final QName ACTIVE_LAYER = Namespaces.getDefaultNamespace().getQName("ActiveLayer");
    private static final QName SRC = Namespaces.getDefaultNamespace().getQName("src");
    private static final QName GRAPHIC = Namespaces.getIdPackageNamespace().getQName("Graphic");
    private static final QName FONTS = Namespaces.getIdPackageNamespace().getQName("Fonts");
    private static final QName STYLES = Namespaces.getIdPackageNamespace().getQName("Styles");
    private static final QName PREFERENCES = Namespaces.getIdPackageNamespace().getQName("Preferences");
    private static final QName TAGS = Namespaces.getIdPackageNamespace().getQName("Tags");
    private static final QName LAYER = Namespaces.getDefaultNamespace().getQName("Layer");
    private static final QName MASTER_SPREAD = Namespaces.getIdPackageNamespace().getQName("MasterSpread");
    private static final QName SPREAD = Namespaces.getIdPackageNamespace().getQName("Spread");
    private static final QName BACKING_STORY = Namespaces.getIdPackageNamespace().getQName("BackingStory");
    private static final QName STORY = Namespaces.getIdPackageNamespace().getQName("Story");
    private final Reader reader;
    private final XMLInputFactory inputFactory;

    DesignMapParser(Reader reader, XMLInputFactory inputFactory) {
        this.reader = reader;
        this.inputFactory = inputFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DesignMap parse() throws XMLStreamException, IOException {
        XMLEventReader eventReader = this.inputFactory.createXMLEventReader(this.reader);
        DesignMap.DesignMapBuilder designMapBuilder = new DesignMap.DesignMapBuilder();
        try {
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement()) continue;
                StartElement element = event.asStartElement();
                if (DOCUMENT.equals(element.getName())) {
                    designMapBuilder = this.parseDocument(element, designMapBuilder);
                    continue;
                }
                if (GRAPHIC.equals(element.getName())) {
                    designMapBuilder.setGraphicPartName(element.getAttributeByName(SRC).getValue());
                    continue;
                }
                if (FONTS.equals(element.getName())) {
                    designMapBuilder.setFontsPartName(element.getAttributeByName(SRC).getValue());
                    continue;
                }
                if (STYLES.equals(element.getName())) {
                    designMapBuilder.setStylesPartName(element.getAttributeByName(SRC).getValue());
                    continue;
                }
                if (PREFERENCES.equals(element.getName())) {
                    designMapBuilder.setPreferencesPartName(element.getAttributeByName(SRC).getValue());
                    continue;
                }
                if (TAGS.equals(element.getName())) {
                    designMapBuilder.setTagsPartName(element.getAttributeByName(SRC).getValue());
                    continue;
                }
                if (LAYER.equals(element.getName())) {
                    designMapBuilder = this.parseLayer(element, designMapBuilder);
                    continue;
                }
                if (MASTER_SPREAD.equals(element.getName())) {
                    designMapBuilder.addMasterSpreadPartName(element.getAttributeByName(SRC).getValue());
                    continue;
                }
                if (SPREAD.equals(element.getName())) {
                    designMapBuilder.addSpreadPartName(element.getAttributeByName(SRC).getValue());
                    continue;
                }
                if (BACKING_STORY.equals(element.getName())) {
                    designMapBuilder.setBackingStoryPartName(element.getAttributeByName(SRC).getValue());
                    continue;
                }
                if (!STORY.equals(element.getName())) continue;
                designMapBuilder.addStoryPartName(element.getAttributeByName(SRC).getValue());
            }
        }
        finally {
            this.reader.close();
        }
        return designMapBuilder.build();
    }

    private DesignMap.DesignMapBuilder parseDocument(StartElement element, DesignMap.DesignMapBuilder designMapBuilder) {
        designMapBuilder.setId(element.getAttributeByName(ParsingIdioms.SELF).getValue());
        designMapBuilder.setStoryIds(Arrays.asList(element.getAttributeByName(STORY_LIST).getValue().split(" ")));
        designMapBuilder.setActiveLayerId(element.getAttributeByName(ACTIVE_LAYER).getValue());
        return designMapBuilder;
    }

    private DesignMap.DesignMapBuilder parseLayer(StartElement element, DesignMap.DesignMapBuilder designMapBuilder) {
        return designMapBuilder.addLayer(new Layer(element.getAttributeByName(ParsingIdioms.SELF).getValue(), Boolean.parseBoolean(element.getAttributeByName(ParsingIdioms.VISIBLE).getValue())));
    }
}

