/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String MAX_ATTRIBUTE_SIZE = "maxAttributeSize";
    private static final String UNTAG_XML_STRUCTURES = "untagXmlStructures";
    private static final String EXTRACT_NOTES = "extractNotes";
    private static final String EXTRACT_MASTER_SPREADS = "extractMasterSpreads";
    private static final String EXTRACT_HIDDEN_LAYERS = "extractHiddenLayers";

    @Override
    public void reset() {
        super.reset();
        this.setMaxAttributeSize(0x400000);
        this.setUntagXmlStructures(true);
        this.setExtractNotes(false);
        this.setExtractMasterSpreads(true);
        this.setExtractHiddenLayers(false);
    }

    public int getMaxAttributeSize() {
        return this.getInteger(MAX_ATTRIBUTE_SIZE);
    }

    public void setMaxAttributeSize(int maxAttributeSize) {
        this.setInteger(MAX_ATTRIBUTE_SIZE, maxAttributeSize);
    }

    public boolean getUntagXmlStructures() {
        return this.getBoolean(UNTAG_XML_STRUCTURES);
    }

    public void setUntagXmlStructures(boolean untagXmlStructures) {
        this.setBoolean(UNTAG_XML_STRUCTURES, untagXmlStructures);
    }

    public boolean getExtractNotes() {
        return this.getBoolean(EXTRACT_NOTES);
    }

    public void setExtractNotes(boolean extractNotes) {
        this.setBoolean(EXTRACT_NOTES, extractNotes);
    }

    public boolean getExtractMasterSpreads() {
        return this.getBoolean(EXTRACT_MASTER_SPREADS);
    }

    public void setExtractMasterSpreads(boolean extractMasterSpreads) {
        this.setBoolean(EXTRACT_MASTER_SPREADS, extractMasterSpreads);
    }

    public boolean getExtractHiddenLayers() {
        return this.getBoolean(EXTRACT_HIDDEN_LAYERS);
    }

    public void setExtractHiddenLayers(boolean extractHiddenLayers) {
        this.setBoolean(EXTRACT_HIDDEN_LAYERS, extractHiddenLayers);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(UNTAG_XML_STRUCTURES, "Untag XML structures", null);
        desc.add(EXTRACT_NOTES, "Extract notes", null);
        desc.add(EXTRACT_MASTER_SPREADS, "Extract master spreads", null);
        desc.add(EXTRACT_HIDDEN_LAYERS, "Extract hidden layers", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("IDML Filter", true, false);
        desc.addCheckboxPart(paramsDesc.get(UNTAG_XML_STRUCTURES));
        desc.addCheckboxPart(paramsDesc.get(EXTRACT_NOTES));
        desc.addCheckboxPart(paramsDesc.get(EXTRACT_MASTER_SPREADS));
        desc.addCheckboxPart(paramsDesc.get(EXTRACT_HIDDEN_LAYERS));
        return desc;
    }
}

