/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.Story;
import net.sf.okapi.filters.idml.StoryEventsAccumulator;
import net.sf.okapi.filters.idml.StoryParser;
import net.sf.okapi.filters.idml.SubDocument;

class StorySubDocument
implements SubDocument {
    private static final String MIME_TYPE = "text/xml";
    private final ZipFile zipFile;
    private final ZipEntry zipEntry;
    private final String parentId;
    private final String id;
    private final Parameters parameters;
    private final XMLInputFactory inputFactory;
    private final XMLEventFactory eventFactory;
    private Iterator<Event> eventsIterator;

    StorySubDocument(ZipFile zipFile, ZipEntry zipEntry, String parentId, String id, Parameters parameters, XMLInputFactory inputFactory, XMLEventFactory eventFactory) {
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
        this.parentId = parentId;
        this.id = id;
        this.parameters = parameters;
        this.inputFactory = inputFactory;
        this.eventFactory = eventFactory;
    }

    @Override
    public ZipFile getZipFile() {
        return this.zipFile;
    }

    @Override
    public ZipEntry getZipEntry() {
        return this.zipEntry;
    }

    @Override
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Event open() throws IOException, XMLStreamException {
        XMLEventReader eventReader = this.inputFactory.createXMLEventReader(new InputStreamReader((InputStream)new BufferedInputStream(this.zipFile.getInputStream(this.zipEntry)), StandardCharsets.UTF_8));
        IdGenerator documentPartIdGenerator = new IdGenerator(this.zipEntry.getName(), "dp");
        IdGenerator textUnitIdGenerator = new IdGenerator(this.zipEntry.getName(), "tu");
        try {
            Story story = new StoryParser(this.parameters, this.eventFactory, eventReader).parse();
            List<Event> events = new StoryEventsAccumulator(story, this.parameters, this.eventFactory, documentPartIdGenerator, textUnitIdGenerator).accumulate();
            events.add(new Event(EventType.END_DOCUMENT, new Ending(this.id)));
            this.eventsIterator = events.iterator();
        }
        finally {
            if (eventReader != null) {
                eventReader.close();
            }
        }
        return this.createStartSubDocumentEvent();
    }

    protected Event createStartSubDocumentEvent() {
        StartSubDocument sd = new StartSubDocument(this.parentId, this.id);
        sd.setName(this.zipEntry.getName());
        sd.setMimeType(MIME_TYPE);
        ZipSkeleton zs = new ZipSkeleton(this.zipFile, this.zipEntry);
        sd.setSkeleton(zs);
        sd.setFilterParameters(this.parameters);
        return new Event(EventType.START_SUBDOCUMENT, sd);
    }

    @Override
    public boolean hasNextEvent() {
        return this.eventsIterator.hasNext();
    }

    @Override
    public Event nextEvent() {
        return this.eventsIterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
    }
}

