/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.MarkupComponentParser;
import net.sf.okapi.filters.openxml.MarkupZipSkeleton;
import net.sf.okapi.filters.openxml.NonTranslatablePartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class ClarifiablePartHandler
extends NonTranslatablePartHandler {
    ClarifiablePartHandler(OpenXMLZipFile zipFile, ZipEntry entry) {
        super(zipFile, entry);
    }

    @Override
    public Event open(String documentId, String subDocumentId, LocaleId srcLang) throws IOException, XMLStreamException {
        XMLEventReader xmlEventReader = this.getZipFile().getInputFactory().createXMLEventReader(new InputStreamReader((InputStream)new BufferedInputStream(this.getInputStream()), StandardCharsets.UTF_8));
        return this.open(xmlEventReader);
    }

    public Event open(InputStream is) throws IOException, XMLStreamException {
        XMLEventReader xmlEventReader = XMLInputFactory.newInstance().createXMLEventReader(new InputStreamReader((InputStream)new BufferedInputStream(is), StandardCharsets.UTF_8));
        return this.open(xmlEventReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event open(XMLEventReader xmlEventReader) throws XMLStreamException {
        DocumentPart documentPart;
        try {
            documentPart = this.handlePart(xmlEventReader);
        }
        finally {
            if (null != xmlEventReader) {
                xmlEventReader.close();
            }
        }
        return new Event(EventType.DOCUMENT_PART, documentPart);
    }

    private InputStream getInputStream() throws IOException, XMLStreamException {
        String modifiedContent = this.getModifiedContent();
        return null == modifiedContent ? this.getZipFile().getInputStream(this.getEntry()) : new ByteArrayInputStream(modifiedContent.getBytes(StandardCharsets.UTF_8));
    }

    private DocumentPart handlePart(XMLEventReader xmlEventReader) throws XMLStreamException {
        MarkupBuilder markupBuilder = new MarkupBuilder();
        while (xmlEventReader.hasNext()) {
            XMLEvent event = xmlEventReader.nextEvent();
            if (XMLEventHelpers.isPresentationStartEvent(event) || XMLEventHelpers.isSheetViewStartEvent(event)) {
                markupBuilder.addMarkupComponent(MarkupComponentFactory.createStartMarkupComponent(this.getZipFile().getEventFactory(), event.asStartElement()));
                continue;
            }
            if (XMLEventHelpers.isPresentationEndEvent(event) || XMLEventHelpers.isSheetViewEndEvent(event)) {
                markupBuilder.addMarkupComponent(MarkupComponentFactory.createEndMarkupComponent(event.asEndElement()));
                continue;
            }
            if (XMLEventHelpers.isAlignmentStartEvent(event)) {
                markupBuilder.addMarkupComponent(MarkupComponentParser.parseEmptyElementMarkupComponent(xmlEventReader, this.getZipFile().getEventFactory(), event.asStartElement()));
                continue;
            }
            markupBuilder.addEvent(event);
        }
        DocumentPart documentPart = new DocumentPart(this.getEntry().getName(), false);
        documentPart.setSkeleton(new MarkupZipSkeleton(this.getZipFile().getZip(), this.getEntry(), markupBuilder.build()));
        return documentPart;
    }

    private static class MarkupBuilder {
        private List<XMLEvent> events = new ArrayList<XMLEvent>();
        private Markup markup = new Block.BlockMarkup();

        private MarkupBuilder() {
        }

        void addEvent(XMLEvent event) {
            this.events.add(event);
        }

        void addMarkupComponent(MarkupComponent markupComponent) {
            this.flushEvents();
            this.markup.addComponent(markupComponent);
        }

        private void flushEvents() {
            if (!this.events.isEmpty()) {
                this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.events));
                this.events = new ArrayList<XMLEvent>();
            }
        }

        Markup build() {
            this.flushEvents();
            return this.markup;
        }
    }
}

