/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import net.sf.okapi.filters.openxml.ClarificationParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentClarifierStrategy;
import net.sf.okapi.filters.openxml.MarkupComponentClarifierStrategyFactory;

class MarkupComponentClarifier {
    private MarkupComponentClarifierStrategy strategy;

    MarkupComponentClarifier(MarkupComponentClarifierStrategy strategy) {
        this.strategy = strategy;
    }

    void clarify(MarkupComponent markupComponent) {
        this.strategy.clarifyMarkupComponent(markupComponent);
    }

    static class AlignmentClarifier
    extends MarkupComponentClarifier {
        AlignmentClarifier(CreationalParameters creationalParameters, ClarificationParameters clarificationParameters) {
            super(MarkupComponentClarifierStrategyFactory.createAlignmentMarkupComponentClarifierStrategy(creationalParameters, clarificationParameters));
        }
    }

    static class SheetViewClarifier
    extends MarkupComponentClarifier {
        SheetViewClarifier(CreationalParameters creationalParameters, ClarificationParameters clarificationParameters) {
            super(MarkupComponentClarifierStrategyFactory.createSheetViewMarkupComponentClarifierStrategy(creationalParameters, clarificationParameters));
        }
    }

    static class PresentationClarifier
    extends MarkupComponentClarifier {
        PresentationClarifier(CreationalParameters creationalParameters, ClarificationParameters clarificationParameters) {
            super(MarkupComponentClarifierStrategyFactory.createPresentationMarkupComponentClarifierStrategy(creationalParameters, clarificationParameters));
        }
    }
}

