/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.ElementSkipperFactory;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.Textual;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class RunBuilder {
    private StartElementContext startElementContext;
    private EndElement endEvent;
    private RunProperties runProperties = RunProperties.emptyRunProperties();
    private RunProperties combinedRunProperties;
    private List<Chunk> runBodyChunks = new ArrayList<Chunk>();
    private List<Textual> nestedTextualItems = new ArrayList<Textual>();
    private boolean isHidden = false;
    private QName textName;
    private String runStyle;
    private boolean containsNestedItems = false;
    private boolean hasComplexCodes;
    private StyleDefinitions styleDefinitions;
    private boolean isTextPreservingWhitespace = false;
    private List<XMLEvent> currentMarkupChunk = new ArrayList<XMLEvent>();
    private boolean hasAnyText = false;
    private boolean hasNonWhitespaceText = false;
    private StringBuilder textContent = new StringBuilder();
    private ElementSkipper elementSkipper;
    private ElementSkipper softHyphenElementSkipper;
    private ElementSkipper alternateContentFallbackElementSkipper;

    RunBuilder(StartElementContext startElementContext, StyleDefinitions styleDefinitions) {
        this.startElementContext = startElementContext;
        this.styleDefinitions = styleDefinitions;
        this.elementSkipper = ElementSkipperFactory.createGeneralElementSkipper(startElementContext.getConditionalParameters(), new ElementSkipper.SkippableElement[0]);
        this.softHyphenElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(startElementContext.getConditionalParameters(), ElementSkipper.GeneralInlineSkippableElement.SOFT_HYPHEN);
        this.alternateContentFallbackElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(startElementContext.getConditionalParameters(), ElementSkipper.GeneralInlineSkippableElement.ALTERNATE_CONTENT_FALLBACK);
    }

    StartElementContext getStartElementContext() {
        return this.startElementContext;
    }

    void setEndEvent(EndElement endEvent) {
        this.endEvent = endEvent;
    }

    List<Chunk> getRunBodyChunks() {
        return this.runBodyChunks;
    }

    RunProperties getRunProperties() {
        return this.runProperties;
    }

    void setRunProperties(RunProperties runProperties) {
        this.runProperties = runProperties;
    }

    RunProperties getCombinedRunProperties(String paragraphStyle) {
        if (null == this.combinedRunProperties) {
            this.resetCombinedRunProperties(paragraphStyle);
        }
        return this.combinedRunProperties;
    }

    void resetCombinedRunProperties(String paragraphStyle) {
        this.combinedRunProperties = this.styleDefinitions.getCombinedRunProperties(paragraphStyle, this.runStyle, this.runProperties);
    }

    List<Textual> getNestedTextualItems() {
        return this.nestedTextualItems;
    }

    void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    QName getTextName() {
        return this.textName;
    }

    String getRunStyle() {
        return this.runStyle;
    }

    void setRunStyle(String runStyle) {
        this.runStyle = runStyle;
    }

    boolean containsNestedItems() {
        return this.containsNestedItems;
    }

    void setContainsNestedItems(boolean containsNestedItems) {
        this.containsNestedItems = containsNestedItems;
    }

    boolean hasComplexCodes() {
        return this.hasComplexCodes;
    }

    void setHasComplexCodes(boolean hasComplexCodes) {
        this.hasComplexCodes = hasComplexCodes;
    }

    StyleDefinitions getStyleDefinitions() {
        return this.styleDefinitions;
    }

    boolean isTextPreservingWhitespace() {
        return this.isTextPreservingWhitespace;
    }

    void setTextPreservingWhitespace(boolean textPreservingWhitespace) {
        this.isTextPreservingWhitespace = textPreservingWhitespace;
    }

    boolean hasNonWhitespaceText() {
        return this.hasNonWhitespaceText;
    }

    Block.BlockChunk build() throws XMLStreamException {
        return new Run(this.startElementContext.getStartElement(), this.endEvent, this.runProperties, this.combinedRunProperties, this.runBodyChunks, this.nestedTextualItems, this.isHidden);
    }

    void addRunBody(XMLEvent e, XMLEventReader eventReader) throws XMLStreamException {
        if (XMLEventHelpers.isTextStartEvent(e)) {
            this.flushMarkupChunk();
            this.processText(e.asStartElement(), eventReader);
        } else if (this.startElementContext.getConditionalParameters().getAddTabAsCharacter() && XMLEventHelpers.isTabStartEvent(e) && !this.isHidden) {
            this.flushMarkupChunk();
            this.addRawText("\t", e.asStartElement());
            this.elementSkipper.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), eventReader, null, this.startElementContext.getConditionalParameters()));
        } else if (this.startElementContext.getConditionalParameters().getAddLineSeparatorCharacter() && XMLEventHelpers.isLineBreakStartEvent(e) && !XMLEventHelpers.isPageBreak(e.asStartElement()) && !this.isHidden) {
            this.flushMarkupChunk();
            char replacement = this.startElementContext.getConditionalParameters().getLineSeparatorReplacement();
            this.addRawText(String.valueOf(replacement), e.asStartElement());
            this.elementSkipper.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), eventReader, null, this.startElementContext.getConditionalParameters()));
        } else if (e.isStartElement() && this.isStrippableRunBodyElement(e.asStartElement())) {
            this.elementSkipper.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), eventReader, null, this.startElementContext.getConditionalParameters()));
        } else if (this.startElementContext.getConditionalParameters().getReplaceNoBreakHyphenTag() && XMLEventHelpers.isNoBreakHyphenStartEvent(e)) {
            this.flushMarkupChunk();
            this.addRawText("-", e.asStartElement());
            this.elementSkipper.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), eventReader, null, this.startElementContext.getConditionalParameters()));
        } else if (this.startElementContext.getConditionalParameters().getIgnoreSoftHyphenTag() && e.isStartElement() && this.softHyphenElementSkipper.canSkip(e.asStartElement(), this.startElementContext.getStartElement())) {
            this.softHyphenElementSkipper.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), eventReader, null, this.startElementContext.getConditionalParameters()));
        } else if (e.isStartElement() && this.alternateContentFallbackElementSkipper.canSkip(e.asStartElement(), this.startElementContext.getStartElement())) {
            this.alternateContentFallbackElementSkipper.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), eventReader, null, this.startElementContext.getConditionalParameters()));
        } else if (!XMLEventHelpers.isWhitespace(e) || this.inPreservingWhitespaceElement()) {
            this.flushText();
            this.isTextPreservingWhitespace = false;
            this.addToMarkupChunk(e);
        }
    }

    String getRunText() {
        for (Chunk chunk : this.getRunBodyChunks()) {
            if (!(chunk instanceof Run.RunText)) continue;
            return ((Run.RunText)chunk).getText();
        }
        return null;
    }

    private boolean inPreservingWhitespaceElement() {
        XMLEvent e;
        return this.currentMarkupChunk.size() > 0 && (e = this.currentMarkupChunk.get(this.currentMarkupChunk.size() - 1)) instanceof StartElement && XMLEventHelpers.hasPreserveWhitespace(e.asStartElement());
    }

    private void processText(StartElement startEvent, XMLEventReader events) throws XMLStreamException {
        this.hasAnyText = true;
        boolean bl = this.isTextPreservingWhitespace = this.isTextPreservingWhitespace || XMLEventHelpers.hasPreserveWhitespace(startEvent);
        if (this.textName == null) {
            this.textName = startEvent.getName();
        }
        while (events.hasNext()) {
            XMLEvent e = events.nextEvent();
            if (XMLEventHelpers.isEndElement(e, startEvent)) {
                return;
            }
            if (!e.isCharacters()) continue;
            String text = e.asCharacters().getData();
            if (text.trim().length() > 0) {
                this.hasNonWhitespaceText = true;
            }
            this.textContent.append(text);
        }
    }

    void flushText() {
        if (this.hasAnyText) {
            this.runBodyChunks.add(new Run.RunText(this.createTextStart(), this.startElementContext.getEventFactory().createCharacters(this.textContent.toString()), this.startElementContext.getEventFactory().createEndElement(this.textName, null)));
            this.textContent.setLength(0);
            this.hasAnyText = false;
        }
    }

    private StartElement createTextStart() {
        return this.startElementContext.getEventFactory().createStartElement(this.textName, this.isTextPreservingWhitespace && !Namespaces.DrawingML.containsName(this.textName) ? Collections.singleton(this.startElementContext.getEventFactory().createAttribute("xml", Namespaces.XML.getURI(), "space", "preserve")).iterator() : null, null);
    }

    private boolean isStrippableRunBodyElement(StartElement el) {
        return el.getName().equals(XMLEventHelpers.CACHED_PAGE_BREAK);
    }

    private void addRawText(String text, StartElement startElement) throws XMLStreamException {
        this.hasAnyText = true;
        this.textContent.append(text);
        if (this.textName == null) {
            this.textName = XMLEventHelpers.createQName("t", startElement.getName());
        }
    }

    void addToMarkupChunk(XMLEvent event) {
        this.currentMarkupChunk.add(event);
    }

    void flushMarkupChunk() {
        if (this.currentMarkupChunk.size() > 0) {
            this.runBodyChunks.add(new Run.RunMarkup().addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.currentMarkupChunk)));
            this.currentMarkupChunk = new ArrayList<XMLEvent>();
        }
    }

    public String toString() {
        try {
            return "RunBuilder for " + this.build().toString();
        }
        catch (XMLStreamException e) {
            return "RunBuilder (" + e.getMessage() + ")";
        }
    }
}

