/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.okapi.filters.openxml.ClarificationParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.RunPropertyFactory;

class RunPropertiesClarifier {
    private static final int DEFAULT_ATTRIBUTES_SIZE = 1;
    private CreationalParameters creationalParameters;
    private ClarificationParameters clarificationParameters;

    RunPropertiesClarifier(CreationalParameters creationalParameters, ClarificationParameters clarificationParameters) {
        this.creationalParameters = creationalParameters;
        this.clarificationParameters = clarificationParameters;
    }

    RunProperties clarify(RunProperties runProperties) {
        if (null == runProperties) {
            if (!this.clarificationParameters.shouldBeBidirectional()) {
                return null;
            }
            return this.addBidirectionalAndLangRunProperties(null);
        }
        Iterator<RunProperty> iterator = runProperties.getProperties().iterator();
        while (iterator.hasNext()) {
            RunProperty runProperty = iterator.next();
            if (!"rtl".equals(runProperty.getName().getLocalPart())) continue;
            if (!this.clarificationParameters.shouldBeBidirectional()) {
                return this.removeRunProperty(runProperties, iterator);
            }
            return this.addLangRunProperty(runProperties);
        }
        if (this.clarificationParameters.shouldBeBidirectional()) {
            return this.addBidirectionalAndLangRunProperties(runProperties);
        }
        return runProperties;
    }

    private RunProperties addBidirectionalAndLangRunProperties(RunProperties runProperties) {
        runProperties = this.addRunProperty(runProperties, "rtl", Collections.emptyMap());
        return this.addLangRunProperty(runProperties);
    }

    private RunProperties addLangRunProperty(RunProperties runProperties) {
        if (!this.clarificationParameters.shouldEntailBidirectionalLang()) {
            return runProperties;
        }
        HashMap<String, String> attributes = new HashMap<String, String>(1);
        attributes.put("bidi", this.clarificationParameters.getBidirectionalLang());
        return this.addRunProperty(runProperties, "lang", attributes);
    }

    private RunProperties addRunProperty(RunProperties runProperties, String localName, Map<String, String> attributes) {
        if (null == runProperties) {
            runProperties = RunProperties.defaultRunProperties(this.creationalParameters.getEventFactory().createStartElement(this.creationalParameters.getPrefix(), this.creationalParameters.getNamespaceUri(), "rPr"), this.creationalParameters.getEventFactory().createEndElement(this.creationalParameters.getPrefix(), this.creationalParameters.getNamespaceUri(), "rPr"), new RunProperty[0]);
        }
        runProperties.getProperties().add(RunPropertyFactory.createRunProperty(this.creationalParameters, localName, attributes));
        return runProperties;
    }

    private RunProperties removeRunProperty(RunProperties runProperties, Iterator<RunProperty> iterator) {
        iterator.remove();
        if (runProperties.getProperties().isEmpty()) {
            return null;
        }
        return runProperties;
    }
}

