/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.RunFonts;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class RunPropertyFactory {
    private static final int DEFAULT_EVENTS_SIZE = 2;
    private static final EnumSet<TogglePropertyName> TOGGLE_PROPERTY_NAMES = EnumSet.range(TogglePropertyName.BOLD, TogglePropertyName.VANISH);

    RunPropertyFactory() {
    }

    static RunProperty createRunProperty(StartElementContext startElementContext) throws XMLStreamException {
        if (RunFonts.RUN_FONTS.equals(startElementContext.getStartElement().getName())) {
            return new RunProperty.FontsRunProperty(RunFonts.createRunFonts(startElementContext));
        }
        if (XMLEventHelpers.RUN_STYLE.equals(startElementContext.getStartElement().getName())) {
            return new RunProperty.RunStyleProperty(XMLEventHelpers.gatherEvents(startElementContext));
        }
        if (TOGGLE_PROPERTY_NAMES.contains((Object)TogglePropertyName.fromValue(startElementContext.getStartElement().getName()))) {
            return new RunProperty.ToggleRunProperty(XMLEventHelpers.gatherEvents(startElementContext));
        }
        return new RunProperty.GenericRunProperty(XMLEventHelpers.gatherEvents(startElementContext));
    }

    static RunProperty createRunProperty(Attribute attribute) {
        return new RunProperty.AttributeRunProperty(attribute);
    }

    static RunProperty createRunProperty(CreationalParameters creationalParameters, String localName, Map<String, String> attributes) {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>(2);
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>(attributes.size());
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            attributeList.add(creationalParameters.getEventFactory().createAttribute(creationalParameters.getPrefix(), creationalParameters.getNamespaceUri(), attribute.getKey(), attribute.getValue()));
        }
        events.add(creationalParameters.getEventFactory().createStartElement(creationalParameters.getPrefix(), creationalParameters.getNamespaceUri(), localName, attributeList.iterator(), null));
        events.add(creationalParameters.getEventFactory().createEndElement(creationalParameters.getPrefix(), creationalParameters.getNamespaceUri(), localName));
        return new RunProperty.GenericRunProperty(events);
    }

    static enum TogglePropertyName {
        UNSUPPORTED(""),
        BOLD("b"),
        COMPLEX_SCRIPT_BOLD("bCs"),
        CAPS("caps"),
        EMBOSS("emboss"),
        ITALICS("i"),
        COMPLEX_SCRIPT_ITALICS("iCs"),
        IMPRINT("imprint"),
        OUTLINE("outline"),
        SHADOW("shadow"),
        SMALL_CAPS("smallCaps"),
        STRIKE_THROUGH("strike"),
        VANISH("vanish");

        QName value;

        private TogglePropertyName(String value) {
            this.value = Namespaces.WordProcessingML.getQName(value);
        }

        QName getValue() {
            return this.value;
        }

        static TogglePropertyName fromValue(QName value) {
            if (null == value) {
                return UNSUPPORTED;
            }
            for (TogglePropertyName propertyName : TogglePropertyName.values()) {
                if (!propertyName.getValue().equals(value)) continue;
                return propertyName;
            }
            return UNSUPPORTED;
        }
    }
}

