/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.filters.openxml.AttributeStripper;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockParser;
import net.sf.okapi.filters.openxml.BlockTextUnitMapper;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.ElementSkipperFactory;
import net.sf.okapi.filters.openxml.GenericPartHandler;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.MarkupComponentParser;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class StyledTextPartHandler
extends GenericPartHandler {
    private XMLEventFactory eventFactory;
    private StyleDefinitions styleDefinitions;
    private ElementSkipper tablePropertiesChangeElementSkipper;
    private ElementSkipper noElementSkipper;
    private ElementSkipper revisionPropertyChangeElementSkipper;
    private XMLEventReader xmlReader;
    private Iterator<Event> filterEventIterator;
    private String documentId;
    private String subDocumentId;
    private LocaleId sourceLanguage;
    private IdGenerator nestedBlockId;
    private IdGenerator textUnitId;

    StyledTextPartHandler(ConditionalParameters cparams, OpenXMLZipFile zipFile, ZipEntry entry, StyleDefinitions styleDefinitions) {
        this(cparams, zipFile.getEventFactory(), entry.getName(), styleDefinitions);
        this.zipFile = zipFile;
        this.entry = entry;
        this.textUnitId = new IdGenerator(this.partName, "tu");
        this.markup = new Block.BlockMarkup();
    }

    StyledTextPartHandler(ConditionalParameters cparams, XMLEventFactory eventFactory, String partName, StyleDefinitions styleDefinitions) {
        super(cparams);
        this.eventFactory = eventFactory;
        this.partName = partName;
        this.styleDefinitions = styleDefinitions;
        this.tablePropertiesChangeElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(cparams, ElementSkipper.RevisionPropertySkippableElement.TABLE_PROPERTIES_CHANGE);
        this.noElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(cparams, new ElementSkipper.SkippableElement[0]);
        this.revisionPropertyChangeElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(cparams, ElementSkipper.RevisionPropertySkippableElement.SECTION_PROPERTIES_CHANGE, ElementSkipper.RevisionPropertySkippableElement.TABLE_GRID_CHANGE, ElementSkipper.RevisionPropertySkippableElement.TABLE_PROPERTIES_EXCEPTIONS_CHANGE, ElementSkipper.RevisionPropertySkippableElement.TABLE_ROW_PROPERTIES_CHANGE, ElementSkipper.RevisionPropertySkippableElement.TABLE_CELL_PROPERTIES_CHANGE);
        this.nestedBlockId = new IdGenerator(null);
        this.textUnitId = new IdGenerator(partName, "tu");
        this.markup = new Block.BlockMarkup();
    }

    @Override
    public Event open(String documentId, String subDocumentId, LocaleId sourceLanguage) throws IOException, XMLStreamException {
        this.documentId = documentId;
        this.subDocumentId = subDocumentId;
        this.sourceLanguage = sourceLanguage;
        this.xmlReader = this.zipFile.getInputFactory().createXMLEventReader(new InputStreamReader((InputStream)new BufferedInputStream(this.zipFile.getInputStream(this.entry)), StandardCharsets.UTF_8));
        return this.open(documentId, subDocumentId, this.xmlReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Event open(String documentId, String subDocumentId, XMLEventReader xmlReader) throws XMLStreamException {
        this.xmlReader = xmlReader;
        try {
            this.process();
        }
        finally {
            if (xmlReader != null) {
                xmlReader.close();
            }
        }
        return this.createStartSubDocumentEvent(documentId, subDocumentId);
    }

    private void process() throws XMLStreamException {
        StartElement parentStartElement = null;
        while (this.xmlReader.hasNext()) {
            StartElementContext startElementContext;
            XMLEvent e = this.xmlReader.nextEvent();
            this.preHandleNextEvent(e);
            if (XMLEventHelpers.isParagraphStartEvent(e)) {
                this.flushDocumentPart();
                startElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.xmlReader, this.eventFactory, this.params, this.sourceLanguage);
                Block block = new BlockParser(startElementContext, this.nestedBlockId, this.styleDefinitions).parse();
                if (block.isHidden()) {
                    this.documentPartEvents.addAll(block.getEvents());
                    continue;
                }
                BlockTextUnitMapper mapper = new BlockTextUnitMapper(block, this.textUnitId);
                if (mapper.getTextUnits().isEmpty() || !this.isCurrentBlockTranslatable()) {
                    this.addBlockChunksToDocumentPart(block.getChunks());
                } else {
                    for (ITextUnit tu : mapper.getTextUnits()) {
                        this.filterEvents.add(new Event(EventType.TEXT_UNIT, tu));
                    }
                }
            } else if (XMLEventHelpers.isBlockMarkupStartEvent(e)) {
                this.addMarkupComponentToDocumentPart(MarkupComponentFactory.createStartMarkupComponent(this.eventFactory, e.asStartElement()));
            } else if (XMLEventHelpers.isTablePropertiesStartEvent(e)) {
                startElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.xmlReader, this.eventFactory, this.params);
                this.addMarkupComponentToDocumentPart(MarkupComponentParser.parseBlockProperties(startElementContext, this.tablePropertiesChangeElementSkipper));
            } else if (XMLEventHelpers.isTextBodyPropertiesStartEvent(e)) {
                startElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.xmlReader, this.eventFactory, this.params);
                this.addMarkupComponentToDocumentPart(MarkupComponentParser.parseBlockProperties(startElementContext, this.noElementSkipper));
            } else if (XMLEventHelpers.isBlockMarkupEndEvent(e)) {
                this.addMarkupComponentToDocumentPart(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
            } else if (e.isStartElement() && this.revisionPropertyChangeElementSkipper.canSkip(e.asStartElement(), parentStartElement)) {
                startElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), parentStartElement, this.xmlReader, this.eventFactory, this.params, null);
                this.revisionPropertyChangeElementSkipper.skip(startElementContext);
            } else {
                if (XMLEventHelpers.isSectionPropertiesStartEvent(e)) {
                    e = AttributeStripper.RevisionAttributeStripper.stripSectionPropertiesRevisionAttributes(StartElementContextFactory.createStartElementContext(e.asStartElement(), null, this.eventFactory, this.params));
                } else if (XMLEventHelpers.isTableRowStartEvent(e)) {
                    e = AttributeStripper.RevisionAttributeStripper.stripTableRowRevisionAttributes(StartElementContextFactory.createStartElementContext(e.asStartElement(), null, this.eventFactory, this.params));
                }
                this.addEventToDocumentPart(e);
            }
            if (XMLEventHelpers.isTableGridStartEvent(e)) {
                parentStartElement = e.asStartElement();
                continue;
            }
            if (!XMLEventHelpers.isTableGridEndEvent(e)) continue;
            parentStartElement = null;
        }
        this.flushDocumentPart();
        this.filterEvents.add(new Event(EventType.END_DOCUMENT, new Ending(this.subDocumentId)));
        this.filterEventIterator = this.filterEvents.iterator();
    }

    protected void preHandleNextEvent(XMLEvent e) {
    }

    protected boolean isCurrentBlockTranslatable() {
        return true;
    }

    private void addMarkupComponentToDocumentPart(MarkupComponent markupComponent) {
        if (!this.documentPartEvents.isEmpty()) {
            this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.documentPartEvents));
            this.documentPartEvents = new ArrayList();
        }
        this.markup.addComponent(markupComponent);
    }

    private void addBlockChunksToDocumentPart(List<Chunk> chunks) {
        for (Chunk chunk : chunks) {
            if (chunk instanceof Markup) {
                for (MarkupComponent markupComponent : ((Markup)chunk).getComponents()) {
                    this.addMarkupComponentToDocumentPart(markupComponent);
                }
                continue;
            }
            this.documentPartEvents.addAll(chunk.getEvents());
        }
    }

    @Override
    public boolean hasNext() {
        return this.filterEventIterator.hasNext();
    }

    @Override
    public Event next() {
        return this.filterEventIterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
    }
}

