/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.transifex;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider,
ISimplifierRulesParameters {
    private static final String OPENPROJECT = "openProject";

    @Override
    public void reset() {
        super.reset();
        this.setOpenProject(true);
        this.setSimplifierRules(null);
    }

    public void setOpenProject(boolean openManifest) {
        this.setBoolean(OPENPROJECT, openManifest);
    }

    public boolean getOpenProject() {
        return this.getBoolean(OPENPROJECT);
    }

    @Override
    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(OPENPROJECT, "Open the project file before processing", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Transifex Filter Parameters", true, false);
        desc.addCheckboxPart(paramDesc.get(OPENPROJECT));
        return desc;
    }
}

