/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xini;

import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;

public class Parameters
extends StringParameters
implements ISimplifierRulesParameters {
    public static final String USE_OKAPI_SEGMENTATION = "useOkapiSegmentation";

    @Override
    public void reset() {
        super.reset();
        this.setUseOkapiSegmentation(true);
        this.setSimplifierRules(null);
    }

    public boolean isUseOkapiSegmentation() {
        return this.getBoolean(USE_OKAPI_SEGMENTATION);
    }

    public void setUseOkapiSegmentation(boolean useOkapiSegmentation) {
        this.setBoolean(USE_OKAPI_SEGMENTATION, useOkapiSegmentation);
    }

    @Override
    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(USE_OKAPI_SEGMENTATION, "Use Okapi segmentation for output", "If disabled, all XINI segments with the same value\nof the attribute 'SegmentIDBeforeSegmentation' will be merged.\nIf the XINI was not segmented, it will remain unsegmented.\nIf this option is enabled, new segmentation\n(i.e. from segmentation step) will be used for the output.");
        return desc;
    }
}

