/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff;

import java.nio.charset.CharsetEncoder;
import java.util.Map;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.filterwriter.ITSContent;
import net.sf.okapi.common.filterwriter.XLIFFContent;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.filters.xliff.Parameters;
import net.sf.okapi.filters.xliff.SdlXliffConfLevel;
import net.sf.okapi.filters.xliff.XLIFFSkeletonWriter;
import net.sf.okapi.filters.xliff.its.ITSStandoffManager;

public class SdlXliffSkeletonWriter
extends XLIFFSkeletonWriter {
    public static final String SDL_SEG_LOCKED_MARKER = "[@#$SDLSEGLOCKED$#@]";
    public static final String SDL_SEG_CONF_MARKER = "[@#$SDLSEGCONF$#@]";
    public static final String SDL_SEG_ORIGIN_MARKER = "[@#$SDLSEGORIGIN$#@]";
    public static final String PROP_SDL_LOCKED = "sdl_lock";
    public static final String PROP_SDL_CONF = "sdl_conf";
    public static final String PROP_SDL_ORIGIN = "sdl_origin";
    public static final String PROP_ORIG_SDL_SEG_CONF = "orig_sdl_seg_conf";

    public SdlXliffSkeletonWriter(Parameters params) {
        super(params);
    }

    public SdlXliffSkeletonWriter(Parameters params, XLIFFContent fmt, ITSContent itsCont, ITSStandoffManager itsStandoffManager, Map<String, GenericAnnotations> lqiStandoff, Map<String, GenericAnnotations> provStandoff, CharsetEncoder chsEnc) {
        super(params, fmt, itsCont, itsStandoffManager, lqiStandoff, provStandoff, chsEnc);
    }

    @Override
    public String processTextUnit(ITextUnit resource) {
        LocaleId tl;
        if (!resource.getTargetLocales().isEmpty() && resource.hasTarget(tl = resource.getTargetLocales().iterator().next())) {
            resource.setSkeleton(this.updateSdlSeg(resource.getTarget(tl), (GenericSkeleton)resource.getSkeleton()));
        }
        return super.processTextUnit(resource);
    }

    private ISkeleton updateSdlSeg(TextContainer target, GenericSkeleton skeleton) {
        for (GenericSkeletonPart p : skeleton.getParts()) {
            Property l = target.getProperty(PROP_SDL_LOCKED);
            Property c = target.getProperty(PROP_SDL_CONF);
            Property o = target.getProperty(PROP_SDL_ORIGIN);
            if (l == null && c == null && o == null) {
                return skeleton;
            }
            String d = p.getData().toString();
            if (l != null) {
                d = d.replace(SDL_SEG_LOCKED_MARKER, Util.isEmpty(this.getParams().getSdlSegLockedValue()) ? l.getValue() : this.getParams().getSdlSegLockedValue());
            }
            if (c != null) {
                if (!target.hasProperty("state") || !SdlXliffConfLevel.isValidStateValue(target.getProperty("state").getValue())) {
                    d = target.hasProperty(PROP_ORIG_SDL_SEG_CONF) && target.getProperty(PROP_ORIG_SDL_SEG_CONF).getValue() != null ? d.replace(SDL_SEG_CONF_MARKER, target.getProperty(PROP_ORIG_SDL_SEG_CONF).getValue()) : d.replace(SDL_SEG_CONF_MARKER, Util.isEmpty(this.getParams().getSdlSegConfValue()) ? c.getValue() : this.getParams().getSdlSegConfValue());
                } else {
                    SdlXliffConfLevel confLevel = SdlXliffConfLevel.fromStateValue(target.getProperty("state").getValue());
                    d = d.replace(SDL_SEG_CONF_MARKER, confLevel.getConfValue());
                }
            }
            if (o != null) {
                d = d.replace(SDL_SEG_ORIGIN_MARKER, Util.isEmpty(this.getParams().getSdlSegOriginValue()) ? o.getValue() : this.getParams().getSdlSegOriginValue());
            }
            p.setData(d);
        }
        return skeleton;
    }
}

