/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.v1;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.Document;
import net.sf.okapi.lib.beans.v1.AnnotationsBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.PersistenceBean;
import net.sf.okapi.lib.persistence.beans.FactoryBean;

public class DocumentBean
extends PersistenceBean<Document> {
    private AnnotationsBean annotations = new AnnotationsBean();
    private String id;
    private List<FactoryBean> documentResources = new ArrayList<FactoryBean>();

    @Override
    protected Document createObject(IPersistenceSession session) {
        return new Document();
    }

    @Override
    protected void fromObject(Document obj, IPersistenceSession session) {
        this.annotations.set(obj.getAnnotations(), session);
        this.id = obj.getId();
        for (IResource res : obj) {
            FactoryBean resBean = new FactoryBean();
            resBean.set(res, session);
            this.documentResources.add(resBean);
        }
    }

    @Override
    protected void setObject(Document obj, IPersistenceSession session) {
        for (FactoryBean annotationBean : this.annotations.getItems()) {
            obj.setAnnotation(annotationBean.get(IAnnotation.class, session));
        }
        obj.setId(this.id);
        for (FactoryBean docPropBean : this.documentResources) {
            obj.addResource(docPropBean.get(IResource.class, session));
        }
    }

    public AnnotationsBean getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(AnnotationsBean annotations) {
        this.annotations = annotations;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<FactoryBean> getDocumentResources() {
        return this.documentResources;
    }

    public void setDocumentResources(List<FactoryBean> documentResources) {
        this.documentResources = documentResources;
    }
}

