/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.v1;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TargetPropertiesAnnotation;
import net.sf.okapi.lib.beans.v1.PropertyBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.PersistenceBean;

public class TargetPropertiesAnnotationBean
extends PersistenceBean<TargetPropertiesAnnotation> {
    private ConcurrentHashMap<String, Map<String, PropertyBean>> targets = new ConcurrentHashMap();

    @Override
    protected TargetPropertiesAnnotation createObject(IPersistenceSession session) {
        return new TargetPropertiesAnnotation();
    }

    @Override
    protected void fromObject(TargetPropertiesAnnotation obj, IPersistenceSession session) {
        for (LocaleId locId : obj) {
            LinkedHashMap<String, PropertyBean> propBeans = new LinkedHashMap<String, PropertyBean>();
            Map<String, Property> props = obj.get(locId);
            for (String key : props.keySet()) {
                Property prop = props.get(key);
                PropertyBean propBean = new PropertyBean();
                propBean.set(prop, session);
                propBeans.put(key, propBean);
            }
            this.targets.put(locId.toString(), propBeans);
        }
    }

    @Override
    protected void setObject(TargetPropertiesAnnotation obj, IPersistenceSession session) {
        for (String locTag : this.targets.keySet()) {
            Map<String, PropertyBean> propBeans = this.targets.get(locTag);
            LinkedHashMap<String, Property> props = new LinkedHashMap<String, Property>();
            for (String key : propBeans.keySet()) {
                PropertyBean propBean = propBeans.get(key);
                Property prop = propBean.get(Property.class, session);
                props.put(key, prop);
            }
            obj.set(LocaleId.fromString(locTag), props);
        }
    }

    public ConcurrentHashMap<String, Map<String, PropertyBean>> getTargets() {
        return this.targets;
    }

    public void setTargets(ConcurrentHashMap<String, Map<String, PropertyBean>> targets) {
        this.targets = targets;
    }
}

