/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.tkit.step;

import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiMergeException;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.lib.tkit.step.OriginalDocumentXliffMergerStep;
import net.sf.okapi.lib.tkit.step.SkeletonXliffMergerStep;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedXliffMergerStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<LocaleId> trgLocs;
    private RawDocument skeleton;
    private RawDocument originalDocument;
    private IFilterConfigurationMapper fcMapper;
    private String outputEncoding;
    private SkeletonXliffMergerStep skeletonMerger = new SkeletonXliffMergerStep();
    private OriginalDocumentXliffMergerStep originalDocumentMerger = new OriginalDocumentXliffMergerStep();

    @Override
    public String getName() {
        return "Skeleton Merger Step";
    }

    @Override
    public String getDescription() {
        return "XLIFF merger which uses a JSON-based skeleton file instead of the original source document.";
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_ENCODING)
    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALES)
    public void setTargetLocales(List<LocaleId> targetLocales) {
        this.trgLocs = targetLocales;
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.skeleton = secondInput;
    }

    @StepParameterMapping(parameterType=StepParameterType.THIRD_INPUT_RAWDOC)
    public void setThirdInput(RawDocument thirdInput) {
        this.originalDocument = thirdInput;
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Event handleRawDocument(Event event) {
        Event me = null;
        Throwable skeletonCuase = null;
        Throwable originalDocumentCuase = null;
        Throwable previousVersionCuase = null;
        try {
            try {
                me = this.skeletonMerge(event);
            }
            catch (Exception e) {
                skeletonCuase = ExceptionUtils.getRootCause((Throwable)e);
                if (skeletonCuase == null) {
                    skeletonCuase = e;
                }
                this.logger.error("Combined merge. Error during skeleton merge root cuase: {}", (Object)skeletonCuase.getMessage());
                this.logger.error("Combined merge. Error during skeleton merge, full trace", e);
            }
            if (me == null) {
                try {
                    me = this.originalDocumentMerge(event);
                }
                catch (Exception e) {
                    originalDocumentCuase = ExceptionUtils.getRootCause((Throwable)e);
                    if (originalDocumentCuase == null) {
                        originalDocumentCuase = e;
                    }
                    this.logger.error("Combined merge. Error during original document merge root cuase: {}", (Object)originalDocumentCuase.getMessage());
                    this.logger.error("Combined merge. Error during original document merge. Full trace.", e);
                }
            }
        }
        finally {
            if (this.skeleton != null) {
                this.skeleton.close();
            }
            if (this.originalDocument != null) {
                this.originalDocument.close();
            }
            event.getRawDocument().close();
        }
        if (me == null) {
            StringBuilder c = new StringBuilder();
            c.append(skeletonCuase == null ? "" : skeletonCuase.getMessage() + "\n");
            c.append(originalDocumentCuase == null ? "" : originalDocumentCuase.getMessage() + "\n");
            c.append(previousVersionCuase == null ? "" : previousVersionCuase.getMessage());
            this.logger.error("Combined merge. Cannot merge using availible methods: {}", (Object)c.toString());
            throw new OkapiMergeException(String.format("Combined merge. Cannot merge using availible methods: %s", c.toString()));
        }
        return me;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void destroy() {
        if (this.skeletonMerger != null) {
            this.skeletonMerger.destroy();
        }
        if (this.originalDocumentMerger != null) {
            this.originalDocumentMerger.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event skeletonMerge(Event event) {
        if (this.skeleton == null) {
            return null;
        }
        RawDocument originalXliff = event.getRawDocument();
        Event me = null;
        try (RawDocument xliffCopy = new RawDocument(originalXliff.getStream(), originalXliff.getEncoding(), originalXliff.getSourceLocale(), originalXliff.getTargetLocale());){
            this.skeletonMerger.setOutputEncoding(this.outputEncoding);
            this.skeletonMerger.setSecondInput(this.skeleton);
            this.skeletonMerger.setTargetLocales(this.trgLocs);
            me = this.skeletonMerger.handleRawDocument(new Event(EventType.RAW_DOCUMENT, xliffCopy));
        }
        return me;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event originalDocumentMerge(Event event) {
        if (this.originalDocument == null) {
            return null;
        }
        RawDocument originalXliff = event.getRawDocument();
        Event me = null;
        try (RawDocument xliffCopy = new RawDocument(originalXliff.getStream(), originalXliff.getEncoding(), originalXliff.getSourceLocale(), originalXliff.getTargetLocale());){
            this.originalDocumentMerger.setOutputEncoding(this.outputEncoding);
            this.originalDocumentMerger.setSecondInput(this.originalDocument);
            this.originalDocumentMerger.setTargetLocales(this.trgLocs);
            this.originalDocumentMerger.setFilterConfigurationMapper(this.fcMapper);
            me = this.originalDocumentMerger.handleRawDocument(new Event(EventType.RAW_DOCUMENT, xliffCopy));
        }
        return me;
    }
}

