/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.enrycher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.translation.QueryUtil;
import net.sf.okapi.steps.enrycher.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrycherClient {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final Pattern HTML_STARTSPAN = Pattern.compile("\\<span\\s(.*?)>", 34);
    private static final Pattern HTML_ENDSPAN = Pattern.compile("\\</span>", 2);
    private Parameters params = new Parameters();
    private String lang = "en";
    private QueryUtil util = new QueryUtil();

    public IParameters getParameters() {
        return this.params;
    }

    public void setParameters(Parameters params) {
        this.params = params;
    }

    public void setLocale(LocaleId locId) {
        this.lang = locId.getLanguage();
    }

    public String processContent(String text) {
        OutputStreamWriter wr = null;
        BufferedReader rd = null;
        try {
            String line;
            URL url = new URL(this.params.getBaseUrl() + this.lang + "/run.html5its2");
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "text/html");
            wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(text);
            wr.flush();
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                sb.append(line + "\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (MalformedURLException e) {
            throw new OkapiException("Invalid URL:\n" + e.getMessage());
        }
        catch (IOException e) {
            throw new OkapiException("Input/Output error:\n" + e.getMessage());
        }
        finally {
            try {
                if (wr != null) {
                    wr.close();
                }
                if (rd != null) {
                    rd.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void processList(LinkedList<ITextUnit> list) {
        if (Util.isEmpty(list)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (ITextUnit tu : list) {
            if (!tu.isTranslatable()) continue;
            ISegments segs = tu.getSource().getSegments();
            for (int i = 0; i < segs.count(); ++i) {
                sb.append("<p id='" + tu.getId() + "_" + i + "'>");
                sb.append(this.util.toCodedHTML(segs.get(i).getContent()));
                sb.append("</p>");
            }
        }
        String res = this.processContent(sb.toString());
        this.parseHTML(res, list);
    }

    protected void parseHTML(String htmlResult, LinkedList<ITextUnit> list) {
        Source source = new Source(htmlResult);
        for (ITextUnit tu : list) {
            try {
                if (!tu.isTranslatable()) continue;
                ISegments segs = tu.getSource().getSegments();
                for (int i = 0; i < segs.count(); ++i) {
                    Element p = source.getElementById(tu.getId() + "_" + i);
                    TextFragment tf = segs.get(i).getContent();
                    String ct = this.util.fromCodedHTML(p.getContent().toString(), tf, false, false);
                    if (!tu.preserveWhitespaces()) {
                        TextFragment.unwrap(tf);
                        ct = this.unwrap(ct);
                    }
                    StringBuilder sb = new StringBuilder(ct);
                    int markersLength = 0;
                    int nestedMarkersLength = 0;
                    Matcher m = HTML_ENDSPAN.matcher(sb.toString());
                    while (m.find()) {
                        int endLength;
                        int nestedCount = -1;
                        int endBlock = m.end();
                        int startBlock = -1;
                        int n = 0;
                        int correctionStart = 0;
                        int correctionEnd = endLength = m.group(0).length();
                        int startLength = 0;
                        m = HTML_STARTSPAN.matcher(sb.toString());
                        while (m.find(n)) {
                            n = m.end();
                            startBlock = m.start();
                            startLength = m.group(0).length();
                            correctionStart += startLength;
                            ++nestedCount;
                            m = HTML_STARTSPAN.matcher(sb.substring(0, endBlock));
                        }
                        correctionEnd += correctionStart;
                        correctionStart -= startLength;
                        if (startBlock == -1) {
                            this.LOGGER.warn("Missing <span> in entry '{}'.", (Object)(tu.getId() + "_" + i));
                            continue;
                        }
                        Source spanSource = new Source(sb.substring(startBlock, endBlock));
                        Element span = spanSource.getFirstElement();
                        GenericAnnotations anns = this.readAnnotation(span);
                        if (anns != null) {
                            int diff = tf.annotate(startBlock - correctionStart + (nestedCount > 0 ? markersLength : markersLength - nestedMarkersLength), endBlock - correctionEnd + markersLength, "generic", anns);
                            nestedMarkersLength += diff;
                            markersLength += diff;
                        }
                        sb.delete(endBlock - endLength, endBlock);
                        sb.delete(startBlock, startBlock + startLength);
                        m = HTML_ENDSPAN.matcher(sb.toString());
                        if (nestedCount != 0) continue;
                        nestedMarkersLength = 0;
                    }
                }
            }
            catch (Throwable e) {
                throw new OkapiIOException(String.format("Error when placing ITS markup (TU id='%s').\n" + e.getMessage(), tu.getId()));
            }
        }
    }

    GenericAnnotations readAnnotation(Element itsSpan) {
        GenericAnnotation ann = new GenericAnnotation("its-ta");
        Attributes attributes = itsSpan.getAttributes();
        for (Attribute attr : attributes) {
            if (attr.getKey().equals("its-ta-class-ref")) {
                ann.setString("taClass", "REF:" + attr.getValue());
                continue;
            }
            if (attr.getKey().equals("its-ta-source")) {
                ann.setString("taSource", attr.getValue());
                continue;
            }
            if (attr.getKey().equals("its-ta-ident")) {
                ann.setString("taIdent", attr.getValue());
                continue;
            }
            if (attr.getKey().equals("its-ta-ident-ref")) {
                ann.setString("taIdent", "REF:" + attr.getValue());
                continue;
            }
            if (!attr.getKey().equals("its-ta-confidence")) continue;
            ann.setDouble("taConfidence", Double.parseDouble(attr.getValue()));
        }
        if (ann.getFieldCount() == 0) {
            return null;
        }
        return new GenericAnnotations(ann);
    }

    public String unwrap(String text) {
        StringBuilder tmp = new StringBuilder(text.length());
        boolean wasWS = true;
        block4: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    tmp.append(text.charAt(i));
                    tmp.append(text.charAt(++i));
                    wasWS = false;
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (wasWS) continue block4;
                    wasWS = true;
                    tmp.append(' ');
                    continue block4;
                }
                default: {
                    wasWS = false;
                    tmp.append(text.charAt(i));
                }
            }
        }
        return tmp.toString();
    }
}

