/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.formatconversion;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LCIDUtil;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public class WordTableFilterWriter
implements IFilterWriter {
    private OutputStreamWriter writer;
    private OutputStream outputStream;
    private String outputPath;
    private LocaleId trgLoc;
    private String trgLCID;
    private String encoding;
    private CharsetEncoder chsEncoder;
    private File tempFile;
    private boolean fromTTX;

    @Override
    public void cancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.writer == null) {
            return;
        }
        IOException err = null;
        InputStream orig = null;
        OutputStream dest = null;
        try {
            this.writer.close();
            this.writer = null;
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
            if (this.tempFile != null) {
                int len;
                dest = new FileOutputStream(this.outputPath);
                orig = new FileInputStream(this.tempFile);
                byte[] buffer = new byte[2048];
                while ((len = orig.read(buffer)) > 0) {
                    dest.write(buffer, 0, len);
                }
            }
        }
        catch (IOException e) {
            err = e;
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException e) {
                    err = e;
                }
                dest = null;
            }
            if (orig != null) {
                try {
                    orig.close();
                }
                catch (IOException e) {
                    err = e;
                }
                orig = null;
                if (err != null) {
                    throw new OkapiException(err);
                }
                if (this.tempFile != null) {
                    this.tempFile.delete();
                    this.tempFile = null;
                }
            }
        }
    }

    @Override
    public String getName() {
        return "WordTableFilterWriter";
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                this.initialize();
                break;
            }
            case START_DOCUMENT: {
                this.handleStartDocument(event.getStartDocument());
                break;
            }
            case TEXT_UNIT: {
                this.handleTextUnit(event);
                break;
            }
            case END_DOCUMENT: {
                this.handleEndDocument(event.getEnding());
                break;
            }
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.trgLoc = locale;
        this.trgLCID = String.valueOf(LCIDUtil.getLCID(this.trgLoc));
    }

    @Override
    public void setOutput(String path) {
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.outputStream = output;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    private void initialize() {
    }

    private void handleStartDocument(StartDocument sd) {
        try {
            this.tempFile = null;
            this.fromTTX = sd.getMimeType().equals("application/x-ttx+xml");
            if (this.outputStream == null) {
                boolean useTemp = false;
                File f = new File(this.outputPath);
                if (f.exists()) {
                    boolean bl = useTemp = !f.delete();
                }
                if (useTemp) {
                    this.tempFile = File.createTempFile("~okapi-44_gfwTmp_", null);
                    this.outputStream = new BufferedOutputStream(new FileOutputStream(this.tempFile.getAbsolutePath()));
                } else {
                    Util.createDirectories(this.outputPath);
                    this.outputStream = new BufferedOutputStream(new FileOutputStream(this.outputPath));
                }
            }
            this.encoding = "windows-1252";
            this.chsEncoder = Charset.forName(this.encoding).newEncoder();
            this.writer = new OutputStreamWriter(this.outputStream, this.encoding);
            this.writer.write("{\\rtf1\\ansi\\ansicpg1252\\uc1\\deff1 \n{\\fonttbl \n{\\f1 \\fmodern\\fcharset0\\fprq1 Courier New;}\n{\\f2 \\fswiss\\fcharset0\\fprq2 Arial;}\n{\\f3 \\froman\\fcharset0\\fprq2 Times New Roman;}}\n{\\colortbl \\red0\\green0\\blue0;\\red0\\green0\\blue0;\\red0\\green0\\blue255;\\red0\\green255\\blue255;\\red0\\green255\\blue0;\\red255\\green0\\blue255;\\red255\\green0\\blue0;\\red255\\green255\\blue0;\\red255\\green255\\blue255;\\red0\\green0\\blue128;\\red0\\green128\\blue128;\\red0\\green128\\blue0;\\red128\\green0\\blue128;\\red128\\green0\\blue0;\\red128\\green128\\blue0;\\red128\\green128\\blue128;\\red192\\green192\\blue192;}\n{\\stylesheet \n{\\s0 \\sb80\\slmult1\\widctlpar\\fs20\\f1 \\snext0 Normal;}\n{\\cs1 \\additive \\v\\cf12\\sub\\f1 tw4winMark;}\n{\\cs2 \\additive \\cf4\\fs40\\f1 tw4winError;}\n{\\cs3 \\additive \\f1\\cf11 tw4winPopup;}\n{\\cs4 \\additive \\f1\\cf10 tw4winJump;}\n{\\cs5 \\additive \\cf15\\f1\\lang1024\\noproof tw4winExternal;}\n{\\cs6 \\additive \\cf6\\f1\\lang1024\\noproof tw4winInternal;}\n{\\cs7 \\additive \\cf2 tw4winTerm;}\n{\\cs8 \\additive \\cf13\\f1\\lang1024\\noproof DO_NOT_TRANSLATE;}\n{\\cs9 \\additive Default Paragraph Font;}{\\cs15 \\additive \\v\\f1\\cf12\\sub tw4winMark;}}\n\\paperw11907\\paperh16840\\viewkind4\\viewzk2\\viewscale100\\pard\\plain\\s0\\sb80\\slmult1\\widctlpar\\fs20\\f2 \n");
            this.writer.write("Review Table\\par\\par\n");
            this.writer.write("\\trowd\\trleft-1350\\trbrdrl\\brdrs\\brdrw10 \\trbrdrt\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trpaddl10\\trpaddr10\\trpaddfl3\\trpaddfr3\\clcbpat16\\clbrdrl\\brdrw10\\brdrs\\clbrdrt\\brdrw10\\brdrs\\clbrdrr\\brdrw10\\brdrs\\clbrdrb\\brdrw10\\brdrs \\cellx-400\\clcbpat16\\clbrdrl\\brdrw10\\brdrs\\clbrdrt\\brdrw10\\brdrs\\clbrdrr\\brdrw10\\brdrs\\clbrdrb\\brdrw10\\brdrs \\cellx600\\clcbpat16\\clbrdrl\\brdrw10\\brdrs\\clbrdrt\\brdrw10\\brdrs\\clbrdrr\\brdrw10\\brdrs\\clbrdrb\\brdrw10\\brdrs \\cellx5400\\clcbpat16\\clbrdrl\\brdrw10\\brdrs\\clbrdrt\\brdrw10\\brdrs\\clbrdrr\\brdrw10\\brdrs\\clbrdrb\\brdrw10\\brdrs \\cellx10400\n");
            this.writer.write("\\pard\\intbl\\widctlpar\\f2\\fs20\\b1 ID\\cell Type\\cell Source\\cell Target\\b0\\cell\\row\n");
            this.writer.write("\\trowd\\trleft-1350\\trbrdrl\\brdrs\\brdrw10 \\trbrdrt\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trpaddl10\\trpaddr10\\trpaddfl3\\trpaddfr3\\clcbpat17\\clbrdrl\\brdrw10\\brdrs\\clbrdrt\\brdrw10\\brdrs\\clbrdrr\\brdrw10\\brdrs\\clbrdrb\\brdrw10\\brdrs \\cellx-400\\clcbpat17\\clbrdrl\\brdrw10\\brdrs\\clbrdrt\\brdrw10\\brdrs\\clbrdrr\\brdrw10\\brdrs\\clbrdrb\\brdrw10\\brdrs \\cellx600\\clcbpat17\\clbrdrl\\brdrw10\\brdrs\\clbrdrt\\brdrw10\\brdrs\\clbrdrr\\brdrw10\\brdrs\\clbrdrb\\brdrw10\\brdrs \\cellx5400\\clcbpat17\\clbrdrl\\brdrw10\\brdrs\\clbrdrt\\brdrw10\\brdrs\\clbrdrr\\brdrw10\\brdrs\\clbrdrb\\brdrw10\\brdrs \\cellx10400\n");
        }
        catch (FileNotFoundException e) {
            throw new OkapiException(e);
        }
        catch (IOException e) {
            throw new OkapiIOException("Writing error.", e);
        }
    }

    private void handleEndDocument(Ending ending) {
        try {
            this.writer.write("}\n");
        }
        catch (IOException e) {
            throw new OkapiIOException("Writing error.", e);
        }
        finally {
            this.close();
        }
    }

    private void handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        String tuId = tu.getId();
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = tu.getTarget(this.trgLoc);
        if (trgCont == null) {
            trgCont = new TextContainer();
        }
        if (srcCont.contentIsOneSegment()) {
            this.writeRow(tuId, srcCont.getFirstContent(), trgCont.getFirstContent(), null);
            return;
        }
        if (trgCont.getSegments().count() != srcCont.getSegments().count()) {
            this.writeRow(tuId, srcCont.getUnSegmentedContentCopy(), trgCont.getUnSegmentedContentCopy(), null);
            return;
        }
        ISegments trgSegs = trgCont.getSegments();
        for (Segment srcSeg : srcCont.getSegments()) {
            Segment trgSeg = trgSegs.get(srcSeg.id);
            if (trgSeg == null) {
                this.writeRow(tuId + "." + srcSeg.id, srcSeg.text, null, null);
                continue;
            }
            this.writeRow(tuId + "." + srcSeg.id, srcSeg.text, trgSeg.text, trgSeg.getAnnotation(AltTranslationsAnnotation.class));
        }
    }

    private void writeRow(String id, TextFragment srcFrag, TextFragment trgFrag, AltTranslationsAnnotation altTrans) {
        String type = null;
        if (this.fromTTX && altTrans != null) {
            AltTranslation alt = altTrans.getFirst();
            type = String.format("%d%%", alt.getCombinedScore());
        }
        try {
            this.writer.write("\\pard\\intbl\\widctlpar\\f2\\fs20 ");
            this.writer.write(id + "\\cell ");
            if (type != null) {
                this.writer.write(type);
            }
            this.writer.write("\\cell ");
            this.writer.write(this.format(srcFrag) + "\\cell\\lang" + this.trgLCID + " ");
            if (trgFrag != null) {
                this.writer.write(this.format(trgFrag));
            }
            this.writer.write("\\cell\\row\n");
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing row.", e);
        }
    }

    private String format(TextFragment frag) {
        String codedText = frag.getCodedText();
        List<Code> codes = frag.getCodes();
        StringBuilder tmp = new StringBuilder();
        StringBuilder span = new StringBuilder();
        block8: for (int i = 0; i < codedText.length(); ++i) {
            switch (codedText.codePointAt(i)) {
                case 57601: 
                case 57602: 
                case 57603: {
                    if (span.length() > 0) {
                        tmp.append(Util.escapeToRTF(span.toString(), true, 0, this.chsEncoder));
                        span.setLength(0);
                    }
                    tmp.append("{\\cs6\\f1\\cf6\\lang1024 ");
                    switch (codedText.codePointAt(i)) {
                        case 57601: {
                            int index = TextFragment.toIndex(codedText.charAt(++i));
                            tmp.append(String.format("<%d>", codes.get(index).getId()));
                            break;
                        }
                        case 57602: {
                            int index = TextFragment.toIndex(codedText.charAt(++i));
                            tmp.append(String.format("</%d>", codes.get(index).getId()));
                            break;
                        }
                        case 57603: {
                            int index = TextFragment.toIndex(codedText.charAt(++i));
                            if (codes.get(index).getTagType() == TextFragment.TagType.OPENING) {
                                tmp.append(String.format("<b%d/>", codes.get(index).getId()));
                                break;
                            }
                            if (codes.get(index).getTagType() == TextFragment.TagType.CLOSING) {
                                tmp.append(String.format("<e%d/>", codes.get(index).getId()));
                                break;
                            }
                            tmp.append(String.format("<%d/>", codes.get(index).getId()));
                        }
                    }
                    tmp.append("}");
                    continue block8;
                }
                default: {
                    span.append(codedText.charAt(i));
                }
            }
        }
        if (span.length() > 0) {
            tmp.append(Util.escapeToRTF(span.toString(), true, 0, this.chsEncoder));
        }
        return tmp.toString();
    }
}

