/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.pipeline;

import java.io.File;
import java.net.URI;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.okapi.applications.rainbow.Input;
import net.sf.okapi.applications.rainbow.Project;
import net.sf.okapi.applications.rainbow.pipeline.PipelineStepUIDescription;
import net.sf.okapi.applications.rainbow.pipeline.PipelineStorage;
import net.sf.okapi.applications.rainbow.pipeline.StepInfo;
import net.sf.okapi.common.ExecutionContext;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditorMapper;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.ParametersEditorMapper;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipeline;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.Pipeline;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IPipelineDriver;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.plugins.PluginItem;
import net.sf.okapi.common.plugins.PluginsManager;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.leveraging.LeveragingStep;
import net.sf.okapi.steps.leveraging.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineWrapper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, StepInfo> availableSteps;
    private Map<String, ClassLoader> pluginConnectors;
    private String path;
    private ArrayList<StepInfo> steps;
    private IPipelineDriver driver;
    private IFilterConfigurationMapper fcMapper;
    private IParametersEditorMapper peMapper;
    private PluginsManager pm;

    public PipelineWrapper(IFilterConfigurationMapper fcMapper, String appFolder, PluginsManager pm, String rootDir, String inputRootDir, String outputDir, Object uiParent, ExecutionContext context) {
        this.fcMapper = fcMapper;
        this.pm = pm;
        this.steps = new ArrayList();
        this.driver = new PipelineDriver();
        this.driver.setFilterConfigurationMapper(this.fcMapper);
        this.driver.setRootDirectories(rootDir, inputRootDir);
        this.driver.setOutputDirectory(outputDir == null ? inputRootDir : outputDir);
        this.driver.setUIParent(uiParent);
        this.driver.setExecutionContext(context);
        this.refreshAvailableStepsList();
    }

    public void refreshAvailableStepsList() {
        this.buildStepList();
        this.addFromPlugins(this.pm);
    }

    public void addFromPlugins(PluginsManager pm) {
        try {
            this.pluginConnectors = new LinkedHashMap<String, ClassLoader>();
            List<PluginItem> plugins = pm.getList();
            URLClassLoader classLoader = pm.getClassLoader();
            for (PluginItem item : plugins) {
                if (item.getType() == 32) {
                    this.pluginConnectors.put(item.getClassName(), classLoader);
                    continue;
                }
                if (item.getType() != 2) continue;
                try {
                    IPipelineStep ps = (IPipelineStep)Class.forName(item.getClassName(), true, classLoader).newInstance();
                    IParameters params = ps.getParameters();
                    StepInfo stepInfo = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), classLoader, params == null ? null : params.getClass().getName());
                    if (params != null) {
                        stepInfo.paramsData = params.toString();
                        if (item.getEditorDescriptionProvider() != null) {
                            this.peMapper.addDescriptionProvider(item.getEditorDescriptionProvider(), stepInfo.paramsClass);
                        }
                        if (item.getParamsEditor() != null) {
                            this.peMapper.addEditor(item.getParamsEditor(), stepInfo.paramsClass);
                        }
                    }
                    this.availableSteps.put(stepInfo.stepClass, stepInfo);
                }
                catch (Throwable e) {
                    this.logger.warn("Could not instantiate step '{}' because of error.\n{}", (Object)item.getClassName(), (Object)e.getMessage());
                }
            }
            if (this.fcMapper instanceof FilterConfigurationMapper) {
                ((FilterConfigurationMapper)this.fcMapper).addFromPlugins(pm);
            }
        }
        catch (Throwable e) {
            throw new OkapiException("Error when creating the plug-ins lists.\n" + e.getMessage(), e);
        }
    }

    public void setRootDirectories(String rootDir, String inputRootDir) {
        this.driver.setRootDirectories(rootDir, inputRootDir);
    }

    private void buildStepList() {
        this.availableSteps = new LinkedHashMap<String, StepInfo>();
        this.peMapper = new ParametersEditorMapper();
        List<PipelineStepUIDescription> pipelineStepDescriptions = this.buildPipelineStepDescriptions();
        for (PipelineStepUIDescription desc : pipelineStepDescriptions) {
            try {
                IPipelineStep ps = (IPipelineStep)Class.forName(desc.getPipelineStepClass()).newInstance();
                StepInfo step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, null);
                IParameters params = ps.getParameters();
                if (params != null) {
                    step.paramsClass = params.getClass().getName();
                    step.paramsData = params.toString();
                    if (desc.hasDescriptionProvider()) {
                        this.peMapper.addDescriptionProvider(desc.getDescriptionProviderClass(), step.paramsClass);
                    }
                    if (desc.hasEditor()) {
                        this.peMapper.addEditor(desc.getEditorClass(), step.paramsClass);
                    }
                }
                this.availableSteps.put(step.stepClass, step);
            }
            catch (InstantiationException e) {
                this.logger.warn("Could not instantiate step for class " + desc.getPipelineStepClass() + ". Skipping to next step.\n{}", (Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                this.logger.warn("Illegal access for step for class " + desc.getPipelineStepClass() + ". Skipping to next step.\n{}", (Object)e.getMessage());
            }
            catch (ClassNotFoundException e) {
                this.logger.warn("Step class " + desc.getPipelineStepClass() + " not found. Skipping to next step.\n{}", (Object)e.getMessage());
            }
            catch (Throwable e) {
                this.logger.warn("Error creating step for class " + desc.getPipelineStepClass() + " Skipping to next step.\n{}", (Object)e.getMessage());
            }
        }
    }

    private List<PipelineStepUIDescription> buildPipelineStepDescriptions() {
        ArrayList<PipelineStepUIDescription> pipelineStepUIDescriptions = new ArrayList<PipelineStepUIDescription>();
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.common.RawDocumentToFilterEventsStep"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.common.FilterEventsToRawDocumentStep"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.leveraging.BatchTmLeveragingStep", null, "net.sf.okapi.steps.leveraging.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.batchtranslation.BatchTranslationStep", null, "net.sf.okapi.steps.batchtranslation.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.bomconversion.BOMConversionStep", "net.sf.okapi.steps.bomconversion.ui.ParametersEditor", null));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.charlisting.CharListingStep", null, "net.sf.okapi.steps.charlisting.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.codesremoval.CodesRemovalStep", null, "net.sf.okapi.steps.codesremoval.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.common.codesimplifier.CodeSimplifierStep", null, "net.sf.okapi.steps.common.codesimplifier.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.common.codesimplifier.PostSegmentationCodeSimplifierStep", null, "net.sf.okapi.steps.common.codesimplifier.PostSegmentationParameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.cleanup.CleanupStep", null, "net.sf.okapi.steps.cleanup.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.common.ConvertSegmentsToTextUnitsStep"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.copyormove.CopyOrMoveStep", null, "net.sf.okapi.steps.copyormove.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.common.createtarget.CreateTargetStep", null, "net.sf.okapi.steps.common.createtarget.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.desegmentation.DesegmentationStep", null, "net.sf.okapi.steps.desegmentation.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.diffleverage.DiffLeverageStep", null, "net.sf.okapi.steps.diffleverage.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.encodingconversion.EncodingConversionStep", "net.sf.okapi.steps.encodingconversion.ui.ParametersEditor", null));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.enrycher.EnrycherStep", null, "net.sf.okapi.steps.enrycher.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.externalcommand.ExternalCommandStep", null, "net.sf.okapi.steps.externalcommand.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.common.ExtractionVerificationStep", null, "net.sf.okapi.steps.common.ExtractionVerificationStepParameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.formatconversion.FormatConversionStep", null, "net.sf.okapi.steps.formatconversion.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.fullwidthconversion.FullWidthConversionStep", "net.sf.okapi.steps.fullwidthconversion.ui.ParametersEditor", null));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.generatesimpletm.GenerateSimpleTmStep", null, "net.sf.okapi.steps.generatesimpletm.ParametersUI"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.gttbatchtranslation.GTTBatchTranslationStep", null, "net.sf.okapi.steps.gttbatchtranslation.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.idaligner.IdBasedAlignerStep", null, "net.sf.okapi.steps.idaligner.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.idbasedcopy.IdBasedCopyStep", null, "net.sf.okapi.steps.idbasedcopy.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.imagemodification.ImageModificationStep", null, "net.sf.okapi.steps.imagemodification.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.inconsistencycheck.InconsistencyCheckStep", null, "net.sf.okapi.steps.inconsistencycheck.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.leveraging.LeveragingStep", "net.sf.okapi.steps.leveraging.ui.ParametersEditor", null));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.terminologyleveraging.TerminologyLeveragingStep", null, "net.sf.okapi.steps.terminologyleveraging.TerminologyParameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.linebreakconversion.LineBreakConversionStep", null, "net.sf.okapi.steps.linebreakconversion.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.moses.ExtractionStep", null, "net.sf.okapi.filters.mosestext.FilterWriterParameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.moses.MergingStep", null, "net.sf.okapi.steps.moses.MergingParameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.msbatchtranslation.MSBatchTranslationStep", null, "net.sf.okapi.steps.msbatchtranslation.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.msbatchtranslation.MSBatchSubmissionStep", null, "net.sf.okapi.steps.msbatchtranslation.SubmissionParameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.paraaligner.ParagraphAlignerStep", null, "net.sf.okapi.steps.paraaligner.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.qualitycheck.QualityCheckStep", "net.sf.okapi.lib.ui.verification.ParametersEditor", null));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.rainbowkit.creation.ExtractionStep", "net.sf.okapi.steps.rainbowkit.ui.CreationParametersEditor", null));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.rainbowkit.postprocess.MergingStep", null, "net.sf.okapi.steps.rainbowkit.postprocess.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.common.removetarget.RemoveTargetStep", null, "net.sf.okapi.steps.common.removetarget.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.repetitionanalysis.RepetitionAnalysisStep", null, "net.sf.okapi.steps.repetitionanalysis.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.common.ResourceSimplifierStep"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.rtfconversion.RTFConversionStep", null, "net.sf.okapi.steps.rtfconversion.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.scopingreport.ScopingReportStep", null, "net.sf.okapi.steps.scopingreport.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.searchandreplace.SearchAndReplaceStep", "net.sf.okapi.steps.searchandreplace.ui.ParametersEditor", null));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.segmentation.SegmentationStep", "net.sf.okapi.steps.segmentation.ui.ParametersEditor", null));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.sentencealigner.SentenceAlignerStep", null, "net.sf.okapi.steps.sentencealigner.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.simpletm2tmx.SimpleTM2TMXStep"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.spacecheck.SpaceCheckStep"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.termextraction.TermExtractionStep", null, "net.sf.okapi.steps.termextraction.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.textmodification.TextModificationStep", "net.sf.okapi.steps.textmodification.ui.ParametersEditor", null));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.tmimport.TMImportStep", null, "net.sf.okapi.steps.tmimport.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.tokenization.TokenizationStep", "net.sf.okapi.steps.tokenization.ui.ParametersEditor", null));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.translationcomparison.TranslationComparisonStep", null, "net.sf.okapi.steps.translationcomparison.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.ttxsplitter.TTXJoinerStep", null, "net.sf.okapi.steps.ttxsplitter.TTXJoinerParameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.ttxsplitter.TTXSplitterStep", null, "net.sf.okapi.steps.ttxsplitter.TTXSplitterParameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.uriconversion.UriConversionStep", "net.sf.okapi.steps.uriconversion.ui.ParametersEditor", null));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.wordcount.WordCountStep", null, "net.sf.okapi.steps.wordcount.common.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.wordcount.CharacterCountStep", null, "net.sf.okapi.steps.wordcount.common.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.wordcount.SimpleWordCountStep"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.whitespacecorrection.WhitespaceCorrectionStep", null, "net.sf.okapi.steps.whitespacecorrection.WhitespaceCorrectionStepParameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.xmlcharfixing.XMLCharFixingStep", null, "net.sf.okapi.steps.xmlcharfixing.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.xliffsplitter.XliffJoinerStep", null, "net.sf.okapi.steps.xliffsplitter.XliffJoinerParameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.xliffsplitter.XliffSplitterStep", null, "net.sf.okapi.steps.xliffsplitter.XliffSplitterParameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.xliffsplitter.XliffWCSplitterStep", null, "net.sf.okapi.steps.xliffsplitter.XliffWCSplitterParameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.xmlanalysis.XMLAnalysisStep", null, "net.sf.okapi.steps.xmlanalysis.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.xmlvalidation.XMLValidationStep", null, "net.sf.okapi.steps.xmlvalidation.Parameters"));
        pipelineStepUIDescriptions.add(new PipelineStepUIDescription("net.sf.okapi.steps.xsltransform.XSLTransformStep", "net.sf.okapi.steps.xsltransform.ui.ParametersEditor", null));
        return pipelineStepUIDescriptions;
    }

    public void clear() {
        this.steps.clear();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public IParametersEditorMapper getEditorMapper() {
        return this.peMapper;
    }

    public Map<String, StepInfo> getAvailableSteps() {
        return this.availableSteps;
    }

    public String getStringStorage() {
        this.copyInfoStepsToPipeline();
        PipelineStorage store = new PipelineStorage(this.availableSteps);
        store.write(this.driver.getPipeline());
        return store.getStringOutput();
    }

    public void reset() {
        this.clear();
        this.path = null;
        this.driver.setPipeline(new Pipeline());
    }

    public void loadFromStringStorageOrReset(String data) {
        if (Util.isEmpty(data)) {
            this.reset();
            return;
        }
        PipelineStorage store = new PipelineStorage(this.availableSteps, (CharSequence)data);
        this.loadPipeline(store.read(), null);
    }

    public void loadPipeline(IPipeline newPipeline, String path) {
        this.driver.setPipeline(newPipeline);
        this.steps.clear();
        for (IPipelineStep step : this.driver.getPipeline().getSteps()) {
            StepInfo infoStep = new StepInfo(step.getName(), step.getDescription(), step.getClass().getName(), step.getClass().getClassLoader(), null);
            IParameters params = step.getParameters();
            if (params != null) {
                infoStep.paramsData = params.toString();
                infoStep.paramsClass = params.getClass().getName();
            }
            this.steps.add(infoStep);
        }
        this.path = path;
    }

    public void load(String path) {
        PipelineStorage store = new PipelineStorage(this.availableSteps, path);
        this.loadPipeline(store.read(), path);
    }

    public void save(String path) {
        PipelineStorage store = new PipelineStorage(this.availableSteps, path);
        this.copyInfoStepsToPipeline();
        store.write(this.driver.getPipeline());
        this.path = path;
    }

    public IPipeline getPipeline() {
        this.copyInfoStepsToPipeline();
        return this.driver.getPipeline();
    }

    public PluginsManager getPluginsManager() {
        return this.pm;
    }

    private void copyInfoStepsToPipeline() {
        try {
            this.driver.setPipeline(new Pipeline());
            for (StepInfo stepInfo : this.steps) {
                IPipelineStep step = stepInfo.loader == null ? (IPipelineStep)Class.forName(stepInfo.stepClass).newInstance() : (IPipelineStep)Class.forName(stepInfo.stepClass, true, stepInfo.loader).newInstance();
                IParameters params = step.getParameters();
                if (params != null && stepInfo.paramsData != null) {
                    params.fromString(stepInfo.paramsData);
                }
                if (step instanceof LeveragingStep) {
                    LeveragingStep ls = (LeveragingStep)step;
                    Parameters lsParams = (Parameters)ls.getParameters();
                    String connectorClassName = lsParams.getResourceClassName();
                    ClassLoader connectorLoader = this.pluginConnectors.get(connectorClassName);
                    ls.setConnectorContext(connectorLoader);
                }
                this.driver.addStep(step);
            }
        }
        catch (InstantiationException e) {
            throw new OkapiException(e);
        }
        catch (IllegalAccessException e) {
            throw new OkapiException(e);
        }
        catch (ClassNotFoundException e) {
            throw new OkapiException(e);
        }
    }

    public void copyParametersToPipeline(IPipeline pipeline) {
        List<IPipelineStep> destSteps = pipeline.getSteps();
        if (destSteps.size() != this.steps.size()) {
            throw new OkapiException("Parameters and destination do not match.");
        }
        for (int i = 0; i < destSteps.size(); ++i) {
            StepInfo stepInfo = this.steps.get(i);
            IParameters params = destSteps.get(i).getParameters();
            if (params == null) continue;
            params.fromString(stepInfo.paramsData);
        }
    }

    public void execute(Project prj) {
        this.execute(prj, null);
    }

    public void execute(Project prj, List<LocaleId> targetLocales) {
        this.copyInfoStepsToPipeline();
        this.driver.clearItems();
        int f = -1;
        int inputRequested = this.driver.getRequestedInputCount();
        for (Input item : prj.getList(0)) {
            ++f;
            URI outURI = new File(prj.buildTargetPath(0, item.relativePath)).toURI();
            URI inpURI = new File(prj.getInputRoot(0) + File.separator + item.relativePath).toURI();
            RawDocument rawDoc = new RawDocument(inpURI, prj.buildSourceEncoding(item), prj.getSourceLanguage(), prj.getTargetLanguage());
            rawDoc.setFilterConfigId(item.filterConfigId);
            rawDoc.setId(Util.makeId(item.relativePath));
            if (targetLocales != null) {
                rawDoc.setTargetLocales(targetLocales);
            }
            BatchItemContext bic = new BatchItemContext(rawDoc, outURI, prj.buildTargetEncoding(item));
            for (int j = 1; j < 3 && j < inputRequested; ++j) {
                ArrayList<Input> list;
                if (3 <= j || (list = prj.getList(j)).size() <= f) continue;
                Input item2 = (Input)list.get(f);
                outURI = new File(prj.buildTargetPath(j, item2.relativePath)).toURI();
                inpURI = new File(prj.getInputRoot(j) + File.separator + item2.relativePath).toURI();
                rawDoc = new RawDocument(inpURI, prj.buildSourceEncoding(item), prj.getSourceLanguage(), prj.getTargetLanguage());
                rawDoc.setFilterConfigId(item2.filterConfigId);
                rawDoc.setId(Util.makeId(item2.relativePath));
                if (targetLocales != null) {
                    rawDoc.setTargetLocales(targetLocales);
                }
                bic.add(rawDoc, outURI, prj.buildTargetEncoding(item2));
            }
            this.driver.addBatchItem(bic);
        }
        this.driver.processBatch();
    }

    public void addStep(StepInfo step) {
        this.steps.add(step);
    }

    public void insertStep(int index, StepInfo step) {
        if (index == -1) {
            this.steps.add(step);
        } else {
            this.steps.add(index, step);
        }
    }

    public void removeStep(int index) {
        this.steps.remove(index);
    }

    public List<StepInfo> getSteps() {
        return this.steps;
    }
}

