/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.utilities;

import java.io.File;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import net.sf.okapi.applications.rainbow.utilities.CancelEvent;
import net.sf.okapi.applications.rainbow.utilities.CancelListener;
import net.sf.okapi.applications.rainbow.utilities.IUtility;
import net.sf.okapi.applications.rainbow.utilities.InputData;
import net.sf.okapi.applications.rainbow.utilities.OutputData;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import org.eclipse.swt.widgets.Shell;

public abstract class BaseUtility
implements IUtility {
    public static final String VAR_PROJDIR = "${ProjDir}";
    protected EventListenerList listenerList = new EventListenerList();
    protected FilterConfigurationMapper mapper;
    protected Shell shell;
    protected IHelp help;
    protected ArrayList<InputData> inputs = new ArrayList();
    protected ArrayList<OutputData> outputs = new ArrayList();
    protected String inputRoot;
    protected String outputRoot;
    protected LocaleId srcLang;
    protected LocaleId trgLang;
    protected String commonFolder;
    protected String updateCommand;
    protected String projectDir;
    protected boolean canPrompt;

    @Override
    public void addCancelListener(CancelListener listener) {
        this.listenerList.add(CancelListener.class, listener);
    }

    public void removeCancelListener(CancelListener listener) {
        this.listenerList.remove(CancelListener.class, listener);
    }

    public String getHelpLocation() {
        return ".." + File.separator + "help" + File.separator + "steps";
    }

    public String getDescription() {
        return null;
    }

    @Override
    public void setContextUI(Object contextUI, IHelp helpParam, String updateCommand, String projectDir, boolean canPrompt) {
        this.shell = (Shell)contextUI;
        this.help = helpParam;
        this.updateCommand = updateCommand;
        this.projectDir = projectDir;
        this.canPrompt = canPrompt;
        this.commonFolder = null;
    }

    @Override
    public void setOptions(LocaleId sourceLanguage, LocaleId targetLanguage) {
        this.srcLang = sourceLanguage;
        this.trgLang = targetLanguage;
    }

    @Override
    public void setFilterAccess(FilterConfigurationMapper mapper) {
        this.mapper = mapper;
    }

    protected void fireCancelEvent(CancelEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != CancelListener.class) continue;
            ((CancelListener)listeners[i + 1]).cancelOccurred(event);
        }
    }

    @Override
    public void addInputData(String path, String encoding, String filterSettings) {
        this.inputs.add(new InputData(path, encoding, filterSettings));
    }

    @Override
    public void addOutputData(String path, String encoding) {
        this.outputs.add(new OutputData(path, encoding));
        this.commonFolder = Util.longestCommonDir(this.commonFolder, Util.getDirectoryName(path), !Util.isOSCaseSensitive());
    }

    public String getInputRoot() {
        return this.inputRoot;
    }

    public String getOutputRoot() {
        return this.outputRoot;
    }

    @Override
    public void resetLists() {
        this.inputs.clear();
        this.outputs.clear();
    }

    @Override
    public void setRoots(String inputRoot, String outputRoot) {
        this.inputRoot = inputRoot;
        this.outputRoot = outputRoot;
    }

    @Override
    public String getFolderAfterProcess() {
        return this.commonFolder;
    }

    public String getInputPath(int index) {
        if (index > this.inputs.size() - 1) {
            return null;
        }
        return this.inputs.get((int)index).path;
    }

    public String getInputEncoding(int index) {
        if (index > this.inputs.size() - 1) {
            return null;
        }
        return this.inputs.get((int)index).encoding;
    }

    public String getInputFilterSettings(int index) {
        if (index > this.inputs.size() - 1) {
            return null;
        }
        return this.inputs.get((int)index).filterSettings;
    }

    public String getOutputPath(int index) {
        if (index > this.inputs.size() - 1) {
            return null;
        }
        return this.outputs.get((int)index).path;
    }

    public String getOutputEncoding(int index) {
        if (index > this.inputs.size() - 1) {
            return null;
        }
        return this.outputs.get((int)index).encoding;
    }

    @Override
    public void cancel() {
        this.fireCancelEvent(new CancelEvent(this));
    }

    @Override
    public void destroy() {
    }

    @Override
    public int inputCountRequested() {
        return 1;
    }
}

